/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.services;

import android.content.Context;
import it.polimi.spf.lib.SPF;
import it.polimi.spf.lib.SPFPerson;
import it.polimi.spf.lib.services.GsonHelper;
import it.polimi.spf.lib.services.InvocationStub;
import it.polimi.spf.lib.services.ServiceInvocationException;
import it.polimi.spf.shared.model.InvocationRequest;
import it.polimi.spf.shared.model.InvocationResponse;
import it.polimi.spf.shared.model.SPFActivity;
import it.polimi.spf.shared.model.SPFServiceDescriptor;

public class SPFServiceExecutor {
    private SPF mExecutionInterface;

    public SPFServiceExecutor(Context context, SPF executionInterface) {
        this.mExecutionInterface = executionInterface;
    }

    public <E> E createStub(final SPFPerson target, Class<E> serviceInterface, ClassLoader classLoader) {
        return InvocationStub.from(serviceInterface, classLoader, new InvocationStub.Target(){

            @Override
            public void prepareArguments(Object[] arguments) throws ServiceInvocationException {
                SPFServiceExecutor.this.mExecutionInterface.injectActivities(target.getIdentifier(), arguments);
            }

            @Override
            public InvocationResponse executeService(InvocationRequest request) throws ServiceInvocationException {
                return SPFServiceExecutor.this.mExecutionInterface.executeService(target.getIdentifier(), request);
            }
        });
    }

    public InvocationStub createStub(final SPFPerson target, SPFServiceDescriptor descriptor) {
        return InvocationStub.from(descriptor, new InvocationStub.Target(){

            @Override
            public void prepareArguments(Object[] arguments) throws ServiceInvocationException {
                SPFServiceExecutor.this.mExecutionInterface.injectActivities(target.getIdentifier(), arguments);
            }

            @Override
            public InvocationResponse executeService(InvocationRequest request) {
                return SPFServiceExecutor.this.mExecutionInterface.executeService(target.getIdentifier(), request);
            }
        });
    }

    public boolean sendActivity(String target, SPFActivity activity) {
        InvocationResponse resp = this.mExecutionInterface.sendActivity(target, activity);
        if (resp.isResult()) {
            return (Boolean)GsonHelper.gson.fromJson(resp.getPayload(), Boolean.class);
        }
        return false;
    }

    protected void recycle() {
    }
}

