/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.services;

import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import it.polimi.spf.lib.Component;
import it.polimi.spf.lib.services.GsonHelper;
import it.polimi.spf.lib.services.InvocationStub;
import it.polimi.spf.lib.services.ServiceInvocationException;
import it.polimi.spf.shared.aidl.LocalServiceManager;
import it.polimi.spf.shared.model.InvocationRequest;
import it.polimi.spf.shared.model.InvocationResponse;
import it.polimi.spf.shared.model.SPFActivity;
import it.polimi.spf.shared.model.SPFError;
import it.polimi.spf.shared.model.SPFServiceDescriptor;

public final class SPFServiceLocalExecutor
extends Component<SPFServiceLocalExecutor, LocalServiceManager> {
    private static final String SERVICE_INTENT = "it.polimi.spf.services.LocalServiceExecutor";
    private static final Component.Descriptor<SPFServiceLocalExecutor, LocalServiceManager> DESCRIPTOR = new Component.Descriptor<SPFServiceLocalExecutor, LocalServiceManager>(){

        @Override
        public String getActionName() {
            return SPFServiceLocalExecutor.SERVICE_INTENT;
        }

        @Override
        public LocalServiceManager castInterface(IBinder binder) {
            return LocalServiceManager.Stub.asInterface((IBinder)binder);
        }

        @Override
        public SPFServiceLocalExecutor createInstance(Context context, LocalServiceManager serviceInterface, ServiceConnection connection, Component.ConnectionCallback<SPFServiceLocalExecutor> callback) {
            return new SPFServiceLocalExecutor(context, serviceInterface, connection, callback);
        }
    };
    private InvocationStub.Target mLocalInvocationTarget = new InvocationStub.Target(){

        @Override
        public void prepareArguments(Object[] arguments) throws ServiceInvocationException {
            String token = SPFServiceLocalExecutor.this.getAccessToken();
            SPFError error = new SPFError();
            try {
                for (Object param : arguments) {
                    if (!(param instanceof SPFActivity)) continue;
                    ((LocalServiceManager)SPFServiceLocalExecutor.this.getService()).injectInformationIntoActivity(token, (SPFActivity)param, error);
                    if (error.isOk()) continue;
                    SPFServiceLocalExecutor.this.handleError(error);
                    throw new ServiceInvocationException(error.toString());
                }
            }
            catch (RemoteException e) {
                SPFServiceLocalExecutor.this.catchRemoteException(e);
                throw new ServiceInvocationException(((Object)((Object)e)).getClass().getSimpleName());
            }
        }

        @Override
        public InvocationResponse executeService(InvocationRequest request) throws ServiceInvocationException {
            String token = SPFServiceLocalExecutor.this.getAccessToken();
            SPFError error = new SPFError();
            try {
                InvocationResponse response = ((LocalServiceManager)SPFServiceLocalExecutor.this.getService()).executeLocalService(token, request, error);
                if (!error.isOk()) {
                    SPFServiceLocalExecutor.this.handleError(error);
                    response = InvocationResponse.error((String)error.toString());
                }
                return response;
            }
            catch (RemoteException e) {
                SPFServiceLocalExecutor.this.catchRemoteException(e);
                throw new ServiceInvocationException(((Object)((Object)e)).getClass().getSimpleName());
            }
        }
    };

    public static void load(Context context, Callback callback) {
        Component.load(context, DESCRIPTOR, callback);
    }

    protected SPFServiceLocalExecutor(Context context, LocalServiceManager serviceInterface, ServiceConnection connection, Component.ConnectionCallback<SPFServiceLocalExecutor> callback) {
        super(context, serviceInterface, connection, callback);
    }

    public <E> E createStub(Class<E> serviceInterface, ClassLoader classLoader) {
        return InvocationStub.from(serviceInterface, classLoader, this.mLocalInvocationTarget);
    }

    public InvocationStub createStub(SPFServiceDescriptor descriptor) {
        return InvocationStub.from(descriptor, this.mLocalInvocationTarget);
    }

    public boolean sendActivityLocally(SPFActivity activity) {
        InvocationResponse resp;
        String token = this.getAccessToken();
        SPFError err = new SPFError();
        try {
            ((LocalServiceManager)this.getService()).injectInformationIntoActivity(token, activity, err);
            if (!err.isOk()) {
                this.handleError(err);
                return false;
            }
            resp = ((LocalServiceManager)this.getService()).sendActivityLocally(token, activity, err);
        }
        catch (RemoteException e) {
            return false;
        }
        if (!err.isOk()) {
            this.handleError(err);
            return false;
        }
        if (!resp.isResult()) {
            return false;
        }
        return (Boolean)GsonHelper.gson.fromJson(resp.getPayload(), Boolean.class);
    }

    private void catchRemoteException(RemoteException e) {
        this.disconnect();
        this.getCallback().onDisconnect();
    }

    public static interface Callback
    extends Component.ConnectionCallback<SPFServiceLocalExecutor> {
    }
}

