/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.services;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import it.polimi.spf.lib.Component;
import it.polimi.spf.lib.Utils;
import it.polimi.spf.lib.services.IllegalServiceException;
import it.polimi.spf.lib.services.ServiceInterface;
import it.polimi.spf.lib.services.ServiceValidator;
import it.polimi.spf.shared.aidl.LocalServiceManager;
import it.polimi.spf.shared.model.SPFError;
import it.polimi.spf.shared.model.SPFServiceDescriptor;

public final class SPFServiceRegistry
extends Component<SPFServiceRegistry, LocalServiceManager> {
    private static final Component.Descriptor<SPFServiceRegistry, LocalServiceManager> DESCRIPTOR = new Component.Descriptor<SPFServiceRegistry, LocalServiceManager>(){

        @Override
        public String getActionName() {
            return "it.polimi.spf.services.LocalServiceExecutor";
        }

        @Override
        public LocalServiceManager castInterface(IBinder binder) {
            return LocalServiceManager.Stub.asInterface((IBinder)binder);
        }

        @Override
        public SPFServiceRegistry createInstance(Context context, LocalServiceManager serviceInterface, ServiceConnection connection, Component.ConnectionCallback<SPFServiceRegistry> callback) {
            return new SPFServiceRegistry(context, serviceInterface, connection, callback);
        }
    };

    public static void load(Context context, Callback callback) {
        Component.load(context, DESCRIPTOR, callback);
    }

    protected SPFServiceRegistry(Context context, LocalServiceManager serviceInterface, ServiceConnection connection, Component.ConnectionCallback<SPFServiceRegistry> callback) {
        super(context, serviceInterface, connection, callback);
    }

    @Deprecated
    public <T> void registerService(Class<? super T> serviceInterface) {
        Utils.notNull(serviceInterface, "serviceInterface must not be null");
        ServiceInterface annotation = serviceInterface.getAnnotation(ServiceInterface.class);
        if (annotation == null) {
            throw new IllegalServiceException("Missing annotation");
        }
        String flattenComponentName = annotation.componentName();
        if (flattenComponentName == null) {
            throw new IllegalStateException("Missing componentName");
        }
        ComponentName cn = ComponentName.unflattenFromString((String)flattenComponentName);
        this.registerService(serviceInterface, cn);
    }

    public <T> void registerService(Class<? super T> serviceInterface, Class<T> implementationClass) {
        Utils.notNull(serviceInterface, "serviceInterface must not be null");
        Utils.notNull(implementationClass, "implementationClass must not be null");
        ComponentName cn = new ComponentName(this.getContext(), implementationClass);
        this.registerService(serviceInterface, cn);
    }

    private <T> void registerService(Class<? super T> serviceInterface, ComponentName cn) {
        ServiceValidator.validateInterface(serviceInterface, 0);
        ServiceValidator.validateServiceImplementation(this.getContext(), cn, serviceInterface);
        ServiceInterface annotation = serviceInterface.getAnnotation(ServiceInterface.class);
        SPFServiceDescriptor descriptor = ServiceInterface.Convert.toServiceDescriptor(annotation, cn.flattenToString());
        String token = this.getAccessToken();
        try {
            SPFError error = new SPFError();
            ((LocalServiceManager)this.getService()).registerService(token, descriptor, error);
            if (!error.isOk()) {
                this.handleError(error);
            }
        }
        catch (RemoteException e) {
            this.catchRemoteException(e);
        }
    }

    public <T> void unregisterService(Class<? super T> serviceInterface) {
        Utils.notNull(serviceInterface, "serviceInterface must not be null");
        ServiceValidator.validateInterface(serviceInterface, 0);
        ServiceInterface svcInterface = serviceInterface.getAnnotation(ServiceInterface.class);
        SPFServiceDescriptor svcDesc = ServiceInterface.Convert.toServiceDescriptor(svcInterface);
        String token = this.getAccessToken();
        try {
            SPFError error = new SPFError();
            ((LocalServiceManager)this.getService()).unregisterService(token, svcDesc, error);
            if (!error.isOk()) {
                this.handleError(error);
            }
        }
        catch (RemoteException e) {
            this.catchRemoteException(e);
        }
    }

    private void catchRemoteException(RemoteException e) {
        this.disconnect();
        this.getCallback().onDisconnect();
    }

    public static interface Callback
    extends Component.ConnectionCallback<SPFServiceRegistry> {
    }
}

