/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.services;

import it.polimi.spf.lib.Utils;
import it.polimi.spf.shared.model.SPFServiceDescriptor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface ServiceInterface {
    public String app();

    public String name() default "";

    public String description() default "";

    public String version();

    @Deprecated
    public String componentName() default "";

    public String[] consumedVerbs() default {};

    public static final class Convert {
        private Convert() {
        }

        public static final SPFServiceDescriptor toServiceDescriptor(ServiceInterface svc) {
            Utils.notNull(svc, "svcInterface must not be null");
            return new SPFServiceDescriptor(svc.name(), svc.description(), svc.app(), svc.version(), null, svc.consumedVerbs());
        }

        public static final SPFServiceDescriptor toServiceDescriptor(ServiceInterface svc, String flattenComponentName) {
            Utils.notNull(svc, "svcInterface must not be null");
            return new SPFServiceDescriptor(svc.name(), svc.description(), svc.app(), svc.version(), flattenComponentName, svc.consumedVerbs());
        }
    }
}

