/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.services;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import it.polimi.spf.lib.services.ActivityConsumer;
import it.polimi.spf.lib.services.IllegalServiceException;
import it.polimi.spf.lib.services.SPFServiceEndpoint;
import it.polimi.spf.lib.services.ServiceInterface;
import it.polimi.spf.lib.services.ServiceInvocationException;
import it.polimi.spf.shared.model.SPFActivity;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

class ServiceValidator {
    static final int TYPE_PUBLISHED = 0;
    static final int TYPE_REMOTE = 1;

    ServiceValidator() {
    }

    static void validateInterface(Class<?> serviceInterface, int validationType) {
        ServiceValidator.assertThat(serviceInterface.isInterface(), "Please provide an interface as serviceInterface param.");
        ServiceInterface service = serviceInterface.getAnnotation(ServiceInterface.class);
        ServiceValidator.assertThat(service != null, "Service is missing required annotation @Service");
        ServiceValidator.assertThat(!ServiceValidator.isStringEmpty(service.name()), "Service name is empty.");
        ServiceValidator.assertThat(validationType != 1 || !ServiceValidator.isStringEmpty(service.app()), "App name is required for this service.");
        for (Method m : serviceInterface.getMethods()) {
            if (m.isAnnotationPresent(ActivityConsumer.class)) {
                ServiceValidator.validateActivityConsumer(service.name(), m);
                continue;
            }
            ServiceValidator.validateStandardMethod(service.name(), m);
        }
    }

    static void validateServiceImplementation(Context context, ComponentName componentName, Class<?> serviceClass) throws IllegalServiceException {
        Class<?> implClass;
        String implName = componentName.getClassName();
        try {
            implClass = Class.forName(implName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalServiceException(String.format("Service implementation %s not found", implName));
        }
        try {
            context.getPackageManager().getServiceInfo(componentName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalServiceException(String.format("Service %s is not registered", implName));
        }
        ServiceValidator.assertThat(serviceClass.isAssignableFrom(implClass), ServiceValidator.e("Service implementation %s does not implement service %s", implName, serviceClass.getCanonicalName()));
        ServiceValidator.assertThat(SPFServiceEndpoint.class.equals(implClass.getSuperclass()), ServiceValidator.e(ErrorMsg.WRONG_SUPERCLASS, implName));
        ServiceValidator.assertThat(!Modifier.isAbstract(implClass.getModifiers()), ServiceValidator.e("Service implementation %s must not be abstract", implName));
    }

    private static void validateActivityConsumer(String serviceName, Method m) {
        String methodName = m.getName();
        ServiceValidator.assertThat(m.getReturnType().equals(Void.TYPE), ServiceValidator.e("Consumer method %s must return void", methodName));
        ServiceValidator.assertThat(m.getParameterTypes().length == 1, ServiceValidator.e("Consumer method %s should have only one parameter of type SPFActivity", methodName));
        ServiceValidator.assertThat(m.getParameterTypes()[0].equals(SPFActivity.class), ServiceValidator.e("Consumer method %s should have only one parameter of type SPFActivity", methodName));
        ServiceValidator.assertThat(m.getExceptionTypes().length == 0, ServiceValidator.e("Consumer method %s should not declare any exception", methodName));
    }

    private static void validateStandardMethod(String serviceName, Method m) {
        Type[] exceptions = m.getGenericExceptionTypes();
        ServiceValidator.assertThat(exceptions.length == 1 && ServiceInvocationException.class.equals((Object)exceptions[0]), "Service methods must declare an InvocationException, and nothing else.");
    }

    private static void assertThat(boolean value, String message) {
        if (!value) {
            throw new IllegalServiceException(message);
        }
    }

    private static String e(String errorMsg, Object ... args) {
        return String.format(errorMsg, args);
    }

    private static boolean isStringEmpty(String s) {
        return s == null || s.equals("");
    }

    private static class ErrorMsg {
        public static final String INTERFACE_REQUIRED = "Please provide an interface as serviceInterface param.";
        public static final String MISSING_ANNOTATION = "Service is missing required annotation @Service";
        public static final String MISSING_SERVICE_NAME = "Service name is empty.";
        public static final String MISSING_APP_NAME = "App name is required for this service.";
        public static final String INVALID_EXCEPTIONS = "Service methods must declare an InvocationException, and nothing else.";
        public static final String CONSUMER_RET_TYPE = "Consumer method %s must return void";
        public static final String CONSUMER_PARAM = "Consumer method %s should have only one parameter of type SPFActivity";
        public static final String CONSUMER_EXCEPTIONS = "Consumer method %s should not declare any exception";
        public static final String MISSING_IMPLEMENTATION = "Service implementation %s not found";
        public static final String INVALID_IMPLEMENTATION = "Service implementation %s does not implement service %s";
        public static final String WRONG_SUPERCLASS = "Service implementation %s is not a sublcass of " + SPFServiceEndpoint.class.getSimpleName();
        public static final String ABSTRACT_IMPLEMENTATION = "Service implementation %s must not be abstract";
        public static final String SERVICE_NOT_REGISTERED = "Service %s is not registered";

        private ErrorMsg() {
        }
    }
}

