/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import it.polimi.spf.lib.services.ActivityConsumer;
import it.polimi.spf.lib.services.GsonHelper;
import it.polimi.spf.lib.services.ServiceInterface;
import it.polimi.spf.lib.services.ServiceInvocationException;
import it.polimi.spf.lib.services.ServiceValidator;
import it.polimi.spf.shared.model.InvocationRequest;
import it.polimi.spf.shared.model.InvocationResponse;
import it.polimi.spf.shared.model.SPFServiceDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ServiceWrapper {
    private SPFServiceDescriptor mServiceDescriptor;
    private Object mImplementation;
    private Map<String, Method> mMethodIndex;

    public ServiceWrapper(Class<?> serviceInterface, Object implementation) {
        ServiceValidator.validateInterface(serviceInterface, 0);
        ServiceInterface service = serviceInterface.getAnnotation(ServiceInterface.class);
        this.mServiceDescriptor = ServiceInterface.Convert.toServiceDescriptor(service);
        this.mImplementation = implementation;
        this.mMethodIndex = new HashMap<String, Method>();
        for (Method m : serviceInterface.getMethods()) {
            if (m.isAnnotationPresent(ActivityConsumer.class)) continue;
            this.mMethodIndex.put(m.getName(), m);
        }
    }

    public InvocationResponse invokeMethod(InvocationRequest request) {
        Object[] params;
        String methodName = request.getMethodName();
        if (!this.mMethodIndex.containsKey(methodName)) {
            String msg = String.format("Method %s not found in service %s.", methodName, this.mServiceDescriptor.getServiceName());
            return InvocationResponse.error((String)msg);
        }
        Method m = this.mMethodIndex.get(methodName);
        try {
            params = this.deserializeParameters(request.getPayload(), m.getGenericParameterTypes());
        }
        catch (ServiceInvocationException e) {
            return InvocationResponse.error((String)("Error deserializing parameters:" + e.getMessage()));
        }
        try {
            Object result = m.invoke(this.mImplementation, params);
            String json = GsonHelper.gson.toJson(result);
            return InvocationResponse.result((String)json);
        }
        catch (IllegalAccessException e) {
            return InvocationResponse.error((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            return InvocationResponse.error((String)"Illegal argument provided for method invocation.");
        }
        catch (InvocationTargetException e) {
            return InvocationResponse.error((Throwable)e.getCause());
        }
    }

    public Set<String> getAvailableMethods() {
        return this.mMethodIndex.keySet();
    }

    public SPFServiceDescriptor getServiceDescriptor() {
        return this.mServiceDescriptor;
    }

    public static <T> String readServiceName(Class<? super T> serviceInterface) {
        ServiceInterface service = serviceInterface.getAnnotation(ServiceInterface.class);
        if (service == null) {
            throw new IllegalArgumentException("Service interface does not have a ServiceInterface annotation.");
        }
        return service.name();
    }

    private Object[] deserializeParameters(String payload, Type[] parameterTypes) throws ServiceInvocationException {
        JsonParser parser = new JsonParser();
        JsonArray array = parser.parse(payload).getAsJsonArray();
        if (array.size() != parameterTypes.length) {
            throw new ServiceInvocationException("Parameter number mismatch");
        }
        Object[] params = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            params[i] = GsonHelper.gson.fromJson(array.get(i), parameterTypes[i]);
        }
        return params;
    }

    private static class ErrorMsg {
        public static final String METHOD_NOT_FOUND = "Method %s not found in service %s.";
        public static final String ILLEGAL_ARGUMENT = "Illegal argument provided for method invocation.";

        private ErrorMsg() {
        }
    }
}

