/*
 * Decompiled with CFR 0.152.
 */
package it.skrape.matchers;

import it.skrape.matchers.AssertionsKt;
import it.skrape.selects.DocElement;
import it.skrape.selects.DocElementKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\u001a\u0015\u0010\u0018\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0086\u0004\u001a\u001b\u0010\u0018\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0086\u0004\u001a\u001b\u0010\u001b\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0086\u0004\u001a!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\b*\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u001d\u001a\u00020\u0019H\u0086\u0004\u001a\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0086\u0004\u001a!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\b*\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001a\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0086\u0004\"\u0017\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0017\u0010\u0004\u001a\u00020\u0001*\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0017\u0010\u0005\u001a\u00020\u0001*\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0017\u0010\u0006\u001a\u00020\u0001*\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\"!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b*\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\"!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b*\b\u0012\u0004\u0012\u00020\u000f0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000b\"\u0015\u0010\u0011\u001a\u00020\u000f*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\b*\b\u0012\u0004\u0012\u00020\u000f0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000b\"!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\b*\b\u0012\u0004\u0012\u00020\u000f0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\"!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\b*\b\u0012\u0004\u0012\u00020\u000f0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006 "}, d2={"containsNumeric", "", "getContainsNumeric", "(Ljava/lang/String;)Ljava/lang/String;", "isDecimal", "isInteger", "isNumeric", "toBeEmpty", "", "", "getToBeEmpty", "(Ljava/util/List;)Ljava/util/List;", "toBeNotEmpty", "getToBeNotEmpty", "toBeNotPresent", "Lit/skrape/selects/DocElement;", "getToBeNotPresent", "toBePresent", "getToBePresent", "(Lit/skrape/selects/DocElement;)Lit/skrape/selects/DocElement;", "toBePresentExactlyOnce", "getToBePresentExactlyOnce", "toBePresentExactlyTwice", "getToBePresentExactlyTwice", "toBe", "", "expected", "toBeNot", "toBePresentTimes", "amount", "toContain", "toNotContain", "assertions"})
@SourceDebugExtension(value={"SMAP\nMatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matchers.kt\nit/skrape/matchers/MatchersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class MatchersKt {
    public static final int toBe(int $this$toBe, int expected) {
        int n;
        int $this$toBe_u24lambda_u240 = n = $this$toBe;
        boolean bl = false;
        AssertionsKt.generalAssertion$default($this$toBe_u24lambda_u240, $this$toBe_u24lambda_u240 == expected, expected, null, 4, null);
        return n;
    }

    @Nullable
    public static final String toBe(@Nullable String $this$toBe, @Nullable String expected) {
        String string;
        String $this$toBe_u24lambda_u241 = string = $this$toBe;
        boolean bl = false;
        AssertionsKt.generalAssertion$default($this$toBe_u24lambda_u241, Intrinsics.areEqual((Object)$this$toBe_u24lambda_u241, (Object)expected), expected, null, 4, null);
        return string;
    }

    @Nullable
    public static final String toBeNot(@Nullable String $this$toBeNot, @Nullable String expected) {
        String string;
        String $this$toBeNot_u24lambda_u242 = string = $this$toBeNot;
        boolean bl = false;
        AssertionsKt.generalAssertion$default($this$toBeNot_u24lambda_u242, !Intrinsics.areEqual((Object)$this$toBeNot_u24lambda_u242, (Object)expected), expected, null, 4, null);
        return string;
    }

    @Nullable
    public static final String toContain(@Nullable String $this$toContain, @NotNull String expected) {
        String string;
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        String $this$toContain_u24lambda_u243 = string = $this$toContain;
        boolean bl = false;
        AssertionsKt.generalAssertion$default($this$toContain_u24lambda_u243, StringsKt.contains$default((CharSequence)String.valueOf($this$toContain_u24lambda_u243), (CharSequence)expected, (boolean)false, (int)2, null), expected, null, 4, null);
        return string;
    }

    @Nullable
    public static final String toNotContain(@Nullable String $this$toNotContain, @NotNull String expected) {
        String string;
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        String $this$toNotContain_u24lambda_u244 = string = $this$toNotContain;
        boolean bl = false;
        AssertionsKt.generalAssertion$default($this$toNotContain_u24lambda_u244, !StringsKt.contains$default((CharSequence)String.valueOf($this$toNotContain_u24lambda_u244), (CharSequence)expected, (boolean)false, (int)2, null), expected, null, 4, null);
        return string;
    }

    @NotNull
    public static final String isNumeric(@Nullable String $this$isNumeric) {
        String string;
        String string2 = $this$isNumeric;
        if (string2 == null) {
            throw new AssertionError((Object)"expect text to be a numeric but it was 'null'");
        }
        String $this$_get_isNumeric__u24lambda_u245 = string = string2;
        boolean bl = false;
        CharSequence charSequence = $this$_get_isNumeric__u24lambda_u245;
        AssertionsKt.generalAssertion($this$_get_isNumeric__u24lambda_u245, new Regex("^-?\\d+(\\.\\d+)?$").matches(charSequence), '\'' + $this$_get_isNumeric__u24lambda_u245 + '\'', "is an integer or a decimal");
        return string;
    }

    @NotNull
    public static final String isInteger(@Nullable String $this$isInteger) {
        String string;
        String string2 = $this$isInteger;
        if (string2 == null) {
            throw new AssertionError((Object)"expect text to be an integer but it was 'null'");
        }
        String $this$_get_isInteger__u24lambda_u246 = string = string2;
        boolean bl = false;
        CharSequence charSequence = $this$_get_isInteger__u24lambda_u246;
        AssertionsKt.generalAssertion($this$_get_isInteger__u24lambda_u246, new Regex("^-?\\d+?$").matches(charSequence), '\'' + $this$_get_isInteger__u24lambda_u246 + '\'', "is an integer");
        return string;
    }

    @NotNull
    public static final String isDecimal(@Nullable String $this$isDecimal) {
        String string;
        String string2 = $this$isDecimal;
        if (string2 == null) {
            throw new AssertionError((Object)"expect text to be a decimal but it was 'null'");
        }
        String $this$_get_isDecimal__u24lambda_u247 = string = string2;
        boolean bl = false;
        CharSequence charSequence = $this$_get_isDecimal__u24lambda_u247;
        AssertionsKt.generalAssertion($this$_get_isDecimal__u24lambda_u247, new Regex("^\\d+\\.\\d+$").matches(charSequence), '\'' + $this$_get_isDecimal__u24lambda_u247 + '\'', "is a decimal");
        return string;
    }

    @NotNull
    public static final String getContainsNumeric(@Nullable String $this$containsNumeric) {
        String string;
        String string2 = $this$containsNumeric;
        if (string2 == null) {
            throw new AssertionError((Object)"expect text to contain a numeric but it was 'null'");
        }
        String $this$_get_containsNumeric__u24lambda_u248 = string = string2;
        boolean bl = false;
        CharSequence charSequence = $this$_get_containsNumeric__u24lambda_u248;
        AssertionsKt.generalAssertion($this$_get_containsNumeric__u24lambda_u248, new Regex(".*-?\\d+(\\.\\d+)?.*").matches(charSequence), '\'' + $this$_get_containsNumeric__u24lambda_u248 + '\'', "contains an integer or a decimal");
        return string;
    }

    @NotNull
    public static final List<Object> toContain(@NotNull List<? extends Object> $this$toContain, @NotNull String expected) {
        List<Object> list;
        Intrinsics.checkNotNullParameter($this$toContain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        List<Object> $this$toContain_u24lambda_u249 = list = $this$toContain;
        boolean bl = false;
        AssertionsKt.generalAssertion$default($this$toContain_u24lambda_u249, $this$toContain_u24lambda_u249.contains(expected), expected, null, 4, null);
        return list;
    }

    @NotNull
    public static final List<DocElement> getToBePresent(@NotNull List<DocElement> $this$toBePresent) {
        List<DocElement> list;
        Intrinsics.checkNotNullParameter($this$toBePresent, (String)"<this>");
        List<DocElement> $this$_get_toBePresent__u24lambda_u2410 = list = $this$toBePresent;
        boolean bl = false;
        AssertionsKt.generalAssertion($this$_get_toBePresent__u24lambda_u2410, DocElementKt.isPresent($this$_get_toBePresent__u24lambda_u2410), String.valueOf(Reflection.getOrCreateKotlinClass($this$_get_toBePresent__u24lambda_u2410.getClass())), "is present");
        return list;
    }

    @NotNull
    public static final List<DocElement> toBePresentTimes(@NotNull List<DocElement> $this$toBePresentTimes, int amount) {
        List<DocElement> list;
        Intrinsics.checkNotNullParameter($this$toBePresentTimes, (String)"<this>");
        List<DocElement> $this$toBePresentTimes_u24lambda_u2411 = list = $this$toBePresentTimes;
        boolean bl = false;
        AssertionsKt.generalAssertion($this$toBePresentTimes_u24lambda_u2411, $this$toBePresentTimes_u24lambda_u2411.size() == amount, String.valueOf(Reflection.getOrCreateKotlinClass($this$toBePresentTimes_u24lambda_u2411.getClass())), "is present " + amount + " times");
        return list;
    }

    @NotNull
    public static final List<DocElement> getToBePresentExactlyOnce(@NotNull List<DocElement> $this$toBePresentExactlyOnce) {
        Intrinsics.checkNotNullParameter($this$toBePresentExactlyOnce, (String)"<this>");
        return MatchersKt.toBePresentTimes($this$toBePresentExactlyOnce, 1);
    }

    @NotNull
    public static final List<DocElement> getToBePresentExactlyTwice(@NotNull List<DocElement> $this$toBePresentExactlyTwice) {
        Intrinsics.checkNotNullParameter($this$toBePresentExactlyTwice, (String)"<this>");
        return MatchersKt.toBePresentTimes($this$toBePresentExactlyTwice, 2);
    }

    @NotNull
    public static final DocElement getToBePresent(@NotNull DocElement $this$toBePresent) {
        DocElement docElement;
        Intrinsics.checkNotNullParameter((Object)$this$toBePresent, (String)"<this>");
        DocElement $this$_get_toBePresent__u24lambda_u2412 = docElement = $this$toBePresent;
        boolean bl = false;
        AssertionsKt.generalAssertion($this$_get_toBePresent__u24lambda_u2412, $this$_get_toBePresent__u24lambda_u2412.isPresent(), "element '" + $this$_get_toBePresent__u24lambda_u2412.getToCssSelector() + '\'', "is present");
        return docElement;
    }

    @NotNull
    public static final List<DocElement> getToBeNotPresent(@NotNull List<DocElement> $this$toBeNotPresent) {
        List<DocElement> list;
        Intrinsics.checkNotNullParameter($this$toBeNotPresent, (String)"<this>");
        List<DocElement> $this$_get_toBeNotPresent__u24lambda_u2413 = list = $this$toBeNotPresent;
        boolean bl = false;
        AssertionsKt.generalAssertion($this$_get_toBeNotPresent__u24lambda_u2413, DocElementKt.isNotPresent($this$_get_toBeNotPresent__u24lambda_u2413), String.valueOf(Reflection.getOrCreateKotlinClass($this$_get_toBeNotPresent__u24lambda_u2413.getClass())), "is not present");
        return list;
    }

    @NotNull
    public static final List<Object> getToBeEmpty(@NotNull List<? extends Object> $this$toBeEmpty) {
        List<Object> list;
        Intrinsics.checkNotNullParameter($this$toBeEmpty, (String)"<this>");
        List<Object> $this$_get_toBeEmpty__u24lambda_u2414 = list = $this$toBeEmpty;
        boolean bl = false;
        AssertionsKt.generalAssertion($this$_get_toBeEmpty__u24lambda_u2414, $this$_get_toBeEmpty__u24lambda_u2414.size() == 0, "list", "is empty");
        return list;
    }

    @NotNull
    public static final List<Object> getToBeNotEmpty(@NotNull List<? extends Object> $this$toBeNotEmpty) {
        List<Object> list;
        Intrinsics.checkNotNullParameter($this$toBeNotEmpty, (String)"<this>");
        List<Object> $this$_get_toBeNotEmpty__u24lambda_u2415 = list = $this$toBeNotEmpty;
        boolean bl = false;
        AssertionsKt.generalAssertion($this$_get_toBeNotEmpty__u24lambda_u2415, $this$_get_toBeNotEmpty__u24lambda_u2415.size() > 0, "list", "is none empty");
        return list;
    }
}

