/*
 * Decompiled with CFR 0.152.
 */
package it.skrape.fetcher;

import io.ktor.client.HttpClientConfig;
import io.ktor.client.engine.apache.ApacheEngineConfig;
import io.ktor.client.plugins.HttpTimeout;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.utils.EmptyContent;
import io.ktor.http.DateUtilsKt;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesKt;
import io.ktor.util.date.GMTDate;
import io.ktor.util.network.NetworkAddressJvmKt;
import io.ktor.util.reflect.TypeInfoJvmKt;
import it.skrape.fetcher.Authentication;
import it.skrape.fetcher.Cookie;
import it.skrape.fetcher.CookieKt;
import it.skrape.fetcher.Domain;
import it.skrape.fetcher.Expires;
import it.skrape.fetcher.ExtensionsKt;
import it.skrape.fetcher.Method;
import it.skrape.fetcher.Request;
import it.skrape.fetcher.Result;
import it.skrape.fetcher.SameSite;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.StringsKt;
import org.apache.http.HttpHost;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u000e\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\bH\u0000\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0000\u001a\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a\u0015\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001a\u001a\u000e\u0010\u001b\u001a\u00020\u001c*\u0004\u0018\u00010\bH\u0000\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0019H\u0000\u001a\u0012\u0010\u001f\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"installBasicAuth", "", "Lio/ktor/client/HttpClientConfig;", "Lio/ktor/client/engine/apache/ApacheEngineConfig;", "toDomainCookie", "Lit/skrape/fetcher/Cookie;", "Lio/ktor/http/Cookie;", "origin", "", "toExpires", "Lit/skrape/fetcher/Expires;", "toHttpHost", "Lorg/apache/http/HttpHost;", "Ljava/net/Proxy;", "toHttpMethod", "Lio/ktor/http/HttpMethod;", "Lit/skrape/fetcher/Method;", "toHttpRequest", "Lio/ktor/client/request/HttpRequestBuilder;", "Lit/skrape/fetcher/Request;", "toMaxAge", "", "(I)Ljava/lang/Integer;", "toResult", "Lit/skrape/fetcher/Result;", "Lio/ktor/client/statement/HttpResponse;", "(Lio/ktor/client/statement/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toSameSite", "Lit/skrape/fetcher/SameSite;", "toStatus", "Lit/skrape/fetcher/Result$Status;", "trustSelfSignedClient", "async-fetcher"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\nit/skrape/fetcher/ExtensionsKt\n+ 2 RequestBody.kt\nio/ktor/client/request/RequestBodyKt\n+ 3 TypeInfoJvm.kt\nio/ktor/util/reflect/TypeInfoJvmKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n16#2,12:125\n30#2:140\n17#3,3:137\n1208#4,2:141\n1238#4,4:143\n1549#4:147\n1620#4,3:148\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\nit/skrape/fetcher/ExtensionsKt\n*L\n36#1:125,12\n36#1:140\n36#1:137,3\n112#1:141,2\n112#1:143,4\n113#1:147\n113#1:148,3\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final HttpRequestBuilder toHttpRequest(@NotNull Request $this$toHttpRequest) {
        HttpRequestBuilder httpRequestBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toHttpRequest, (String)"<this>");
        Request request = $this$toHttpRequest;
        HttpRequestBuilder $this$toHttpRequest_u24lambda_u241 = httpRequestBuilder = new HttpRequestBuilder();
        boolean bl = false;
        $this$toHttpRequest_u24lambda_u241.setMethod(ExtensionsKt.toHttpMethod(request.getMethod()));
        HttpRequestKt.url((HttpRequestBuilder)$this$toHttpRequest_u24lambda_u241, (String)request.getUrl());
        HttpRequestKt.headers((HttpMessageBuilder)((HttpMessageBuilder)$this$toHttpRequest_u24lambda_u241), (Function1)((Function1)new Function1<HeadersBuilder, Unit>(request, $this$toHttpRequest){
            final /* synthetic */ Request $request;
            final /* synthetic */ Request $this_toHttpRequest;
            {
                this.$request = $request;
                this.$this_toHttpRequest = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HeadersBuilder $this$headers) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
                    Map $this$forEach$iv = this.$request.getHeaders();
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> entry = element$iv = iterator.next();
                        boolean bl = false;
                        String k = (String)entry.getKey();
                        String v = (String)entry.getValue();
                        $this$headers.append(k, v);
                    }
                    $this$headers.append("User-Agent", this.$request.getUserAgent());
                    this.$this_toHttpRequest.setCookies(this.$request.getCookies());
                    Authentication authentication = this.$request.getAuthentication();
                    if (authentication == null) break block1;
                    Authentication $this$invoke_u24lambda_u241 = authentication;
                    boolean bl = false;
                    $this$headers.append("Authorization", $this$invoke_u24lambda_u241.toHeaderValue());
                }
            }
        }));
        String string = request.getBody();
        if (string != null) {
            String $this$toHttpRequest_u24lambda_u241_u24lambda_u240 = string;
            boolean bl2 = false;
            HttpRequestBuilder $this$setBody$iv = $this$toHttpRequest_u24lambda_u241;
            boolean $i$f$setBody = false;
            String string2 = $this$toHttpRequest_u24lambda_u241_u24lambda_u240;
            if (string2 == null) {
                $this$setBody$iv.setBody((Object)EmptyContent.INSTANCE);
                $this$setBody$iv.setBodyType(null);
            } else if (string2 instanceof OutgoingContent) {
                $this$setBody$iv.setBody((Object)$this$toHttpRequest_u24lambda_u241_u24lambda_u240);
                $this$setBody$iv.setBodyType(null);
            } else {
                $this$setBody$iv.setBody((Object)$this$toHttpRequest_u24lambda_u241_u24lambda_u240);
                boolean $i$f$typeInfo = false;
                KType kType$iv$iv = Reflection.typeOf(String.class);
                Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(String.class), (KType)kType$iv$iv));
            }
        }
        HttpTimeoutKt.timeout((HttpRequestBuilder)$this$toHttpRequest_u24lambda_u241, (Function1)((Function1)new Function1<HttpTimeout.HttpTimeoutCapabilityConfiguration, Unit>(request){
            final /* synthetic */ Request $request;
            {
                this.$request = $request;
                super(1);
            }

            public final void invoke(@NotNull HttpTimeout.HttpTimeoutCapabilityConfiguration $this$timeout) {
                Intrinsics.checkNotNullParameter((Object)$this$timeout, (String)"$this$timeout");
                $this$timeout.setSocketTimeoutMillis(Long.valueOf(this.$request.getTimeout()));
            }
        }));
        return httpRequestBuilder;
    }

    public static final void installBasicAuth(@NotNull HttpClientConfig<ApacheEngineConfig> $this$installBasicAuth) {
        Intrinsics.checkNotNullParameter($this$installBasicAuth, (String)"<this>");
        $this$installBasicAuth.engine((Function1)installBasicAuth.1.INSTANCE);
    }

    @NotNull
    public static final HttpMethod toHttpMethod(@NotNull Method $this$toHttpMethod) {
        HttpMethod httpMethod;
        Intrinsics.checkNotNullParameter((Object)$this$toHttpMethod, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toHttpMethod.ordinal()]) {
            case 1: {
                httpMethod = HttpMethod.Companion.getGet();
                break;
            }
            case 2: {
                httpMethod = HttpMethod.Companion.getPost();
                break;
            }
            case 3: {
                httpMethod = HttpMethod.Companion.getHead();
                break;
            }
            case 4: {
                httpMethod = HttpMethod.Companion.getDelete();
                break;
            }
            case 5: {
                httpMethod = HttpMethod.Companion.getPatch();
                break;
            }
            case 6: {
                httpMethod = HttpMethod.Companion.getPut();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpMethod;
    }

    @NotNull
    public static final Cookie toDomainCookie(@NotNull io.ktor.http.Cookie $this$toDomainCookie, @NotNull String origin) {
        Intrinsics.checkNotNullParameter((Object)$this$toDomainCookie, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        String string = $this$toDomainCookie.getPath();
        if (string == null) {
            string = "/";
        }
        String path = string;
        GMTDate gMTDate = $this$toDomainCookie.getExpires();
        Expires expires = ExtensionsKt.toExpires(gMTDate != null ? DateUtilsKt.toHttpDate((GMTDate)gMTDate) : null);
        String domainUrl = $this$toDomainCookie.getDomain();
        Domain domain = domainUrl == null ? new Domain(origin, false) : new Domain(CookieKt.getUrlOrigin((String)domainUrl), true);
        SameSite sameSite = ExtensionsKt.toSameSite((String)$this$toDomainCookie.getExtensions().get("SameSite"));
        Integer maxAge = ExtensionsKt.toMaxAge($this$toDomainCookie.getMaxAgeInt());
        return new Cookie($this$toDomainCookie.getName(), $this$toDomainCookie.getValue(), expires, maxAge, domain, path, sameSite, $this$toDomainCookie.getSecure(), $this$toDomainCookie.getHttpOnly());
    }

    @Nullable
    public static final Integer toMaxAge(int $this$toMaxAge) {
        return $this$toMaxAge == 0 ? null : Integer.valueOf($this$toMaxAge);
    }

    @NotNull
    public static final Expires toExpires(@Nullable String $this$toExpires) {
        return $this$toExpires == null ? (Expires)Expires.Session.INSTANCE : (Expires)new Expires.Date($this$toExpires);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final SameSite toSameSite(@Nullable String $this$toSameSite) {
        block10: {
            block8: {
                block9: {
                    v0 = $this$toSameSite;
                    if (v0 != null) {
                        var2_1 = v0;
                        v1 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDefault()");
                        v2 = var2_1.toLowerCase(v1);
                        v3 = v2;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"this as java.lang.String).toLowerCase(locale)");
                    } else {
                        v3 = var1_2 = null;
                    }
                    if (var1_2 == null) break block8;
                    switch (var1_2.hashCode()) {
                        case 106915: {
                            if (var1_2.equals("lax")) break;
                            ** break;
                        }
                        case 3387192: {
                            if (!var1_2.equals("none")) {
                                ** break;
                            }
                            break block9;
                        }
                        case -891986231: {
                            if (!var1_2.equals("strict")) ** break;
                            v4 = SameSite.STRICT;
                            break block10;
                        }
                    }
                    v4 = SameSite.LAX;
                    break block10;
                }
                v4 = SameSite.NONE;
                break block10;
            }
            v4 = SameSite.LAX;
        }
        return v4;
    }

    public static final void trustSelfSignedClient(@NotNull HttpClientConfig<ApacheEngineConfig> $this$trustSelfSignedClient) {
        Intrinsics.checkNotNullParameter($this$trustSelfSignedClient, (String)"<this>");
        $this$trustSelfSignedClient.engine((Function1)trustSelfSignedClient.1.INSTANCE);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public static final Object toResult(@NotNull HttpResponse var0, @NotNull Continuation<? super Result> var1_1) {
        if (!(var1_1 instanceof toResult.1)) ** GOTO lbl-1000
        var20_2 = var1_1;
        if ((var20_2.label & -2147483648) != 0) {
            var20_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ExtensionsKt.toResult(null, (Continuation<? super Result>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this$toResult;
                $continuation.label = 1;
                v0 = HttpResponseKt.bodyAsText$default((HttpResponse)$this$toResult, null, (Continuation)$continuation, (int)1, null);
                if (v0 == var21_4) {
                    return var21_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this$toResult = (HttpResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                var2_5 = (String)v0;
                var3_6 = ExtensionsKt.toStatus($this$toResult);
                v1 /* !! */  = HttpMessagePropertiesKt.contentType((HttpMessage)((HttpMessage)$this$toResult));
                var4_7 = v1 /* !! */  != null && (v1 /* !! */  = v1 /* !! */ .toString()) != null ? StringsKt.replace$default((String)v1 /* !! */ , (String)" ", (String)"", (boolean)false, (int)4, null) : null;
                $this$associateBy$iv = StringValuesKt.flattenEntries((StringValues)((StringValues)$this$toResult.getHeaders()));
                $i$f$associateBy = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                var9_12 = $this$associateBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    var14_17 = (Pair)element$iv$iv;
                    var16_19 = destination$iv$iv;
                    $i$a$-associateBy-ExtensionsKt$toResult$2 = false;
                    item = (Pair)element$iv$iv;
                    var17_20 = (String)item.getFirst();
                    $i$a$-associateBy-ExtensionsKt$toResult$3 = false;
                    Intrinsics.checkNotNull((Object)$this$toResult.getHeaders().get((String)item.getFirst()));
                    var16_19.put(var17_20, var18_21);
                }
                var5_22 = destination$iv$iv;
                $this$map$iv = HttpMessagePropertiesKt.setCookie((HttpMessage)((HttpMessage)$this$toResult));
                $i$f$map = false;
                $this$associateByTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    item = (io.ktor.http.Cookie)item$iv$iv;
                    var16_19 = destination$iv$iv;
                    $i$a$-map-ExtensionsKt$toResult$4 = false;
                    var16_19.add(ExtensionsKt.toDomainCookie((io.ktor.http.Cookie)cookie, CookieKt.getUrlOrigin((String)HttpResponseKt.getRequest((HttpResponse)$this$toResult).getUrl().toString())));
                }
                var6_8 = (List)destination$iv$iv;
                var7_10 = HttpResponseKt.getRequest((HttpResponse)$this$toResult).getUrl().toString();
                return new Result(var2_5, var3_6, var4_7, var5_22, var7_10, var6_8);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final Result.Status toStatus(@NotNull HttpResponse $this$toStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$toStatus, (String)"<this>");
        return new Result.Status($this$toStatus.getStatus().getValue(), $this$toStatus.getStatus().getDescription());
    }

    @Nullable
    public static final HttpHost toHttpHost(@NotNull Proxy $this$toHttpHost) {
        HttpHost httpHost;
        int n;
        Proxy.Type type;
        Intrinsics.checkNotNullParameter((Object)$this$toHttpHost, (String)"<this>");
        Proxy.Type type2 = type = $this$toHttpHost.type();
        int n2 = n = type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type2.ordinal()];
        if (type == Proxy.NO_PROXY) {
            httpHost = null;
        } else if (n == 1) {
            SocketAddress socketAddress = $this$toHttpHost.address();
            Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"this.address()");
            String string = NetworkAddressJvmKt.getHostname((SocketAddress)socketAddress);
            SocketAddress socketAddress2 = $this$toHttpHost.address();
            Intrinsics.checkNotNullExpressionValue((Object)socketAddress2, (String)"this.address()");
            httpHost = new HttpHost(string, NetworkAddressJvmKt.getPort((SocketAddress)socketAddress2));
        } else {
            httpHost = null;
        }
        return httpHost;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Method.values().length];
            try {
                nArray[Method.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.POST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.HEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.DELETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.PATCH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.PUT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Proxy.Type.values().length];
            try {
                nArray[Proxy.Type.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

