/*
 * Decompiled with CFR 0.152.
 */
package it.skrape.core;

import it.skrape.fetcher.BrowserFetcher;
import it.skrape.selects.Doc;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0018H\u0002R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lit/skrape/core/Parser;", "", "html", "", "charset", "Ljava/nio/charset/Charset;", "jsExecution", "", "baseUri", "(Ljava/lang/String;Ljava/nio/charset/Charset;ZLjava/lang/String;)V", "getBaseUri", "()Ljava/lang/String;", "getCharset", "()Ljava/nio/charset/Charset;", "getHtml", "setHtml", "(Ljava/lang/String;)V", "getJsExecution", "()Z", "checkBrowserFetcherIsPresent", "", "parse", "Lit/skrape/selects/Doc;", "toDocWrapper", "Lorg/jsoup/nodes/Document;", "MissingDependencyException", "html-parser"})
public final class Parser {
    @NotNull
    private String html;
    @NotNull
    private final Charset charset;
    private final boolean jsExecution;
    @NotNull
    private final String baseUri;

    public Parser(@NotNull String html2, @NotNull Charset charset, boolean jsExecution, @NotNull String baseUri) {
        Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)baseUri, (String)"baseUri");
        this.html = html2;
        this.charset = charset;
        this.jsExecution = jsExecution;
        this.baseUri = baseUri;
    }

    @NotNull
    public final String getHtml() {
        return this.html;
    }

    public final void setHtml(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.html = string;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public final boolean getJsExecution() {
        return this.jsExecution;
    }

    @NotNull
    public final String getBaseUri() {
        return this.baseUri;
    }

    @NotNull
    public final Doc parse() {
        Doc doc;
        if (this.jsExecution) {
            this.checkBrowserFetcherIsPresent();
            Document document2 = org.jsoup.parser.Parser.parse((String)BrowserFetcher.INSTANCE.render(this.html), (String)this.baseUri);
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"jSoupParser(BrowserFetcher.render(html), baseUri)");
            doc = this.toDocWrapper(document2);
        } else {
            Document document3 = org.jsoup.parser.Parser.parse((String)this.html, (String)this.baseUri);
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"jSoupParser(html, baseUri)");
            doc = this.toDocWrapper(document3);
        }
        return doc;
    }

    private final void checkBrowserFetcherIsPresent() {
        try {
            Class.forName("it.skrape.fetcher.BrowserFetcherKt");
        }
        catch (ClassNotFoundException e) {
            throw new MissingDependencyException("\u26a0\ufe0f You need to add browser-fetcher dependency to execute Javascript.\n\ud83d\udca1 Please add 'it.skrape:skrapeit-browser-fetcher' dependency to your project.\n\ud83e\uddd0 Find overview of latest releases: https://search.maven.org/artifact/it.skrape/skrapeit-browser-fetcher");
        }
    }

    private final Doc toDocWrapper(Document $this$toDocWrapper) {
        return new Doc($this$toDocWrapper, false, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lit/skrape/core/Parser$MissingDependencyException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "html-parser"})
    public static final class MissingDependencyException
    extends Exception {
        public MissingDependencyException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }

        public /* synthetic */ MissingDependencyException(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            this(string);
        }

        public MissingDependencyException() {
            this(null, 1, null);
        }
    }
}

