/*
 * Decompiled with CFR 0.152.
 */
package it.skrape.fetcher;

import io.ktor.client.HttpClientConfig;
import io.ktor.client.engine.apache.ApacheEngineConfig;
import io.ktor.client.plugins.HttpTimeout;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.utils.EmptyContent;
import io.ktor.http.DateUtilsKt;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesKt;
import io.ktor.util.date.GMTDate;
import io.ktor.util.network.NetworkAddressJvmKt;
import io.ktor.util.reflect.TypeInfoJvmKt;
import it.skrape.fetcher.Authentication;
import it.skrape.fetcher.Cookie;
import it.skrape.fetcher.CookieKt;
import it.skrape.fetcher.Domain;
import it.skrape.fetcher.Expires;
import it.skrape.fetcher.ExtensionsKt;
import it.skrape.fetcher.Method;
import it.skrape.fetcher.Request;
import it.skrape.fetcher.Result;
import it.skrape.fetcher.SameSite;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.http.HttpHost;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\bH\u0002\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0000\u001a\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0000\u001a\u000e\u0010\u001a\u001a\u00020\u001b*\u0004\u0018\u00010\bH\u0002\u001a\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0019H\u0002\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0000\u00a8\u0006\u001f"}, d2={"installBasicAuth", "", "Lio/ktor/client/HttpClientConfig;", "Lio/ktor/client/engine/apache/ApacheEngineConfig;", "toDomainCookie", "Lit/skrape/fetcher/Cookie;", "Lio/ktor/http/Cookie;", "origin", "", "toExpires", "Lit/skrape/fetcher/Expires;", "toHttpHost", "Lorg/apache/http/HttpHost;", "Ljava/net/Proxy;", "toHttpMethod", "Lio/ktor/http/HttpMethod;", "Lit/skrape/fetcher/Method;", "toHttpRequest", "Lio/ktor/client/request/HttpRequestBuilder;", "Lit/skrape/fetcher/Request;", "toMaxAge", "", "(I)Ljava/lang/Integer;", "toResult", "Lit/skrape/fetcher/Result;", "Lio/ktor/client/statement/HttpResponse;", "toSameSite", "Lit/skrape/fetcher/SameSite;", "toStatus", "Lit/skrape/fetcher/Result$Status;", "trustSelfSignedClient", "http-fetcher"})
@SourceDebugExtension(value={"SMAP\nextensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extensions.kt\nit/skrape/fetcher/ExtensionsKt\n+ 2 RequestBody.kt\nio/ktor/client/request/RequestBodyKt\n+ 3 TypeInfoJvm.kt\nio/ktor/util/reflect/TypeInfoJvmKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n16#2,12:127\n30#2:142\n17#3,3:139\n1208#4,2:143\n1238#4,4:145\n1549#4:149\n1620#4,3:150\n*S KotlinDebug\n*F\n+ 1 extensions.kt\nit/skrape/fetcher/ExtensionsKt\n*L\n37#1:127,12\n37#1:142\n37#1:139,3\n114#1:143,2\n114#1:145,4\n115#1:149\n115#1:150,3\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final HttpRequestBuilder toHttpRequest(@NotNull Request $this$toHttpRequest) {
        HttpRequestBuilder httpRequestBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toHttpRequest, (String)"<this>");
        Request request = $this$toHttpRequest;
        HttpRequestBuilder $this$toHttpRequest_u24lambda_u241 = httpRequestBuilder = new HttpRequestBuilder();
        boolean bl = false;
        $this$toHttpRequest_u24lambda_u241.setMethod(ExtensionsKt.toHttpMethod(request.getMethod()));
        HttpRequestKt.url((HttpRequestBuilder)$this$toHttpRequest_u24lambda_u241, (String)request.getUrl());
        HttpRequestKt.headers((HttpMessageBuilder)((HttpMessageBuilder)$this$toHttpRequest_u24lambda_u241), (Function1)((Function1)new Function1<HeadersBuilder, Unit>(request, $this$toHttpRequest){
            final /* synthetic */ Request $request;
            final /* synthetic */ Request $this_toHttpRequest;
            {
                this.$request = $request;
                this.$this_toHttpRequest = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HeadersBuilder $this$headers) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
                    Map $this$forEach$iv = this.$request.getHeaders();
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> entry = element$iv = iterator.next();
                        boolean bl = false;
                        String k = (String)entry.getKey();
                        String v = (String)entry.getValue();
                        $this$headers.append(k, v);
                    }
                    $this$headers.append("User-Agent", this.$request.getUserAgent());
                    this.$this_toHttpRequest.setCookies(this.$request.getCookies());
                    Authentication authentication = this.$request.getAuthentication();
                    if (authentication == null) break block1;
                    Authentication $this$invoke_u24lambda_u241 = authentication;
                    boolean bl = false;
                    $this$headers.append("Authorization", $this$invoke_u24lambda_u241.toHeaderValue());
                }
            }
        }));
        String string = request.getBody();
        if (string != null) {
            String $this$toHttpRequest_u24lambda_u241_u24lambda_u240 = string;
            boolean bl2 = false;
            HttpRequestBuilder $this$setBody$iv = $this$toHttpRequest_u24lambda_u241;
            boolean $i$f$setBody = false;
            String string2 = $this$toHttpRequest_u24lambda_u241_u24lambda_u240;
            if (string2 == null) {
                $this$setBody$iv.setBody((Object)EmptyContent.INSTANCE);
                $this$setBody$iv.setBodyType(null);
            } else if (string2 instanceof OutgoingContent) {
                $this$setBody$iv.setBody((Object)$this$toHttpRequest_u24lambda_u241_u24lambda_u240);
                $this$setBody$iv.setBodyType(null);
            } else {
                $this$setBody$iv.setBody((Object)$this$toHttpRequest_u24lambda_u241_u24lambda_u240);
                boolean $i$f$typeInfo = false;
                KType kType$iv$iv = Reflection.typeOf(String.class);
                Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(String.class), (KType)kType$iv$iv));
            }
        }
        HttpTimeoutKt.timeout((HttpRequestBuilder)$this$toHttpRequest_u24lambda_u241, (Function1)((Function1)new Function1<HttpTimeout.HttpTimeoutCapabilityConfiguration, Unit>(request){
            final /* synthetic */ Request $request;
            {
                this.$request = $request;
                super(1);
            }

            public final void invoke(@NotNull HttpTimeout.HttpTimeoutCapabilityConfiguration $this$timeout) {
                Intrinsics.checkNotNullParameter((Object)$this$timeout, (String)"$this$timeout");
                $this$timeout.setSocketTimeoutMillis(Long.valueOf(this.$request.getTimeout()));
            }
        }));
        return httpRequestBuilder;
    }

    public static final void installBasicAuth(@NotNull HttpClientConfig<ApacheEngineConfig> $this$installBasicAuth) {
        Intrinsics.checkNotNullParameter($this$installBasicAuth, (String)"<this>");
        $this$installBasicAuth.engine((Function1)installBasicAuth.1.INSTANCE);
    }

    private static final HttpMethod toHttpMethod(Method $this$toHttpMethod) {
        HttpMethod httpMethod;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toHttpMethod.ordinal()]) {
            case 1: {
                httpMethod = HttpMethod.Companion.getGet();
                break;
            }
            case 2: {
                httpMethod = HttpMethod.Companion.getPost();
                break;
            }
            case 3: {
                httpMethod = HttpMethod.Companion.getHead();
                break;
            }
            case 4: {
                httpMethod = HttpMethod.Companion.getDelete();
                break;
            }
            case 5: {
                httpMethod = HttpMethod.Companion.getPatch();
                break;
            }
            case 6: {
                httpMethod = HttpMethod.Companion.getPut();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpMethod;
    }

    private static final Cookie toDomainCookie(io.ktor.http.Cookie $this$toDomainCookie, String origin) {
        String string = $this$toDomainCookie.getPath();
        if (string == null) {
            string = "/";
        }
        String path = string;
        GMTDate gMTDate = $this$toDomainCookie.getExpires();
        Expires expires = ExtensionsKt.toExpires(gMTDate != null ? DateUtilsKt.toHttpDate((GMTDate)gMTDate) : null);
        String domainUrl = $this$toDomainCookie.getDomain();
        Domain domain = domainUrl == null ? new Domain(origin, false) : new Domain(CookieKt.getUrlOrigin((String)domainUrl), true);
        SameSite sameSite = ExtensionsKt.toSameSite((String)$this$toDomainCookie.getExtensions().get("SameSite"));
        Integer maxAge = ExtensionsKt.toMaxAge($this$toDomainCookie.getMaxAgeInt());
        return new Cookie($this$toDomainCookie.getName(), $this$toDomainCookie.getValue(), expires, maxAge, domain, path, sameSite, $this$toDomainCookie.getSecure(), $this$toDomainCookie.getHttpOnly());
    }

    private static final Integer toMaxAge(int $this$toMaxAge) {
        return $this$toMaxAge == 0 ? null : Integer.valueOf($this$toMaxAge);
    }

    private static final Expires toExpires(String $this$toExpires) {
        return $this$toExpires == null ? (Expires)Expires.Session.INSTANCE : (Expires)new Expires.Date($this$toExpires);
    }

    /*
     * Unable to fully structure code
     */
    private static final SameSite toSameSite(String $this$toSameSite) {
        block10: {
            block8: {
                block9: {
                    v0 = $this$toSameSite;
                    if (v0 != null) {
                        var2_1 = v0;
                        v1 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDefault()");
                        v2 = var2_1.toLowerCase(v1);
                        v3 = v2;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"this as java.lang.String).toLowerCase(locale)");
                    } else {
                        v3 = var1_2 = null;
                    }
                    if (var1_2 == null) break block8;
                    switch (var1_2.hashCode()) {
                        case 106915: {
                            if (var1_2.equals("lax")) break;
                            ** break;
                        }
                        case 3387192: {
                            if (!var1_2.equals("none")) {
                                ** break;
                            }
                            break block9;
                        }
                        case -891986231: {
                            if (!var1_2.equals("strict")) ** break;
                            v4 = SameSite.STRICT;
                            break block10;
                        }
                    }
                    v4 = SameSite.LAX;
                    break block10;
                }
                v4 = SameSite.NONE;
                break block10;
            }
            v4 = SameSite.LAX;
        }
        return v4;
    }

    public static final void trustSelfSignedClient(@NotNull HttpClientConfig<ApacheEngineConfig> $this$trustSelfSignedClient) {
        Intrinsics.checkNotNullParameter($this$trustSelfSignedClient, (String)"<this>");
        $this$trustSelfSignedClient.engine((Function1)trustSelfSignedClient.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result toResult(@NotNull HttpResponse $this$toResult) {
        void $this$mapTo$iv$iv;
        Pair item;
        Object object;
        Iterable $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toResult, (String)"<this>");
        String string = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>($this$toResult, null){
            int label;
            final /* synthetic */ HttpResponse $this_toResult;
            {
                this.$this_toResult = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpResponseKt.bodyAsText$default((HttpResponse)this.$this_toResult, null, (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Result.Status status = ExtensionsKt.toStatus($this$toResult);
        Object object2 = HttpMessagePropertiesKt.contentType((HttpMessage)((HttpMessage)$this$toResult));
        String string2 = object2 != null && (object2 = object2.toString()) != null ? StringsKt.replace$default((String)object2, (String)" ", (String)"", (boolean)false, (int)4, null) : null;
        Iterable iterable = StringValuesKt.flattenEntries((StringValues)((StringValues)$this$toResult.getHeaders()));
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var8_8 = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            String string3;
            Pair pair = (Pair)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            item = (Pair)element$iv$iv;
            String string4 = (String)item.getFirst();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)$this$toResult.getHeaders().get((String)item.getFirst()));
            object.put(string4, string3);
        }
        Map map = destination$iv$iv;
        Iterable $this$map$iv = HttpMessagePropertiesKt.setCookie((HttpMessage)((HttpMessage)$this$toResult));
        boolean $i$f$map = false;
        $this$associateByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cookie;
            item = (io.ktor.http.Cookie)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(ExtensionsKt.toDomainCookie((io.ktor.http.Cookie)cookie, CookieKt.getUrlOrigin((String)HttpResponseKt.getRequest((HttpResponse)$this$toResult).getUrl().toString())));
        }
        iterable = (List)destination$iv$iv;
        String string5 = HttpResponseKt.getRequest((HttpResponse)$this$toResult).getUrl().toString();
        return new Result(string, status, string2, map, string5, (List)iterable);
    }

    private static final Result.Status toStatus(HttpResponse $this$toStatus) {
        return new Result.Status($this$toStatus.getStatus().getValue(), $this$toStatus.getStatus().getDescription());
    }

    @Nullable
    public static final HttpHost toHttpHost(@NotNull Proxy $this$toHttpHost) {
        HttpHost httpHost;
        int n;
        Proxy.Type type;
        Intrinsics.checkNotNullParameter((Object)$this$toHttpHost, (String)"<this>");
        Proxy.Type type2 = type = $this$toHttpHost.type();
        int n2 = n = type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type2.ordinal()];
        if (type == Proxy.NO_PROXY) {
            httpHost = null;
        } else if (n == 1) {
            SocketAddress socketAddress = $this$toHttpHost.address();
            Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"this.address()");
            String string = NetworkAddressJvmKt.getHostname((SocketAddress)socketAddress);
            SocketAddress socketAddress2 = $this$toHttpHost.address();
            Intrinsics.checkNotNullExpressionValue((Object)socketAddress2, (String)"this.address()");
            httpHost = new HttpHost(string, NetworkAddressJvmKt.getPort((SocketAddress)socketAddress2));
        } else {
            httpHost = null;
        }
        return httpHost;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Method.values().length];
            try {
                nArray[Method.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.POST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.HEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.DELETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.PATCH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.PUT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Proxy.Type.values().length];
            try {
                nArray[Proxy.Type.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

