/*
 * Decompiled with CFR 0.152.
 */
package it.techgap.common.security.aop;

import it.techgap.common.security.aop.AspectSecurityUtils;
import it.techgap.common.security.cache.SecurityCache;
import it.techgap.common.security.rules.AspectSecurityRule;
import it.techgap.common.security.security.SecurityPolicy;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AspectSecurity<UserClass extends Authentication> {
    private static final Logger log = LoggerFactory.getLogger(AspectSecurity.class);
    private final SecurityCache<UserClass> securityCache;
    private String defaultPolicy = "denyAnonymousAccess";
    @Autowired
    ApplicationContext applicationContext;

    public AspectSecurity(SecurityCache<UserClass> securityCache) {
        this.securityCache = securityCache;
    }

    protected abstract UserClass getUser(Authentication var1);

    @Pointcut(value="execution(public * *(..))")
    public final void anyPublicOperation() {
    }

    @Pointcut(value="within(@it.techgap.common.security.annotation.AopSecured *)")
    public final void isSecuredBean() {
    }

    @Around(value="isSecuredBean() && anyPublicOperation()")
    public Object checkIfMethodAllowed(ProceedingJoinPoint pjp) throws Throwable {
        this.securityCheck(AspectSecurityUtils.getSignatureString(pjp), pjp);
        return pjp.proceed();
    }

    private void securityCheck(String signatureName, ProceedingJoinPoint pjp) throws Exception {
        Collection<SecurityPolicy> rules;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        UserClass theUser = this.getUser(authentication);
        if (theUser != null ? !this.checkRules(pjp, theUser, rules = this.securityCache.retrieve(theUser, signatureName)) : !this.getChecker(this.defaultPolicy).check(pjp, null)) {
            throw new InsufficientAuthenticationException("Access to method  is not allowed!");
        }
    }

    private boolean checkRules(ProceedingJoinPoint pjp, UserClass authenticationUser, Collection<? extends SecurityPolicy> rules) {
        if (CollectionUtils.isNotEmpty(rules)) {
            for (SecurityPolicy securityPolicy : rules) {
                AspectSecurityRule<UserClass> checker = this.getChecker(securityPolicy.getPolicy());
                if (checker == null || !checker.check(pjp, authenticationUser)) continue;
                return true;
            }
        }
        return false;
    }

    protected AspectSecurityRule<UserClass> getChecker(String rule) {
        return (AspectSecurityRule)this.applicationContext.getBean(rule, AspectSecurityRule.class);
    }

    public void setDefaultPolicy(String defaultPolicy) {
        if (defaultPolicy == null) {
            throw new IllegalArgumentException("defaultPolicy cannot be null!");
        }
        this.defaultPolicy = defaultPolicy;
    }
}

