/*
 * Decompiled with CFR 0.152.
 */
package it.techgap.common.security.aop;

import java.lang.reflect.Modifier;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public abstract class AspectSecurityUtils {
    public static Class<?> getTargetClass(ProceedingJoinPoint pjp) {
        Class declaringType = pjp.getSignature().getDeclaringType();
        int modifiers = declaringType.getModifiers();
        if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers)) {
            return pjp.getTarget().getClass();
        }
        return declaringType;
    }

    public static MethodSignature getMethodSignature(ProceedingJoinPoint pjp) {
        return (MethodSignature)pjp.getSignature();
    }

    public static String getSignatureString(ProceedingJoinPoint pjp) {
        return AspectSecurityUtils.getTargetClass(pjp).getCanonicalName() + "." + AspectSecurityUtils.getMethodSignature(pjp).getName();
    }
}

