/*
 * Decompiled with CFR 0.152.
 */
package it.techgap.common.security.cache;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import it.techgap.common.security.cache.SecurityCache;
import it.techgap.common.security.security.SecurityPolicy;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public abstract class GuavaBasedSecurityCache<U extends Authentication, P extends SecurityPolicy>
implements SecurityCache<U> {
    private static final Logger logger = LoggerFactory.getLogger(GuavaBasedSecurityCache.class);
    private static final long MAX_CACHE_SIZE = 1000L;
    private final LoadingCache<U, ImmutableListMultimap<String, P>> cache;
    private final PolicyNameGetter getPolicyName = new PolicyNameGetter();

    public GuavaBasedSecurityCache() {
        this(30L, TimeUnit.SECONDS);
    }

    public GuavaBasedSecurityCache(long duration, TimeUnit timeUnit) {
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(duration, timeUnit).build((CacheLoader)new SecurityCacheLoader());
    }

    protected abstract Collection<P> getPoliciesFor(U var1);

    @Override
    public Collection<? extends SecurityPolicy> retrieve(U user, String method) throws ExecutionException {
        return ((ImmutableListMultimap)this.cache.get(user)).get((Object)method);
    }

    @Override
    public void refresh(U user) {
        this.cache.refresh(user);
    }

    private class SecurityCacheLoader
    extends CacheLoader<U, ImmutableListMultimap<String, P>> {
        private SecurityCacheLoader() {
        }

        public ImmutableListMultimap<String, P> load(U user) throws Exception {
            try {
                Collection policies = GuavaBasedSecurityCache.this.getPoliciesFor(user);
                return Multimaps.index(policies, (Function)GuavaBasedSecurityCache.this.getPolicyName);
            }
            catch (Exception e) {
                logger.error("Error while retrieving policies for user {}", user, (Object)e);
                return ImmutableListMultimap.of();
            }
        }
    }

    private class PolicyNameGetter
    implements Function<SecurityPolicy, String> {
        private PolicyNameGetter() {
        }

        public String apply(SecurityPolicy input) {
            return input.getMethod();
        }
    }
}

