/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.boundary.gps.alignments;

import com.google.common.collect.ImmutableList;
import it.unibo.alchemist.boundary.gps.GPSTimeAlignment;
import it.unibo.alchemist.model.Time;
import it.unibo.alchemist.model.maps.GPSTrace;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AbstractGPSTimeAlignment
implements GPSTimeAlignment {
    private final SinglePointBehavior policy;

    protected AbstractGPSTimeAlignment(SinglePointBehavior policy) {
        this.policy = policy;
    }

    @Override
    public ImmutableList<GPSTrace> alignTime(List<GPSTrace> traces) {
        Stream stream = traces.stream().map(trace -> trace.startAt(this.computeStartTime(traces, (GPSTrace)trace)));
        if (this.policy == SinglePointBehavior.DISCARD_SINGLE_POINTS) {
            stream = stream.filter(trace -> trace.size() > 1);
        }
        if (this.policy == SinglePointBehavior.THROW_EXCEPTION_ON_SINGLE_POINTS) {
            ImmutableList reified = (ImmutableList)stream.collect(ImmutableList.toImmutableList());
            Optional<GPSTrace> single = reified.stream().filter(t -> t.size() <= 1).findAny();
            if (single.isPresent()) {
                throw new IllegalStateException("Time alignment produced a trace with a single point: " + single.get());
            }
            stream = reified.stream();
        }
        return (ImmutableList)stream.collect(ImmutableList.toImmutableList());
    }

    protected abstract Time computeStartTime(List<GPSTrace> var1, GPSTrace var2);

    protected static enum SinglePointBehavior {
        RETAIN_SINGLE_POINTS,
        DISCARD_SINGLE_POINTS,
        THROW_EXCEPTION_ON_SINGLE_POINTS;

    }
}

