/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.boundary.gps.alignments;

import it.unibo.alchemist.boundary.gps.alignments.AbstractGPSTimeAlignment;
import it.unibo.alchemist.model.Time;
import it.unibo.alchemist.model.maps.GPSTrace;
import it.unibo.alchemist.model.times.DoubleTime;
import java.util.List;
import java.util.Objects;

public final class AlignToTime
extends AbstractGPSTimeAlignment {
    private final Time time;

    public AlignToTime(double time2, boolean filterEmpty, boolean exceptionForEmpty) {
        this((Time)new DoubleTime(time2), filterEmpty, exceptionForEmpty);
    }

    public AlignToTime(Time time2, boolean filterEmpty, boolean exceptionForEmpty) {
        super(AlignToTime.getPolicy(filterEmpty, exceptionForEmpty));
        if (Objects.requireNonNull(time2).toDouble() < 0.0) {
            throw new IllegalArgumentException("the time can't be negative");
        }
        this.time = time2;
    }

    @Override
    protected Time computeStartTime(List<GPSTrace> allTraces, GPSTrace currentTrace) {
        return this.time;
    }

    private static AbstractGPSTimeAlignment.SinglePointBehavior getPolicy(boolean filterEmpty, boolean exceptionForEmpty) {
        if (filterEmpty && exceptionForEmpty) {
            return AbstractGPSTimeAlignment.SinglePointBehavior.THROW_EXCEPTION_ON_SINGLE_POINTS;
        }
        if (filterEmpty) {
            return AbstractGPSTimeAlignment.SinglePointBehavior.DISCARD_SINGLE_POINTS;
        }
        if (!exceptionForEmpty) {
            return AbstractGPSTimeAlignment.SinglePointBehavior.RETAIN_SINGLE_POINTS;
        }
        throw new IllegalArgumentException("Invalid combination of parameter filterEmpty: " + filterEmpty + " exceptionForEmpty: " + exceptionForEmpty);
    }
}

