/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.boundary.gps.loaders;

import com.google.common.collect.ImmutableSet;
import io.jenetics.jpx.GPX;
import io.jenetics.jpx.Track;
import io.jenetics.jpx.WayPoint;
import it.unibo.alchemist.boundary.gps.GPSFileLoader;
import it.unibo.alchemist.boundary.gps.loaders.GPXLoader;
import it.unibo.alchemist.model.Time;
import it.unibo.alchemist.model.maps.GPSPoint;
import it.unibo.alchemist.model.maps.GPSTrace;
import it.unibo.alchemist.model.maps.positions.GPSPointImpl;
import it.unibo.alchemist.model.maps.routes.GPSTraceImpl;
import it.unibo.alchemist.model.times.DoubleTime;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openstreetmap.osmosis.osmbinary.file.FileFormatException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lit/unibo/alchemist/boundary/gps/loaders/GPXLoader;", "Lit/unibo/alchemist/boundary/gps/GPSFileLoader;", "()V", "getGPX", "Lio/jenetics/jpx/GPX;", "stream", "Ljava/io/InputStream;", "getTrace", "Lit/unibo/alchemist/model/maps/GPSTrace;", "track", "Lio/jenetics/jpx/Track;", "readTrace", "", "url", "Ljava/net/URL;", "supportedExtensions", "Lcom/google/common/collect/ImmutableSet;", "", "Companion", "alchemist-maps"})
@SourceDebugExtension(value={"SMAP\nGPXLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GPXLoader.kt\nit/unibo/alchemist/boundary/gps/loaders/GPXLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class GPXLoader
implements GPSFileLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final ImmutableSet<String> EXTENSIONS = ImmutableSet.of((Object)"gpx");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<GPSTrace> readTrace(@NotNull URL url) {
        List<GPSTrace> list;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Closeable closeable = url.openStream();
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stream);
            List<GPSTrace> list2 = this.getGPX(stream).tracks().map(arg_0 -> GPXLoader.readTrace$lambda$1$lambda$0((Function1)new Function1<Track, GPSTrace>(this){
                final /* synthetic */ GPXLoader this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final GPSTrace invoke(@NotNull Track track) {
                    Intrinsics.checkNotNullParameter((Object)track, (String)"track");
                    Track track2 = Objects.requireNonNull(track, "GPS track not found");
                    Intrinsics.checkNotNullExpressionValue((Object)track2, (String)"requireNonNull(...)");
                    return GPXLoader.access$getTrace(this.this$0, track2);
                }
            }, arg_0)).collect(Collectors.toList());
            list = list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue(list, (String)"use(...)");
        return list;
    }

    @NotNull
    public ImmutableSet<String> supportedExtensions() {
        ImmutableSet<String> immutableSet = EXTENSIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"EXTENSIONS");
        return immutableSet;
    }

    private final GPX getGPX(InputStream stream) {
        GPX gPX;
        try {
            gPX = GPX.Reader.DEFAULT.read(stream);
            Intrinsics.checkNotNull((Object)gPX);
        }
        catch (IOException e) {
            FileFormatException realException = new FileFormatException("Cannot read the GPX content. Please make sure it is a valid GPX.");
            realException.initCause((Throwable)e);
            throw realException;
        }
        return gPX;
    }

    private final GPSTrace getTrace(Track track) {
        List list = track.getSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSegments(...)");
        if (!(!((Collection)list).isEmpty())) {
            boolean $i$a$-check-GPXLoader$getTrace$22 = false;
            String $i$a$-check-GPXLoader$getTrace$22 = "Track " + track + " contains no segment";
            throw new IllegalStateException($i$a$-check-GPXLoader$getTrace$22.toString());
        }
        if (!track.segments().noneMatch(arg_0 -> GPXLoader.getTrace$lambda$3(getTrace.2.INSTANCE, arg_0))) {
            boolean bl = false;
            String string = "Track " + track + " contains at least a segment with no points";
            throw new IllegalStateException(string.toString());
        }
        List<GPSPoint> list2 = track.segments().flatMap(arg_0 -> GPXLoader.getTrace$lambda$5(getTrace.points.1.INSTANCE, arg_0)).map(arg_0 -> GPXLoader.getTrace$lambda$6((Function1)new Function1<WayPoint, GPSPointImpl>(track){
            final /* synthetic */ Track $track;
            {
                this.$track = $track;
                super(1);
            }

            public final GPSPointImpl invoke(WayPoint wayPoint) {
                Optional<Double> time2 = wayPoint.getTime().map(arg_0 -> getTrace.points.2.invoke$lambda$0(getTrace.points.time.1.INSTANCE, arg_0));
                boolean bl = time2.isPresent();
                Track track = this.$track;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "Track " + track + " contains at least a waypoint without timestamp: " + wayPoint;
                    throw new IllegalStateException(string.toString());
                }
                double d = wayPoint.getLatitude().doubleValue();
                double d2 = wayPoint.getLongitude().doubleValue();
                Double d3 = time2.get();
                Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"get(...)");
                return new GPSPointImpl(d, d2, (Time)new DoubleTime(((Number)d3).doubleValue()));
            }

            private static final Double invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Double)$tmp0.invoke(p0);
            }
        }, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"collect(...)");
        List<GPSPoint> points2 = list2;
        return new GPSTraceImpl(points2);
    }

    private static final GPSTrace readTrace$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GPSTrace)$tmp0.invoke(p0);
    }

    private static final boolean getTrace$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Stream getTrace$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final GPSPointImpl getTrace$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GPSPointImpl)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ GPSTrace access$getTrace(GPXLoader $this, Track track) {
        return $this.getTrace(track);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lit/unibo/alchemist/boundary/gps/loaders/GPXLoader$Companion;", "", "()V", "EXTENSIONS", "Lcom/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "alchemist-maps"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

