/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.boundary.gps.loaders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import it.unibo.alchemist.boundary.gps.GPSFileLoader;
import it.unibo.alchemist.boundary.gps.GPSTimeAlignment;
import it.unibo.alchemist.model.maps.GPSTrace;
import it.unibo.alchemist.util.ClassPathScanner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.danilopianini.jirf.CreationResult;
import org.danilopianini.jirf.Factory;
import org.danilopianini.jirf.FactoryBuilder;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.fi.util.function.CheckedFunction;
import org.jooq.lambda.tuple.Tuple2;
import org.kaikikm.threadresloader.ResourceLoader;
import org.openstreetmap.osmosis.osmbinary.file.FileFormatException;

public final class TraceLoader
implements Iterable<GPSTrace> {
    private static final Map<String, GPSFileLoader> LOADER = ClassPathScanner.subTypesOf(GPSFileLoader.class, (String[])new String[]{"it.unibo.alchemist"}).stream().map(Unchecked.function(clazz -> (GPSFileLoader)clazz.getConstructor(new Class[0]).newInstance(new Object[0]))).flatMap(l -> l.supportedExtensions().stream().map(ext -> new Tuple2((Object)ext.toLowerCase(Locale.US), l))).collect(Collectors.toMap(Tuple2::v1, Tuple2::v2));
    private final boolean cyclic;
    private final ImmutableList<GPSTrace> traces;
    private static final Factory FACTORY = new FactoryBuilder().withWideningConversions().withNarrowingConversions().withAutoBoxing().build();
    private static final List<Class<? extends GPSTimeAlignment>> AVAILABLE_GPS_TIME_ALIGNMENT = ClassPathScanner.subTypesOf(GPSTimeAlignment.class, (String[])new String[0]);
    private static final Semaphore MUTEX = new Semaphore(1);

    public TraceLoader(String path, boolean cycle, GPSTimeAlignment normalizer) throws IOException {
        this.cyclic = cycle;
        this.traces = normalizer.alignTime(this.loadTraces(path));
    }

    public TraceLoader(String path, boolean cycle, String timeNormalizerClass, Object ... normalizerArgs) throws IOException {
        this(path, cycle, TraceLoader.makeNormalizer(timeNormalizerClass, normalizerArgs));
    }

    public TraceLoader(String path, GPSTimeAlignment normalizer) throws IOException {
        this(path, false, normalizer);
    }

    public TraceLoader(String path, String timeNormalizerClass, Object ... normalizerArgs) throws IOException {
        this(path, false, timeNormalizerClass, normalizerArgs);
    }

    @Override
    @Nonnull
    public Iterator<GPSTrace> iterator() {
        return this.cyclic ? Iterators.cycle(this.traces) : this.traces.iterator();
    }

    private List<GPSTrace> loadTraces(String path) throws IOException {
        boolean isDirectory = TraceLoader.runOnPathsStream(path, s -> s.allMatch(line -> ResourceLoader.getResource((String)line) != null));
        if (isDirectory) {
            return (List)TraceLoader.runOnPathsStream(path, s -> (ImmutableList)s.map(CheckedFunction.unchecked(this::loadTraces)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList()));
        }
        String[] pathSplit = path.split("\\.");
        String extensionFile = pathSplit[pathSplit.length - 1].toLowerCase(Locale.US);
        if (!LOADER.containsKey(extensionFile)) {
            throw new IllegalArgumentException("no loader defined for file with extension: " + extensionFile + " (file: " + path + ")");
        }
        GPSFileLoader fileLoader = LOADER.get(extensionFile);
        try {
            return fileLoader.readTrace(ResourceLoader.getResource((String)path));
        }
        catch (FileFormatException e) {
            throw new IllegalStateException("Loader: " + LOADER.get(extensionFile).getClass().getSimpleName() + " can't load file: " + path + ", plese make sure it is a " + extensionFile + "file?", e);
        }
    }

    public Optional<Integer> size() {
        return Optional.ofNullable(this.cyclic ? null : Integer.valueOf(this.traces.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GPSTimeAlignment makeNormalizer(String clazzName, Object ... args) {
        Optional<Class<? extends GPSTimeAlignment>> targetClass;
        Optional<Class<? extends GPSTimeAlignment>> optional = targetClass = clazzName.contains(".") ? TraceLoader.findClassWithName(Class::getName, clazzName) : TraceLoader.findClassWithName(Class::getSimpleName, clazzName);
        if (targetClass.isEmpty()) {
            throw new IllegalArgumentException("Normalizer with claas name: " + clazzName + " not found.Available GPSTimeAlignment are: [" + AVAILABLE_GPS_TIME_ALIGNMENT.stream().map(Class::getName).reduce((c1, c2) -> c1 + ", " + c2).orElse("") + " ]");
        }
        try {
            MUTEX.acquireUninterruptibly();
            CreationResult buildResult = FACTORY.build(targetClass.get(), args);
            GPSTimeAlignment gPSTimeAlignment = (GPSTimeAlignment)buildResult.getCreatedObjectOrThrowException();
            return gPSTimeAlignment;
        }
        finally {
            MUTEX.release();
        }
    }

    private static Optional<Class<? extends GPSTimeAlignment>> findClassWithName(Function<Class<? extends GPSTimeAlignment>, String> classToName, String targetName) {
        return AVAILABLE_GPS_TIME_ALIGNMENT.stream().filter(clazz -> ((String)classToName.apply((Class<? extends GPSTimeAlignment>)clazz)).equals(targetName)).findFirst();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <R> R runOnPathsStream(String path, Function<Stream<String>, R> op) {
        InputStream resourceStream = ResourceLoader.getResourceAsStream((String)path);
        Objects.requireNonNull(resourceStream, "resource not found: '" + path + "', make sure the file exists in the classpath");
        try (BufferedReader in = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));){
            R r = op.apply(in.lines().map(line -> path + "/" + line));
            return r;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error reading lines of: " + path, e);
        }
    }
}

