/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.actions;

import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Node;
import it.unibo.alchemist.model.Reaction;
import it.unibo.alchemist.model.RoutingService;
import it.unibo.alchemist.model.RoutingServiceOptions;
import it.unibo.alchemist.model.maps.GPSTrace;
import it.unibo.alchemist.model.maps.MapEnvironment;
import it.unibo.alchemist.model.maps.actions.MoveOnMapWithGPS;
import it.unibo.alchemist.model.maps.movestrategies.routing.OnStreets;
import it.unibo.alchemist.model.maps.movestrategies.speed.RoutingTraceDependantSpeed;
import it.unibo.alchemist.model.maps.movestrategies.target.FollowTrace;
import it.unibo.alchemist.model.movestrategies.RoutingStrategy;
import it.unibo.alchemist.model.movestrategies.SpeedSelectionStrategy;
import it.unibo.alchemist.model.movestrategies.TargetSelectionStrategy;

public final class GPSTraceWalker<T, O extends RoutingServiceOptions<O>, S extends RoutingService<GeoPosition, O>>
extends MoveOnMapWithGPS<T, O, S> {
    private static final long serialVersionUID = -6495138719085165782L;

    public GPSTraceWalker(MapEnvironment<T, O, S> environment, Node<T> node, Reaction<T> reaction, O options, String path, boolean cycle, String normalizer, Object ... normalizerArgs) {
        this(environment, node, reaction, options, GPSTraceWalker.traceFor(environment, path, cycle, normalizer, normalizerArgs));
    }

    public GPSTraceWalker(MapEnvironment<T, O, S> environment, Node<T> node, Reaction<T> reaction, String path, boolean cycle, String normalizer, Object ... normalizerArgs) {
        this(environment, node, reaction, environment.getRoutingService().getDefaultOptions(), path, cycle, normalizer, normalizerArgs);
    }

    private GPSTraceWalker(MapEnvironment<T, O, S> environment, Node<T> node, Reaction<T> reaction, O options, GPSTrace trace) {
        this(environment, node, new OnStreets<T, O, S>(environment, options), new RoutingTraceDependantSpeed<T, O, S>(environment, node, reaction, options), new FollowTrace(reaction), trace);
    }

    private GPSTraceWalker(MapEnvironment<T, O, S> environment, Node<T> node, RoutingStrategy<T, GeoPosition> routingStrategy, SpeedSelectionStrategy<T, GeoPosition> speedSelectionStrategy, TargetSelectionStrategy<T, GeoPosition> targetSelectionStrategy, GPSTrace trace) {
        super(environment, node, routingStrategy, speedSelectionStrategy, targetSelectionStrategy, trace);
    }

    @Override
    public GPSTraceWalker<T, O, S> cloneAction(Node<T> node, Reaction<T> reaction) {
        return new GPSTraceWalker(this.getEnvironment(), node, this.getRoutingStrategy().cloneIfNeeded(node, reaction), this.getSpeedSelectionStrategy().cloneIfNeeded(node, reaction), this.getTargetSelectionStrategy().cloneIfNeeded(node, reaction), this.getTrace());
    }
}

