/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.actions;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unibo.alchemist.boundary.gps.loaders.TraceLoader;
import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Node;
import it.unibo.alchemist.model.RoutingService;
import it.unibo.alchemist.model.RoutingServiceOptions;
import it.unibo.alchemist.model.maps.GPSTrace;
import it.unibo.alchemist.model.maps.MapEnvironment;
import it.unibo.alchemist.model.maps.ObjectWithGPS;
import it.unibo.alchemist.model.maps.actions.MoveOnMap;
import it.unibo.alchemist.model.movestrategies.RoutingStrategy;
import it.unibo.alchemist.model.movestrategies.SpeedSelectionStrategy;
import it.unibo.alchemist.model.movestrategies.TargetSelectionStrategy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="SpotBugs is reporting false positives")
public class MoveOnMapWithGPS<T, O extends RoutingServiceOptions<O>, S extends RoutingService<GeoPosition, O>>
extends MoveOnMap<T, O, S> {
    private static final long serialVersionUID = 1L;
    private static final LoadingCache<TraceRef, TraceLoader> TRACE_LOADER_CACHE = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(key -> new TraceLoader(key.path, key.cycle, key.normalizer, key.args));
    private static final LoadingCache<MapEnvironment<?, ?, ?>, LoadingCache<TraceRef, Iterator<GPSTrace>>> LOADER = Caffeine.newBuilder().weakKeys().build(e -> Caffeine.newBuilder().build(key -> Objects.requireNonNull((TraceLoader)TRACE_LOADER_CACHE.get(key)).iterator()));
    private final GPSTrace trace;

    public MoveOnMapWithGPS(MapEnvironment<T, O, S> environment, Node<T> node, RoutingStrategy<T, GeoPosition> routingStrategy, SpeedSelectionStrategy<T, GeoPosition> speedSelectionStrategy, TargetSelectionStrategy<T, GeoPosition> targetSelectionStrategy, String path, boolean cycle, String normalizer, Object ... normalizerArgs) {
        this(environment, node, routingStrategy, speedSelectionStrategy, targetSelectionStrategy, MoveOnMapWithGPS.traceFor(environment, path, cycle, normalizer, normalizerArgs));
    }

    public MoveOnMapWithGPS(MapEnvironment<T, O, S> environment, Node<T> node, RoutingStrategy<T, GeoPosition> routingStrategy, SpeedSelectionStrategy<T, GeoPosition> speedSelectionStrategy, TargetSelectionStrategy<T, GeoPosition> targetSelectionStrategy, GPSTrace trace) {
        super(environment, node, routingStrategy, speedSelectionStrategy, targetSelectionStrategy);
        this.trace = Objects.requireNonNull(trace);
        if (routingStrategy instanceof ObjectWithGPS) {
            ((ObjectWithGPS)routingStrategy).setTrace(trace);
        }
        if (speedSelectionStrategy instanceof ObjectWithGPS) {
            ((ObjectWithGPS)speedSelectionStrategy).setTrace(trace);
        }
        if (targetSelectionStrategy instanceof ObjectWithGPS) {
            ((ObjectWithGPS)targetSelectionStrategy).setTrace(trace);
        }
    }

    public static GPSTrace traceFor(MapEnvironment<?, ?, ?> environment, String path, boolean cycle, String normalizer, Object ... normalizerArgs) {
        LoadingCache gpsTraceLoader = (LoadingCache)LOADER.get(Objects.requireNonNull(environment));
        if (gpsTraceLoader == null) {
            throw new IllegalStateException("Unable to load a GPS Trace mapping for: " + environment + " (null was returned)");
        }
        TraceRef key = new TraceRef(Objects.requireNonNull(path), cycle, normalizer, Objects.requireNonNull(normalizerArgs));
        Iterator iter = (Iterator)gpsTraceLoader.get((Object)key);
        if (iter == null) {
            throw new IllegalStateException("Unable to load a GPS Trace iterator for: " + key);
        }
        if (iter.hasNext()) {
            return (GPSTrace)iter.next();
        }
        throw new IllegalStateException("All traces for " + key + " have been consumed.");
    }

    protected GPSTrace getTrace() {
        return this.trace;
    }

    private static final class TraceRef {
        private final String path;
        private final String normalizer;
        private final boolean cycle;
        private final Object[] args;
        private int hash;

        private TraceRef(String path, boolean cycle, String normalizer, Object ... args) {
            this.path = path;
            this.cycle = cycle;
            this.normalizer = normalizer;
            this.args = args;
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = Objects.hash(this.path, this.normalizer, this.cycle, Arrays.hashCode(this.args));
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TraceRef) {
                TraceRef ck = (TraceRef)obj;
                return this.path.equals(ck.path) && this.normalizer.equals(ck.normalizer) && this.cycle == ck.cycle && Arrays.deepEquals(this.args, ck.args);
            }
            return false;
        }

        public String toString() {
            return (this.cycle ? "Cyclic" : "") + "Trace[path=" + this.path + ", normalizer=" + this.normalizer + "(" + Arrays.toString(this.args) + ")]";
        }
    }
}

