/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.actions;

import it.unibo.alchemist.model.Environment;
import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Node;
import it.unibo.alchemist.model.Position;
import it.unibo.alchemist.model.Reaction;
import it.unibo.alchemist.model.Route;
import it.unibo.alchemist.model.RoutingService;
import it.unibo.alchemist.model.RoutingServiceOptions;
import it.unibo.alchemist.model.deployments.Polygon;
import it.unibo.alchemist.model.maps.MapEnvironment;
import it.unibo.alchemist.model.maps.actions.MoveOnMap;
import it.unibo.alchemist.model.movestrategies.ChangeTargetOnCollision;
import it.unibo.alchemist.model.movestrategies.SpeedSelectionStrategy;
import it.unibo.alchemist.model.movestrategies.TargetSelectionStrategy;
import it.unibo.alchemist.model.movestrategies.speed.ConstantSpeed;
import it.unibo.alchemist.model.routes.PolygonalChain;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\u0014\b\u0002\u0010\u0004*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00020\u00052\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u0007Ba\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0013\u00a2\u0006\u0002\u0010\u0015BQ\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017\u00a2\u0006\u0002\u0010\u0018R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lit/unibo/alchemist/model/maps/actions/RandomTargetInPolygonOnMap;", "T", "O", "Lit/unibo/alchemist/model/RoutingServiceOptions;", "S", "Lit/unibo/alchemist/model/RoutingService;", "Lit/unibo/alchemist/model/GeoPosition;", "Lit/unibo/alchemist/model/maps/actions/MoveOnMap;", "randomGenerator", "Lorg/apache/commons/math3/random/RandomGenerator;", "environment", "Lit/unibo/alchemist/model/maps/MapEnvironment;", "node", "Lit/unibo/alchemist/model/Node;", "reaction", "Lit/unibo/alchemist/model/Reaction;", "speed", "", "polygonCoordinates", "", "", "(Lorg/apache/commons/math3/random/RandomGenerator;Lit/unibo/alchemist/model/maps/MapEnvironment;Lit/unibo/alchemist/model/Node;Lit/unibo/alchemist/model/Reaction;DLjava/util/List;)V", "positionGenerator", "Lit/unibo/alchemist/model/deployments/Polygon;", "(Lit/unibo/alchemist/model/maps/MapEnvironment;Lit/unibo/alchemist/model/Node;Lit/unibo/alchemist/model/Reaction;DLit/unibo/alchemist/model/deployments/Polygon;)V", "getPositionGenerator", "()Lit/unibo/alchemist/model/deployments/Polygon;", "alchemist-maps"})
public final class RandomTargetInPolygonOnMap<T, O extends RoutingServiceOptions<? extends O>, S extends RoutingService<GeoPosition, O>>
extends MoveOnMap<T, O, S> {
    @NotNull
    private final Polygon<GeoPosition> positionGenerator;

    public RandomTargetInPolygonOnMap(final @NotNull MapEnvironment<T, O, S> environment, final @NotNull Node<T> node, @NotNull Reaction<T> reaction, double speed, final @NotNull Polygon<GeoPosition> positionGenerator) {
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(reaction, (String)"reaction");
        Intrinsics.checkNotNullParameter(positionGenerator, (String)"positionGenerator");
        Function0<GeoPosition> function0 = new Function0<GeoPosition>(){

            @NotNull
            public final GeoPosition invoke() {
                Position position = environment.getPosition(node);
                Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getPosition(...)");
                return (GeoPosition)position;
            }
        };
        super(environment, node, RandomTargetInPolygonOnMap::_init_$lambda$0, (SpeedSelectionStrategy)new ConstantSpeed(reaction, speed), (TargetSelectionStrategy)new ChangeTargetOnCollision<T, GeoPosition>(function0){

            protected GeoPosition chooseTarget() {
                return (GeoPosition)positionGenerator.stream().findFirst().orElseThrow(2::chooseTarget$lambda$0);
            }

            @NotNull
            public 2<T, O, S> cloneIfNeeded(@Nullable Node<T> destination, @Nullable Reaction<T> reaction) {
                return this;
            }

            private static final IllegalStateException chooseTarget$lambda$0() {
                return new IllegalStateException("Bug in Alchemist.");
            }
        });
        this.positionGenerator = positionGenerator;
    }

    @NotNull
    public final Polygon<GeoPosition> getPositionGenerator() {
        return this.positionGenerator;
    }

    public RandomTargetInPolygonOnMap(@NotNull RandomGenerator randomGenerator, @NotNull MapEnvironment<T, O, S> environment, @NotNull Node<T> node, @NotNull Reaction<T> reaction, double speed, @NotNull List<? extends List<? extends Number>> polygonCoordinates) {
        Intrinsics.checkNotNullParameter((Object)randomGenerator, (String)"randomGenerator");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(reaction, (String)"reaction");
        Intrinsics.checkNotNullParameter(polygonCoordinates, (String)"polygonCoordinates");
        this(environment, node, reaction, speed, (Polygon<GeoPosition>)new Polygon((Environment)environment, randomGenerator, 1, polygonCoordinates));
    }

    private static final Route _init_$lambda$0(GeoPosition current, GeoPosition geoPosition) {
        GeoPosition[] geoPositionArray = new GeoPosition[]{current, geoPosition};
        return (Route)new PolygonalChain((Position[])geoPositionArray);
    }
}

