/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.actions;

import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Molecule;
import it.unibo.alchemist.model.Node;
import it.unibo.alchemist.model.Reaction;
import it.unibo.alchemist.model.RoutingService;
import it.unibo.alchemist.model.RoutingServiceOptions;
import it.unibo.alchemist.model.maps.MapEnvironment;
import it.unibo.alchemist.model.maps.actions.MoveOnMap;
import it.unibo.alchemist.model.maps.movestrategies.routing.OnStreets;
import it.unibo.alchemist.model.maps.movestrategies.target.FollowTargetOnMap;
import it.unibo.alchemist.model.molecules.SimpleMolecule;
import it.unibo.alchemist.model.movestrategies.speed.ConstantSpeed;
import it.unibo.alchemist.model.movestrategies.speed.InteractWithOthers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TargetMapWalker<T, O extends RoutingServiceOptions<O>, S extends RoutingService<GeoPosition, O>>
extends MoveOnMap<T, O, S> {
    public static final double DEFAULT_SPEED = 1.5;
    public static final double DEFAULT_RANGE = 0.0;
    public static final double DEFAULT_INTERACTION = 0.0;
    private static final long serialVersionUID = 5097382908560832035L;

    public TargetMapWalker(@Nonnull MapEnvironment<T, O, S> environment, @Nonnull Node<T> node, @Nonnull Reaction<T> reaction, @Nonnull Molecule trackMolecule, @Nullable Molecule interactingMolecule, double speed, double interaction, double range) {
        super(environment, node, new OnStreets<T, O, S>(environment, environment.getRoutingService().getDefaultOptions()), interaction <= 0.0 || interactingMolecule == null ? new ConstantSpeed(reaction, speed) : new InteractWithOthers(environment, node, reaction, interactingMolecule, speed, range, interaction), new FollowTargetOnMap<T>(environment, node, trackMolecule));
    }

    public TargetMapWalker(MapEnvironment<T, O, S> environment, Node<T> node, Reaction<T> reaction, Molecule trackMolecule, Molecule interactingMolecule, double speed) {
        this(environment, node, reaction, trackMolecule, interactingMolecule, speed, 0.0, 0.0);
    }

    public TargetMapWalker(MapEnvironment<T, O, S> environment, Node<T> node, Reaction<T> reaction, Molecule trackMolecule, Molecule interactingMolecule) {
        this(environment, node, reaction, trackMolecule, interactingMolecule, 1.5);
    }

    public TargetMapWalker(MapEnvironment<T, O, S> environment, Node<T> node, Reaction<T> reaction, String trackMolecule, String interactingMolecule, double speed, double interaction, double range) {
        this(environment, node, reaction, (Molecule)new SimpleMolecule((CharSequence)trackMolecule), (Molecule)(interactingMolecule == null ? null : new SimpleMolecule((CharSequence)interactingMolecule)), speed, interaction, range);
    }

    public TargetMapWalker(MapEnvironment<T, O, S> environment, Node<T> node, Reaction<T> reaction, String trackMolecule, double speed) {
        this(environment, node, reaction, trackMolecule, null, speed, 0.0, 0.0);
    }

    public TargetMapWalker(MapEnvironment<T, O, S> environment, Node<T> node, Reaction<T> reaction, String trackMolecule) {
        this(environment, node, reaction, trackMolecule, 1.5);
    }
}

