/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.environments;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Incarnation;
import it.unibo.alchemist.model.Node;
import it.unibo.alchemist.model.Position;
import it.unibo.alchemist.model.Route;
import it.unibo.alchemist.model.environments.Abstract2DEnvironment;
import it.unibo.alchemist.model.maps.MapEnvironment;
import it.unibo.alchemist.model.maps.positions.LatLongPosition;
import it.unibo.alchemist.model.maps.routingservices.GraphHopperOptions;
import it.unibo.alchemist.model.maps.routingservices.GraphHopperRoutingService;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jooq.lambda.Unchecked;
import org.kaikikm.threadresloader.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OSMEnvironment<T>
extends Abstract2DEnvironment<T, GeoPosition>
implements MapEnvironment<T, GraphHopperOptions, GraphHopperRoutingService> {
    public static final int DEFAULT_APPROXIMATION = 0;
    public static final boolean DEFAULT_ON_STREETS = true;
    public static final boolean DEFAULT_FORCE_STREETS = false;
    private static final Logger L = LoggerFactory.getLogger(OSMEnvironment.class);
    private static final long serialVersionUID = 1L;
    private final boolean forceStreets;
    private final boolean onlyStreet;
    @Nullable
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Re-loaded automatically")
    private transient GraphHopperRoutingService navigator;
    @Nullable
    private transient LoadingCache<CacheEntry, Route<GeoPosition>> routecache;
    private boolean benchmarking;
    private final int approximation;
    private final String mapFile;

    public OSMEnvironment(Incarnation<T, GeoPosition> incarnation) {
        this(incarnation, null, false);
    }

    public OSMEnvironment(Incarnation<T, GeoPosition> incarnation, String file) {
        this(incarnation, file, true);
    }

    public OSMEnvironment(Incarnation<T, GeoPosition> incarnation, String file, boolean onStreets) {
        this(incarnation, file, onStreets, false);
    }

    public OSMEnvironment(Incarnation<T, GeoPosition> incarnation, String file, boolean onStreets, boolean onlyOnStreets) {
        this(incarnation, file, 0, onStreets, onlyOnStreets);
    }

    public OSMEnvironment(Incarnation<T, GeoPosition> incarnation, String file, int approximation) {
        this(incarnation, file, approximation, true, false);
    }

    public OSMEnvironment(Incarnation<T, GeoPosition> incarnation, String file, int approximation, boolean onStreets, boolean onlyOnStreets) {
        super(incarnation);
        if (approximation < 0 || approximation > 64) {
            throw new IllegalArgumentException();
        }
        this.forceStreets = onStreets;
        this.onlyStreet = onlyOnStreets;
        if (file == null) {
            L.warn("No OpenStreetMap extract provided. The navigation system won't be available.");
        }
        this.mapFile = file;
        this.approximation = approximation;
    }

    protected GeoPosition computeActualInsertionPosition(Node<T> node, GeoPosition position) {
        return this.forceStreets ? Optional.ofNullable(this.getNavigator().allowedPointClosestTo(Objects.requireNonNull(position))).orElse(position) : position;
    }

    @Override
    public Route<GeoPosition> computeRoute(GeoPosition p1, GeoPosition p2) {
        return this.computeRoute(p1, p2, GraphHopperRoutingService.Companion.getDefaultOptions());
    }

    @Override
    public Route<GeoPosition> computeRoute(GeoPosition from, GeoPosition to, GraphHopperOptions options) {
        if (this.routecache == null) {
            Caffeine builder = Caffeine.newBuilder();
            if (this.benchmarking) {
                builder.recordStats();
            }
            this.routecache = builder.expireAfterAccess(10L, TimeUnit.SECONDS).build(key -> this.getNavigator().route(Objects.requireNonNull(key).start, key.end, key.options));
        }
        return (Route)this.routecache.get((Object)new CacheEntry(options, from, to));
    }

    @Override
    public Route<GeoPosition> computeRoute(Node<T> node, GeoPosition coord) {
        return this.computeRoute(node, coord, GraphHopperRoutingService.Companion.getDefaultOptions());
    }

    @Override
    public Route<GeoPosition> computeRoute(Node<T> node, GeoPosition coord, GraphHopperOptions options) {
        return this.computeRoute((GeoPosition)this.getPosition(node), coord, options);
    }

    @Override
    public Route<GeoPosition> computeRoute(Node<T> node, Node<T> node2) {
        return this.computeRoute(node, (GeoPosition)this.getPosition(node2));
    }

    public void enableBenchmark() {
        this.benchmarking = true;
    }

    public double getBenchmarkResult() {
        if (this.benchmarking) {
            if (this.routecache != null) {
                return this.routecache.stats().hitRate();
            }
            return 0.0;
        }
        throw new IllegalStateException("You should call doBenchmark() before.");
    }

    private double getMaxLatitude() {
        return super.getOffset()[1] + super.getSize()[1];
    }

    private double getMaxLongitude() {
        return super.getOffset()[0] + super.getSize()[0];
    }

    private double getMinLatitude() {
        return super.getOffset()[1];
    }

    private double getMinLongitude() {
        return super.getOffset()[0];
    }

    @Override
    public GraphHopperRoutingService getRoutingService() {
        return this.getNavigator();
    }

    public double[] getSizeInDistanceUnits() {
        double minlat = this.getMinLatitude();
        double maxlat = this.getMaxLatitude();
        double minlon = this.getMinLongitude();
        double maxlon = this.getMaxLongitude();
        if (Double.isNaN(minlat) || Double.isNaN(maxlat) || Double.isNaN(minlon) || Double.isNaN(maxlon)) {
            return new double[]{Double.NaN, Double.NaN};
        }
        LatLongPosition minmin = new LatLongPosition(minlat, minlon);
        LatLongPosition minmax = new LatLongPosition(minlat, maxlon);
        LatLongPosition maxmin = new LatLongPosition(maxlat, minlon);
        LatLongPosition maxmax = new LatLongPosition(maxlat, maxlon);
        double sizex = Math.max(minmin.distanceTo((Position)minmax), maxmax.distanceTo((Position)maxmin));
        double sizey = Math.max(minmin.distanceTo((Position)maxmin), maxmax.distanceTo((Position)minmax));
        return new double[]{sizex, sizey};
    }

    public GeoPosition makePosition(Number ... coordinates) {
        if (coordinates.length != 2) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " only supports bi-dimensional coordinates (latitude, longitude)");
        }
        return new LatLongPosition(coordinates[0].doubleValue(), coordinates[1].doubleValue());
    }

    protected boolean nodeShouldBeAdded(Node<T> node, GeoPosition position) {
        assert (node != null);
        return !this.onlyStreet || this.getNavigator().allowedPointClosestTo(position) != null;
    }

    @Nonnull
    private GraphHopperRoutingService getNavigator() {
        if (this.navigator == null) {
            if (this.mapFile == null) {
                throw new IllegalStateException("Navigation system required, but no map file has been provided. Consider using BBBike at https://extract.bbbike.org/to get a protocolbuffer extract of OpenStreetMap");
            }
            URL map = Optional.of(new File(this.mapFile)).filter(File::exists).map(File::toURI).map(Unchecked.function(URI::toURL)).orElse(ResourceLoader.getResource((String)this.mapFile));
            if (map == null) {
                throw new IllegalArgumentException(this.mapFile + " is not a valid file on the file system,nor it can be loaded from the classpath as a Resource");
            }
            this.navigator = new GraphHopperRoutingService(map);
        }
        return this.navigator;
    }

    private final class CacheEntry {
        private final GeoPosition apprEnd;
        private final GeoPosition apprStart;
        private final GeoPosition end;
        private int hash;
        private final GeoPosition start;
        private final GraphHopperOptions options;

        private CacheEntry(GraphHopperOptions options, GeoPosition from, GeoPosition to) {
            this.options = Objects.requireNonNull(options);
            this.start = Objects.requireNonNull(from);
            this.end = Objects.requireNonNull(to);
            this.apprStart = this.approximate(this.start);
            this.apprEnd = this.approximate(this.end);
        }

        private double approximate(double value) {
            return Double.longBitsToDouble(Double.doubleToLongBits(value) & -1L << OSMEnvironment.this.approximation);
        }

        private GeoPosition approximate(GeoPosition p) {
            if (OSMEnvironment.this.approximation == 0) {
                return p;
            }
            return OSMEnvironment.this.makePosition(this.approximate(p.getLatitude()), this.approximate(p.getLongitude()));
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheEntry) {
                CacheEntry other = (CacheEntry)obj;
                return this.options.equals(other.options) && this.apprStart.equals(other.apprStart) && this.apprEnd.equals(other.apprEnd);
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = Objects.hash(this.options, this.apprStart, this.apprEnd);
            }
            return this.hash;
        }
    }
}

