/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.linkingrules;

import it.unibo.alchemist.model.Environment;
import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Neighborhood;
import it.unibo.alchemist.model.Node;
import it.unibo.alchemist.model.linkingrules.AbstractLocallyConsistentLinkingRule;
import it.unibo.alchemist.model.maps.MapEnvironment;
import it.unibo.alchemist.model.neighborhoods.Neighborhoods;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class LinkNodesWithinRoutingRange<T>
extends AbstractLocallyConsistentLinkingRule<T, GeoPosition> {
    private static final long serialVersionUID = 726751817489962367L;
    private final double range;

    public LinkNodesWithinRoutingRange(double r) {
        this.range = r;
    }

    public Neighborhood<T> computeNeighborhood(Node<T> center, Environment<T, GeoPosition> environment) {
        if (environment instanceof MapEnvironment) {
            MapEnvironment menv = (MapEnvironment)environment;
            Stream stream = menv.getNodesWithinRange(center, this.range).parallelStream();
            List filtered = stream.filter(node -> menv.computeRoute(center, node).length() < this.range).collect(Collectors.toList());
            return Neighborhoods.make((Environment)menv, center, filtered);
        }
        return Neighborhoods.make(environment, center);
    }
}

