/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.movestrategies.speed;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Node;
import it.unibo.alchemist.model.Reaction;
import it.unibo.alchemist.model.RoutingService;
import it.unibo.alchemist.model.RoutingServiceOptions;
import it.unibo.alchemist.model.Time;
import it.unibo.alchemist.model.maps.GPSPoint;
import it.unibo.alchemist.model.maps.MapEnvironment;
import it.unibo.alchemist.model.maps.movestrategies.AbstractStrategyWithGPS;
import it.unibo.alchemist.model.movestrategies.SpeedSelectionStrategy;
import java.util.Objects;

public abstract class TraceDependantSpeed<T, O extends RoutingServiceOptions<O>, S extends RoutingService<GeoPosition, O>>
extends AbstractStrategyWithGPS
implements SpeedSelectionStrategy<T, GeoPosition> {
    private static final long serialVersionUID = 8021140539083062866L;
    private final Reaction<T> reaction;
    private final MapEnvironment<T, O, S> environment;
    private final Node<T> node;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is made by purpose")
    public TraceDependantSpeed(MapEnvironment<T, O, S> environment, Node<T> node, Reaction<T> reaction) {
        this.environment = Objects.requireNonNull(environment);
        this.node = Objects.requireNonNull(node);
        this.reaction = Objects.requireNonNull(reaction);
    }

    public final double getNodeMovementLength(GeoPosition target) {
        GPSPoint next;
        double expArrival;
        Time currentTime = this.reaction.getTau();
        double curTime = currentTime.toDouble();
        if (curTime >= (expArrival = (next = this.getTrace().getNextPosition(currentTime)).getTime().toDouble())) {
            return Double.POSITIVE_INFINITY;
        }
        double frequency = this.reaction.getRate();
        double steps = (expArrival - curTime) * frequency;
        return this.computeDistance(this.environment, this.node, target) / steps;
    }

    protected abstract double computeDistance(MapEnvironment<T, O, S> var1, Node<T> var2, GeoPosition var3);

    protected MapEnvironment<T, O, S> getEnvironment() {
        return this.environment;
    }
}

