/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.positions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Time;
import it.unibo.alchemist.model.maps.GPSPoint;
import it.unibo.alchemist.model.maps.positions.LatLongPosition;
import java.util.List;
import javax.annotation.Nonnull;
import org.danilopianini.util.Hashes;

public final class GPSPointImpl
implements GPSPoint {
    private static final long serialVersionUID = 1L;
    private final LatLongPosition repr;
    private final Time t;

    public GPSPointImpl(double latitude, double longitude, Time time2) {
        this(new LatLongPosition(latitude, longitude), time2);
    }

    public GPSPointImpl(LatLongPosition latlong, Time time2) {
        this.repr = latlong;
        this.t = time2;
    }

    @Override
    public GPSPointImpl addTime(Time t) {
        return new GPSPointImpl(this.repr, this.t.plus(t));
    }

    @Nonnull
    public List<GeoPosition> boundingBox(double range) {
        return this.repr.boundingBox(range);
    }

    @Override
    public int compareTo(GPSPoint p) {
        return (int)Math.signum(this.t.toDouble() - p.getTime().toDouble());
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GPSPointImpl) {
            GPSPointImpl pt = (GPSPointImpl)obj;
            return pt.getTime().equals(this.t) && this.repr.equals(pt.repr);
        }
        return false;
    }

    @Nonnull
    public double[] getCoordinates() {
        return this.repr.getCoordinates();
    }

    public double getCoordinate(int dimension) {
        return this.repr.getCoordinate(dimension);
    }

    public GeoPosition plus(GeoPosition other) {
        return this.repr.plus(other);
    }

    @Nonnull
    public GeoPosition plus(@Nonnull double[] other) {
        return this.repr.plus(other);
    }

    public GeoPosition minus(GeoPosition other) {
        return this.repr.minus(other);
    }

    @Nonnull
    public GeoPosition minus(@Nonnull double[] other) {
        return this.repr.minus(other);
    }

    public int getDimensions() {
        return this.repr.getDimensions();
    }

    public double distanceTo(@Nonnull GeoPosition other) {
        if (other instanceof GPSPointImpl) {
            return this.repr.distanceTo(((GPSPointImpl)other).repr);
        }
        return this.repr.distanceTo(other);
    }

    public double getLatitude() {
        return this.repr.getLatitude();
    }

    public double getLongitude() {
        return this.repr.getLongitude();
    }

    @Override
    public Time getTime() {
        return this.t;
    }

    public double getX() {
        return this.repr.getX();
    }

    public double getY() {
        return this.repr.getY();
    }

    public int hashCode() {
        return Hashes.hash32((Object[])new Object[]{this.repr, this.t});
    }

    @Override
    public GPSPointImpl subtractTime(Time t) {
        return new GPSPointImpl(this.repr, this.t.minus(t));
    }

    public String toString() {
        return "[" + this.repr.getLatitude() + "," + this.repr.getLongitude() + "]@" + this.t;
    }
}

