/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.positions;

import com.google.common.collect.Lists;
import com.javadocmd.simplelatlng.LatLng;
import com.javadocmd.simplelatlng.util.LengthUnit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unibo.alchemist.model.GeoPosition;
import java.util.List;
import java.util.function.BinaryOperator;
import javax.annotation.Nonnull;
import org.apache.commons.math3.util.FastMath;
import org.danilopianini.util.Hashes;

public final class LatLongPosition
implements GeoPosition {
    public static final DistanceFormula DEFAULT_DISTANCE_FORMULA = DistanceFormula.EQUIRECTANGULAR;
    public static final double EARTH_MEAN_RADIUS_METERS = 6371009.0;
    private static final double MAX_LAT = Math.toRadians(90.0);
    private static final double MAX_LON = Math.toRadians(180.0);
    private static final double MIN_LAT = Math.toRadians(-90.0);
    private static final double MIN_LON = Math.toRadians(-180.0);
    private static final long serialVersionUID = -8972065367390749356L;
    private final DistanceFormula df;
    private int hash;
    private final LatLng latlng;

    public LatLongPosition(double lat, double lon) {
        this(lat, lon, DEFAULT_DISTANCE_FORMULA);
    }

    public LatLongPosition(double lat, double lon, DistanceFormula distanceFormula) {
        this.latlng = new LatLng(lat, lon);
        this.df = distanceFormula;
    }

    public LatLongPosition(double lat, double lon, int distanceFormula) {
        this(lat, lon, DistanceFormula.values()[distanceFormula % DistanceFormula.values().length]);
    }

    public LatLongPosition(Number lat, Number lon) {
        this(lat.doubleValue(), lon.doubleValue());
    }

    @Nonnull
    public List<GeoPosition> boundingBox(double range) {
        double maxLon;
        double minLon;
        if (range < 0.0) {
            throw new IllegalArgumentException("Negative ranges make no sense.");
        }
        double radDist = range / 6371009.0;
        double radLat = FastMath.toRadians((double)this.getLatitude());
        double radLon = FastMath.toRadians((double)this.getLongitude());
        double minLat = radLat - radDist;
        double maxLat = radLat + radDist;
        if (minLat > MIN_LAT && maxLat < MAX_LAT) {
            double deltaLon = FastMath.asin((double)(Math.sin(radDist) / FastMath.cos((double)radLat)));
            minLon = radLon - deltaLon;
            if (minLon < MIN_LON) {
                minLon += Math.PI * 2;
            }
            if ((maxLon = radLon + deltaLon) > MAX_LON) {
                maxLon -= Math.PI * 2;
            }
        } else {
            minLat = Math.max(minLat, MIN_LAT);
            maxLat = Math.min(maxLat, MAX_LAT);
            minLon = MIN_LON;
            maxLon = MAX_LON;
        }
        return Lists.newArrayList((Object[])new GeoPosition[]{new LatLongPosition(FastMath.toDegrees((double)minLat), FastMath.toDegrees((double)minLon)), new LatLongPosition(FastMath.toDegrees((double)maxLat), FastMath.toDegrees((double)maxLon))});
    }

    public static double distance(LatLng point1, LatLng point2, DistanceFormula df) {
        return LatLongPosition.distanceInRadians(point1, point2, df) * 6371009.0;
    }

    public static double distance(LatLng point1, LatLng point2, LengthUnit unit, DistanceFormula df) {
        return LengthUnit.METER.convertTo(unit, LatLongPosition.distance(point1, point2, df));
    }

    public double distanceTo(@Nonnull GeoPosition other) {
        if (other instanceof LatLongPosition) {
            return LatLongPosition.distance(this.latlng, ((LatLongPosition)other).latlng, this.df);
        }
        return LatLongPosition.distance(this.latlng, new LatLng(other.getLatitude(), other.getLongitude()), this.df);
    }

    private GeoPosition ebeOperation(BinaryOperator<Double> op, GeoPosition other) {
        return new LatLongPosition((Number)op.apply(this.getLatitude(), other.getLatitude()), (Number)op.apply(this.getLongitude(), other.getLongitude()));
    }

    @SuppressFBWarnings(justification="Exact floating point equality is required here.")
    public boolean equals(Object obj) {
        if (obj instanceof LatLongPosition) {
            LatLongPosition llp = (LatLongPosition)obj;
            return this.getLatitude() == llp.getLatitude() && this.getLongitude() == llp.getLongitude();
        }
        return false;
    }

    @Nonnull
    public double[] getCoordinates() {
        return new double[]{this.getLatitude(), this.getLongitude()};
    }

    public double getCoordinate(int dimension) {
        if (dimension == 0) {
            return this.getLatitude();
        }
        if (dimension == 1) {
            return this.getLongitude();
        }
        throw new IllegalArgumentException("Pass 1 for longitude or 0 for latitude. No other value accepted.");
    }

    public int getDimensions() {
        return 2;
    }

    public double getLatitude() {
        return this.latlng.getLatitude();
    }

    public double getLongitude() {
        return this.latlng.getLongitude();
    }

    public double getX() {
        return this.getLongitude();
    }

    public double getY() {
        return this.getLatitude();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Hashes.hash32((Object[])new Object[]{this.getLatitude(), this.getLongitude()});
        }
        return this.hash;
    }

    public GeoPosition minus(@Nonnull GeoPosition other) {
        return this.ebeOperation((self, o) -> self - o, other);
    }

    @Nonnull
    public GeoPosition minus(@Nonnull double[] other) {
        return new LatLongPosition(this.getLatitude() - other[0], this.getLongitude() - other[1]);
    }

    @Nonnull
    public GeoPosition plus(@Nonnull double[] other) {
        return new LatLongPosition(this.getLatitude() + other[0], this.getLongitude() + other[1]);
    }

    public GeoPosition plus(@Nonnull GeoPosition other) {
        return this.ebeOperation(Double::sum, other);
    }

    public String toString() {
        return this.latlng.toString();
    }

    public static double distanceInRadians(LatLng point1, LatLng point2, DistanceFormula precision) {
        double lat1R = FastMath.toRadians((double)point1.getLatitude());
        double lat2R = FastMath.toRadians((double)point2.getLatitude());
        double lon1R = FastMath.toRadians((double)point1.getLongitude());
        double lon2R = FastMath.toRadians((double)point2.getLongitude());
        switch (precision) {
            case HAVERSINE: {
                double dLatR = FastMath.abs((double)(lat2R - lat1R));
                double dLngR = FastMath.abs((double)(lon2R - lon1R));
                double a = FastMath.sin((double)(dLatR / 2.0)) * FastMath.sin((double)(dLatR / 2.0)) + FastMath.cos((double)lat1R) * FastMath.cos((double)lat2R) * FastMath.sin((double)(dLngR / 2.0)) * FastMath.sin((double)(dLngR / 2.0));
                return 2.0 * FastMath.atan2((double)FastMath.sqrt((double)a), (double)FastMath.sqrt((double)(1.0 - a)));
            }
            case SPHERICAL_COSINES: {
                return FastMath.acos((double)(FastMath.sin((double)lat1R) * FastMath.sin((double)lat2R) + FastMath.cos((double)lat1R) * FastMath.cos((double)lat2R) * FastMath.cos((double)FastMath.abs((double)(lon2R - lon1R)))));
            }
            case EQUIRECTANGULAR: {
                double x = (lon2R - lon1R) * FastMath.cos((double)((lat1R + lat2R) / 2.0));
                double y = lat2R - lat1R;
                return FastMath.sqrt((double)(x * x + y * y));
            }
        }
        throw new IllegalStateException("Unknown algorithm required: " + precision);
    }

    public static enum DistanceFormula {
        EQUIRECTANGULAR,
        HAVERSINE,
        SPHERICAL_COSINES;

    }
}

