/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.routes;

import com.google.common.collect.ImmutableList;
import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Position;
import it.unibo.alchemist.model.Time;
import it.unibo.alchemist.model.maps.GPSPoint;
import it.unibo.alchemist.model.maps.GPSTrace;
import it.unibo.alchemist.model.routes.PolygonalChain;
import it.unibo.alchemist.utils.Maps;
import java.util.List;
import org.apache.commons.math3.util.Pair;

public final class GPSTraceImpl
extends PolygonalChain<GPSPoint>
implements GPSTrace {
    private static final long serialVersionUID = 1L;

    public GPSTraceImpl(GPSPoint ... trace) {
        super((Position[])trace);
    }

    public GPSTraceImpl(List<GPSPoint> tr) {
        super(tr);
    }

    @Override
    public GPSTraceImpl startAt(Time time2) {
        List filtered = (List)this.stream().map(p -> p.subtractTime(time2)).filter(pt -> pt.getTime().toDouble() >= 0.0).collect(ImmutableList.toImmutableList());
        return new GPSTraceImpl((List<GPSPoint>)(filtered.isEmpty() ? ImmutableList.of((Object)this.getFinalPosition()) : filtered));
    }

    @Override
    public GPSPoint getNextPosition(Time time2) {
        return (GPSPoint)this.searchPoint(time2).getSecond();
    }

    @Override
    public GPSPoint getPreviousPosition(Time time2) {
        return (GPSPoint)this.searchPoint(time2).getFirst();
    }

    @Override
    public Time getStartTime() {
        return ((GPSPoint)this.getPoints().get(0)).getTime();
    }

    @Override
    public GeoPosition interpolate(Time time2) {
        Pair<GPSPoint, GPSPoint> coords = this.searchPoint(time2);
        GPSPoint prev = (GPSPoint)coords.getFirst();
        GPSPoint next = (GPSPoint)coords.getSecond();
        double tdtime = next.getTime().toDouble() - prev.getTime().toDouble();
        if (tdtime == 0.0) {
            return next;
        }
        double ratio = (time2.toDouble() - prev.getTime().toDouble()) / tdtime;
        double dist = Maps.getDistance(prev, next);
        return Maps.getDestinationLocation((GeoPosition)prev, next, dist * ratio);
    }

    private Pair<GPSPoint, GPSPoint> searchPoint(Time time2) {
        if (this.size() < 2 || time2.toDouble() < ((GPSPoint)this.getPoint(0)).getTime().toDouble()) {
            return new Pair((Object)((GPSPoint)this.getPoint(0)), (Object)((GPSPoint)this.getPoint(0)));
        }
        if (this.size() < 3) {
            return new Pair((Object)((GPSPoint)this.getPoint(0)), (Object)((GPSPoint)this.getPoint(1)));
        }
        if (time2.toDouble() > ((GPSPoint)this.getPoint(this.size() - 1)).getTime().toDouble()) {
            return new Pair((Object)((GPSPoint)this.getPoint(this.size() - 1)), (Object)((GPSPoint)this.getPoint(this.size() - 1)));
        }
        int low = 0;
        int high = this.size() - 1;
        int i = this.size() / 2;
        while (high - low > 1) {
            if (((GPSPoint)this.getPoint(i)).getTime().toDouble() < time2.toDouble()) {
                low = i;
            } else {
                high = i;
            }
            i = low + (high - low) / 2;
        }
        return new Pair((Object)((GPSPoint)this.getPoint(low)), (Object)((GPSPoint)this.getPoint(high)));
    }

    @Override
    public double getTripTime() {
        return ((GPSPoint)this.getPoint(this.size() - 1)).getTime().toDouble() - ((GPSPoint)this.getPoint(0)).getTime().toDouble();
    }

    @Override
    public GPSPoint getInitialPosition() {
        return (GPSPoint)this.getPoint(0);
    }

    @Override
    public GPSPoint getFinalPosition() {
        return (GPSPoint)this.getPoint(this.size() - 1);
    }

    @Override
    public Time getFinalTime() {
        return ((GPSPoint)this.getPoint(this.size() - 1)).getTime();
    }
}

