/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.routes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.graphhopper.GHResponse;
import com.graphhopper.ResponsePath;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint3D;
import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Position;
import it.unibo.alchemist.model.maps.TimedRoute;
import it.unibo.alchemist.model.maps.positions.LatLongPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lit/unibo/alchemist/model/maps/routes/GraphHopperRoute;", "Lit/unibo/alchemist/model/maps/TimedRoute;", "Lit/unibo/alchemist/model/GeoPosition;", "from", "to", "response", "Lcom/graphhopper/GHResponse;", "(Lit/unibo/alchemist/model/GeoPosition;Lit/unibo/alchemist/model/GeoPosition;Lcom/graphhopper/GHResponse;)V", "distance", "", "points", "Lcom/google/common/collect/ImmutableList;", "time", "getPoint", "step", "", "getPoints", "getTripTime", "iterator", "", "length", "size", "stream", "Ljava/util/stream/Stream;", "Companion", "alchemist-maps"})
@SourceDebugExtension(value={"SMAP\nGraphHopperRoute.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphHopperRoute.kt\nit/unibo/alchemist/model/maps/routes/GraphHopperRoute\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,100:1\n1549#2:101\n1620#2,3:102\n1313#3,2:105\n1313#3,2:107\n*S KotlinDebug\n*F\n+ 1 GraphHopperRoute.kt\nit/unibo/alchemist/model/maps/routes/GraphHopperRoute\n*L\n33#1:101\n33#1:102,3\n51#1:105,2\n60#1:107,2\n*E\n"})
public final class GraphHopperRoute
implements TimedRoute<GeoPosition> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double distance;
    private final double time;
    @NotNull
    private final ImmutableList<GeoPosition> points;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    public GraphHopperRoute(@NotNull GeoPosition from, @NotNull GeoPosition to, @NotNull GHResponse response) {
        ImmutableList.Builder builder;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        List errors = response.getErrors();
        if (errors.isEmpty()) {
            double endingDistance;
            Object[] it;
            void $this$mapTo$iv$iv;
            ResponsePath bestResponse = response.getBest();
            PointList pointList = bestResponse.getPoints();
            Intrinsics.checkNotNullExpressionValue((Object)pointList, (String)"getPoints(...)");
            Iterable $this$map$iv = (Iterable)pointList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GHPoint3D gHPoint3D = (GHPoint3D)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(GraphHopperRoute.Companion.asPosition((GHPoint3D)it));
            }
            List points2 = (List)destination$iv$iv;
            double initDistance = from.distanceTo((Position)CollectionsKt.first((List)points2));
            Sequence pointSequence = CollectionsKt.asSequence((Iterable)points2);
            double actualDistance = bestResponse.getDistance();
            if (initDistance > 0.0) {
                actualDistance += initDistance;
                Object[] objectArray = new GeoPosition[]{from};
                pointSequence = SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Sequence)pointSequence);
            }
            if ((endingDistance = ((LatLongPosition)CollectionsKt.last((List)points2)).distanceTo(to)) > 0.0) {
                actualDistance += endingDistance;
                it = new GeoPosition[]{to};
                pointSequence = SequencesKt.plus((Sequence)pointSequence, (Sequence)SequencesKt.sequenceOf((Object[])it));
            }
            double averageSpeed = bestResponse.getDistance() * (double)TimeUnit.SECONDS.toMillis(1L) / (double)bestResponse.getTime();
            this.time = actualDistance / averageSpeed;
            this.distance = actualDistance;
            builder = ImmutableList.builder();
            Sequence $this$forEach$iv = pointSequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GeoPosition p0 = (GeoPosition)element$iv;
                boolean bl = false;
                builder.add((Object)p0);
            }
        } else {
            Intrinsics.checkNotNull((Object)errors);
            Throwable firstError = (Throwable)CollectionsKt.first((List)errors);
            IllegalArgumentException exception = new IllegalArgumentException("Failure in the GraphHopper routing system when navigating from " + from + " to " + to + ", received response:\n" + response, firstError);
            Sequence $this$forEach$iv = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)errors), (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable it = (Throwable)element$iv;
                boolean bl = false;
                Throwable throwable = exception;
                Intrinsics.checkNotNull((Object)it);
                ExceptionsKt.addSuppressed((Throwable)throwable, (Throwable)it);
            }
            throw exception;
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        this.points = immutableList;
    }

    public double length() {
        return this.distance;
    }

    @NotNull
    public GeoPosition getPoint(int step) {
        Object object = this.points.get(step);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (GeoPosition)object;
    }

    @NotNull
    public ImmutableList<GeoPosition> getPoints() {
        return this.points;
    }

    @Override
    public double getTripTime() {
        return this.time;
    }

    @NotNull
    public Iterator<GeoPosition> iterator() {
        UnmodifiableIterator unmodifiableIterator = this.points.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        return (Iterator)unmodifiableIterator;
    }

    @NotNull
    public Stream<GeoPosition> stream() {
        Stream stream = this.points.stream();
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream(...)");
        return stream;
    }

    public int size() {
        return this.points.size();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lit/unibo/alchemist/model/maps/routes/GraphHopperRoute$Companion;", "", "()V", "serialVersionUID", "", "asPosition", "Lit/unibo/alchemist/model/maps/positions/LatLongPosition;", "Lcom/graphhopper/util/shapes/GHPoint3D;", "alchemist-maps"})
    public static final class Companion {
        private Companion() {
        }

        private final LatLongPosition asPosition(GHPoint3D $this$asPosition) {
            return new LatLongPosition($this$asPosition.lat, $this$asPosition.lon);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

