/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.routingservices;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.graphhopper.config.Profile;
import com.graphhopper.util.CustomModel;
import it.unibo.alchemist.model.RoutingServiceOptions;
import it.unibo.alchemist.model.maps.routingservices.GraphHopperOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u000f\u0010B\u0017\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0012\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions;", "Lit/unibo/alchemist/model/RoutingServiceOptions;", "profile", "", "algorithm", "(Ljava/lang/String;Ljava/lang/String;)V", "info", "Lkotlin/Pair;", "(Lkotlin/Pair;)V", "Lcom/graphhopper/config/Profile;", "(Lcom/graphhopper/config/Profile;Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "getProfile", "()Lcom/graphhopper/config/Profile;", "Companion", "GraphHopperWeighting", "alchemist-maps"})
@SourceDebugExtension(value={"SMAP\nGraphHopperOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphHopperOptions.kt\nit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1#2:147\n1549#3:148\n1620#3,3:149\n1360#3:152\n1446#3,2:153\n1549#3:155\n1620#3,3:156\n1448#3,3:159\n*S KotlinDebug\n*F\n+ 1 GraphHopperOptions.kt\nit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions\n*L\n40#1:148\n40#1:149,3\n103#1:152\n103#1:153,2\n103#1:155\n103#1:156,3\n103#1:159,3\n*E\n"})
public final class GraphHopperOptions
implements RoutingServiceOptions<GraphHopperOptions> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Profile profile;
    @NotNull
    private final String algorithm;
    @NotNull
    private static final LoadingCache<Pair<String, String>, GraphHopperOptions> profiles;
    @NotNull
    private static final List<String> graphHopperAlgorithms;
    @NotNull
    private static final List<String> graphHopperVehicles;
    @NotNull
    private static final List<GraphHopperWeighting> graphHopperWeightings;
    @NotNull
    private static final List<Profile> allProfiles;
    @NotNull
    private static final GraphHopperOptions defaultOptions;

    private GraphHopperOptions(Profile profile, String algorithm) {
        this.profile = profile;
        this.algorithm = algorithm;
    }

    @NotNull
    public final Profile getProfile() {
        return this.profile;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    /*
     * WARNING - void declaration
     */
    private GraphHopperOptions(String profile, String algorithm) {
        void it;
        Object v0;
        GraphHopperOptions graphHopperOptions;
        Object object;
        block4: {
            object = allProfiles;
            graphHopperOptions = this;
            Iterable iterable = object;
            for (Object t : iterable) {
                Profile it2 = (Profile)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)profile)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        GraphHopperOptions graphHopperOptions2 = graphHopperOptions;
        Profile profile2 = v0;
        if (profile2 == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = allProfiles;
            graphHopperOptions = graphHopperOptions2;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Profile profile3 = (Profile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it3.getName());
            }
            GraphHopperOptions graphHopperOptions3 = graphHopperOptions;
            String string = "Invalid GraphHopper profile. Valid profiles are: " + (List)destination$iv$iv;
            throw new IllegalArgumentException(string);
        }
        Object $i$f$map = object = algorithm;
        Profile profile4 = profile2;
        graphHopperOptions = graphHopperOptions2;
        boolean bl = false;
        boolean bl2 = graphHopperAlgorithms.contains(it);
        Object object2 = bl2 ? object : null;
        if (object2 == null) {
            throw new IllegalArgumentException("Invalid GraphHopper algorithm. Valid choices are: " + graphHopperAlgorithms);
        }
        graphHopperOptions(profile4, (String)object2);
    }

    private GraphHopperOptions(Pair<String, String> info) {
        this((String)info.getFirst(), (String)info.getSecond());
    }

    private static final GraphHopperOptions profiles$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GraphHopperOptions)$tmp0.invoke(p0);
    }

    private static final String _init_$error(String subject) {
        return "Unable to find any valid GraphHopper " + subject + ". This is most likely due to using an unsupported version of GraphHopper";
    }

    public /* synthetic */ GraphHopperOptions(Pair info, DefaultConstructorMarker $constructor_marker) {
        this((Pair<String, String>)info);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_6;
        void $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        LoadingCache loadingCache = Caffeine.newBuilder().build(arg_0 -> GraphHopperOptions.profiles$lambda$3(Companion.profiles.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        profiles = loadingCache;
        Object[] objectArray = new String[]{"alternative_route", "astar", "astarbi", "dijkstra", "dijkstrabi", "dijkstra_one_to_many", "round_trip"};
        graphHopperAlgorithms = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"bike", "car", "foot", "mtb", "racingbike", "roads"};
        graphHopperVehicles = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new GraphHopperWeighting[]{new GraphHopperWeighting("fastest", 0.0), new GraphHopperWeighting("short_fastest", 30.0), new GraphHopperWeighting("shortest", 3600.0)};
        graphHopperWeightings = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$flatMap$iv = graphHopperVehicles;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String vehicle = (String)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = graphHopperWeightings;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void weighting;
                GraphHopperWeighting graphHopperWeighting = (GraphHopperWeighting)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(GraphHopperOptions.Companion.profileFor(vehicle, (GraphHopperWeighting)weighting));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        allProfiles = (List)var3_6;
        if (!(!((Collection)graphHopperAlgorithms).isEmpty())) {
            boolean $i$a$-require-GraphHopperOptions$Companion$42 = false;
            String $i$a$-require-GraphHopperOptions$Companion$42 = GraphHopperOptions._init_$error("algorithm");
            throw new IllegalArgumentException($i$a$-require-GraphHopperOptions$Companion$42.toString());
        }
        if (!(!((Collection)graphHopperVehicles).isEmpty())) {
            boolean $i$a$-require-GraphHopperOptions$Companion$52 = false;
            String $i$a$-require-GraphHopperOptions$Companion$52 = GraphHopperOptions._init_$error("vehicle");
            throw new IllegalArgumentException($i$a$-require-GraphHopperOptions$Companion$52.toString());
        }
        if (!(!((Collection)graphHopperWeightings).isEmpty())) {
            boolean bl = false;
            String string = GraphHopperOptions._init_$error("weighting");
            throw new IllegalArgumentException(string.toString());
        }
        defaultOptions = it.unibo.alchemist.model.maps.routingservices.GraphHopperOptions$Companion.optionsFor$default(Companion, null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\rH\u0007J$\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\rJ\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0015\u0012\u0004\u0012\u00020\t0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions$Companion;", "", "()V", "allProfiles", "", "Lcom/graphhopper/config/Profile;", "getAllProfiles", "()Ljava/util/List;", "defaultOptions", "Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions;", "getDefaultOptions", "()Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions;", "graphHopperAlgorithms", "", "getGraphHopperAlgorithms", "graphHopperVehicles", "getGraphHopperVehicles", "graphHopperWeightings", "Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions$GraphHopperWeighting;", "profiles", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lkotlin/Pair;", "optionsFor", "profile", "algorithm", "vehicle", "weighting", "profileFor", "alchemist-maps"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getGraphHopperAlgorithms() {
            return graphHopperAlgorithms;
        }

        @NotNull
        public final List<String> getGraphHopperVehicles() {
            return graphHopperVehicles;
        }

        @NotNull
        public final List<Profile> getAllProfiles() {
            return allProfiles;
        }

        @NotNull
        public final GraphHopperOptions getDefaultOptions() {
            return defaultOptions;
        }

        @NotNull
        public final GraphHopperOptions optionsFor(@NotNull String vehicle, @NotNull String weighting, @NotNull String algorithm) {
            Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
            Intrinsics.checkNotNullParameter((Object)weighting, (String)"weighting");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            return this.optionsFor(vehicle + "_" + weighting, algorithm);
        }

        public static /* synthetic */ GraphHopperOptions optionsFor$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = "foot";
            }
            if ((n & 2) != 0) {
                string2 = "fastest";
            }
            if ((n & 4) != 0) {
                string3 = "dijkstrabi";
            }
            return companion.optionsFor(string, string2, string3);
        }

        @JvmOverloads
        @NotNull
        public final GraphHopperOptions optionsFor(@NotNull String profile, @NotNull String algorithm) {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            GraphHopperOptions graphHopperOptions = (GraphHopperOptions)profiles.get((Object)TuplesKt.to((Object)profile, (Object)algorithm));
            if (graphHopperOptions == null) {
                throw new IllegalArgumentException("The requested profile (" + profile + ", " + algorithm + ") could not be created.");
            }
            return graphHopperOptions;
        }

        public static /* synthetic */ GraphHopperOptions optionsFor$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = "foot_fastest";
            }
            if ((n & 2) != 0) {
                string2 = "dijkstrabi";
            }
            return companion.optionsFor(string, string2);
        }

        private final Profile profileFor(String vehicle, GraphHopperWeighting weighting) {
            Profile profile = new Profile(vehicle + "_" + weighting.getName()).setVehicle(vehicle).setWeighting("custom").setCustomModel(weighting.getCustomModel());
            Intrinsics.checkNotNullExpressionValue((Object)profile, (String)"setCustomModel(...)");
            return profile;
        }

        @JvmOverloads
        @NotNull
        public final GraphHopperOptions optionsFor(@NotNull String profile) {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            return it.unibo.alchemist.model.maps.routingservices.GraphHopperOptions$Companion.optionsFor$default(this, profile, null, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final GraphHopperOptions optionsFor() {
            return it.unibo.alchemist.model.maps.routingservices.GraphHopperOptions$Companion.optionsFor$default(this, null, null, 3, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions$GraphHopperWeighting;", "", "name", "", "distanceInfluence", "", "(Ljava/lang/String;D)V", "customModel", "Lcom/graphhopper/util/CustomModel;", "getCustomModel", "()Lcom/graphhopper/util/CustomModel;", "getDistanceInfluence", "()D", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "alchemist-maps"})
    private static final class GraphHopperWeighting {
        @NotNull
        private final String name;
        private final double distanceInfluence;
        @NotNull
        private final CustomModel customModel;

        public GraphHopperWeighting(@NotNull String name, double distanceInfluence) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.distanceInfluence = distanceInfluence;
            CustomModel customModel = new CustomModel().setDistanceInfluence(Double.valueOf(this.distanceInfluence));
            Intrinsics.checkNotNullExpressionValue((Object)customModel, (String)"setDistanceInfluence(...)");
            this.customModel = customModel;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final double getDistanceInfluence() {
            return this.distanceInfluence;
        }

        @NotNull
        public final CustomModel getCustomModel() {
            return this.customModel;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final double component2() {
            return this.distanceInfluence;
        }

        @NotNull
        public final GraphHopperWeighting copy(@NotNull String name, double distanceInfluence) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new GraphHopperWeighting(name, distanceInfluence);
        }

        public static /* synthetic */ GraphHopperWeighting copy$default(GraphHopperWeighting graphHopperWeighting, String string, double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = graphHopperWeighting.name;
            }
            if ((n & 2) != 0) {
                d = graphHopperWeighting.distanceInfluence;
            }
            return graphHopperWeighting.copy(string, d);
        }

        @NotNull
        public String toString() {
            return "GraphHopperWeighting(name=" + this.name + ", distanceInfluence=" + this.distanceInfluence + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Double.hashCode(this.distanceInfluence);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GraphHopperWeighting)) {
                return false;
            }
            GraphHopperWeighting graphHopperWeighting = (GraphHopperWeighting)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)graphHopperWeighting.name)) {
                return false;
            }
            return Double.compare(this.distanceInfluence, graphHopperWeighting.distanceInfluence) == 0;
        }
    }
}

