/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.model.maps.routingservices;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.hash.Hashing;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.DefaultVehicleEncodedValuesFactory;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.BBox;
import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.Position;
import it.unibo.alchemist.model.Route;
import it.unibo.alchemist.model.RoutingService;
import it.unibo.alchemist.model.maps.positions.LatLongPosition;
import it.unibo.alchemist.model.maps.routes.GraphHopperRoute;
import it.unibo.alchemist.model.maps.routingservices.GraphHopperOptions;
import it.unibo.alchemist.model.maps.routingservices.GraphHopperRoutingService;
import it.unibo.alchemist.model.routes.PolygonalChain;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.harawata.appdirs.AppDirs;
import net.harawata.appdirs.AppDirsFactory;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u001e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001eB#\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u0002H\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\b\u000f\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lit/unibo/alchemist/model/maps/routingservices/GraphHopperRoutingService;", "Lit/unibo/alchemist/model/RoutingService;", "Lit/unibo/alchemist/model/GeoPosition;", "Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions;", "map", "Ljava/net/URL;", "workingDirectory", "Ljava/io/File;", "defaultOptions", "(Ljava/net/URL;Ljava/io/File;Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions;)V", "accessFilters", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/graphhopper/routing/util/AccessFilter;", "getDefaultOptions", "()Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions;", "defaultOptions$1", "graphHopper", "Lcom/graphhopper/GraphHopper;", "allowedPointClosestTo", "position", "options", "parseOptions", "", "route", "Lit/unibo/alchemist/model/Route;", "from", "to", "coerceToMap", "Lkotlin/Pair;", "", "Companion", "alchemist-maps"})
@SourceDebugExtension(value={"SMAP\nGraphHopperRoutingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphHopperRoutingService.kt\nit/unibo/alchemist/model/maps/routingservices/GraphHopperRoutingService\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n643#2,5:183\n1#3:188\n4117#4:189\n4217#4,2:190\n1855#5,2:192\n*S KotlinDebug\n*F\n+ 1 GraphHopperRoutingService.kt\nit/unibo/alchemist/model/maps/routingservices/GraphHopperRoutingService\n*L\n54#1:183,5\n70#1:189\n70#1:190,2\n71#1:192,2\n*E\n"})
public final class GraphHopperRoutingService
implements RoutingService<GeoPosition, GraphHopperOptions> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GraphHopperOptions defaultOptions$1;
    @NotNull
    private final GraphHopper graphHopper;
    @NotNull
    private final LoadingCache<GraphHopperOptions, AccessFilter> accessFilters;
    private static final Logger logger = LoggerFactory.getLogger(GraphHopperRoutingService.class);
    @NotNull
    private static final Semaphore lockfileLock = new Semaphore(1);
    @NotNull
    private static final PMap emptyPMap = new PMap();
    @NotNull
    private static final DefaultVehicleEncodedValuesFactory vehicleEncoder = new DefaultVehicleEncodedValuesFactory();
    @NotNull
    private static final GraphHopperOptions defaultOptions = GraphHopperOptions.Companion.getDefaultOptions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmOverloads
    public GraphHopperRoutingService(@NotNull URL map, @NotNull File workingDirectory, @NotNull GraphHopperOptions defaultOptions) {
        String string;
        block26: {
            Intrinsics.checkNotNullParameter((Object)map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
            Intrinsics.checkNotNullParameter((Object)defaultOptions, (String)"defaultOptions");
            this.defaultOptions$1 = defaultOptions;
            String string2 = map.toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toExternalForm(...)");
            char[] cArray = new char[]{'/'};
            String $this$takeWhile$iv = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it22 = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it22 != '?') continue;
                String it22 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = it22.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block26;
            }
            string = $this$takeWhile$iv;
        }
        String mapName = string;
        File mapFile = new File(workingDirectory, mapName);
        lockfileLock.acquireUninterruptibly();
        try {
            Closeable closeable = new RandomAccessFile(new File(workingDirectory, ".lock"), "rw");
            Throwable throwable = null;
            try {
                Object object;
                RandomAccessFile fileAccess = (RandomAccessFile)closeable;
                boolean bl = false;
                Object object2 = fileAccess.getChannel().lock();
                Object object3 = null;
                try {
                    FileLock it = (FileLock)object2;
                    boolean bl2 = false;
                    if (!mapFile.exists()) {
                        Files.copy(map.openStream(), mapFile.toPath(), new CopyOption[0]);
                    }
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    object3 = it;
                    throw it;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)object3);
                }
                object2 = this;
                GraphHopperRoutingService graphHopperRoutingService = this;
                try {
                    GraphHopperRoutingService $this$lambda_u247_u24lambda_u242 = (GraphHopperRoutingService)object2;
                    boolean bl3 = false;
                    object3 = Result.constructor-impl((Object)GraphHopperRoutingService.Companion.initNavigationSystem(mapFile, workingDirectory));
                }
                catch (Throwable throwable2) {
                    object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                object2 = object3;
                object3 = Result.exceptionOrNull-impl((Object)object2);
                if (object3 == null) {
                    object = object2;
                } else {
                    Object object4;
                    Object object5 = object2;
                    try {
                        List list;
                        List list2;
                        File[] fileArray;
                        Object ex = object3;
                        boolean bl4 = false;
                        logger.warn("Could not initialize with " + mapFile + " (version conflict?): erasing cache and retrying", (Throwable)ex);
                        if (fileArray != null) {
                            void $this$filterNotTo$iv$iv;
                            fileArray = workingDirectory.listFiles();
                            Intrinsics.checkNotNull((Object)fileArray);
                            File[] $this$filterNot$iv = fileArray;
                            boolean $i$f$filterNot = false;
                            File[] fileArray2 = $this$filterNot$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterNotTo = false;
                            int n = ((void)$this$filterNotTo$iv$iv).length;
                            for (int i = 0; i < n; ++i) {
                                void element$iv$iv;
                                void it = element$iv$iv = $this$filterNotTo$iv$iv[i];
                                boolean bl5 = false;
                                if (Intrinsics.areEqual((Object)it, (Object)mapFile)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            list2 = (List)destination$iv$iv;
                        } else {
                            list2 = list = null;
                        }
                        if (list2 == null) {
                            list = CollectionsKt.emptyList();
                        }
                        List corruptedContent = list;
                        Iterable $this$forEach$iv = corruptedContent;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            File it = (File)element$iv;
                            boolean bl6 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (FilesKt.deleteRecursively((File)it)) continue;
                            boolean bl7 = false;
                            String string4 = "Could not delete $" + it + ". Something nasty is going on with your file system";
                            throw new IllegalArgumentException(string4.toString());
                        }
                        workingDirectory.mkdirs();
                        object4 = Result.constructor-impl((Object)GraphHopperRoutingService.Companion.initNavigationSystem(mapFile, workingDirectory));
                    }
                    catch (Throwable throwable3) {
                        object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable3));
                    }
                    object = object4;
                }
                object2 = object;
                ResultKt.throwOnFailure((Object)object2);
                graphHopperRoutingService.graphHopper = (GraphHopper)object2;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        finally {
            lockfileLock.release();
        }
        LoadingCache loadingCache = Caffeine.newBuilder().build(arg_0 -> GraphHopperRoutingService._init_$lambda$8(2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.accessFilters = loadingCache;
    }

    public /* synthetic */ GraphHopperRoutingService(URL uRL, File file, GraphHopperOptions graphHopperOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            InputStream inputStream = uRL.openStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
            file = GraphHopperRoutingService.Companion.defaultWorkingDirectory(inputStream);
        }
        if ((n & 4) != 0) {
            graphHopperOptions = defaultOptions;
        }
        this(uRL, file, graphHopperOptions);
    }

    @Override
    @NotNull
    public GraphHopperOptions getDefaultOptions() {
        return this.defaultOptions$1;
    }

    @Override
    @Nullable
    public GeoPosition allowedPointClosestTo(@NotNull GeoPosition position, @NotNull GraphHopperOptions options) {
        LatLongPosition latLongPosition;
        Snap snap;
        Snap snap2;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Snap it = snap2 = this.graphHopper.getLocationIndex().findClosest(position.getLatitude(), position.getLongitude(), (EdgeFilter)this.accessFilters.get((Object)options));
        boolean bl = false;
        Object object = snap = it.isValid() ? snap2 : null;
        if (snap != null && (snap2 = snap.getSnappedPoint()) != null) {
            Snap it2 = snap2;
            boolean bl2 = false;
            latLongPosition = new LatLongPosition(it2.lat, it2.lon);
        } else {
            latLongPosition = null;
        }
        return latLongPosition;
    }

    private final Pair<Double, Double> coerceToMap(GeoPosition $this$coerceToMap) {
        BBox bounds = this.graphHopper.getBaseGraph().getBounds();
        return TuplesKt.to((Object)RangesKt.coerceIn((Comparable)Double.valueOf($this$coerceToMap.getLatitude()), (ClosedFloatingPointRange)RangesKt.rangeTo((double)bounds.minLat, (double)bounds.maxLat)), (Object)RangesKt.coerceIn((Comparable)Double.valueOf($this$coerceToMap.getLongitude()), (ClosedFloatingPointRange)RangesKt.rangeTo((double)bounds.minLon, (double)bounds.maxLon)));
    }

    @Override
    @NotNull
    public Route<GeoPosition> route(@NotNull GeoPosition from, @NotNull GeoPosition to, @NotNull GraphHopperOptions options) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (Intrinsics.areEqual((Object)from, (Object)to)) {
            GeoPosition[] geoPositionArray = new GeoPosition[]{from};
            return (Route)new PolygonalChain((Position[])geoPositionArray);
        }
        Pair<Double, Double> naviStart = this.coerceToMap(from);
        Pair<Double, Double> naviEnd = this.coerceToMap(to);
        GHRequest gHRequest = new GHRequest(((Number)naviStart.getFirst()).doubleValue(), ((Number)naviStart.getSecond()).doubleValue(), ((Number)naviEnd.getFirst()).doubleValue(), ((Number)naviEnd.getSecond()).doubleValue()).setAlgorithm(options.getAlgorithm()).setProfile(options.getProfile().getName());
        Intrinsics.checkNotNullExpressionValue((Object)gHRequest, (String)"setProfile(...)");
        GHRequest request = gHRequest;
        GHResponse gHResponse = this.graphHopper.route(request);
        Intrinsics.checkNotNullExpressionValue((Object)gHResponse, (String)"route(...)");
        return new GraphHopperRoute(from, to, gHResponse);
    }

    @Override
    @NotNull
    public GraphHopperOptions parseOptions(@NotNull String options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String string = "On-the-fly parsing of navigation options is still to be implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @JvmOverloads
    public GraphHopperRoutingService(@NotNull URL map, @NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        this(map, workingDirectory, null, 4, null);
    }

    @JvmOverloads
    public GraphHopperRoutingService(@NotNull URL map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        this(map, null, null, 6, null);
    }

    private static final AccessFilter _init_$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AccessFilter)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lit/unibo/alchemist/model/maps/routingservices/GraphHopperRoutingService$Companion;", "", "()V", "defaultOptions", "Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions;", "getDefaultOptions", "()Lit/unibo/alchemist/model/maps/routingservices/GraphHopperOptions;", "emptyPMap", "Lcom/graphhopper/util/PMap;", "lockfileLock", "Ljava/util/concurrent/Semaphore;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "vehicleEncoder", "Lcom/graphhopper/routing/util/DefaultVehicleEncodedValuesFactory;", "defaultWorkingDirectory", "Ljava/io/File;", "map", "Ljava/io/InputStream;", "initNavigationSystem", "Lcom/graphhopper/GraphHopper;", "mapFile", "internalWorkdir", "nameFromHash", "", "alchemist-maps"})
    @SourceDebugExtension(value={"SMAP\nGraphHopperRoutingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphHopperRoutingService.kt\nit/unibo/alchemist/model/maps/routingservices/GraphHopperRoutingService$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,182:1\n179#2:183\n180#2:185\n1#3:184\n429#4:186\n502#4,5:187\n*S KotlinDebug\n*F\n+ 1 GraphHopperRoutingService.kt\nit/unibo/alchemist/model/maps/routingservices/GraphHopperRoutingService$Companion\n*L\n149#1:183\n149#1:185\n173#1:186\n173#1:187,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GraphHopperOptions getDefaultOptions() {
            return defaultOptions;
        }

        private final synchronized File defaultWorkingDirectory(InputStream map) {
            Object v2;
            block8: {
                String code = this.nameFromHash(map);
                AppDirs appDirs = AppDirsFactory.getInstance();
                Object[] objectArray = new Function3[5];
                Intrinsics.checkNotNull((Object)appDirs);
                objectArray[0] = new Function3<String, String, String, String>((Object)appDirs){

                    public final String invoke(String p0, String p1, String p2) {
                        return ((AppDirs)this.receiver).getUserCacheDir(p0, p1, p2);
                    }
                };
                objectArray[1] = new Function3<String, String, String, String>((Object)appDirs){

                    public final String invoke(String p0, String p1, String p2) {
                        return ((AppDirs)this.receiver).getUserDataDir(p0, p1, p2);
                    }
                };
                objectArray[2] = new Function3<String, String, String, String>((Object)appDirs){

                    public final String invoke(String p0, String p1, String p2) {
                        return ((AppDirs)this.receiver).getUserConfigDir(p0, p1, p2);
                    }
                };
                objectArray[3] = defaultWorkingDirectory.possibleLocations.4.INSTANCE;
                objectArray[4] = defaultWorkingDirectory.possibleLocations.5.INSTANCE;
                Sequence possibleLocations2 = SequencesKt.sequenceOf((Object[])objectArray);
                Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)possibleLocations2, (Function1)((Function1)new Function1<Function3<? super String, ? super String, ? super String, ? extends String>, File>(code){
                    final /* synthetic */ String $code;
                    {
                        this.$code = $code;
                        super(1);
                    }

                    @NotNull
                    public final File invoke(@NotNull Function3<? super String, ? super String, ? super String, String> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return new File((String)it.invoke((Object)"alchemist", (Object)("map-" + this.$code + "$"), (Object)"it.unibo"));
                    }
                }));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    File folder = (File)element$iv;
                    boolean bl2 = false;
                    if (folder.exists()) {
                        boolean bl3;
                        boolean it = bl3 = folder.isDirectory() && folder.canWrite();
                        boolean bl4 = false;
                        if (!it) {
                            logger.warn("{} is not writeable", (Object)folder);
                        }
                        bl = bl3;
                    } else {
                        Object object;
                        Object object2 = Companion;
                        try {
                            Companion $this$defaultWorkingDirectory_u24lambda_u243_u24lambda_u241 = object2;
                            boolean bl5 = false;
                            object = Result.constructor-impl((Object)folder.mkdirs());
                        }
                        catch (Throwable bl5) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
                        }
                        object2 = object;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                        if (throwable != null) {
                            Object it = object = throwable;
                            boolean bl6 = false;
                            logger.warn("Directory structure " + folder + " could not be created", (Throwable)it);
                        }
                        bl = Result.isSuccess-impl((Object)object2);
                    }
                    if (!bl) continue;
                    v2 = element$iv;
                    break block8;
                }
                v2 = null;
            }
            File file = v2;
            if (file == null) {
                throw new IllegalStateException("No writeable path was found.".toString());
            }
            return file;
        }

        private final synchronized GraphHopper initNavigationSystem(File mapFile, File internalWorkdir) {
            GraphHopper graphHopper = new GraphHopper().setOSMFile(mapFile.getAbsolutePath()).setElevation(false).setGraphHopperLocation(internalWorkdir.getAbsolutePath()).setProfiles(GraphHopperOptions.Companion.getAllProfiles()).importOrLoad();
            Intrinsics.checkNotNullExpressionValue((Object)graphHopper, (String)"importOrLoad(...)");
            return graphHopper;
        }

        /*
         * WARNING - void declaration
         */
        private final String nameFromHash(InputStream $this$nameFromHash) {
            void $this$filterTo$iv$iv;
            String string = new Base32().encodeAsString(Hashing.sha256().hashBytes($this$nameFromHash.readAllBytes()).asBytes());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeAsString(...)");
            String $this$filter$iv = string;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!(it != '=')) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string2 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

