/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.alchemist.utils;

import com.javadocmd.simplelatlng.LatLng;
import com.javadocmd.simplelatlng.LatLngTool;
import com.javadocmd.simplelatlng.util.LengthUnit;
import it.unibo.alchemist.model.GeoPosition;
import it.unibo.alchemist.model.maps.positions.LatLongPosition;

public final class Maps {
    private Maps() {
    }

    public static double getDistance(GeoPosition p1, GeoPosition p2) {
        return LatLngTool.distance((LatLng)Maps.toLatLng(p1), (LatLng)Maps.toLatLng(p2), (LengthUnit)LengthUnit.METER);
    }

    public static double initialBearing(GeoPosition start, GeoPosition end) {
        return LatLngTool.initialBearing((LatLng)Maps.toLatLng(start), (LatLng)Maps.toLatLng(end));
    }

    public static LatLongPosition getDestinationLocation(GeoPosition start, double initialBearing, double dist) {
        return Maps.toLatLong(LatLngTool.travel((LatLng)Maps.toLatLng(start), (double)initialBearing, (double)dist, (LengthUnit)LengthUnit.METER));
    }

    public static LatLongPosition getDestinationLocation(GeoPosition start, GeoPosition end, double dist) {
        double bearing = Maps.initialBearing(start, end);
        return Maps.getDestinationLocation(start, bearing, dist);
    }

    public static LatLng toLatLng(GeoPosition p) {
        return new LatLng(p.getLatitude(), p.getLongitude());
    }

    public static LatLongPosition toLatLong(LatLng p) {
        return new LatLongPosition(p.getLatitude(), p.getLongitude());
    }
}

