/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.gui;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import it.unibo.tuprolog.bdd.BinaryDecisionDiagram;
import it.unibo.tuprolog.bdd.BinaryDecisionDiagramUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lit/unibo/tuprolog/ui/gui/GraphvizRenderer;", "", "()V", "available", "Ljava/util/concurrent/Future;", "", "isAvailable", "()Z", "isReady", "initialize", "", "renderAsPNG", "graph", "", "imageOutputStream", "Ljava/io/OutputStream;", "ide-plp"})
public final class GraphvizRenderer {
    @NotNull
    public static final GraphvizRenderer INSTANCE = new GraphvizRenderer();
    @NotNull
    private static Future<Boolean> available;

    private GraphvizRenderer() {
    }

    public final void initialize() {
        CompletableFuture<Boolean> completableFuture = CompletableFuture.supplyAsync(GraphvizRenderer::initialize$lambda-0);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026e\n            }\n        }");
        available = completableFuture;
    }

    public final boolean isAvailable() {
        boolean bl;
        if (available.isDone()) {
            Boolean bl2 = available.get();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"available.get()");
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isReady() {
        return available.isDone();
    }

    public final void renderAsPNG(@NotNull String graph, @NotNull OutputStream imageOutputStream) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)imageOutputStream, (String)"imageOutputStream");
        if (!this.isAvailable()) {
            throw new UnsupportedOperationException("Graphviz renderer is not available");
        }
        Graphviz.fromString((String)graph).render(Format.PNG).toOutputStream(imageOutputStream);
    }

    private static final Boolean initialize$lambda-0() {
        boolean bl;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BinaryDecisionDiagram sampleBDD = BinaryDecisionDiagram.Companion.terminalOf(true);
            Graphviz.fromString((String)BinaryDecisionDiagramUtils.toDotString((BinaryDecisionDiagram)sampleBDD)).render(Format.PNG).toOutputStream((OutputStream)outputStream);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    static {
        CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(false)");
        available = completableFuture;
    }
}

