/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.gui;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import it.unibo.tuprolog.bdd.BinaryDecisionDiagram;
import it.unibo.tuprolog.bdd.BinaryDecisionDiagramUtils;
import it.unibo.tuprolog.core.Formatter;
import it.unibo.tuprolog.core.FormatterExtensions;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermFormatter;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.solve.ProbExtensions;
import it.unibo.tuprolog.solve.Solution;
import it.unibo.tuprolog.solve.exception.TimeOutException;
import it.unibo.tuprolog.ui.gui.AssignmentView;
import it.unibo.tuprolog.ui.gui.GraphRenderView;
import it.unibo.tuprolog.ui.gui.PLPSolutionView;
import it.unibo.tuprolog.ui.gui.SolutionView;
import it.unibo.tuprolog.utils.Taggable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 2*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004:\u00042345B\u000f\b\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010)\u001a\u00020*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0002J\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u000200*\u0004\u0018\u000101H\u0002R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00128\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u00188\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u00188\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u0010\u0010\u0005\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u001e\u0010!\u001a\u00020\u00188\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001a\"\u0004\b#\u0010\u001cR\u001e\u0010$\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u0082\u0001\u0003678\u00a8\u00069"}, d2={"Lit/unibo/tuprolog/ui/gui/PLPSolutionView;", "T", "S", "Lit/unibo/tuprolog/solve/Solution;", "Ljavafx/scene/layout/VBox;", "solution", "(Lit/unibo/tuprolog/solve/Solution;)V", "btnShowBinaryDecisionDiagram", "Ljavafx/scene/control/Button;", "getBtnShowBinaryDecisionDiagram", "()Ljavafx/scene/control/Button;", "setBtnShowBinaryDecisionDiagram", "(Ljavafx/scene/control/Button;)V", "formatter", "Lit/unibo/tuprolog/core/TermFormatter;", "getFormatter", "()Lit/unibo/tuprolog/core/TermFormatter;", "led", "Ljavafx/scene/shape/Circle;", "getLed", "()Ljavafx/scene/shape/Circle;", "setLed", "(Ljavafx/scene/shape/Circle;)V", "probability", "Ljavafx/scene/control/Label;", "getProbability", "()Ljavafx/scene/control/Label;", "setProbability", "(Ljavafx/scene/control/Label;)V", "query", "getQuery", "setQuery", "Lit/unibo/tuprolog/solve/Solution;", "status", "getStatus", "setStatus", "substitutions", "getSubstitutions", "()Ljavafx/scene/layout/VBox;", "setSubstitutions", "(Ljavafx/scene/layout/VBox;)V", "bddToImage", "Ljavafx/scene/image/Image;", "bdd", "Lit/unibo/tuprolog/bdd/BinaryDecisionDiagram;", "onShowBinaryDecisionDiagramPressed", "", "toMonospacedText", "Ljavafx/scene/Node;", "", "Companion", "HaltViewPLP", "NoViewPLP", "YesViewPLP", "Lit/unibo/tuprolog/ui/gui/PLPSolutionView$YesViewPLP;", "Lit/unibo/tuprolog/ui/gui/PLPSolutionView$NoViewPLP;", "Lit/unibo/tuprolog/ui/gui/PLPSolutionView$HaltViewPLP;", "ide-plp"})
public abstract class PLPSolutionView<T, S extends Solution>
extends VBox {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final S solution;
    @NotNull
    private final TermFormatter formatter;
    @FXML
    public Circle led;
    @FXML
    public Label status;
    @FXML
    public Label query;
    @FXML
    public Label probability;
    @FXML
    public VBox substitutions;
    @FXML
    public Button btnShowBinaryDecisionDiagram;
    @NotNull
    private static final String FXML = "PLPSolutionView.fxml";
    @NotNull
    private static final Insets ITEM_MARGIN = new Insets(0.0, 0.0, 0.0, 55.0);
    @NotNull
    private static final Paint COLOR_YES;
    @NotNull
    private static final Paint COLOR_NO;
    @NotNull
    private static final Paint COLOR_HALT;
    @NotNull
    private static final Paint COLOR_TIMEOUT;

    private PLPSolutionView(S solution) {
        this.solution = solution;
        this.formatter = TermFormatter.Companion.prettyExpressions();
        FXMLLoader loader = new FXMLLoader(PLPSolutionView.class.getResource(FXML));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    protected final TermFormatter getFormatter() {
        return this.formatter;
    }

    @NotNull
    public final Circle getLed() {
        Circle circle = this.led;
        if (circle != null) {
            return circle;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"led");
        return null;
    }

    public final void setLed(@NotNull Circle circle) {
        Intrinsics.checkNotNullParameter((Object)circle, (String)"<set-?>");
        this.led = circle;
    }

    @NotNull
    public final Label getStatus() {
        Label label = this.status;
        if (label != null) {
            return label;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"status");
        return null;
    }

    public final void setStatus(@NotNull Label label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"<set-?>");
        this.status = label;
    }

    @NotNull
    public final Label getQuery() {
        Label label = this.query;
        if (label != null) {
            return label;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"query");
        return null;
    }

    public final void setQuery(@NotNull Label label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"<set-?>");
        this.query = label;
    }

    @NotNull
    public final Label getProbability() {
        Label label = this.probability;
        if (label != null) {
            return label;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"probability");
        return null;
    }

    public final void setProbability(@NotNull Label label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"<set-?>");
        this.probability = label;
    }

    @NotNull
    public final VBox getSubstitutions() {
        VBox vBox = this.substitutions;
        if (vBox != null) {
            return vBox;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"substitutions");
        return null;
    }

    public final void setSubstitutions(@NotNull VBox vBox) {
        Intrinsics.checkNotNullParameter((Object)vBox, (String)"<set-?>");
        this.substitutions = vBox;
    }

    @NotNull
    public final Button getBtnShowBinaryDecisionDiagram() {
        Button button = this.btnShowBinaryDecisionDiagram;
        if (button != null) {
            return button;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"btnShowBinaryDecisionDiagram");
        return null;
    }

    public final void setBtnShowBinaryDecisionDiagram(@NotNull Button button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"<set-?>");
        this.btnShowBinaryDecisionDiagram = button;
    }

    private final Node toMonospacedText(String $this$toMonospacedText) {
        if ($this$toMonospacedText == null) {
            return (Node)new Text();
        }
        Text text = new Text($this$toMonospacedText);
        boolean bl = false;
        boolean bl2 = false;
        Text it = text;
        boolean bl3 = false;
        it.setStyle("-fx-font-family: monospaced");
        return (Node)text;
    }

    public final void onShowBinaryDecisionDiagramPressed() {
        BinaryDecisionDiagram binaryDecisionDiagram = ProbExtensions.getBinaryDecisionDiagram(this.solution);
        if (binaryDecisionDiagram != null) {
            BinaryDecisionDiagram binaryDecisionDiagram2 = binaryDecisionDiagram;
            boolean bl = false;
            boolean bl2 = false;
            BinaryDecisionDiagram it = binaryDecisionDiagram2;
            boolean bl3 = false;
            Alert dialog = new Alert(Alert.AlertType.INFORMATION);
            dialog.setTitle("Binary Decision Diagram");
            dialog.getDialogPane().setContent((Node)new GraphRenderView(BinaryDecisionDiagramUtils.toDotString((BinaryDecisionDiagram)it)));
            dialog.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            dialog.getDialogPane().setMinWidth(Double.NEGATIVE_INFINITY);
            dialog.setGraphic(null);
            dialog.setHeaderText(null);
            dialog.showAndWait();
        }
    }

    private final Image bddToImage(BinaryDecisionDiagram<?> bdd) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Graphviz.fromString((String)BinaryDecisionDiagramUtils.toDotString(bdd)).render(Format.PNG).toOutputStream((OutputStream)outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return new Image((InputStream)inputStream);
    }

    public /* synthetic */ PLPSolutionView(Solution solution, DefaultConstructorMarker $constructor_marker) {
        this(solution);
    }

    static {
        Paint paint = SolutionView.Companion.getCOLOR_YES();
        Intrinsics.checkNotNullExpressionValue((Object)paint, (String)"SolutionView.COLOR_YES");
        COLOR_YES = paint;
        paint = SolutionView.Companion.getCOLOR_NO();
        Intrinsics.checkNotNullExpressionValue((Object)paint, (String)"SolutionView.COLOR_NO");
        COLOR_NO = paint;
        paint = SolutionView.Companion.getCOLOR_HALT();
        Intrinsics.checkNotNullExpressionValue((Object)paint, (String)"SolutionView.COLOR_HALT");
        COLOR_HALT = paint;
        paint = SolutionView.Companion.getCOLOR_TIMEOUT();
        Intrinsics.checkNotNullExpressionValue((Object)paint, (String)"SolutionView.COLOR_TIMEOUT");
        COLOR_TIMEOUT = paint;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lit/unibo/tuprolog/ui/gui/PLPSolutionView$Companion;", "", "()V", "COLOR_HALT", "Ljavafx/scene/paint/Paint;", "getCOLOR_HALT", "()Ljavafx/scene/paint/Paint;", "COLOR_NO", "getCOLOR_NO", "COLOR_TIMEOUT", "getCOLOR_TIMEOUT", "COLOR_YES", "getCOLOR_YES", "FXML", "", "ITEM_MARGIN", "Ljavafx/geometry/Insets;", "of", "Lit/unibo/tuprolog/ui/gui/PLPSolutionView;", "solution", "Lit/unibo/tuprolog/solve/Solution;", "ide-plp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Paint getCOLOR_YES() {
            return COLOR_YES;
        }

        @NotNull
        public final Paint getCOLOR_NO() {
            return COLOR_NO;
        }

        @NotNull
        public final Paint getCOLOR_HALT() {
            return COLOR_HALT;
        }

        @NotNull
        public final Paint getCOLOR_TIMEOUT() {
            return COLOR_TIMEOUT;
        }

        @NotNull
        public final PLPSolutionView<?, ?> of(@NotNull Solution solution) {
            Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
            return (PLPSolutionView)((Object)Solution.DefaultImpls.whenIs$default((Solution)solution, (Function1)of.1.INSTANCE, (Function1)of.2.INSTANCE, (Function1)of.3.INSTANCE, null, (int)8, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0004\u0012\u00020\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lit/unibo/tuprolog/ui/gui/PLPSolutionView$YesViewPLP;", "Lit/unibo/tuprolog/ui/gui/PLPSolutionView;", "Lkotlin/Pair;", "Lit/unibo/tuprolog/core/Var;", "Lit/unibo/tuprolog/core/Term;", "Lit/unibo/tuprolog/solve/Solution$Yes;", "solution", "(Lit/unibo/tuprolog/solve/Solution$Yes;)V", "ide-plp"})
    public static final class YesViewPLP
    extends PLPSolutionView<Pair<? extends Var, ? extends Term>, Solution.Yes> {
        /*
         * WARNING - void declaration
         */
        public YesViewPLP(@NotNull Solution.Yes solution) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
            super((Solution)solution, null);
            this.getStatus().setText("yes:");
            this.getLed().setFill(Companion.getCOLOR_YES());
            this.getQuery().setText(FormatterExtensions.format((Object)solution.getSolvedQuery(), (Formatter)((Formatter)this.getFormatter())));
            Map $this$map$iv = (Map)solution.getSubstitution();
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var7_10 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var7_10.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var13_18 = it;
                boolean bl3 = false;
                Pair pair = new Pair(var13_18.getKey(), var13_18.getValue());
                collection.add(pair);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl4 = false;
                AssignmentView assignment = new AssignmentView(it, this.getFormatter());
                this.getSubstitutions().getChildren().add((Object)assignment);
                VBox.setMargin((Node)((Node)assignment), (Insets)ITEM_MARGIN);
            }
            Label label = this.getProbability();
            String string = "Probability: %.2f";
            Object[] objectArray = new Object[]{ProbExtensions.getProbability((Taggable)((Taggable)solution)) * (double)100};
            boolean bl5 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            label.setText(string2);
            if (ProbExtensions.getHasBinaryDecisionDiagram((Solution)((Solution)solution))) {
                this.getBtnShowBinaryDecisionDiagram().setVisible(true);
                this.getBtnShowBinaryDecisionDiagram().setOnAction(arg_0 -> YesViewPLP._init_$lambda-2(this, arg_0));
            } else {
                this.getBtnShowBinaryDecisionDiagram().setVisible(false);
            }
        }

        private static final void _init_$lambda-2(YesViewPLP this$0, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.onShowBinaryDecisionDiagramPressed();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lit/unibo/tuprolog/ui/gui/PLPSolutionView$NoViewPLP;", "Lit/unibo/tuprolog/ui/gui/PLPSolutionView;", "", "Lit/unibo/tuprolog/solve/Solution$No;", "solution", "(Lit/unibo/tuprolog/solve/Solution$No;)V", "ide-plp"})
    public static final class NoViewPLP
    extends PLPSolutionView<String, Solution.No> {
        public NoViewPLP(@NotNull Solution.No solution) {
            Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
            super((Solution)solution, null);
            this.getLed().setFill(Companion.getCOLOR_NO());
            this.getStatus().setText("no.");
            this.getQuery().setVisible(false);
            this.getProbability().setText("");
            this.getBtnShowBinaryDecisionDiagram().setVisible(false);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lit/unibo/tuprolog/ui/gui/PLPSolutionView$HaltViewPLP;", "Lit/unibo/tuprolog/ui/gui/PLPSolutionView;", "", "Lit/unibo/tuprolog/solve/Solution$Halt;", "solution", "(Lit/unibo/tuprolog/solve/Solution$Halt;)V", "ide-plp"})
    public static final class HaltViewPLP
    extends PLPSolutionView<String, Solution.Halt> {
        /*
         * WARNING - void declaration
         */
        public HaltViewPLP(@NotNull Solution.Halt solution) {
            Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
            super((Solution)solution, null);
            this.getProbability().setText("");
            this.getBtnShowBinaryDecisionDiagram().setVisible(false);
            if (solution.getException() instanceof TimeOutException) {
                this.getLed().setFill(Companion.getCOLOR_TIMEOUT());
                this.getStatus().setText("timeout.");
                this.getQuery().setVisible(false);
            } else {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                this.getLed().setFill(Companion.getCOLOR_HALT());
                this.getStatus().setText("halt:");
                this.getQuery().setText(solution.getException().getMessage());
                ObservableList observableList = this.getChildren();
                boolean bl = false;
                boolean bl2 = false;
                ObservableList $this$_init__u24lambda_u2d2 = observableList;
                boolean bl3 = false;
                Iterable $this$map$iv = solution.getException().getLogicStackTrace();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Struct struct = (Struct)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    String string = FormatterExtensions.format((Object)it, (Formatter)((Formatter)this.getFormatter()));
                    collection.add(string);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    Label lbl = new Label(Intrinsics.stringPlus((String)"at ", (Object)it));
                    $this$_init__u24lambda_u2d2.add((Object)lbl);
                    VBox.setMargin((Node)((Node)lbl), (Insets)ITEM_MARGIN);
                }
            }
        }
    }
}

