/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.gui;

import it.unibo.tuprolog.core.operators.OperatorSet;
import it.unibo.tuprolog.ui.gui.SyntaxColoring;
import it.unibo.tuprolog.ui.gui.TuPrologIDEController;
import it.unibo.tuprolog.ui.gui.TuPrologIDEModel;
import java.io.File;
import java.io.IOException;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Tab;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0001.B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010(\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010)\u001a\u00020\"2\u0006\u0010&\u001a\u00020*H\u0007J\u0010\u0010+\u001a\u00020\"2\u0006\u0010&\u001a\u00020,H\u0007J\u0006\u0010-\u001a\u00020\"R\u001e\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0016@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lit/unibo/tuprolog/ui/gui/FileTabView;", "Ljavafx/scene/control/Tab;", "file", "Ljava/io/File;", "model", "Lit/unibo/tuprolog/ui/gui/TuPrologIDEModel;", "ideController", "Lit/unibo/tuprolog/ui/gui/TuPrologIDEController;", "initialText", "", "(Ljava/io/File;Lit/unibo/tuprolog/ui/gui/TuPrologIDEModel;Lit/unibo/tuprolog/ui/gui/TuPrologIDEController;Ljava/lang/String;)V", "codeArea", "Lorg/fxmisc/richtext/CodeArea;", "getCodeArea", "()Lorg/fxmisc/richtext/CodeArea;", "setCodeArea", "(Lorg/fxmisc/richtext/CodeArea;)V", "value", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "", "fontSize", "setFontSize", "(I)V", "syntaxColoring", "Lit/unibo/tuprolog/ui/gui/SyntaxColoring;", "wholeText", "getWholeText", "()Ljava/lang/String;", "setWholeText", "(Ljava/lang/String;)V", "notifyOperators", "", "operators", "Lit/unibo/tuprolog/core/operators/OperatorSet;", "onKeyPressedOnCodeArea", "e", "Ljavafx/scene/input/KeyEvent;", "onKeyTypedOnCodeArea", "onMousePressedOnCodeArea", "Ljavafx/scene/input/MouseEvent;", "onTabSelectionChanged", "Ljavafx/event/Event;", "updateSyntaxColoring", "Companion", "ide"})
public final class FileTabView
extends Tab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TuPrologIDEModel model;
    @NotNull
    private final TuPrologIDEController ideController;
    @NotNull
    private final SyntaxColoring syntaxColoring;
    private int fontSize;
    @FXML
    public CodeArea codeArea;
    @NotNull
    private File file;
    @NotNull
    private static final String FXML = "FileTabView.fxml";
    private static final int MIN_FONT_SIZE = 13;
    private static final int DEFAULT_FONT_SIZE = 16;

    public FileTabView(@NotNull File file, @NotNull TuPrologIDEModel model, @NotNull TuPrologIDEController ideController, @NotNull String initialText) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)ideController, (String)"ideController");
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        this.model = model;
        this.ideController = ideController;
        this.fontSize = 13;
        FXMLLoader loader = new FXMLLoader(FileTabView.class.getResource(FXML));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.setFontSize(16);
        this.getCodeArea().appendText(initialText);
        this.getCodeArea().setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)((GenericStyledArea)this.getCodeArea())));
        this.syntaxColoring = new SyntaxColoring(this.getCodeArea(), null, null, null, 14, null);
        this.syntaxColoring.activate();
        this.setText(file.getName());
        this.file = file;
    }

    public /* synthetic */ FileTabView(File file, TuPrologIDEModel tuPrologIDEModel, TuPrologIDEController tuPrologIDEController, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = "";
        }
        this(file, tuPrologIDEModel, tuPrologIDEController, string);
    }

    private final void setFontSize(int value) {
        int n = 13;
        boolean bl = false;
        this.fontSize = Math.max(value, n);
        this.getCodeArea().setStyle(Intrinsics.stringPlus((String)"-fx-font-size: ", (Object)value));
    }

    @NotNull
    public final CodeArea getCodeArea() {
        CodeArea codeArea = this.codeArea;
        if (codeArea != null) {
            return codeArea;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"codeArea");
        return null;
    }

    public final void setCodeArea(@NotNull CodeArea codeArea) {
        Intrinsics.checkNotNullParameter((Object)codeArea, (String)"<set-?>");
        this.codeArea = codeArea;
    }

    @NotNull
    public final String getWholeText() {
        String string = this.getCodeArea().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codeArea.text");
        return string;
    }

    public final void setWholeText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getCodeArea().replaceText(value);
        String string = this.getCodeArea().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codeArea.text");
        this.model.setFile(this.file, string);
    }

    public final void notifyOperators(@NotNull OperatorSet operators2) {
        Intrinsics.checkNotNullParameter((Object)operators2, (String)"operators");
        this.syntaxColoring.setOperators(operators2);
        this.syntaxColoring.applyHighlightingNow();
    }

    public final void updateSyntaxColoring() {
        this.syntaxColoring.applyHighlightingNow();
    }

    @FXML
    public final void onTabSelectionChanged(@NotNull Event e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isSelected()) {
            this.model.selectFile(this.file);
        }
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final void setFile(@NotNull File value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.file = value;
        this.setText(value.getName());
    }

    @FXML
    public final void onMousePressedOnCodeArea(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.ideController.onMouseClickedOnCurrentFile(e);
    }

    @FXML
    public final void onKeyTypedOnCodeArea(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.model.setFile(this.file, this.getWholeText());
        this.ideController.onKeyTypedOnCurrentFile(e);
        if (e.isControlDown()) {
            String string = e.getCharacter();
            if (Intrinsics.areEqual((Object)string, (Object)"+")) {
                FileTabView fileTabView = this;
                int n = fileTabView.fontSize;
                fileTabView.setFontSize(n + 1);
            } else if (Intrinsics.areEqual((Object)string, (Object)"-")) {
                FileTabView fileTabView = this;
                int n = fileTabView.fontSize;
                fileTabView.setFontSize(n + -1);
            }
        }
    }

    @FXML
    public final void onKeyPressedOnCodeArea(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.model.setFile(this.file, this.getWholeText());
        this.ideController.onKeyPressedOnCurrentFile(e);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lit/unibo/tuprolog/ui/gui/FileTabView$Companion;", "", "()V", "DEFAULT_FONT_SIZE", "", "FXML", "", "MIN_FONT_SIZE", "ide"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

