/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.gui;

import it.unibo.tuprolog.core.Formatter;
import it.unibo.tuprolog.core.FormatterExtensions;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermFormatter;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.solve.Solution;
import it.unibo.tuprolog.solve.exception.TimeOutException;
import it.unibo.tuprolog.ui.gui.AssignmentView;
import it.unibo.tuprolog.ui.gui.SolutionView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004:\u0004\u001d\u001e\u001f B\u000f\b\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00128\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0005\u001a\u00028\u0001X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001a\u001a\u00020\u00128\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016\u0082\u0001\u0003!\"#\u00a8\u0006$"}, d2={"Lit/unibo/tuprolog/ui/gui/SolutionView;", "T", "S", "Lit/unibo/tuprolog/solve/Solution;", "Ljavafx/scene/layout/VBox;", "solution", "(Lit/unibo/tuprolog/solve/Solution;)V", "formatter", "Lit/unibo/tuprolog/core/TermFormatter;", "getFormatter", "()Lit/unibo/tuprolog/core/TermFormatter;", "led", "Ljavafx/scene/shape/Circle;", "getLed", "()Ljavafx/scene/shape/Circle;", "setLed", "(Ljavafx/scene/shape/Circle;)V", "query", "Ljavafx/scene/control/Label;", "getQuery", "()Ljavafx/scene/control/Label;", "setQuery", "(Ljavafx/scene/control/Label;)V", "getSolution", "()Lit/unibo/tuprolog/solve/Solution;", "Lit/unibo/tuprolog/solve/Solution;", "status", "getStatus", "setStatus", "Companion", "HaltView", "NoView", "YesView", "Lit/unibo/tuprolog/ui/gui/SolutionView$YesView;", "Lit/unibo/tuprolog/ui/gui/SolutionView$NoView;", "Lit/unibo/tuprolog/ui/gui/SolutionView$HaltView;", "ide"})
public abstract class SolutionView<T, S extends Solution>
extends VBox {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final S solution;
    @NotNull
    private final TermFormatter formatter;
    @FXML
    public Circle led;
    @FXML
    public Label status;
    @FXML
    public Label query;
    @NotNull
    private static final String FXML = "SolutionView.fxml";
    @NotNull
    private static final Insets ITEM_MARGIN = new Insets(0.0, 0.0, 0.0, 55.0);
    private static final Paint COLOR_YES = Paint.valueOf((String)"LIME");
    private static final Paint COLOR_NO = Paint.valueOf((String)"GRAY");
    private static final Paint COLOR_HALT = Paint.valueOf((String)"RED");
    private static final Paint COLOR_TIMEOUT = Paint.valueOf((String)"GOLD");

    private SolutionView(S solution) {
        this.solution = solution;
        this.formatter = TermFormatter.Companion.prettyExpressions();
        FXMLLoader loader = new FXMLLoader(SolutionView.class.getResource(FXML));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    protected final S getSolution() {
        return this.solution;
    }

    @NotNull
    protected final TermFormatter getFormatter() {
        return this.formatter;
    }

    @NotNull
    public final Circle getLed() {
        Circle circle = this.led;
        if (circle != null) {
            return circle;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"led");
        return null;
    }

    public final void setLed(@NotNull Circle circle) {
        Intrinsics.checkNotNullParameter((Object)circle, (String)"<set-?>");
        this.led = circle;
    }

    @NotNull
    public final Label getStatus() {
        Label label = this.status;
        if (label != null) {
            return label;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"status");
        return null;
    }

    public final void setStatus(@NotNull Label label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"<set-?>");
        this.status = label;
    }

    @NotNull
    public final Label getQuery() {
        Label label = this.query;
        if (label != null) {
            return label;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"query");
        return null;
    }

    public final void setQuery(@NotNull Label label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"<set-?>");
        this.query = label;
    }

    public /* synthetic */ SolutionView(Solution solution, DefaultConstructorMarker $constructor_marker) {
        this(solution);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0019\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lit/unibo/tuprolog/ui/gui/SolutionView$Companion;", "", "()V", "COLOR_HALT", "Ljavafx/scene/paint/Paint;", "kotlin.jvm.PlatformType", "getCOLOR_HALT", "()Ljavafx/scene/paint/Paint;", "COLOR_NO", "getCOLOR_NO", "COLOR_TIMEOUT", "getCOLOR_TIMEOUT", "COLOR_YES", "getCOLOR_YES", "FXML", "", "ITEM_MARGIN", "Ljavafx/geometry/Insets;", "of", "Lit/unibo/tuprolog/ui/gui/SolutionView;", "solution", "Lit/unibo/tuprolog/solve/Solution;", "ide"})
    public static final class Companion {
        private Companion() {
        }

        public final Paint getCOLOR_YES() {
            return COLOR_YES;
        }

        public final Paint getCOLOR_NO() {
            return COLOR_NO;
        }

        public final Paint getCOLOR_HALT() {
            return COLOR_HALT;
        }

        public final Paint getCOLOR_TIMEOUT() {
            return COLOR_TIMEOUT;
        }

        @NotNull
        public final SolutionView<?, ?> of(@NotNull Solution solution) {
            Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
            return (SolutionView)((Object)Solution.DefaultImpls.whenIs$default((Solution)solution, (Function1)of.1.INSTANCE, (Function1)of.2.INSTANCE, (Function1)of.3.INSTANCE, null, (int)8, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0004\u0012\u00020\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lit/unibo/tuprolog/ui/gui/SolutionView$YesView;", "Lit/unibo/tuprolog/ui/gui/SolutionView;", "Lkotlin/Pair;", "Lit/unibo/tuprolog/core/Var;", "Lit/unibo/tuprolog/core/Term;", "Lit/unibo/tuprolog/solve/Solution$Yes;", "solution", "(Lit/unibo/tuprolog/solve/Solution$Yes;)V", "ide"})
    public static final class YesView
    extends SolutionView<Pair<? extends Var, ? extends Term>, Solution.Yes> {
        /*
         * WARNING - void declaration
         */
        public YesView(@NotNull Solution.Yes solution) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
            super((Solution)solution, null);
            this.getStatus().setText("yes:");
            this.getLed().setFill(Companion.getCOLOR_YES());
            this.getQuery().setText(FormatterExtensions.format((Object)solution.getSolvedQuery(), (Formatter)((Formatter)this.getFormatter())));
            Map $this$map$iv = (Map)solution.getSubstitution();
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var7_8 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var7_8.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var13_16 = it;
                boolean bl3 = false;
                Pair pair = new Pair(var13_16.getKey(), var13_16.getValue());
                collection.add(pair);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl4 = false;
                AssignmentView assignment = new AssignmentView((Pair<? extends Var, ? extends Term>)it, this.getFormatter());
                this.getChildren().add((Object)assignment);
                VBox.setMargin((Node)((Node)assignment), (Insets)ITEM_MARGIN);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lit/unibo/tuprolog/ui/gui/SolutionView$NoView;", "Lit/unibo/tuprolog/ui/gui/SolutionView;", "", "Lit/unibo/tuprolog/solve/Solution$No;", "solution", "(Lit/unibo/tuprolog/solve/Solution$No;)V", "ide"})
    public static final class NoView
    extends SolutionView<String, Solution.No> {
        public NoView(@NotNull Solution.No solution) {
            Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
            super((Solution)solution, null);
            this.getLed().setFill(Companion.getCOLOR_NO());
            this.getStatus().setText("no.");
            this.getQuery().setVisible(false);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lit/unibo/tuprolog/ui/gui/SolutionView$HaltView;", "Lit/unibo/tuprolog/ui/gui/SolutionView;", "", "Lit/unibo/tuprolog/solve/Solution$Halt;", "solution", "(Lit/unibo/tuprolog/solve/Solution$Halt;)V", "ide"})
    public static final class HaltView
    extends SolutionView<String, Solution.Halt> {
        /*
         * WARNING - void declaration
         */
        public HaltView(@NotNull Solution.Halt solution) {
            Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
            super((Solution)solution, null);
            if (solution.getException() instanceof TimeOutException) {
                this.getLed().setFill(Companion.getCOLOR_TIMEOUT());
                this.getStatus().setText("timeout.");
                this.getQuery().setVisible(false);
            } else {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                this.getLed().setFill(Companion.getCOLOR_HALT());
                this.getStatus().setText("halt:");
                this.getQuery().setText(solution.getException().getMessage());
                ObservableList observableList = this.getChildren();
                boolean bl = false;
                boolean bl2 = false;
                ObservableList $this$_init__u24lambda_u2d2 = observableList;
                boolean bl3 = false;
                Iterable $this$map$iv = solution.getException().getLogicStackTrace();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Struct struct = (Struct)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    String string = FormatterExtensions.format((Object)it, (Formatter)((Formatter)this.getFormatter()));
                    collection.add(string);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    Label lbl = new Label(Intrinsics.stringPlus((String)"at ", (Object)it));
                    $this$_init__u24lambda_u2d2.add((Object)lbl);
                    VBox.setMargin((Node)((Node)lbl), (Insets)ITEM_MARGIN);
                }
            }
        }
    }
}

