/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.gui;

import it.unibo.tuprolog.core.exception.TuPrologException;
import it.unibo.tuprolog.core.parsing.ParseException;
import it.unibo.tuprolog.solve.exception.error.SyntaxError;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lit/unibo/tuprolog/ui/gui/SyntaxException;", "Lit/unibo/tuprolog/core/exception/TuPrologException;", "cause", "Lit/unibo/tuprolog/core/parsing/ParseException;", "(Lit/unibo/tuprolog/core/parsing/ParseException;)V", "getCause", "()Lit/unibo/tuprolog/core/parsing/ParseException;", "message", "", "getMessage", "()Ljava/lang/String;", "InQuerySyntaxError", "InTheorySyntaxError", "Lit/unibo/tuprolog/ui/gui/SyntaxException$InTheorySyntaxError;", "Lit/unibo/tuprolog/ui/gui/SyntaxException$InQuerySyntaxError;", "ide"})
public abstract class SyntaxException
extends TuPrologException {
    @NotNull
    private final ParseException cause;

    private SyntaxException(ParseException cause) {
        super((Throwable)cause);
        this.cause = cause;
    }

    @NotNull
    public ParseException getCause() {
        return this.cause;
    }

    @NotNull
    public abstract String getMessage();

    public /* synthetic */ SyntaxException(ParseException cause, DefaultConstructorMarker $constructor_marker) {
        this(cause);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lit/unibo/tuprolog/ui/gui/SyntaxException$InTheorySyntaxError;", "Lit/unibo/tuprolog/ui/gui/SyntaxException;", "file", "Ljava/io/File;", "cause", "Lit/unibo/tuprolog/core/parsing/ParseException;", "(Ljava/io/File;Lit/unibo/tuprolog/core/parsing/ParseException;)V", "getFile", "()Ljava/io/File;", "message", "", "getMessage", "()Ljava/lang/String;", "ide"})
    public static final class InTheorySyntaxError
    extends SyntaxException {
        @NotNull
        private final File file;

        public InTheorySyntaxError(@NotNull File file, @NotNull ParseException cause) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(cause, null);
            this.file = file;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @Override
        @NotNull
        public String getMessage() {
            Object object = this.getCause().getInput();
            String string = object == null ? null : object.toString();
            String errorDetector = SyntaxError.Companion.errorDetector(string == null ? FilesKt.readText$default((File)this.file, null, (int)1, null) : string, this.getCause().getLine(), this.getCause().getColumn(), this.getCause().getMessage());
            return StringsKt.trimMargin$default((String)("\n                    |Syntax error at " + this.getCause().getLine() + ':' + this.getCause().getColumn() + " of " + this.file.getName() + ", while parsing clause " + this.getCause().getClauseIndex() + "\n                    |\n                    |    " + StringsKt.replace$default((String)errorDetector, (String)"\n", (String)"\n|    ", (boolean)false, (int)4, null) + "\n                    "), null, (int)1, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lit/unibo/tuprolog/ui/gui/SyntaxException$InQuerySyntaxError;", "Lit/unibo/tuprolog/ui/gui/SyntaxException;", "query", "", "cause", "Lit/unibo/tuprolog/core/parsing/ParseException;", "(Ljava/lang/String;Lit/unibo/tuprolog/core/parsing/ParseException;)V", "message", "getMessage", "()Ljava/lang/String;", "getQuery", "ide"})
    public static final class InQuerySyntaxError
    extends SyntaxException {
        @NotNull
        private final String query;

        public InQuerySyntaxError(@NotNull String query, @NotNull ParseException cause) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(cause, null);
            this.query = query;
        }

        @NotNull
        public final String getQuery() {
            return this.query;
        }

        @Override
        @NotNull
        public String getMessage() {
            CharSequence charSequence = this.query;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return "Query cannot be empty";
            }
            String errorDetector = SyntaxError.Companion.errorDetector(this.query, this.getCause().getLine(), this.getCause().getColumn(), this.getCause().getMessage());
            return StringsKt.trimMargin$default((String)("\n                    |Syntax error in query, near column " + this.getCause().getColumn() + "\n                    |\n                    |    " + StringsKt.replace$default((String)errorDetector, (String)"\n", (String)"\n|    ", (boolean)false, (int)4, null) + "\n                    "), null, (int)1, null);
        }
    }
}

