/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.libs.io;

import it.unibo.tuprolog.solve.libs.io.Url;
import it.unibo.tuprolog.solve.libs.io.exceptions.IOException;
import it.unibo.tuprolog.solve.libs.io.exceptions.InvalidUrlException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B;\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bB\r\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0018\u001a\u00020\rH\u00c6\u0003J\u0013\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lit/unibo/tuprolog/solve/libs/io/JvmUrl;", "Lit/unibo/tuprolog/solve/libs/io/Url;", "string", "", "(Ljava/lang/String;)V", "protocol", "host", "port", "", "path", "query", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)V", "url", "Ljava/net/URL;", "(Ljava/net/URL;)V", "getHost", "()Ljava/lang/String;", "getPath", "getPort", "()Ljava/lang/Integer;", "getProtocol", "getQuery", "getUrl", "()Ljava/net/URL;", "component1", "copy", "equals", "", "other", "", "hashCode", "readAsByteArray", "", "readAsText", "toString", "Companion", "io-lib"})
public final class JvmUrl
implements Url {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL url;

    public JvmUrl(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    public JvmUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this(JvmUrl.Companion.toUrl(string));
    }

    public JvmUrl(@NotNull String protocol, @NotNull String host, @Nullable Integer port, @NotNull String path, @Nullable String query) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(Url.Companion.toString$io_lib(protocol, host, port, path, query));
    }

    public /* synthetic */ JvmUrl(String string, String string2, Integer n, String string3, String string4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            string4 = null;
        }
        this(string, string2, n, string3, string4);
    }

    @Override
    @NotNull
    public String getProtocol() {
        String string = this.url.getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.protocol");
        return string;
    }

    @Override
    @NotNull
    public String getHost() {
        String string = this.url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.host");
        return string;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
        return string;
    }

    @Override
    @Nullable
    public Integer getPort() {
        int n = this.url.getPort();
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        return it > 0 ? Integer.valueOf(it) : null;
    }

    @Override
    @Nullable
    public String getQuery() {
        return this.url.getQuery();
    }

    @Override
    @NotNull
    public String readAsText() {
        Object object;
        try {
            object = new BufferedReader(new InputStreamReader(this.url.openStream())).lines();
            Intrinsics.checkNotNullExpressionValue(object, (String)"BufferedReader(InputStre\u2026rl.openStream())).lines()");
            object = SequencesKt.joinToString$default((Sequence)StreamsKt.asSequence(object), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        catch (FileNotFoundException e) {
            throw new IOException(Intrinsics.stringPlus((String)"Cannot find resource: ", (Object)this.url), e);
        }
        catch (java.io.IOException e) {
            throw new IOException(Intrinsics.stringPlus((String)"Generic I/O error while accessing: ", (Object)this.url), e);
        }
        return object;
    }

    @Override
    @NotNull
    public byte[] readAsByteArray() {
        byte[] byArray;
        try {
            byArray = new BufferedInputStream(this.url.openStream()).readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n            BufferedIn\u2026.readAllBytes()\n        }");
        }
        catch (java.io.IOException e) {
            throw new IOException(e.getMessage(), e);
        }
        return byArray;
    }

    @NotNull
    public String toString() {
        String string = this.url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
        return string;
    }

    @Override
    @NotNull
    public Url div(@NotNull String child) {
        return Url.DefaultImpls.div(this, child);
    }

    @Override
    @NotNull
    public Url resolve(@NotNull String child) {
        return Url.DefaultImpls.resolve(this, child);
    }

    @Override
    public boolean isFile() {
        return Url.DefaultImpls.isFile(this);
    }

    @Override
    public boolean isHttp() {
        return Url.DefaultImpls.isHttp(this);
    }

    @NotNull
    public final URL component1() {
        return this.url;
    }

    @NotNull
    public final JvmUrl copy(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new JvmUrl(url);
    }

    public static /* synthetic */ JvmUrl copy$default(JvmUrl jvmUrl, URL uRL, int n, Object object) {
        if ((n & 1) != 0) {
            uRL = jvmUrl.url;
        }
        return jvmUrl.copy(uRL);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmUrl)) {
            return false;
        }
        JvmUrl jvmUrl = (JvmUrl)other;
        return Intrinsics.areEqual((Object)this.url, (Object)jvmUrl.url);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lit/unibo/tuprolog/solve/libs/io/JvmUrl$Companion;", "", "()V", "toUrl", "Ljava/net/URL;", "", "io-lib"})
    public static final class Companion {
        private Companion() {
        }

        private final URL toUrl(String $this$toUrl) {
            URL uRL;
            try {
                uRL = new URL($this$toUrl);
            }
            catch (MalformedURLException e) {
                throw new InvalidUrlException(Intrinsics.stringPlus((String)"Invalid URL: ", (Object)$this$toUrl), e);
            }
            return uRL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

