(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', '2p-solve', '2p-core', '2p-theory', 'kt-math', '2p-utils', '2p-unify'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('2p-solve'), require('2p-core'), require('2p-theory'), require('kt-math'), require('2p-utils'), require('2p-unify'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module '2p-oop-lib'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to '2p-oop-lib'.");
    }if (typeof this['2p-solve'] === 'undefined') {
      throw new Error("Error loading module '2p-oop-lib'. Its dependency '2p-solve' was not found. Please, check whether '2p-solve' is loaded prior to '2p-oop-lib'.");
    }if (typeof this['2p-core'] === 'undefined') {
      throw new Error("Error loading module '2p-oop-lib'. Its dependency '2p-core' was not found. Please, check whether '2p-core' is loaded prior to '2p-oop-lib'.");
    }if (typeof this['2p-theory'] === 'undefined') {
      throw new Error("Error loading module '2p-oop-lib'. Its dependency '2p-theory' was not found. Please, check whether '2p-theory' is loaded prior to '2p-oop-lib'.");
    }if (typeof this['kt-math'] === 'undefined') {
      throw new Error("Error loading module '2p-oop-lib'. Its dependency 'kt-math' was not found. Please, check whether 'kt-math' is loaded prior to '2p-oop-lib'.");
    }if (typeof this['2p-utils'] === 'undefined') {
      throw new Error("Error loading module '2p-oop-lib'. Its dependency '2p-utils' was not found. Please, check whether '2p-utils' is loaded prior to '2p-oop-lib'.");
    }if (typeof this['2p-unify'] === 'undefined') {
      throw new Error("Error loading module '2p-oop-lib'. Its dependency '2p-unify' was not found. Please, check whether '2p-unify' is loaded prior to '2p-oop-lib'.");
    }root['2p-oop-lib'] = factory(typeof this['2p-oop-lib'] === 'undefined' ? {} : this['2p-oop-lib'], kotlin, this['2p-solve'], this['2p-core'], this['2p-theory'], this['kt-math'], this['2p-utils'], this['2p-unify']);
  }
}(this, function (_, Kotlin, $module$_2p_solve, $module$_2p_core, $module$_2p_theory, $module$kt_math, $module$_2p_utils, $module$_2p_unify) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var NullPointerException_init = Kotlin.kotlin.NullPointerException_init;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Library = $module$_2p_solve.it.unibo.tuprolog.solve.library.Library;
  var Specifier = $module$_2p_core.it.unibo.tuprolog.core.operators.Specifier;
  var Operator = $module$_2p_core.it.unibo.tuprolog.core.operators.Operator;
  var OperatorSet_init = $module$_2p_core.it.unibo.tuprolog.core.operators.OperatorSet_init_1gzv2l$;
  var Theory = $module$_2p_theory.it.unibo.tuprolog.theory.Theory;
  var PrimitiveClasses$stringClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.stringClass;
  var PrimitiveClasses$arrayClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.arrayClass;
  var getKClass = Kotlin.getKClass;
  var List = Kotlin.kotlin.collections.List;
  var ArrayList = Kotlin.kotlin.collections.ArrayList;
  var Map = Kotlin.kotlin.collections.Map;
  var LinkedHashMap = Kotlin.kotlin.collections.LinkedHashMap;
  var PrimitiveClasses$intClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.intClass;
  var PrimitiveClasses$doubleClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.doubleClass;
  var PrimitiveClasses$floatClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.floatClass;
  var Long = Kotlin.Long;
  var PrimitiveClasses$shortClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.shortClass;
  var PrimitiveClasses$byteClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.byteClass;
  var Char = Kotlin.BoxedChar;
  var PrimitiveClasses$booleanClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.booleanClass;
  var PrimitiveClasses$anyClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.anyClass;
  var PrimitiveClasses$nothingClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.nothingClass;
  var BigInteger = $module$kt_math.org.gciatto.kt.math.BigInteger;
  var BigDecimal = $module$kt_math.org.gciatto.kt.math.BigDecimal;
  var sequenceOf = Kotlin.kotlin.sequences.sequenceOf_i5x0yv$;
  var map = Kotlin.kotlin.sequences.map_z5avom$;
  var toMap = Kotlin.kotlin.collections.toMap_ah2ab9$;
  var AliasedLibrary = $module$_2p_solve.it.unibo.tuprolog.solve.library.AliasedLibrary;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var listOf = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var toList = Kotlin.kotlin.collections.toList_7wnvza$;
  var toList_0 = Kotlin.kotlin.sequences.toList_veqyi0$;
  var Atom = $module$_2p_core.it.unibo.tuprolog.core.Atom;
  var lazy = Kotlin.kotlin.lazy_klfg04$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var ToTermConvertible = $module$_2p_core.it.unibo.tuprolog.core.ToTermConvertible;
  var Optional = $module$_2p_utils.it.unibo.tuprolog.utils.Optional;
  var setOf = Kotlin.kotlin.collections.setOf_i5x0yv$;
  var contains = Kotlin.kotlin.collections.contains_2ws7j4$;
  var indexed = $module$_2p_utils.it.unibo.tuprolog.utils.indexed_veqyi0$;
  var trimMargin = Kotlin.kotlin.text.trimMargin_rjktp$;
  var listOf_0 = Kotlin.kotlin.collections.listOf_mh5how$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var checkIndexOverflow = Kotlin.kotlin.collections.checkIndexOverflow_za3lpa$;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var ExistenceError = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.ExistenceError;
  var ExistenceError$ObjectType = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.ExistenceError.ObjectType;
  var TypeError = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.TypeError;
  var TypeError$Expected = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.TypeError.Expected;
  var unboxChar = Kotlin.unboxChar;
  var toString = Kotlin.toString;
  var TermFormatter = $module$_2p_core.it.unibo.tuprolog.core.TermFormatter;
  var format = $module$_2p_core.it.unibo.tuprolog.core.format;
  var toBoxedChar = Kotlin.toBoxedChar;
  var Struct = $module$_2p_core.it.unibo.tuprolog.core.Struct;
  var throwCCE = Kotlin.throwCCE;
  var Unificator = $module$_2p_unify.it.unibo.tuprolog.unify.Unificator;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var TuPrologException = $module$_2p_core.it.unibo.tuprolog.core.exception.TuPrologException;
  var TuPrologException_init = $module$_2p_core.it.unibo.tuprolog.core.exception.TuPrologException_init_dbl4no$;
  var SystemError = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.SystemError;
  var ensureNotNull = Kotlin.ensureNotNull;
  var PermissionError = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.PermissionError;
  var PermissionError$Operation = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.PermissionError.Operation;
  var PermissionError$Permission = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.PermissionError.Permission;
  var RepresentationError = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.RepresentationError;
  var RepresentationError$Limit = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.RepresentationError.Limit;
  var Term = $module$_2p_core.it.unibo.tuprolog.core.Term;
  var Integer = $module$_2p_core.it.unibo.tuprolog.core.Integer;
  var Real = $module$_2p_core.it.unibo.tuprolog.core.Real;
  var concatToString = Kotlin.kotlin.text.concatToString_355ntz$;
  var Truth = $module$_2p_core.it.unibo.tuprolog.core.Truth;
  var NumberTypeTester = $module$_2p_utils.it.unibo.tuprolog.utils.NumberTypeTester;
  var Var = $module$_2p_core.it.unibo.tuprolog.core.Var;
  var Exception = Kotlin.kotlin.Exception;
  var asSequence = Kotlin.kotlin.collections.asSequence_7wnvza$;
  var first = Kotlin.kotlin.sequences.first_veqyi0$;
  var filterNotNull = Kotlin.kotlin.sequences.filterNotNull_q2m9h7$;
  var plus = Kotlin.kotlin.sequences.plus_v0iwhp$;
  var Long$Companion$MIN_VALUE = Kotlin.Long.MIN_VALUE;
  var Long$Companion$MAX_VALUE = Kotlin.Long.MAX_VALUE;
  var rangeTo = Kotlin.kotlin.ranges.rangeTo_8xshf9$;
  var kotlin_js_internal_DoubleCompanionObject = Kotlin.kotlin.js.internal.DoubleCompanionObject;
  var kotlin_js_internal_FloatCompanionObject = Kotlin.kotlin.js.internal.FloatCompanionObject;
  var toSet = Kotlin.kotlin.sequences.toSet_veqyi0$;
  var Optional$Some = $module$_2p_utils.it.unibo.tuprolog.utils.Optional.Some;
  var PrimitiveWrapper = $module$_2p_solve.it.unibo.tuprolog.solve.primitive.PrimitiveWrapper;
  var Substitution = $module$_2p_core.it.unibo.tuprolog.core.Substitution;
  var TernaryRelation$Functional = $module$_2p_solve.it.unibo.tuprolog.solve.primitive.TernaryRelation.Functional;
  var Throwable = Error;
  var List_0 = $module$_2p_core.it.unibo.tuprolog.core.List;
  var Any = Object;
  var BinaryRelation$Functional = $module$_2p_solve.it.unibo.tuprolog.solve.primitive.BinaryRelation.Functional;
  var asSequence_0 = Kotlin.kotlin.collections.asSequence_us0mfu$;
  var TernaryRelation$Predicative = $module$_2p_solve.it.unibo.tuprolog.solve.primitive.TernaryRelation.Predicative;
  var flatMap = Kotlin.kotlin.sequences.flatMap_49vfel$;
  var distinct = Kotlin.kotlin.sequences.distinct_veqyi0$;
  var TernaryRelation = $module$_2p_solve.it.unibo.tuprolog.solve.primitive.TernaryRelation;
  var TypeTester = $module$_2p_solve.it.unibo.tuprolog.solve.primitive.TypeTester;
  var Solution$Yes = $module$_2p_solve.it.unibo.tuprolog.solve.Solution.Yes;
  var firstOrNull = Kotlin.kotlin.sequences.firstOrNull_veqyi0$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var filter = Kotlin.kotlin.sequences.filter_euau3h$;
  var Sequence = Kotlin.kotlin.sequences.Sequence;
  var InstantiationError = $module$_2p_solve.it.unibo.tuprolog.solve.exception.error.InstantiationError;
  var Unit = Kotlin.kotlin.Unit;
  var BinaryRelation$NonBacktrackable = $module$_2p_solve.it.unibo.tuprolog.solve.primitive.BinaryRelation.NonBacktrackable;
  var Set = Kotlin.kotlin.collections.Set;
  var UnaryPredicate$NonBacktrackable = $module$_2p_solve.it.unibo.tuprolog.solve.primitive.UnaryPredicate.NonBacktrackable;
  var RuleWrapper_init = $module$_2p_solve.it.unibo.tuprolog.solve.rule.RuleWrapper_init_kn9vy1$;
  var RuleWrapper = $module$_2p_solve.it.unibo.tuprolog.solve.rule.RuleWrapper;
  var PropertyMetadata = Kotlin.PropertyMetadata;
  var primitive = $module$_2p_solve.it.unibo.tuprolog.solve.stdlib.primitive;
  var NotImplementedError = Kotlin.kotlin.NotImplementedError;
  var split = Kotlin.kotlin.text.split_o64adg$;
  var get_kotlin = Kotlin.kotlin.js.get_kotlin_2sk2mx$;
  var hashCode = Kotlin.hashCode;
  var toString_0 = Kotlin.kotlin.text.toString_dqglrj$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  Result$None.prototype = Object.create(Result.prototype);
  Result$None.prototype.constructor = Result$None;
  Result$Value.prototype = Object.create(Result.prototype);
  Result$Value.prototype.constructor = Result$Value;
  OopException.prototype = Object.create(TuPrologException.prototype);
  OopException.prototype.constructor = OopException;
  ConstructorInvocationException.prototype = Object.create(OopException.prototype);
  ConstructorInvocationException.prototype.constructor = ConstructorInvocationException;
  MalformedAliasException.prototype = Object.create(OopException.prototype);
  MalformedAliasException.prototype.constructor = MalformedAliasException;
  MethodInvocationException.prototype = Object.create(OopException.prototype);
  MethodInvocationException.prototype.constructor = MethodInvocationException;
  NoSuchAnAliasException.prototype = Object.create(OopException.prototype);
  NoSuchAnAliasException.prototype.constructor = NoSuchAnAliasException;
  OopRuntimeException.prototype = Object.create(OopException.prototype);
  OopRuntimeException.prototype.constructor = OopRuntimeException;
  PropertyAssignmentException.prototype = Object.create(OopException.prototype);
  PropertyAssignmentException.prototype.constructor = PropertyAssignmentException;
  RuntimePermissionException.prototype = Object.create(OopException.prototype);
  RuntimePermissionException.prototype.constructor = RuntimePermissionException;
  TermToObjectConversionException.prototype = Object.create(OopException.prototype);
  TermToObjectConversionException.prototype.constructor = TermToObjectConversionException;
  AbstractInvoke.prototype = Object.create(TernaryRelation$Functional.prototype);
  AbstractInvoke.prototype.constructor = AbstractInvoke;
  AbstractIterableItems.prototype = Object.create(BinaryRelation$Functional.prototype);
  AbstractIterableItems.prototype.constructor = AbstractIterableItems;
  ArrayItems.prototype = Object.create(AbstractIterableItems.prototype);
  ArrayItems.prototype.constructor = ArrayItems;
  Assign.prototype = Object.create(TernaryRelation$Predicative.prototype);
  Assign.prototype.constructor = Assign;
  Cast.prototype = Object.create(TernaryRelation.prototype);
  Cast.prototype.constructor = Cast;
  InvokeMethod.prototype = Object.create(AbstractInvoke.prototype);
  InvokeMethod.prototype.constructor = InvokeMethod;
  InvokeStrict.prototype = Object.create(AbstractInvoke.prototype);
  InvokeStrict.prototype.constructor = InvokeStrict;
  ListItems.prototype = Object.create(AbstractIterableItems.prototype);
  ListItems.prototype.constructor = ListItems;
  NewObject3.prototype = Object.create(TernaryRelation$Functional.prototype);
  NewObject3.prototype.constructor = NewObject3;
  NullRef_0.prototype = Object.create(TypeTester.prototype);
  NullRef_0.prototype.constructor = NullRef_0;
  ObjectRef_0.prototype = Object.create(TypeTester.prototype);
  ObjectRef_0.prototype.constructor = ObjectRef_0;
  Ref_0.prototype = Object.create(TypeTester.prototype);
  Ref_0.prototype.constructor = Ref_0;
  Register.prototype = Object.create(BinaryRelation$NonBacktrackable.prototype);
  Register.prototype.constructor = Register;
  SetItems.prototype = Object.create(AbstractIterableItems.prototype);
  SetItems.prototype.constructor = SetItems;
  Type.prototype = Object.create(BinaryRelation$Functional.prototype);
  Type.prototype.constructor = Type;
  TypeRef_0.prototype = Object.create(TypeTester.prototype);
  TypeRef_0.prototype.constructor = TypeRef_0;
  Unregister.prototype = Object.create(UnaryPredicate$NonBacktrackable.prototype);
  Unregister.prototype.constructor = Unregister;
  Alias.prototype = Object.create(RuleWrapper.prototype);
  Alias.prototype.constructor = Alias;
  ColonEquals.prototype = Object.create(RuleWrapper.prototype);
  ColonEquals.prototype.constructor = ColonEquals;
  ColonEquals$Cast.prototype = Object.create(ColonEquals.prototype);
  ColonEquals$Cast.prototype.constructor = ColonEquals$Cast;
  ColonEquals$Invocation.prototype = Object.create(ColonEquals.prototype);
  ColonEquals$Invocation.prototype.constructor = ColonEquals$Invocation;
  ColonEquals$Assignment.prototype = Object.create(ColonEquals.prototype);
  ColonEquals$Assignment.prototype.constructor = ColonEquals$Assignment;
  Dot.prototype = Object.create(RuleWrapper.prototype);
  Dot.prototype.constructor = Dot;
  FluentReduce.prototype = Object.create(RuleWrapper.prototype);
  FluentReduce.prototype.constructor = FluentReduce;
  FluentReduce$Recursive.prototype = Object.create(FluentReduce.prototype);
  FluentReduce$Recursive.prototype.constructor = FluentReduce$Recursive;
  FluentReduce$Couple.prototype = Object.create(FluentReduce.prototype);
  FluentReduce$Couple.prototype.constructor = FluentReduce$Couple;
  FluentReduce$Trivial.prototype = Object.create(FluentReduce.prototype);
  FluentReduce$Trivial.prototype.constructor = FluentReduce$Trivial;
  NewObject2.prototype = Object.create(RuleWrapper.prototype);
  NewObject2.prototype.constructor = NewObject2;
  PropertyReduce.prototype = Object.create(RuleWrapper.prototype);
  PropertyReduce.prototype.constructor = PropertyReduce;
  PropertyReduce$Recursive.prototype = Object.create(PropertyReduce.prototype);
  PropertyReduce$Recursive.prototype.constructor = PropertyReduce$Recursive;
  PropertyReduce$Base.prototype = Object.create(PropertyReduce.prototype);
  PropertyReduce$Base.prototype.constructor = PropertyReduce$Base;
  function NullRef() {
  }
  Object.defineProperty(NullRef.prototype, 'object', {
    configurable: true,
    get: function () {
      throw NullPointerException_init();
    }
  });
  NullRef.prototype.invoke_rktqbv$ = function (objectConverter, methodName, arguments_0) {
    throw NullPointerException_init();
  };
  NullRef.prototype.assign_2ptaz8$ = function (objectConverter, propertyName, value) {
    throw NullPointerException_init();
  };
  NullRef.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'NullRef',
    interfaces: [ObjectRef]
  };
  function OOP() {
    OOP_instance = this;
    this.ACCESS_OPERATOR = '.';
    this.CALL_OPERATOR = ':=';
    this.DEALIASING_OPERATOR = '$';
    this.CAST_OPERATOR = 'as';
    this.ALIAS_FUNCTOR = 'alias';
  }
  OOP.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'OOP',
    interfaces: []
  };
  var OOP_instance = null;
  function OOP_getInstance() {
    if (OOP_instance === null) {
      new OOP();
    }return OOP_instance;
  }
  function OOPLib() {
    OOPLib_instance = this;
    this.$delegate_2d56m6$_0 = Library.Companion.aliased(OperatorSet_init([new Operator('.', Specifier.XFY, 800), new Operator(':=', Specifier.XFX, 850), new Operator('as', Specifier.XFX, 200), new Operator('$', Specifier.FX, 100)]), Theory.Companion.indexedOfSequence(map(sequenceOf([ColonEquals$Cast_getInstance(), ColonEquals$Invocation_getInstance(), ColonEquals$Assignment_getInstance(), Dot_getInstance(), FluentReduce$Recursive_getInstance(), FluentReduce$Couple_getInstance(), FluentReduce$Trivial_getInstance(), NewObject2_getInstance(), PropertyReduce$Recursive_getInstance(), PropertyReduce$Base_getInstance(), Alias$Companion_getInstance().forType_hqvncd$('string', PrimitiveClasses$stringClass), Alias$Companion_getInstance().forType_hqvncd$('array', PrimitiveClasses$arrayClass), Alias$Companion_getInstance().forType_hqvncd$('list', getKClass(List)), Alias$Companion_getInstance().forType_hqvncd$('arraylist', getKClass(ArrayList)), Alias$Companion_getInstance().forType_hqvncd$('map', getKClass(Map)), Alias$Companion_getInstance().forType_hqvncd$('hashmap', getKClass(LinkedHashMap)), Alias$Companion_getInstance().forType_hqvncd$('int', PrimitiveClasses$intClass), Alias$Companion_getInstance().forType_hqvncd$('integer', PrimitiveClasses$intClass), Alias$Companion_getInstance().forType_hqvncd$('double', PrimitiveClasses$doubleClass), Alias$Companion_getInstance().forType_hqvncd$('float', PrimitiveClasses$floatClass), Alias$Companion_getInstance().forType_hqvncd$('long', getKClass(Long)), Alias$Companion_getInstance().forType_hqvncd$('short', PrimitiveClasses$shortClass), Alias$Companion_getInstance().forType_hqvncd$('byte', PrimitiveClasses$byteClass), Alias$Companion_getInstance().forType_hqvncd$('char', getKClass(Char)), Alias$Companion_getInstance().forType_hqvncd$('bool', PrimitiveClasses$booleanClass), Alias$Companion_getInstance().forType_hqvncd$('boolean', PrimitiveClasses$booleanClass), Alias$Companion_getInstance().forType_hqvncd$('any', PrimitiveClasses$anyClass), Alias$Companion_getInstance().forType_hqvncd$('nothing', PrimitiveClasses$nothingClass), Alias$Companion_getInstance().forType_hqvncd$('big_integer', getKClass(BigInteger)), Alias$Companion_getInstance().forType_hqvncd$('big_decimal', getKClass(BigDecimal))].concat(get_platformSpecificAliases())), OOPLib_init$lambda)), toMap(map(sequenceOf([ArrayItems_getInstance(), Assign_getInstance(), Cast_getInstance(), Type_getInstance(), InvokeMethod_getInstance(), InvokeStrict_getInstance(), ListItems_getInstance(), NewObject3_getInstance(), NullRef_getInstance(), ObjectRef_getInstance(), Ref_getInstance(), Register_getInstance(), SetItems_getInstance(), TypeRef_getInstance(), Unregister_getInstance()]), OOPLib_init$lambda_0)), void 0, 'prolog.oop');
  }
  Object.defineProperty(OOPLib.prototype, 'alias', {
    configurable: true,
    get: function () {
      return this.$delegate_2d56m6$_0.alias;
    }
  });
  Object.defineProperty(OOPLib.prototype, 'functions', {
    configurable: true,
    get: function () {
      return this.$delegate_2d56m6$_0.functions;
    }
  });
  Object.defineProperty(OOPLib.prototype, 'operators', {
    configurable: true,
    get: function () {
      return this.$delegate_2d56m6$_0.operators;
    }
  });
  Object.defineProperty(OOPLib.prototype, 'primitives', {
    configurable: true,
    get: function () {
      return this.$delegate_2d56m6$_0.primitives;
    }
  });
  Object.defineProperty(OOPLib.prototype, 'theory', {
    configurable: true,
    get: function () {
      return this.$delegate_2d56m6$_0.theory;
    }
  });
  OOPLib.prototype.containsOperator = function (operator) {
    return this.$delegate_2d56m6$_0.containsOperator(operator);
  };
  OOPLib.prototype.containsSignature = function (signature) {
    return this.$delegate_2d56m6$_0.containsSignature(signature);
  };
  OOPLib.prototype.hasPrimitive = function (signature) {
    return this.$delegate_2d56m6$_0.hasPrimitive(signature);
  };
  OOPLib.prototype.hasProtected = function (signature) {
    return this.$delegate_2d56m6$_0.hasProtected(signature);
  };
  function OOPLib_init$lambda(it) {
    return it.wrappedImplementation;
  }
  function OOPLib_init$lambda_0(it) {
    return to(it.signature, it.wrappedImplementation);
  }
  OOPLib.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'OOPLib',
    interfaces: [AliasedLibrary]
  };
  var OOPLib_instance = null;
  function OOPLib_getInstance() {
    if (OOPLib_instance === null) {
      new OOPLib();
    }return OOPLib_instance;
  }
  function ObjectRef() {
    ObjectRef$Companion_getInstance();
  }
  function ObjectRef$Companion() {
    ObjectRef$Companion_instance = this;
    this.NULL = NullRefImpl_getInstance();
  }
  ObjectRef$Companion.prototype.nameOf_s8jyv4$ = function (any) {
    if (any == null)
      return this.nameOf_0(PrimitiveClasses$nothingClass, 'null');
    else
      return this.nameOf_0(Kotlin.getKClassFromExpression(any), get_identifier(any));
  };
  ObjectRef$Companion.prototype.nameOf_0 = function (type, identifier) {
    return '<object:' + get_fullName(type) + '#' + identifier + '>';
  };
  ObjectRef$Companion.prototype.of_s8jyv4$ = function (any) {
    if (any == null)
      return this.NULL;
    else
      return new ObjectRefImpl(any);
  };
  ObjectRef$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ObjectRef$Companion_instance = null;
  function ObjectRef$Companion_getInstance() {
    if (ObjectRef$Companion_instance === null) {
      new ObjectRef$Companion();
    }return ObjectRef$Companion_instance;
  }
  ObjectRef.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ObjectRef',
    interfaces: [Ref]
  };
  function ObjectToTermConverter() {
    ObjectToTermConverter$Companion_getInstance();
  }
  function ObjectToTermConverter$Companion() {
    ObjectToTermConverter$Companion_instance = this;
    this.default = new ObjectToTermConverterImpl();
  }
  ObjectToTermConverter$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ObjectToTermConverter$Companion_instance = null;
  function ObjectToTermConverter$Companion_getInstance() {
    if (ObjectToTermConverter$Companion_instance === null) {
      new ObjectToTermConverter$Companion();
    }return ObjectToTermConverter$Companion_instance;
  }
  ObjectToTermConverter.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ObjectToTermConverter',
    interfaces: []
  };
  function OverloadSelector() {
    OverloadSelector$Companion_getInstance();
  }
  function OverloadSelector$Companion() {
    OverloadSelector$Companion_instance = this;
  }
  OverloadSelector$Companion.prototype.of_hdd6bw$ = function (type, termToObjectConverter) {
    if (termToObjectConverter === void 0)
      termToObjectConverter = TermToObjectConverter$Companion_getInstance().default;
    return overloadSelector(type, termToObjectConverter);
  };
  OverloadSelector$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OverloadSelector$Companion_instance = null;
  function OverloadSelector$Companion_getInstance() {
    if (OverloadSelector$Companion_instance === null) {
      new OverloadSelector$Companion();
    }return OverloadSelector$Companion_instance;
  }
  OverloadSelector.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'OverloadSelector',
    interfaces: []
  };
  function Ref() {
  }
  Ref.prototype.invoke_eg4gfx$ = function (objectConverter, methodName, arguments_0) {
    return this.invoke_rktqbv$(objectConverter, methodName, listOf(arguments_0.slice()));
  };
  Ref.prototype.invoke_82lxi7$ = function (objectConverter, methodName, arguments_0) {
    return this.invoke_rktqbv$(objectConverter, methodName, toList(arguments_0));
  };
  Ref.prototype.invoke_150s8f$ = function (objectConverter, methodName, arguments_0) {
    return this.invoke_rktqbv$(objectConverter, methodName, toList_0(arguments_0));
  };
  Ref.prototype.invoke_ozkpgk$ = function (methodName, arguments_0) {
    return this.invoke_rktqbv$(TermToObjectConverter$Companion_getInstance().default, methodName, listOf(arguments_0.slice()));
  };
  Ref.prototype.invoke_bkd1uy$ = function (methodName, arguments_0) {
    return this.invoke_rktqbv$(TermToObjectConverter$Companion_getInstance().default, methodName, arguments_0);
  };
  Ref.prototype.invoke_589wg2$ = function (methodName, arguments_0) {
    return this.invoke_rktqbv$(TermToObjectConverter$Companion_getInstance().default, methodName, toList(arguments_0));
  };
  Ref.prototype.invoke_o75wts$ = function (methodName, arguments_0) {
    return this.invoke_rktqbv$(TermToObjectConverter$Companion_getInstance().default, methodName, toList_0(arguments_0));
  };
  Ref.prototype.assign_2ol4p7$ = function (propertyName, value) {
    return this.assign_2ptaz8$(TermToObjectConverter$Companion_getInstance().default, propertyName, value);
  };
  Ref.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Ref',
    interfaces: [Atom]
  };
  function Result() {
  }
  function Result$None() {
    Result$None_instance = this;
    Result.call(this);
  }
  Result$None.prototype.toTerm = function () {
    return null;
  };
  Result$None.prototype.asObjectRef = function () {
    return null;
  };
  Result$None.prototype.isNone = function () {
    return true;
  };
  Result$None.prototype.asNone = function () {
    return this;
  };
  Result$None.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'None',
    interfaces: [Result]
  };
  var Result$None_instance = null;
  function Result$None_getInstance() {
    if (Result$None_instance === null) {
      new Result$None();
    }return Result$None_instance;
  }
  function Result$Value(value) {
    Result.call(this);
    this.value = value;
    this.termValue_ab01ee$_0 = lazy(Result$Value$termValue$lambda(this));
    this.objectRef_c8xpq1$_0 = lazy(Result$Value$objectRef$lambda(this));
  }
  Object.defineProperty(Result$Value.prototype, 'termValue_0', {
    configurable: true,
    get: function () {
      return this.termValue_ab01ee$_0.value;
    }
  });
  Object.defineProperty(Result$Value.prototype, 'objectRef_0', {
    configurable: true,
    get: function () {
      return this.objectRef_c8xpq1$_0.value;
    }
  });
  Result$Value.prototype.toTerm = function () {
    return this.termValue_0;
  };
  Result$Value.prototype.asObjectRef = function () {
    return this.objectRef_0;
  };
  Result$Value.prototype.isValue = function () {
    return true;
  };
  Result$Value.prototype.asValue = function () {
    return this;
  };
  function Result$Value$termValue$lambda(this$Value) {
    return function () {
      return ObjectToTermConverter$Companion_getInstance().default.convert_s8jyv4$(this$Value.value);
    };
  }
  function Result$Value$objectRef$lambda(this$Value) {
    return function () {
      var $receiver = this$Value.termValue_0;
      var this$Value_0 = this$Value;
      return Kotlin.isType($receiver, ObjectRef) ? $receiver : ObjectRef$Companion_getInstance().of_s8jyv4$(this$Value_0.value);
    };
  }
  Result$Value.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Value',
    interfaces: [ToTermConvertible, Result]
  };
  Result$Value.prototype.component1 = function () {
    return this.value;
  };
  Result$Value.prototype.copy_s8jyv4$ = function (value) {
    return new Result$Value(value === void 0 ? this.value : value);
  };
  Result$Value.prototype.toString = function () {
    return 'Value(value=' + Kotlin.toString(this.value) + ')';
  };
  Result$Value.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  Result$Value.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  Result.prototype.isNone = function () {
    return false;
  };
  Result.prototype.isValue = function () {
    return false;
  };
  Result.prototype.asNone = function () {
    return null;
  };
  Result.prototype.asValue = function () {
    return null;
  };
  Result.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Result',
    interfaces: []
  };
  function TermToObjectConverter() {
    TermToObjectConverter$Companion_getInstance();
  }
  TermToObjectConverter.prototype.convert_z0t4vt$ = function (term) {
    return this.convertInto_ulrmtq$(this.mostAdequateType_z0t4vt$(term), term);
  };
  function TermToObjectConverter$Companion() {
    TermToObjectConverter$Companion_instance = this;
    this.default = this.of_u5gbj4$();
  }
  function TermToObjectConverter$Companion$of$lambda(it) {
    return null;
  }
  TermToObjectConverter$Companion.prototype.of_u5gbj4$ = function (typeFactory, dealiaser) {
    if (typeFactory === void 0)
      typeFactory = TypeFactory$Companion_getInstance().default;
    if (dealiaser === void 0)
      dealiaser = TermToObjectConverter$Companion$of$lambda;
    return new TermToObjectConverterImpl(typeFactory, dealiaser);
  };
  TermToObjectConverter$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TermToObjectConverter$Companion_instance = null;
  function TermToObjectConverter$Companion_getInstance() {
    if (TermToObjectConverter$Companion_instance === null) {
      new TermToObjectConverter$Companion();
    }return TermToObjectConverter$Companion_instance;
  }
  TermToObjectConverter.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TermToObjectConverter',
    interfaces: []
  };
  function TypeFactory() {
    TypeFactory$Companion_getInstance();
  }
  function TypeFactory$Companion() {
    TypeFactory$Companion_instance = this;
    this.default = new TypeFactoryImpl();
  }
  TypeFactory$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TypeFactory$Companion_instance = null;
  function TypeFactory$Companion_getInstance() {
    if (TypeFactory$Companion_instance === null) {
      new TypeFactory$Companion();
    }return TypeFactory$Companion_instance;
  }
  function TypeFactory$typeRefFromName$lambda(it) {
    return TypeRef$Companion_getInstance().of_xo1ogr$(it);
  }
  TypeFactory.prototype.typeRefFromName_61zpoe$ = function (typeName) {
    return Optional.Companion.of_mh5how$(this.typeFromName_61zpoe$(typeName)).map_2o04qz$(TypeFactory$typeRefFromName$lambda).value;
  };
  TypeFactory.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TypeFactory',
    interfaces: []
  };
  function TypeRef() {
    TypeRef$Companion_getInstance();
  }
  TypeRef.prototype.create_r8fmqz$ = function (objectConverter, arguments_0) {
    return this.create_7l9yux$(objectConverter, listOf(arguments_0.slice()));
  };
  TypeRef.prototype.create_v3ypzh$ = function (objectConverter, arguments_0) {
    return this.create_7l9yux$(objectConverter, toList(arguments_0));
  };
  TypeRef.prototype.create_ur6a81$ = function (objectConverter, arguments_0) {
    return this.create_7l9yux$(objectConverter, toList_0(arguments_0));
  };
  TypeRef.prototype.create_vek5ca$ = function (arguments_0) {
    return this.create_7l9yux$(TermToObjectConverter$Companion_getInstance().default, listOf(arguments_0.slice()));
  };
  TypeRef.prototype.create_l0zifs$ = function (arguments_0) {
    return this.create_7l9yux$(TermToObjectConverter$Companion_getInstance().default, arguments_0);
  };
  TypeRef.prototype.create_8bqfx0$ = function (arguments_0) {
    return this.create_7l9yux$(TermToObjectConverter$Companion_getInstance().default, toList(arguments_0));
  };
  TypeRef.prototype.create_p0bg4e$ = function (arguments_0) {
    return this.create_7l9yux$(TermToObjectConverter$Companion_getInstance().default, toList_0(arguments_0));
  };
  function TypeRef$Companion() {
    TypeRef$Companion_instance = this;
  }
  TypeRef$Companion.prototype.of_xo1ogr$ = function (type) {
    return new TypeRefImpl(type);
  };
  TypeRef$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TypeRef$Companion_instance = null;
  function TypeRef$Companion_getInstance() {
    if (TypeRef$Companion_instance === null) {
      new TypeRef$Companion();
    }return TypeRef$Companion_instance;
  }
  TypeRef.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TypeRef',
    interfaces: [Ref]
  };
  var PRIMITIVE_TYPES;
  var id;
  function get_isPrimitiveType($receiver) {
    return contains(PRIMITIVE_TYPES, $receiver);
  }
  function isSupertypeOf($receiver, other) {
    return isSupertypeOf_0($receiver, other, false);
  }
  function isSupertypeOf_0($receiver, other, strict) {
    var $receiver_0 = allSupertypes(other, strict);
    var any$result;
    any$break: do {
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (element != null ? element.equals($receiver) : null) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    return any$result;
  }
  function superTypeDistance($receiver, other) {
    var tmp$;
    var $receiver_0 = indexed(allSupertypes(other, false));
    var firstOrNull$result;
    firstOrNull$break: do {
      var tmp$_0;
      tmp$_0 = $receiver_0.iterator();
      while (tmp$_0.hasNext()) {
        var element = tmp$_0.next();
        var it = element.component2();
        if (it != null ? it.equals($receiver) : null) {
          firstOrNull$result = element;
          break firstOrNull$break;
        }}
      firstOrNull$result = null;
    }
     while (false);
    return (tmp$ = firstOrNull$result) != null ? tmp$.index : null;
  }
  function isSubtypeOf($receiver, other) {
    return isSubtypeOf_0($receiver, other, false);
  }
  function isSubtypeOf_0($receiver, other, strict) {
    return isSupertypeOf_0(other, $receiver, strict);
  }
  function subTypeDistance($receiver, other) {
    return superTypeDistance(other, $receiver);
  }
  function invoke($receiver, objectConverter, methodName, arguments_0) {
    return invoke_0(Kotlin.getKClassFromExpression($receiver), objectConverter, methodName, arguments_0, $receiver);
  }
  function ensureArgumentsListIsOfSize($receiver, actualArguments) {
    var $receiver_0 = get_formalParameterTypes($receiver);
    if (!(get_formalParameterTypes($receiver).size === actualArguments.size)) {
      var tmp$ = '\n' + '            |' + '\n' + '            |Error while invoking ' + $receiver.callableName + ' the expected argument types ' + '\n' + '            |   ';
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_0, 10));
      var tmp$_0;
      tmp$_0 = $receiver_0.iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        destination.add_11rb$(get_name(item));
      }
      var message = trimMargin(tmp$ + destination + ' ' + '\n' + '            |are not as many as the as the actual parameters (' + $receiver_0.size + ' vs. ' + actualArguments.size + '):' + '\n' + '            |   ' + actualArguments + '\n' + '            |' + '\n' + '            ');
      throw IllegalArgumentException_init(message.toString());
    }return $receiver_0;
  }
  function invoke_0($receiver, objectConverter, methodName, arguments_0, instance) {
    var methodRef = OverloadSelector$Companion_getInstance().of_hdd6bw$($receiver, objectConverter).findMethod_bkd1uy$(methodName, arguments_0);
    return callWithPrologArguments(methodRef, objectConverter, arguments_0, instance);
  }
  function callWithPrologArguments$lambda(closure$instance, closure$args, this$callWithPrologArguments) {
    return function () {
      var result = invoke_1(this$callWithPrologArguments, closure$instance, closure$args.slice());
      return new Result$Value(result);
    };
  }
  function callWithPrologArguments($receiver, converter, arguments_0, instance) {
    if (instance === void 0)
      instance = null;
    var formalArgumentsTypes = ensureArgumentsListIsOfSize($receiver, arguments_0);
    var destination = ArrayList_init(collectionSizeOrDefault(arguments_0, 10));
    var tmp$, tmp$_0;
    var index = 0;
    tmp$ = arguments_0.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(converter.convertInto_ulrmtq$(formalArgumentsTypes.get_za3lpa$(checkIndexOverflow((tmp$_0 = index, index = tmp$_0 + 1 | 0, tmp$_0))), item));
    }
    var args = copyToArray(destination);
    return catchingPlatformSpecificException($receiver, instance, callWithPrologArguments$lambda(instance, args, $receiver));
  }
  function assign($receiver, objectConverter, propertyName, value) {
    return assign_0(Kotlin.getKClassFromExpression($receiver), objectConverter, propertyName, value, $receiver);
  }
  function assign_0($receiver, objectConverter, propertyName, value, instance) {
    var setterRef = get_setterMethod(OverloadSelector$Companion_getInstance().of_hdd6bw$($receiver, objectConverter).findProperty_2ol4p7$(propertyName, value));
    return callWithPrologArguments(setterRef, objectConverter, listOf_0(value), instance);
  }
  function create($receiver, objectConverter, arguments_0) {
    var constructorRef = OverloadSelector$Companion_getInstance().of_hdd6bw$($receiver, objectConverter).findConstructor_l0zifs$(arguments_0);
    return callWithPrologArguments(constructorRef, objectConverter, arguments_0);
  }
  function ConstructorInvocationException(type, admissibleTypes) {
    OopException_init('There is no constructor on type ' + get_fullName(type) + ' which accepts ' + ('[' + OopException$Companion_getInstance().pretty_stgjs9$(admissibleTypes) + '] as formal arguments'), void 0, this);
    this.type = type;
    this.admissibleTypes = admissibleTypes;
    this.name = 'ConstructorInvocationException';
  }
  ConstructorInvocationException.prototype.toPrologError_yuggv1$ = function (context, signature) {
    var tmp$;
    return ExistenceError.Companion.of(context, ExistenceError$ObjectType.OOP_CONSTRUCTOR, this.culprit, (tmp$ = this.message) != null ? tmp$ : '');
  };
  Object.defineProperty(ConstructorInvocationException.prototype, 'culprit', {
    configurable: true,
    get: function () {
      return Atom.Companion.of(get_fullName(this.type) + '::(' + OopException$Companion_getInstance().pretty_stgjs9$(this.admissibleTypes) + ')');
    }
  });
  ConstructorInvocationException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ConstructorInvocationException',
    interfaces: [OopException]
  };
  function MalformedAliasException(dealiasingExpression) {
    OopException_init('This is not a dealiasing expression `' + dealiasingExpression + '` in the form ' + format(DEALIASING_TEMPLATE, TermFormatter.Companion.prettyExpressionsPrettyVariablesDefaultOperators()), void 0, this);
    this.dealiasingExpression = dealiasingExpression;
    this.name = 'MalformedAliasException';
  }
  MalformedAliasException.prototype.toPrologError_yuggv1$ = function (context, signature) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    tmp$_2 = TypeError.Companion;
    tmp$ = TypeError$Expected.DEALIASING_EXPRESSION;
    tmp$_0 = this.culprit;
    var tmp$_3 = 'Error in ' + signature.toIndicator() + ': ';
    var tmp$_4;
    if ((tmp$_1 = this.message) != null) {
      var tmp$_5;
      if (tmp$_1.length > 0) {
        var $receiver = unboxChar(toBoxedChar(tmp$_1.charCodeAt(0)));
        tmp$_5 = String.fromCharCode($receiver).toLowerCase().toString() + tmp$_1.substring(1);
      } else
        tmp$_5 = tmp$_1;
      tmp$_4 = tmp$_5;
    } else
      tmp$_4 = null;
    return tmp$_2.of(context, tmp$, tmp$_0, tmp$_3 + toString(tmp$_4));
  };
  Object.defineProperty(MalformedAliasException.prototype, 'culprit', {
    configurable: true,
    get: function () {
      return this.dealiasingExpression;
    }
  });
  MalformedAliasException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MalformedAliasException',
    interfaces: [OopException]
  };
  function MethodInvocationException(type, missingMethodName, admissibleTypes) {
    OopException_init('There is no method on type ' + get_fullName(type) + ' which is named `' + missingMethodName + '` and accepts ' + ('[' + OopException$Companion_getInstance().pretty_stgjs9$(admissibleTypes) + '] as formal arguments'), void 0, this);
    this.type = type;
    this.missingMethodName = missingMethodName;
    this.admissibleTypes = admissibleTypes;
    this.name = 'MethodInvocationException';
  }
  MethodInvocationException.prototype.toPrologError_yuggv1$ = function (context, signature) {
    var tmp$;
    return ExistenceError.Companion.of(context, ExistenceError$ObjectType.OOP_METHOD, this.culprit, (tmp$ = this.message) != null ? tmp$ : '');
  };
  Object.defineProperty(MethodInvocationException.prototype, 'culprit', {
    configurable: true,
    get: function () {
      return Atom.Companion.of(get_fullName(this.type) + '::' + this.missingMethodName + '(' + OopException$Companion_getInstance().pretty_stgjs9$(this.admissibleTypes) + ')');
    }
  });
  MethodInvocationException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MethodInvocationException',
    interfaces: [OopException]
  };
  function NoSuchAnAliasException(dealiasingExpression) {
    OopException_init('There exists no reference whose alias is `' + dealiasingExpression.get(0) + '`', void 0, this);
    this.dealiasingExpression = dealiasingExpression;
    this.name = 'NoSuchAnAliasException';
    if (!Unificator.Companion.matches(this.dealiasingExpression, DEALIASING_TEMPLATE)) {
      var message = 'Failed requirement.';
      throw IllegalArgumentException_init(message.toString());
    }if (!Kotlin.isType(this.dealiasingExpression.get(0), Struct)) {
      var message_0 = 'Failed requirement.';
      throw IllegalArgumentException_init(message_0.toString());
    }}
  Object.defineProperty(NoSuchAnAliasException.prototype, 'alias', {
    configurable: true,
    get: function () {
      var tmp$;
      return Kotlin.isType(tmp$ = this.dealiasingExpression.get(0), Struct) ? tmp$ : throwCCE();
    }
  });
  NoSuchAnAliasException.prototype.toPrologError_yuggv1$ = function (context, signature) {
    var tmp$;
    return ExistenceError.Companion.of(context, ExistenceError$ObjectType.OOP_ALIAS, this.culprit, (tmp$ = this.message) != null ? tmp$ : '');
  };
  Object.defineProperty(NoSuchAnAliasException.prototype, 'culprit', {
    configurable: true,
    get: function () {
      return this.dealiasingExpression;
    }
  });
  NoSuchAnAliasException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NoSuchAnAliasException',
    interfaces: [OopException]
  };
  function OopException() {
    OopException$Companion_getInstance();
    this.name = 'OopException';
  }
  function OopException$Companion() {
    OopException$Companion_instance = this;
  }
  function OopException$Companion$pretty$lambda(this$OopException$) {
    return function (it) {
      return this$OopException$.pretty_vdi4wu$(it);
    };
  }
  OopException$Companion.prototype.pretty_stgjs9$ = function ($receiver) {
    return joinToString($receiver, void 0, void 0, void 0, void 0, void 0, OopException$Companion$pretty$lambda(this));
  };
  function OopException$Companion$pretty$lambda_0(it) {
    return get_name(it);
  }
  OopException$Companion.prototype.pretty_vdi4wu$ = function ($receiver) {
    return joinToString($receiver, '|', void 0, void 0, void 0, void 0, OopException$Companion$pretty$lambda_0);
  };
  OopException$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OopException$Companion_instance = null;
  function OopException$Companion_getInstance() {
    if (OopException$Companion_instance === null) {
      new OopException$Companion();
    }return OopException$Companion_instance;
  }
  OopException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OopException',
    interfaces: [TuPrologException]
  };
  function OopException_init(message, cause, $this) {
    if (message === void 0)
      message = null;
    if (cause === void 0)
      cause = null;
    $this = $this || Object.create(OopException.prototype);
    TuPrologException.call($this, message, cause);
    OopException.call($this);
    return $this;
  }
  function OopException_init_0(cause, $this) {
    $this = $this || Object.create(OopException.prototype);
    TuPrologException_init(cause, $this);
    OopException.call($this);
    return $this;
  }
  function OopRuntimeException(callable, receiver, inner) {
    var tmp$;
    OopException_init((tmp$ = inner.message) != null ? tmp$ : 'Unhandled exception of type ' + get_fullName(Kotlin.getKClassFromExpression(inner)) + ' while executing OOP code', inner, this);
    this.callable_0 = callable;
    this.receiver_0 = receiver;
    this.name = 'OopRuntimeException';
  }
  OopRuntimeException.prototype.toPrologError_yuggv1$ = function (context, signature) {
    return SystemError.Companion.forUncaughtKtException(context, this);
  };
  Object.defineProperty(OopRuntimeException.prototype, 'message', {
    configurable: true,
    get: function () {
      return ensureNotNull(Kotlin.callGetter(this, OopException.prototype, 'message'));
    }
  });
  Object.defineProperty(OopRuntimeException.prototype, 'cause', {
    configurable: true,
    get: function () {
      return ensureNotNull(Kotlin.callGetter(this, OopException.prototype, 'cause'));
    }
  });
  Object.defineProperty(OopRuntimeException.prototype, 'culprit', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0;
      tmp$_0 = Atom.Companion;
      if (this.receiver_0 == null) {
        tmp$ = pretty(this.callable_0);
      } else {
        tmp$ = get_fullName(Kotlin.getKClassFromExpression(this.receiver_0)) + '::' + pretty(this.callable_0);
      }
      return tmp$_0.of(tmp$);
    }
  });
  OopRuntimeException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OopRuntimeException',
    interfaces: [OopException]
  };
  function PropertyAssignmentException(type, missingPropertyName, admissibleTypes) {
    OopException_init('There is no property on type ' + get_fullName(type) + ' which is named `' + missingPropertyName + '` and can be ' + ('assigned to a value of type ' + OopException$Companion_getInstance().pretty_vdi4wu$(admissibleTypes)), void 0, this);
    this.type = type;
    this.missingPropertyName = missingPropertyName;
    this.admissibleTypes = admissibleTypes;
    this.name = 'PropertyAssignmentException';
  }
  PropertyAssignmentException.prototype.toPrologError_yuggv1$ = function (context, signature) {
    var tmp$;
    return ExistenceError.Companion.of(context, ExistenceError$ObjectType.OOP_PROPERTY, this.culprit, (tmp$ = this.message) != null ? tmp$ : '');
  };
  Object.defineProperty(PropertyAssignmentException.prototype, 'culprit', {
    configurable: true,
    get: function () {
      return Atom.Companion.of(get_fullName(this.type) + '::' + this.missingPropertyName + ': ' + OopException$Companion_getInstance().pretty_vdi4wu$(this.admissibleTypes));
    }
  });
  PropertyAssignmentException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PropertyAssignmentException',
    interfaces: [OopException]
  };
  function RuntimePermissionException(callable, receiver, cause) {
    if (cause === void 0)
      cause = null;
    tmp$_0 = 'Invoking method ' + pretty(callable);
    if (receiver != null) {
      tmp$ = ' on object `' + toString(receiver) + '` of type `' + get_fullName(Kotlin.getKClassFromExpression(receiver)) + ' ';
    } else {
      tmp$ = ' ';
    }
    var tmp$, tmp$_0;
    OopException_init(tmp$_0 + tmp$ + 'is not permitted', cause, this);
    this.callable = callable;
    this.receiver = receiver;
    this.name = 'RuntimePermissionException';
  }
  RuntimePermissionException.prototype.toPrologError_yuggv1$ = function (context, signature) {
    return PermissionError.Companion.of(context, signature, PermissionError$Operation.INVOKE, PermissionError$Permission.OOP_METHOD, this.culprit);
  };
  Object.defineProperty(RuntimePermissionException.prototype, 'culprit', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0;
      tmp$_0 = Atom.Companion;
      if (this.receiver == null) {
        tmp$ = pretty(this.callable);
      } else {
        tmp$ = get_fullName(Kotlin.getKClassFromExpression(this.receiver)) + '::' + pretty(this.callable);
      }
      return tmp$_0.of(tmp$);
    }
  });
  RuntimePermissionException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RuntimePermissionException',
    interfaces: [OopException]
  };
  function TermToObjectConversionException(term, targetType) {
    if (targetType === void 0)
      targetType = null;
    var tmp$;
    OopException_init((tmp$ = targetType != null ? 'Term `' + term + '` cannot be converted into an object of type ' + get_fullName(targetType) : null) != null ? tmp$ : 'Term `' + term + '` cannot be converted into an object', void 0, this);
    this.term = term;
    this.targetType = targetType;
    this.name = 'TermToObjectConversionException';
  }
  TermToObjectConversionException.prototype.toPrologError_yuggv1$ = function (context, signature) {
    return RepresentationError.Companion.of(context, signature, RepresentationError$Limit.OOP_OBJECT, this);
  };
  Object.defineProperty(TermToObjectConversionException.prototype, 'culprit', {
    configurable: true,
    get: function () {
      return this.term;
    }
  });
  TermToObjectConversionException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TermToObjectConversionException',
    interfaces: [OopException]
  };
  function TermToObjectConversionException_init(term, $this) {
    $this = $this || Object.create(TermToObjectConversionException.prototype);
    TermToObjectConversionException.call($this, term, null);
    return $this;
  }
  function NullRefImpl() {
    NullRefImpl_instance = this;
    this.$delegate_tjs3rp$_0 = Atom.Companion.of(ObjectRef$Companion_getInstance().nameOf_s8jyv4$(null));
  }
  Object.defineProperty(NullRefImpl.prototype, 'isConstant', {
    configurable: true,
    get: function () {
      return true;
    }
  });
  NullRefImpl.prototype.asConstant = function () {
    return this;
  };
  NullRefImpl.prototype.freshCopy = function () {
    return this;
  };
  NullRefImpl.prototype.freshCopyFromScope = function (scope) {
    return this;
  };
  NullRefImpl.prototype.as_wr69nn$ = function () {
    var tmp$;
    return Kotlin.isType(tmp$ = this, Term) ? tmp$ : null;
  };
  NullRefImpl.prototype.castTo_wr69nn$ = function () {
    var tmp$;
    return Kotlin.isType(tmp$ = this, Term) ? tmp$ : throwCCE();
  };
  NullRefImpl.prototype.applySubstitution = function (substitution) {
    return this;
  };
  NullRefImpl.prototype.apply = function (substitution, substitutions) {
    return this;
  };
  NullRefImpl.prototype.getSubstituted = function (substitution, substitutions) {
    return this;
  };
  NullRefImpl.prototype.accept = function (visitor) {
    return visitor.visitAtom(this);
  };
  Object.defineProperty(NullRefImpl.prototype, 'argsList', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.args;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'argsSequence', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.argsSequence;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'arity', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.arity;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'functor', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.functor;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'indicator', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.indicator;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isAtom', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isAtom;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isClause', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isClause;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isCollection', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isCollection;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isCons', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isCons;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isDirective', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isDirective;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isEmptyList', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isEmptyList;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isEmptySet', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isEmptySet;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isFact', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isFact;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isFail', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isFail;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isFunctorWellFormed', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isFunctorWellFormed;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isGround', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isGround;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isIndicator', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isIndicator;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isInt', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isInt;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isList', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isList;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isNumber', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isNumber;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isReal', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isReal;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isRule', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isRule;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isSet', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isSet;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isStruct', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isStruct;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isTrue', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isTrue;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isTruth', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isTruth;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isTuple', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isTuple;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'isVariable', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.isVariable;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'tags', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.tags;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'value', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.value;
    }
  });
  Object.defineProperty(NullRefImpl.prototype, 'variables', {
    configurable: true,
    get: function () {
      return this.$delegate_tjs3rp$_0.variables;
    }
  });
  NullRefImpl.prototype.addFirst = function (argument) {
    return this.$delegate_tjs3rp$_0.addFirst(argument);
  };
  NullRefImpl.prototype.addLast = function (argument) {
    return this.$delegate_tjs3rp$_0.addLast(argument);
  };
  NullRefImpl.prototype.append = function (argument) {
    return this.$delegate_tjs3rp$_0.append(argument);
  };
  NullRefImpl.prototype.asAtom = function () {
    return this.$delegate_tjs3rp$_0.asAtom();
  };
  NullRefImpl.prototype.asClause = function () {
    return this.$delegate_tjs3rp$_0.asClause();
  };
  NullRefImpl.prototype.asCollection = function () {
    return this.$delegate_tjs3rp$_0.asCollection();
  };
  NullRefImpl.prototype.asCons = function () {
    return this.$delegate_tjs3rp$_0.asCons();
  };
  NullRefImpl.prototype.asDirective = function () {
    return this.$delegate_tjs3rp$_0.asDirective();
  };
  NullRefImpl.prototype.asEmptyList = function () {
    return this.$delegate_tjs3rp$_0.asEmptyList();
  };
  NullRefImpl.prototype.asEmptySet = function () {
    return this.$delegate_tjs3rp$_0.asEmptySet();
  };
  NullRefImpl.prototype.asFact = function () {
    return this.$delegate_tjs3rp$_0.asFact();
  };
  NullRefImpl.prototype.asIndicator = function () {
    return this.$delegate_tjs3rp$_0.asIndicator();
  };
  NullRefImpl.prototype.asInteger = function () {
    return this.$delegate_tjs3rp$_0.asInteger();
  };
  NullRefImpl.prototype.asList = function () {
    return this.$delegate_tjs3rp$_0.asList();
  };
  NullRefImpl.prototype.asNumeric = function () {
    return this.$delegate_tjs3rp$_0.asNumeric();
  };
  NullRefImpl.prototype.asReal = function () {
    return this.$delegate_tjs3rp$_0.asReal();
  };
  NullRefImpl.prototype.asRule = function () {
    return this.$delegate_tjs3rp$_0.asRule();
  };
  NullRefImpl.prototype.asSet = function () {
    return this.$delegate_tjs3rp$_0.asSet();
  };
  NullRefImpl.prototype.asStruct = function () {
    return this.$delegate_tjs3rp$_0.asStruct();
  };
  NullRefImpl.prototype.asTerm = function () {
    return this.$delegate_tjs3rp$_0.asTerm();
  };
  NullRefImpl.prototype.asTruth = function () {
    return this.$delegate_tjs3rp$_0.asTruth();
  };
  NullRefImpl.prototype.asTuple = function () {
    return this.$delegate_tjs3rp$_0.asTuple();
  };
  NullRefImpl.prototype.asVar = function () {
    return this.$delegate_tjs3rp$_0.asVar();
  };
  NullRefImpl.prototype.castToAtom = function () {
    return this.$delegate_tjs3rp$_0.castToAtom();
  };
  NullRefImpl.prototype.castToClause = function () {
    return this.$delegate_tjs3rp$_0.castToClause();
  };
  NullRefImpl.prototype.castToCollection = function () {
    return this.$delegate_tjs3rp$_0.castToCollection();
  };
  NullRefImpl.prototype.castToCons = function () {
    return this.$delegate_tjs3rp$_0.castToCons();
  };
  NullRefImpl.prototype.castToConstant = function () {
    return this.$delegate_tjs3rp$_0.castToConstant();
  };
  NullRefImpl.prototype.castToDirective = function () {
    return this.$delegate_tjs3rp$_0.castToDirective();
  };
  NullRefImpl.prototype.castToEmptyList = function () {
    return this.$delegate_tjs3rp$_0.castToEmptyList();
  };
  NullRefImpl.prototype.castToEmptySet = function () {
    return this.$delegate_tjs3rp$_0.castToEmptySet();
  };
  NullRefImpl.prototype.castToFact = function () {
    return this.$delegate_tjs3rp$_0.castToFact();
  };
  NullRefImpl.prototype.castToIndicator = function () {
    return this.$delegate_tjs3rp$_0.castToIndicator();
  };
  NullRefImpl.prototype.castToInteger = function () {
    return this.$delegate_tjs3rp$_0.castToInteger();
  };
  NullRefImpl.prototype.castToList = function () {
    return this.$delegate_tjs3rp$_0.castToList();
  };
  NullRefImpl.prototype.castToNumeric = function () {
    return this.$delegate_tjs3rp$_0.castToNumeric();
  };
  NullRefImpl.prototype.castToReal = function () {
    return this.$delegate_tjs3rp$_0.castToReal();
  };
  NullRefImpl.prototype.castToRule = function () {
    return this.$delegate_tjs3rp$_0.castToRule();
  };
  NullRefImpl.prototype.castToSet = function () {
    return this.$delegate_tjs3rp$_0.castToSet();
  };
  NullRefImpl.prototype.castToStruct = function () {
    return this.$delegate_tjs3rp$_0.castToStruct();
  };
  NullRefImpl.prototype.castToTerm = function () {
    return this.$delegate_tjs3rp$_0.castToTerm();
  };
  NullRefImpl.prototype.castToTruth = function () {
    return this.$delegate_tjs3rp$_0.castToTruth();
  };
  NullRefImpl.prototype.castToTuple = function () {
    return this.$delegate_tjs3rp$_0.castToTuple();
  };
  NullRefImpl.prototype.castToVar = function () {
    return this.$delegate_tjs3rp$_0.castToVar();
  };
  NullRefImpl.prototype.compareTo_11rb$ = function (other) {
    return this.$delegate_tjs3rp$_0.compareTo_11rb$(other);
  };
  NullRefImpl.prototype.containsTag = function (name) {
    return this.$delegate_tjs3rp$_0.containsTag(name);
  };
  NullRefImpl.prototype.equalsUsingVarCompleteNames = function (other, useVarCompleteName) {
    return this.$delegate_tjs3rp$_0.equalsUsingVarCompleteNames(other, useVarCompleteName);
  };
  NullRefImpl.prototype.equals = function (other) {
    return this.$delegate_tjs3rp$_0.equals(other);
  };
  NullRefImpl.prototype.get = function (index) {
    return this.$delegate_tjs3rp$_0.get(index);
  };
  NullRefImpl.prototype.getArgAt = function (index) {
    return this.$delegate_tjs3rp$_0.getArgAt(index);
  };
  NullRefImpl.prototype.getTag = function (name) {
    return this.$delegate_tjs3rp$_0.getTag(name);
  };
  NullRefImpl.prototype.hashCode = function () {
    return this.$delegate_tjs3rp$_0.hashCode();
  };
  NullRefImpl.prototype.insertAt = function (index, argument) {
    return this.$delegate_tjs3rp$_0.insertAt(index, argument);
  };
  NullRefImpl.prototype.resetTags = function (tags) {
    return this.$delegate_tjs3rp$_0.resetTags(tags);
  };
  NullRefImpl.prototype.setArgs = function (args) {
    return this.$delegate_tjs3rp$_0.setArgs(args);
  };
  NullRefImpl.prototype.setArgsIterable = function (args) {
    return this.$delegate_tjs3rp$_0.setArgsIterable(args);
  };
  NullRefImpl.prototype.setArgsSequence = function (args) {
    return this.$delegate_tjs3rp$_0.setArgsSequence(args);
  };
  NullRefImpl.prototype.setFunctor = function (functor) {
    return this.$delegate_tjs3rp$_0.setFunctor(functor);
  };
  NullRefImpl.prototype.structurallyEquals = function (other) {
    return this.$delegate_tjs3rp$_0.structurallyEquals(other);
  };
  NullRefImpl.prototype.toString = function () {
    return this.$delegate_tjs3rp$_0.toString();
  };
  NullRefImpl.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'NullRefImpl',
    interfaces: [NullRef, Atom]
  };
  var NullRefImpl_instance = null;
  function NullRefImpl_getInstance() {
    if (NullRefImpl_instance === null) {
      new NullRefImpl();
    }return NullRefImpl_instance;
  }
  function ObjectRefImpl(object) {
    this.object_xccwio$_0 = object;
    this.$delegate_k0njbh$_0 = Atom.Companion.of(ObjectRef$Companion_getInstance().nameOf_s8jyv4$(object));
  }
  Object.defineProperty(ObjectRefImpl.prototype, 'object', {
    get: function () {
      return this.object_xccwio$_0;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isConstant', {
    configurable: true,
    get: function () {
      return true;
    }
  });
  ObjectRefImpl.prototype.asConstant = function () {
    return this;
  };
  ObjectRefImpl.prototype.invoke_rktqbv$ = function (objectConverter, methodName, arguments_0) {
    return invoke(this.object, objectConverter, methodName, arguments_0);
  };
  ObjectRefImpl.prototype.assign_2ptaz8$ = function (objectConverter, propertyName, value) {
    assign(this.object, objectConverter, propertyName, value);
    return true;
  };
  ObjectRefImpl.prototype.freshCopy = function () {
    return this;
  };
  ObjectRefImpl.prototype.freshCopyFromScope = function (scope) {
    return this;
  };
  ObjectRefImpl.prototype.as_wr69nn$ = function () {
    var tmp$;
    return Kotlin.isType(tmp$ = this, Term) ? tmp$ : null;
  };
  ObjectRefImpl.prototype.castTo_wr69nn$ = function () {
    var tmp$;
    return Kotlin.isType(tmp$ = this, Term) ? tmp$ : throwCCE();
  };
  ObjectRefImpl.prototype.applySubstitution = function (substitution) {
    return this;
  };
  ObjectRefImpl.prototype.apply = function (substitution, substitutions) {
    return this;
  };
  ObjectRefImpl.prototype.getSubstituted = function (substitution, substitutions) {
    return this;
  };
  ObjectRefImpl.prototype.accept = function (visitor) {
    return visitor.visitAtom(this);
  };
  Object.defineProperty(ObjectRefImpl.prototype, 'argsList', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.args;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'argsSequence', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.argsSequence;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'arity', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.arity;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'functor', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.functor;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'indicator', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.indicator;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isAtom', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isAtom;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isClause', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isClause;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isCollection', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isCollection;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isCons', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isCons;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isDirective', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isDirective;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isEmptyList', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isEmptyList;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isEmptySet', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isEmptySet;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isFact', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isFact;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isFail', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isFail;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isFunctorWellFormed', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isFunctorWellFormed;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isGround', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isGround;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isIndicator', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isIndicator;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isInt', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isInt;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isList', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isList;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isNumber', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isNumber;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isReal', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isReal;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isRule', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isRule;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isSet', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isSet;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isStruct', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isStruct;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isTrue', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isTrue;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isTruth', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isTruth;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isTuple', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isTuple;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'isVariable', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.isVariable;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'tags', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.tags;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'value', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.value;
    }
  });
  Object.defineProperty(ObjectRefImpl.prototype, 'variables', {
    configurable: true,
    get: function () {
      return this.$delegate_k0njbh$_0.variables;
    }
  });
  ObjectRefImpl.prototype.addFirst = function (argument) {
    return this.$delegate_k0njbh$_0.addFirst(argument);
  };
  ObjectRefImpl.prototype.addLast = function (argument) {
    return this.$delegate_k0njbh$_0.addLast(argument);
  };
  ObjectRefImpl.prototype.append = function (argument) {
    return this.$delegate_k0njbh$_0.append(argument);
  };
  ObjectRefImpl.prototype.asAtom = function () {
    return this.$delegate_k0njbh$_0.asAtom();
  };
  ObjectRefImpl.prototype.asClause = function () {
    return this.$delegate_k0njbh$_0.asClause();
  };
  ObjectRefImpl.prototype.asCollection = function () {
    return this.$delegate_k0njbh$_0.asCollection();
  };
  ObjectRefImpl.prototype.asCons = function () {
    return this.$delegate_k0njbh$_0.asCons();
  };
  ObjectRefImpl.prototype.asDirective = function () {
    return this.$delegate_k0njbh$_0.asDirective();
  };
  ObjectRefImpl.prototype.asEmptyList = function () {
    return this.$delegate_k0njbh$_0.asEmptyList();
  };
  ObjectRefImpl.prototype.asEmptySet = function () {
    return this.$delegate_k0njbh$_0.asEmptySet();
  };
  ObjectRefImpl.prototype.asFact = function () {
    return this.$delegate_k0njbh$_0.asFact();
  };
  ObjectRefImpl.prototype.asIndicator = function () {
    return this.$delegate_k0njbh$_0.asIndicator();
  };
  ObjectRefImpl.prototype.asInteger = function () {
    return this.$delegate_k0njbh$_0.asInteger();
  };
  ObjectRefImpl.prototype.asList = function () {
    return this.$delegate_k0njbh$_0.asList();
  };
  ObjectRefImpl.prototype.asNumeric = function () {
    return this.$delegate_k0njbh$_0.asNumeric();
  };
  ObjectRefImpl.prototype.asReal = function () {
    return this.$delegate_k0njbh$_0.asReal();
  };
  ObjectRefImpl.prototype.asRule = function () {
    return this.$delegate_k0njbh$_0.asRule();
  };
  ObjectRefImpl.prototype.asSet = function () {
    return this.$delegate_k0njbh$_0.asSet();
  };
  ObjectRefImpl.prototype.asStruct = function () {
    return this.$delegate_k0njbh$_0.asStruct();
  };
  ObjectRefImpl.prototype.asTerm = function () {
    return this.$delegate_k0njbh$_0.asTerm();
  };
  ObjectRefImpl.prototype.asTruth = function () {
    return this.$delegate_k0njbh$_0.asTruth();
  };
  ObjectRefImpl.prototype.asTuple = function () {
    return this.$delegate_k0njbh$_0.asTuple();
  };
  ObjectRefImpl.prototype.asVar = function () {
    return this.$delegate_k0njbh$_0.asVar();
  };
  ObjectRefImpl.prototype.castToAtom = function () {
    return this.$delegate_k0njbh$_0.castToAtom();
  };
  ObjectRefImpl.prototype.castToClause = function () {
    return this.$delegate_k0njbh$_0.castToClause();
  };
  ObjectRefImpl.prototype.castToCollection = function () {
    return this.$delegate_k0njbh$_0.castToCollection();
  };
  ObjectRefImpl.prototype.castToCons = function () {
    return this.$delegate_k0njbh$_0.castToCons();
  };
  ObjectRefImpl.prototype.castToConstant = function () {
    return this.$delegate_k0njbh$_0.castToConstant();
  };
  ObjectRefImpl.prototype.castToDirective = function () {
    return this.$delegate_k0njbh$_0.castToDirective();
  };
  ObjectRefImpl.prototype.castToEmptyList = function () {
    return this.$delegate_k0njbh$_0.castToEmptyList();
  };
  ObjectRefImpl.prototype.castToEmptySet = function () {
    return this.$delegate_k0njbh$_0.castToEmptySet();
  };
  ObjectRefImpl.prototype.castToFact = function () {
    return this.$delegate_k0njbh$_0.castToFact();
  };
  ObjectRefImpl.prototype.castToIndicator = function () {
    return this.$delegate_k0njbh$_0.castToIndicator();
  };
  ObjectRefImpl.prototype.castToInteger = function () {
    return this.$delegate_k0njbh$_0.castToInteger();
  };
  ObjectRefImpl.prototype.castToList = function () {
    return this.$delegate_k0njbh$_0.castToList();
  };
  ObjectRefImpl.prototype.castToNumeric = function () {
    return this.$delegate_k0njbh$_0.castToNumeric();
  };
  ObjectRefImpl.prototype.castToReal = function () {
    return this.$delegate_k0njbh$_0.castToReal();
  };
  ObjectRefImpl.prototype.castToRule = function () {
    return this.$delegate_k0njbh$_0.castToRule();
  };
  ObjectRefImpl.prototype.castToSet = function () {
    return this.$delegate_k0njbh$_0.castToSet();
  };
  ObjectRefImpl.prototype.castToStruct = function () {
    return this.$delegate_k0njbh$_0.castToStruct();
  };
  ObjectRefImpl.prototype.castToTerm = function () {
    return this.$delegate_k0njbh$_0.castToTerm();
  };
  ObjectRefImpl.prototype.castToTruth = function () {
    return this.$delegate_k0njbh$_0.castToTruth();
  };
  ObjectRefImpl.prototype.castToTuple = function () {
    return this.$delegate_k0njbh$_0.castToTuple();
  };
  ObjectRefImpl.prototype.castToVar = function () {
    return this.$delegate_k0njbh$_0.castToVar();
  };
  ObjectRefImpl.prototype.compareTo_11rb$ = function (other) {
    return this.$delegate_k0njbh$_0.compareTo_11rb$(other);
  };
  ObjectRefImpl.prototype.containsTag = function (name) {
    return this.$delegate_k0njbh$_0.containsTag(name);
  };
  ObjectRefImpl.prototype.equalsUsingVarCompleteNames = function (other, useVarCompleteName) {
    return this.$delegate_k0njbh$_0.equalsUsingVarCompleteNames(other, useVarCompleteName);
  };
  ObjectRefImpl.prototype.equals = function (other) {
    return this.$delegate_k0njbh$_0.equals(other);
  };
  ObjectRefImpl.prototype.get = function (index) {
    return this.$delegate_k0njbh$_0.get(index);
  };
  ObjectRefImpl.prototype.getArgAt = function (index) {
    return this.$delegate_k0njbh$_0.getArgAt(index);
  };
  ObjectRefImpl.prototype.getTag = function (name) {
    return this.$delegate_k0njbh$_0.getTag(name);
  };
  ObjectRefImpl.prototype.hashCode = function () {
    return this.$delegate_k0njbh$_0.hashCode();
  };
  ObjectRefImpl.prototype.insertAt = function (index, argument) {
    return this.$delegate_k0njbh$_0.insertAt(index, argument);
  };
  ObjectRefImpl.prototype.resetTags = function (tags) {
    return this.$delegate_k0njbh$_0.resetTags(tags);
  };
  ObjectRefImpl.prototype.setArgs = function (args) {
    return this.$delegate_k0njbh$_0.setArgs(args);
  };
  ObjectRefImpl.prototype.setArgsIterable = function (args) {
    return this.$delegate_k0njbh$_0.setArgsIterable(args);
  };
  ObjectRefImpl.prototype.setArgsSequence = function (args) {
    return this.$delegate_k0njbh$_0.setArgsSequence(args);
  };
  ObjectRefImpl.prototype.setFunctor = function (functor) {
    return this.$delegate_k0njbh$_0.setFunctor(functor);
  };
  ObjectRefImpl.prototype.structurallyEquals = function (other) {
    return this.$delegate_k0njbh$_0.structurallyEquals(other);
  };
  ObjectRefImpl.prototype.toString = function () {
    return this.$delegate_k0njbh$_0.toString();
  };
  ObjectRefImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ObjectRefImpl',
    interfaces: [ObjectRef, Atom]
  };
  function ObjectToTermConverterImpl() {
    this.numberTypeTester_0 = new NumberTypeTester();
  }
  ObjectToTermConverterImpl.prototype.convert_s8jyv4$ = function (source) {
    var $receiver = this.numberTypeTester_0;
    var block$result;
    if (source == null) {
      block$result = ObjectRef$Companion_getInstance().NULL;
    } else if (typeof source === 'string') {
      block$result = Atom.Companion.of(source);
    } else if (Kotlin.isNumber(source))
      if ($receiver.get_isInteger_rcaex3$(source)) {
        block$result = Integer.Companion.ofBigInteger($receiver.toInteger_rcaex3$(source));
      } else {
        block$result = Real.Companion.ofBigDecimal($receiver.toDecimal_rcaex3$(source));
      }
     else if (Kotlin.isChar(source)) {
      block$result = Atom.Companion.of(concatToString(Kotlin.charArrayOf(unboxChar(source))));
    } else if (typeof source === 'boolean') {
      block$result = Truth.Companion.of(source);
    } else {
      block$result = ObjectRef$Companion_getInstance().of_s8jyv4$(source);
    }
    return block$result;
  };
  ObjectToTermConverterImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ObjectToTermConverterImpl',
    interfaces: [ObjectToTermConverter]
  };
  function TermToObjectConverterImpl(typeFactory, dealiaser) {
    this.typeFactory_0 = typeFactory;
    this.dealiaser_0 = dealiaser;
  }
  TermToObjectConverterImpl.prototype.convertInto_ulrmtq$ = function (type, term) {
    var tmp$, tmp$_0;
    if (Kotlin.isType(term, NullRef) || Kotlin.isType(term, Var))
      if (get_isPrimitiveType(type)) {
        throw new TermToObjectConversionException(term, type);
      } else {
        tmp$_0 = null;
      }
     else if (Kotlin.isType(term, ObjectRef))
      if (isSubtypeOf(Kotlin.getKClassFromExpression(term.object), type)) {
        tmp$_0 = term.object;
      } else {
        throw new TermToObjectConversionException(term, type);
      }
     else if (Kotlin.isType(term, Truth))
      if (isSubtypeOf(PrimitiveClasses$booleanClass, type))
        tmp$_0 = term.isTrue;
      else if (isSubtypeOf(PrimitiveClasses$stringClass, type))
        tmp$_0 = term.value;
      else
        throw new TermToObjectConversionException(term, type);
    else if (Kotlin.isType(term, Atom))
      if (isSubtypeOf(PrimitiveClasses$stringClass, type))
        tmp$_0 = term.value;
      else if (isSubtypeOf(getKClass(Char), type))
        if (term.value.length === 1) {
          tmp$_0 = toBoxedChar(term.value.charCodeAt(0));
        } else {
          throw new TermToObjectConversionException(term, type);
        }
       else
        throw new TermToObjectConversionException(term, type);
    else if (Kotlin.isType(term, Real))
      if (isSubtypeOf(getKClass(BigDecimal), type))
        tmp$_0 = term.decimalValue;
      else if (isSubtypeOf(PrimitiveClasses$doubleClass, type))
        tmp$_0 = term.decimalValue.toDouble();
      else if (isSubtypeOf(PrimitiveClasses$floatClass, type))
        tmp$_0 = term.decimalValue.toFloat();
      else
        throw new TermToObjectConversionException(term, type);
    else if (Kotlin.isType(term, Integer))
      if (isSubtypeOf(getKClass(BigInteger), type))
        tmp$_0 = term.intValue;
      else if (isSubtypeOf(getKClass(Long), type))
        tmp$_0 = term.intValue.toLongExact();
      else if (isSubtypeOf(PrimitiveClasses$intClass, type))
        tmp$_0 = term.intValue.toIntExact();
      else if (isSubtypeOf(PrimitiveClasses$shortClass, type))
        tmp$_0 = term.intValue.toShortExact();
      else if (isSubtypeOf(PrimitiveClasses$byteClass, type))
        tmp$_0 = term.intValue.toByteExact();
      else if (isSubtypeOf(getKClass(BigDecimal), type))
        tmp$_0 = term.decimalValue;
      else if (isSubtypeOf(PrimitiveClasses$doubleClass, type))
        tmp$_0 = term.decimalValue.toDouble();
      else if (isSubtypeOf(PrimitiveClasses$floatClass, type))
        tmp$_0 = term.decimalValue.toFloat();
      else
        throw new TermToObjectConversionException(term, type);
    else if (Kotlin.isType(term, Struct)) {
      if (Unificator.Companion.matches(term, CAST_TEMPLATE))
        tmp$ = this.explicitConversion_0(term, term.get(0), term.get(1));
      else if (Unificator.Companion.matches(term, DEALIASING_TEMPLATE)) {
        var ref = this.dealiaser_0(term);
        if (Kotlin.isType(ref, ObjectRef))
          tmp$ = this.convertInto_ulrmtq$(type, ref);
        else
          throw TermToObjectConversionException_init(term);
      } else
        throw TermToObjectConversionException_init(term);
      var $receiver = tmp$;
      if ($receiver != null && !isSubtypeOf(Kotlin.getKClassFromExpression($receiver), type)) {
        throw TermToObjectConversionException_init(term);
      }tmp$_0 = $receiver;
    } else
      throw TermToObjectConversionException_init(term);
    return tmp$_0;
  };
  TermToObjectConverterImpl.prototype.explicitConversion_0 = function (castExpression, term, type) {
    var targetType = this.getType_0(castExpression, type);
    try {
      return this.convertInto_ulrmtq$(targetType, term);
    } catch (e) {
      if (Kotlin.isType(e, TermToObjectConversionException)) {
        throw e;
      } else if (Kotlin.isType(e, Exception)) {
        var _ = e;
        throw new TermToObjectConversionException(term, targetType);
      } else
        throw e;
    }
  };
  TermToObjectConverterImpl.prototype.getType_0 = function (castExpression, typeTerm) {
    var tmp$;
    if (Kotlin.isType(typeTerm, TypeRef))
      return typeTerm.type;
    else if (Kotlin.isType(typeTerm, Atom)) {
      tmp$ = this.typeFactory_0.typeFromName_61zpoe$(typeTerm.value);
      if (tmp$ == null) {
        throw TermToObjectConversionException_init(castExpression);
      }return tmp$;
    } else if (Kotlin.isType(typeTerm, Struct))
      if (Unificator.Companion.matches(typeTerm, DEALIASING_TEMPLATE)) {
        var ref = this.dealiaser_0(typeTerm);
        if (Kotlin.isType(ref, TypeRef))
          return ref.type;
        else
          throw TermToObjectConversionException_init(castExpression);
      } else
        throw TermToObjectConversionException_init(castExpression);
    else
      throw TermToObjectConversionException_init(castExpression);
  };
  function TermToObjectConverterImpl$possibleConversions$lambda(closure$term, this$TermToObjectConverterImpl) {
    return function (it) {
      return this$TermToObjectConverterImpl.convertInto_ulrmtq$(it, closure$term);
    };
  }
  TermToObjectConverterImpl.prototype.possibleConversions_z0t4vt$ = function (term) {
    return map(asSequence(this.admissibleTypes_z0t4vt$(term)), TermToObjectConverterImpl$possibleConversions$lambda(term, this));
  };
  TermToObjectConverterImpl.prototype.mostAdequateType_z0t4vt$ = function (term) {
    return first(this.admissibleTypesByPriority_0(term));
  };
  function TermToObjectConverterImpl$priorityOfConversion$lambda(closure$type) {
    return function (it) {
      return subTypeDistance(closure$type, it);
    };
  }
  function TermToObjectConverterImpl$priorityOfConversion$lambda_0(f) {
    var index = f.component1()
    , dist = f.component2();
    return dist != null ? Kotlin.imul(index + 1 | 0, dist + 1 | 0) : null;
  }
  TermToObjectConverterImpl.prototype.priorityOfConversion_ulrmtq$ = function (type, term) {
    var $receiver = filterNotNull(map(indexed(map(asSequence(this.admissibleTypes_z0t4vt$(term)), TermToObjectConverterImpl$priorityOfConversion$lambda(type))), TermToObjectConverterImpl$priorityOfConversion$lambda_0));
    var minByOrNull$result;
    minByOrNull$break: do {
      var iterator = $receiver.iterator();
      if (!iterator.hasNext()) {
        minByOrNull$result = null;
        break minByOrNull$break;
      }var minElem = iterator.next();
      if (!iterator.hasNext()) {
        minByOrNull$result = minElem;
        break minByOrNull$break;
      }var minValue = minElem;
      do {
        var e = iterator.next();
        var v = e;
        if (Kotlin.compareTo(minValue, v) > 0) {
          minElem = e;
          minValue = v;
        }}
       while (iterator.hasNext());
      minByOrNull$result = minElem;
    }
     while (false);
    return minByOrNull$result;
  };
  TermToObjectConverterImpl.prototype.admissibleTypesByPriority_0 = function (term) {
    var tmp$;
    if (Kotlin.isType(term, NullRef) || Kotlin.isType(term, Var))
      tmp$ = sequenceOf([PrimitiveClasses$nothingClass]);
    else if (Kotlin.isType(term, ObjectRef))
      tmp$ = sequenceOf([Kotlin.getKClassFromExpression(term.object)]);
    else if (Kotlin.isType(term, Truth))
      tmp$ = sequenceOf([PrimitiveClasses$booleanClass, PrimitiveClasses$stringClass]);
    else if (Kotlin.isType(term, Atom)) {
      var admissible = sequenceOf([PrimitiveClasses$stringClass]);
      if (term.value.length === 1) {
        admissible = plus(admissible, sequenceOf([getKClass(Char)]));
      }tmp$ = admissible;
    } else if (Kotlin.isType(term, Real))
      tmp$ = sequenceOf([getKClass(BigDecimal), PrimitiveClasses$doubleClass, PrimitiveClasses$floatClass]);
    else if (Kotlin.isType(term, Integer)) {
      var admissible_0 = sequenceOf([getKClass(BigInteger)]);
      if (rangeTo(BigInteger.Companion.ofLong(Long$Companion$MIN_VALUE), BigInteger.Companion.ofLong(Long$Companion$MAX_VALUE)).contains_mef7kx$(term.intValue)) {
        admissible_0 = plus(admissible_0, sequenceOf([getKClass(Long)]));
      }if (rangeTo(BigInteger.Companion.of(-2147483648), BigInteger.Companion.of(2147483647)).contains_mef7kx$(term.intValue)) {
        admissible_0 = plus(admissible_0, sequenceOf([PrimitiveClasses$intClass]));
      }if (rangeTo(BigInteger.Companion.of(-32768), BigInteger.Companion.of(32767)).contains_mef7kx$(term.intValue)) {
        admissible_0 = plus(admissible_0, sequenceOf([PrimitiveClasses$shortClass]));
      }if (rangeTo(BigInteger.Companion.of(-128), BigInteger.Companion.of(127)).contains_mef7kx$(term.intValue)) {
        admissible_0 = plus(admissible_0, sequenceOf([PrimitiveClasses$byteClass]));
      }admissible_0 = plus(admissible_0, sequenceOf([getKClass(BigDecimal)]));
      if (rangeTo(BigDecimal.Companion.of_59slkr$(kotlin_js_internal_DoubleCompanionObject.MIN_VALUE), BigDecimal.Companion.of_59slkr$(kotlin_js_internal_DoubleCompanionObject.MAX_VALUE)).contains_mef7kx$(term.decimalValue)) {
        admissible_0 = plus(admissible_0, sequenceOf([PrimitiveClasses$doubleClass]));
      }if (rangeTo(BigDecimal.Companion.of_jt1o38$(kotlin_js_internal_FloatCompanionObject.MIN_VALUE), BigDecimal.Companion.of_jt1o38$(kotlin_js_internal_FloatCompanionObject.MAX_VALUE)).contains_mef7kx$(term.decimalValue)) {
        admissible_0 = plus(admissible_0, sequenceOf([PrimitiveClasses$floatClass]));
      }tmp$ = admissible_0;
    } else if (Kotlin.isType(term, Struct))
      if (Unificator.Companion.matches(term, CAST_TEMPLATE))
        tmp$ = sequenceOf([this.getType_0(term, term.get(1))]);
      else if (Unificator.Companion.matches(term, DEALIASING_TEMPLATE)) {
        var ref = this.dealiaser_0(term);
        if (Kotlin.isType(ref, ObjectRef))
          tmp$ = this.admissibleTypesByPriority_0(ref);
        else
          throw TermToObjectConversionException_init(term);
      } else
        throw TermToObjectConversionException_init(term);
    else
      throw TermToObjectConversionException_init(term);
    return tmp$;
  };
  TermToObjectConverterImpl.prototype.admissibleTypes_z0t4vt$ = function (term) {
    return toSet(this.admissibleTypesByPriority_0(term));
  };
  TermToObjectConverterImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TermToObjectConverterImpl',
    interfaces: [TermToObjectConverter]
  };
  function TypeFactoryImpl() {
  }
  TypeFactoryImpl.prototype.typeFromName_61zpoe$ = function (typeName) {
    return kClassFromName(typeName).value;
  };
  TypeFactoryImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TypeFactoryImpl',
    interfaces: [TypeFactory]
  };
  function TypeRefImpl(type) {
    TypeRefImpl$Companion_getInstance();
    this.type_8aiap6$_0 = type;
    this.$delegate_q25n14$_0 = Atom.Companion.of(TypeRefImpl$Companion_getInstance().nameOf_0(type));
  }
  Object.defineProperty(TypeRefImpl.prototype, 'type', {
    get: function () {
      return this.type_8aiap6$_0;
    }
  });
  function TypeRefImpl$Companion() {
    TypeRefImpl$Companion_instance = this;
  }
  TypeRefImpl$Companion.prototype.nameOf_0 = function (type) {
    return '<type:' + get_fullName(type) + '>';
  };
  TypeRefImpl$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TypeRefImpl$Companion_instance = null;
  function TypeRefImpl$Companion_getInstance() {
    if (TypeRefImpl$Companion_instance === null) {
      new TypeRefImpl$Companion();
    }return TypeRefImpl$Companion_instance;
  }
  TypeRefImpl.prototype.create_7l9yux$ = function (objectConverter, arguments_0) {
    return create(this.type, objectConverter, arguments_0);
  };
  TypeRefImpl.prototype.invoke_rktqbv$ = function (objectConverter, methodName, arguments_0) {
    var companionObjectRef = get_companionObjectRef(this.type);
    if (Kotlin.isType(companionObjectRef, Optional$Some))
      return invoke(companionObjectRef.value, objectConverter, methodName, arguments_0);
    else
      return invoke_0(this.type, objectConverter, methodName, arguments_0, null);
  };
  Object.defineProperty(TypeRefImpl.prototype, 'isConstant', {
    configurable: true,
    get: function () {
      return true;
    }
  });
  TypeRefImpl.prototype.asConstant = function () {
    return this;
  };
  TypeRefImpl.prototype.freshCopy = function () {
    return this;
  };
  TypeRefImpl.prototype.freshCopyFromScope = function (scope) {
    return this;
  };
  TypeRefImpl.prototype.as_wr69nn$ = function () {
    var tmp$;
    return Kotlin.isType(tmp$ = this, Term) ? tmp$ : null;
  };
  TypeRefImpl.prototype.castTo_wr69nn$ = function () {
    var tmp$;
    return Kotlin.isType(tmp$ = this, Term) ? tmp$ : throwCCE();
  };
  TypeRefImpl.prototype.applySubstitution = function (substitution) {
    return this;
  };
  TypeRefImpl.prototype.apply = function (substitution, substitutions) {
    return this;
  };
  TypeRefImpl.prototype.getSubstituted = function (substitution, substitutions) {
    return this;
  };
  TypeRefImpl.prototype.accept = function (visitor) {
    return visitor.visitAtom(this);
  };
  TypeRefImpl.prototype.assign_2ptaz8$ = function (objectConverter, propertyName, value) {
    var companionObjectRef = get_companionObjectRef(this.type);
    if (Kotlin.isType(companionObjectRef, Optional$Some))
      assign(companionObjectRef.value, objectConverter, propertyName, value);
    else
      assign_0(this.type, objectConverter, propertyName, value, null);
    return true;
  };
  Object.defineProperty(TypeRefImpl.prototype, 'argsList', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.args;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'argsSequence', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.argsSequence;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'arity', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.arity;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'functor', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.functor;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'indicator', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.indicator;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isAtom', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isAtom;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isClause', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isClause;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isCollection', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isCollection;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isCons', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isCons;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isDirective', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isDirective;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isEmptyList', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isEmptyList;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isEmptySet', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isEmptySet;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isFact', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isFact;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isFail', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isFail;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isFunctorWellFormed', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isFunctorWellFormed;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isGround', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isGround;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isIndicator', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isIndicator;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isInt', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isInt;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isList', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isList;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isNumber', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isNumber;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isReal', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isReal;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isRule', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isRule;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isSet', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isSet;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isStruct', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isStruct;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isTrue', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isTrue;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isTruth', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isTruth;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isTuple', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isTuple;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'isVariable', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.isVariable;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'tags', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.tags;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'value', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.value;
    }
  });
  Object.defineProperty(TypeRefImpl.prototype, 'variables', {
    configurable: true,
    get: function () {
      return this.$delegate_q25n14$_0.variables;
    }
  });
  TypeRefImpl.prototype.addFirst = function (argument) {
    return this.$delegate_q25n14$_0.addFirst(argument);
  };
  TypeRefImpl.prototype.addLast = function (argument) {
    return this.$delegate_q25n14$_0.addLast(argument);
  };
  TypeRefImpl.prototype.append = function (argument) {
    return this.$delegate_q25n14$_0.append(argument);
  };
  TypeRefImpl.prototype.asAtom = function () {
    return this.$delegate_q25n14$_0.asAtom();
  };
  TypeRefImpl.prototype.asClause = function () {
    return this.$delegate_q25n14$_0.asClause();
  };
  TypeRefImpl.prototype.asCollection = function () {
    return this.$delegate_q25n14$_0.asCollection();
  };
  TypeRefImpl.prototype.asCons = function () {
    return this.$delegate_q25n14$_0.asCons();
  };
  TypeRefImpl.prototype.asDirective = function () {
    return this.$delegate_q25n14$_0.asDirective();
  };
  TypeRefImpl.prototype.asEmptyList = function () {
    return this.$delegate_q25n14$_0.asEmptyList();
  };
  TypeRefImpl.prototype.asEmptySet = function () {
    return this.$delegate_q25n14$_0.asEmptySet();
  };
  TypeRefImpl.prototype.asFact = function () {
    return this.$delegate_q25n14$_0.asFact();
  };
  TypeRefImpl.prototype.asIndicator = function () {
    return this.$delegate_q25n14$_0.asIndicator();
  };
  TypeRefImpl.prototype.asInteger = function () {
    return this.$delegate_q25n14$_0.asInteger();
  };
  TypeRefImpl.prototype.asList = function () {
    return this.$delegate_q25n14$_0.asList();
  };
  TypeRefImpl.prototype.asNumeric = function () {
    return this.$delegate_q25n14$_0.asNumeric();
  };
  TypeRefImpl.prototype.asReal = function () {
    return this.$delegate_q25n14$_0.asReal();
  };
  TypeRefImpl.prototype.asRule = function () {
    return this.$delegate_q25n14$_0.asRule();
  };
  TypeRefImpl.prototype.asSet = function () {
    return this.$delegate_q25n14$_0.asSet();
  };
  TypeRefImpl.prototype.asStruct = function () {
    return this.$delegate_q25n14$_0.asStruct();
  };
  TypeRefImpl.prototype.asTerm = function () {
    return this.$delegate_q25n14$_0.asTerm();
  };
  TypeRefImpl.prototype.asTruth = function () {
    return this.$delegate_q25n14$_0.asTruth();
  };
  TypeRefImpl.prototype.asTuple = function () {
    return this.$delegate_q25n14$_0.asTuple();
  };
  TypeRefImpl.prototype.asVar = function () {
    return this.$delegate_q25n14$_0.asVar();
  };
  TypeRefImpl.prototype.castToAtom = function () {
    return this.$delegate_q25n14$_0.castToAtom();
  };
  TypeRefImpl.prototype.castToClause = function () {
    return this.$delegate_q25n14$_0.castToClause();
  };
  TypeRefImpl.prototype.castToCollection = function () {
    return this.$delegate_q25n14$_0.castToCollection();
  };
  TypeRefImpl.prototype.castToCons = function () {
    return this.$delegate_q25n14$_0.castToCons();
  };
  TypeRefImpl.prototype.castToConstant = function () {
    return this.$delegate_q25n14$_0.castToConstant();
  };
  TypeRefImpl.prototype.castToDirective = function () {
    return this.$delegate_q25n14$_0.castToDirective();
  };
  TypeRefImpl.prototype.castToEmptyList = function () {
    return this.$delegate_q25n14$_0.castToEmptyList();
  };
  TypeRefImpl.prototype.castToEmptySet = function () {
    return this.$delegate_q25n14$_0.castToEmptySet();
  };
  TypeRefImpl.prototype.castToFact = function () {
    return this.$delegate_q25n14$_0.castToFact();
  };
  TypeRefImpl.prototype.castToIndicator = function () {
    return this.$delegate_q25n14$_0.castToIndicator();
  };
  TypeRefImpl.prototype.castToInteger = function () {
    return this.$delegate_q25n14$_0.castToInteger();
  };
  TypeRefImpl.prototype.castToList = function () {
    return this.$delegate_q25n14$_0.castToList();
  };
  TypeRefImpl.prototype.castToNumeric = function () {
    return this.$delegate_q25n14$_0.castToNumeric();
  };
  TypeRefImpl.prototype.castToReal = function () {
    return this.$delegate_q25n14$_0.castToReal();
  };
  TypeRefImpl.prototype.castToRule = function () {
    return this.$delegate_q25n14$_0.castToRule();
  };
  TypeRefImpl.prototype.castToSet = function () {
    return this.$delegate_q25n14$_0.castToSet();
  };
  TypeRefImpl.prototype.castToStruct = function () {
    return this.$delegate_q25n14$_0.castToStruct();
  };
  TypeRefImpl.prototype.castToTerm = function () {
    return this.$delegate_q25n14$_0.castToTerm();
  };
  TypeRefImpl.prototype.castToTruth = function () {
    return this.$delegate_q25n14$_0.castToTruth();
  };
  TypeRefImpl.prototype.castToTuple = function () {
    return this.$delegate_q25n14$_0.castToTuple();
  };
  TypeRefImpl.prototype.castToVar = function () {
    return this.$delegate_q25n14$_0.castToVar();
  };
  TypeRefImpl.prototype.compareTo_11rb$ = function (other) {
    return this.$delegate_q25n14$_0.compareTo_11rb$(other);
  };
  TypeRefImpl.prototype.containsTag = function (name) {
    return this.$delegate_q25n14$_0.containsTag(name);
  };
  TypeRefImpl.prototype.equalsUsingVarCompleteNames = function (other, useVarCompleteName) {
    return this.$delegate_q25n14$_0.equalsUsingVarCompleteNames(other, useVarCompleteName);
  };
  TypeRefImpl.prototype.equals = function (other) {
    return this.$delegate_q25n14$_0.equals(other);
  };
  TypeRefImpl.prototype.get = function (index) {
    return this.$delegate_q25n14$_0.get(index);
  };
  TypeRefImpl.prototype.getArgAt = function (index) {
    return this.$delegate_q25n14$_0.getArgAt(index);
  };
  TypeRefImpl.prototype.getTag = function (name) {
    return this.$delegate_q25n14$_0.getTag(name);
  };
  TypeRefImpl.prototype.hashCode = function () {
    return this.$delegate_q25n14$_0.hashCode();
  };
  TypeRefImpl.prototype.insertAt = function (index, argument) {
    return this.$delegate_q25n14$_0.insertAt(index, argument);
  };
  TypeRefImpl.prototype.resetTags = function (tags) {
    return this.$delegate_q25n14$_0.resetTags(tags);
  };
  TypeRefImpl.prototype.setArgs = function (args) {
    return this.$delegate_q25n14$_0.setArgs(args);
  };
  TypeRefImpl.prototype.setArgsIterable = function (args) {
    return this.$delegate_q25n14$_0.setArgsIterable(args);
  };
  TypeRefImpl.prototype.setArgsSequence = function (args) {
    return this.$delegate_q25n14$_0.setArgsSequence(args);
  };
  TypeRefImpl.prototype.setFunctor = function (functor) {
    return this.$delegate_q25n14$_0.setFunctor(functor);
  };
  TypeRefImpl.prototype.structurallyEquals = function (other) {
    return this.$delegate_q25n14$_0.structurallyEquals(other);
  };
  TypeRefImpl.prototype.toString = function () {
    return this.$delegate_q25n14$_0.toString();
  };
  TypeRefImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TypeRefImpl',
    interfaces: [TypeRef, Atom]
  };
  function AbstractInvoke(suffix) {
    TernaryRelation$Functional.call(this, 'invoke_' + suffix);
  }
  AbstractInvoke.prototype.computeOneSubstitution_uxflct$ = function ($receiver, first, second, third) {
    var tmp$;
    PrimitiveWrapper.Companion.ensuringArgumentIsStruct_3adri$($receiver, 0);
    PrimitiveWrapper.Companion.ensuringArgumentIsStruct_3adri$($receiver, 1);
    var method = Kotlin.isType(tmp$ = second, Struct) ? tmp$ : throwCCE();
    var catchingOopExceptions$result;
    try {
      var action$result;
      if (Kotlin.isType(first, Ref)) {
        action$result = this.actuallyInvoke_rfxqgf$_0($receiver, first, method, third);
      } else if (Kotlin.isType(first, Struct)) {
        var ref = findRefFromAlias($receiver, first);
        action$result = this.actuallyInvoke_rfxqgf$_0($receiver, ref, method, third);
      } else {
        action$result = Substitution.Companion.failed();
      }
      catchingOopExceptions$result = action$result;
    } catch (e) {
      if (Kotlin.isType(e, OopException)) {
        throw e.toPrologError_yuggv1$($receiver.context, $receiver.signature);
      } else if (Kotlin.isType(e, Throwable)) {
        throw SystemError.Companion.forUncaughtKtException($receiver.context, e);
      } else
        throw e;
    }
    return catchingOopExceptions$result;
  };
  AbstractInvoke.prototype.actuallyInvoke_rfxqgf$_0 = function ($receiver, ref, method, resultTerm) {
    var tmp$;
    var result = ref.invoke_rktqbv$(get_termToObjectConverter($receiver), method.functor, method.argsList);
    if (Kotlin.isType(result, Result$Value))
      tmp$ = Unificator.Companion.mguWith(resultTerm, this.getInvocationResult_1g0hlq$(result));
    else
      tmp$ = Substitution.Companion.failed();
    return tmp$;
  };
  AbstractInvoke.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AbstractInvoke',
    interfaces: [TernaryRelation$Functional]
  };
  function AbstractIterableItems(iterable, target) {
    BinaryRelation$Functional.call(this, iterable + '_items');
    this.target_bzqj7y$_0 = target;
  }
  function AbstractIterableItems$computeOneSubstitution$lambda(closure$converter) {
    return function (it) {
      return closure$converter.convert_z0t4vt$(it);
    };
  }
  function AbstractIterableItems$computeOneSubstitution$lambda_0(it) {
    return ObjectToTermConverter$Companion_getInstance().default.convert_s8jyv4$(it);
  }
  AbstractIterableItems.prototype.computeOneSubstitution_2j1e5m$ = function ($receiver, first, second) {
    var tmp$;
    if (Kotlin.isType(first, Var) && Kotlin.isType(second, Var)) {
      PrimitiveWrapper.Companion.ensuringAllArgumentsAreInstantiated_7mfa40$($receiver);
      return Substitution.Companion.failed();
    } else if (Kotlin.isType(second, List_0)) {
      var converter = get_termToObjectConverter($receiver);
      var items = this.toIterable_i087mg$(map(second.toSequence(), AbstractIterableItems$computeOneSubstitution$lambda(converter)));
      var objectRef = ObjectRef$Companion_getInstance().of_s8jyv4$(items);
      return Unificator.Companion.mguWith(first, objectRef);
    } else if (Kotlin.isType(first, ObjectRef)) {
      var obj = first.object;
      if (this.get_isIterable_mzud1t$(obj)) {
        var items_0 = map(this.get_items_l5gk0$(Kotlin.isType(tmp$ = obj, Any) ? tmp$ : throwCCE()), AbstractIterableItems$computeOneSubstitution$lambda_0);
        return Unificator.Companion.mguWith(second, List_0.Companion.ofSequence(items_0));
      } else {
        return Substitution.Companion.failed();
      }
    } else {
      throw TypeError.Companion.forArgument($receiver.context, $receiver.signature, TypeError$Expected.OBJECT_REFERENCE, first, 0);
    }
  };
  AbstractIterableItems.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AbstractIterableItems',
    interfaces: [BinaryRelation$Functional]
  };
  function ArrayItems() {
    ArrayItems_instance = this;
    AbstractIterableItems.call(this, 'array', PrimitiveClasses$arrayClass);
  }
  ArrayItems.prototype.toIterable_i087mg$ = function ($receiver) {
    return copyToArray(toList_0($receiver));
  };
  ArrayItems.prototype.get_isIterable_mzud1t$ = function ($receiver) {
    return Kotlin.isArray($receiver);
  };
  ArrayItems.prototype.get_items_l5gk0$ = function ($receiver) {
    return asSequence_0($receiver);
  };
  ArrayItems.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ArrayItems',
    interfaces: [AbstractIterableItems]
  };
  var ArrayItems_instance = null;
  function ArrayItems_getInstance() {
    if (ArrayItems_instance === null) {
      new ArrayItems();
    }return ArrayItems_instance;
  }
  function Assign() {
    Assign_instance = this;
    TernaryRelation$Predicative.call(this, 'assign');
  }
  Assign.prototype.compute_uxflct$ = function ($receiver, first, second, third) {
    PrimitiveWrapper.Companion.ensuringArgumentIsAtom_3adri$($receiver, 0);
    PrimitiveWrapper.Companion.ensuringArgumentIsAtom_3adri$($receiver, 1);
    var catchingOopExceptions$result;
    try {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
      if (Kotlin.isType(first, Ref))
        tmp$_0 = first;
      else {
        tmp$_0 = findRefFromAlias($receiver, Kotlin.isType(tmp$ = first, Atom) ? tmp$ : throwCCE());
      }
      var ref = tmp$_0;
      if (Unificator.Companion.matches(third, DEALIASING_TEMPLATE)) {
        tmp$_2 = findRefFromAlias($receiver, Kotlin.isType(tmp$_1 = third, Struct) ? tmp$_1 : throwCCE());
      } else {
        tmp$_2 = third;
      }
      var value = tmp$_2;
      catchingOopExceptions$result = ref.assign_2ptaz8$(get_termToObjectConverter($receiver), (Kotlin.isType(tmp$_3 = second, Atom) ? tmp$_3 : throwCCE()).value, value);
    } catch (e) {
      if (Kotlin.isType(e, OopException)) {
        throw e.toPrologError_yuggv1$($receiver.context, $receiver.signature);
      } else if (Kotlin.isType(e, Throwable)) {
        throw SystemError.Companion.forUncaughtKtException($receiver.context, e);
      } else
        throw e;
    }
    return catchingOopExceptions$result;
  };
  Assign.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Assign',
    interfaces: [TernaryRelation$Predicative]
  };
  var Assign_instance = null;
  function Assign_getInstance() {
    if (Assign_instance === null) {
      new Assign();
    }return Assign_instance;
  }
  function Cast() {
    Cast_instance = this;
    TernaryRelation.call(this, 'cast');
  }
  function Cast$computeAll$lambda$lambda(it) {
    return allSupertypes(it, false);
  }
  function Cast$computeAll$lambda$lambda_0(closure$first, closure$third, this$Cast, this$, closure$second) {
    return function (it) {
      return this$Cast.cast_0(this$, closure$first, it, closure$third).plus(Unificator.Companion.mguWith(closure$second, TypeRef$Companion_getInstance().of_xo1ogr$(it)));
    };
  }
  function Cast$computeAll$lambda$lambda_1(this$) {
    return function (it) {
      return this$.replyWith(it, void 0, []);
    };
  }
  Cast.prototype.computeAll_uxflct$ = function ($receiver, first, second, third) {
    var catchingOopExceptions$result;
    try {
      var action$result;
      action$break: do {
        if (Kotlin.isType(second, Struct)) {
          ensuringArgumentIsTypeRef($receiver, 1);
          var type = getArgumentAsTypeRef($receiver, 1);
          try {
            action$result = sequenceOf([$receiver.replyWith(this.cast_0($receiver, first, type != null ? type.type : null, third), void 0, [])]);
          } catch (_) {
            if (Kotlin.isType(_, TermToObjectConversionException)) {
              action$result = sequenceOf([$receiver.replyFail(void 0, [])]);
              break action$break;
            } else
              throw _;
          }
        } else if (Kotlin.isType(second, Var)) {
          action$result = map(map(distinct(flatMap(asSequence(get_termToObjectConverter($receiver).admissibleTypes_z0t4vt$(first)), Cast$computeAll$lambda$lambda)), Cast$computeAll$lambda$lambda_0(first, third, this, $receiver, second)), Cast$computeAll$lambda$lambda_1($receiver));
        } else {
          ensuringArgumentIsTypeRef($receiver, 1);
          action$result = sequenceOf([$receiver.replyFail(void 0, [])]);
        }
      }
       while (false);
      catchingOopExceptions$result = action$result;
    } catch (e) {
      if (Kotlin.isType(e, OopException)) {
        throw e.toPrologError_yuggv1$($receiver.context, $receiver.signature);
      } else if (Kotlin.isType(e, Throwable)) {
        throw SystemError.Companion.forUncaughtKtException($receiver.context, e);
      } else
        throw e;
    }
    return catchingOopExceptions$result;
  };
  Cast.prototype.cast_0 = function ($receiver, term, type, result) {
    if (type == null) {
      return Substitution.Companion.failed();
    } else {
      var casted = get_termToObjectConverter($receiver).convertInto_ulrmtq$(type, term);
      return Unificator.Companion.mguWith(result, ObjectRef$Companion_getInstance().of_s8jyv4$(casted));
    }
  };
  Cast.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Cast',
    interfaces: [TernaryRelation]
  };
  var Cast_instance = null;
  function Cast_getInstance() {
    if (Cast_instance === null) {
      new Cast();
    }return Cast_instance;
  }
  function InvokeMethod() {
    InvokeMethod_instance = this;
    AbstractInvoke.call(this, 'method');
  }
  InvokeMethod.prototype.getInvocationResult_1g0hlq$ = function ($receiver) {
    return $receiver.toTerm();
  };
  InvokeMethod.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'InvokeMethod',
    interfaces: [AbstractInvoke]
  };
  var InvokeMethod_instance = null;
  function InvokeMethod_getInstance() {
    if (InvokeMethod_instance === null) {
      new InvokeMethod();
    }return InvokeMethod_instance;
  }
  function InvokeStrict() {
    InvokeStrict_instance = this;
    AbstractInvoke.call(this, 'strict');
  }
  InvokeStrict.prototype.getInvocationResult_1g0hlq$ = function ($receiver) {
    return $receiver.asObjectRef();
  };
  InvokeStrict.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'InvokeStrict',
    interfaces: [AbstractInvoke]
  };
  var InvokeStrict_instance = null;
  function InvokeStrict_getInstance() {
    if (InvokeStrict_instance === null) {
      new InvokeStrict();
    }return InvokeStrict_instance;
  }
  function ListItems() {
    ListItems_instance = this;
    AbstractIterableItems.call(this, 'list', getKClass(List));
  }
  ListItems.prototype.toIterable_i087mg$ = function ($receiver) {
    return toList_0($receiver);
  };
  ListItems.prototype.get_isIterable_mzud1t$ = function ($receiver) {
    return Kotlin.isType($receiver, List);
  };
  ListItems.prototype.get_items_l5gk0$ = function ($receiver) {
    return asSequence($receiver);
  };
  ListItems.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ListItems',
    interfaces: [AbstractIterableItems]
  };
  var ListItems_instance = null;
  function ListItems_getInstance() {
    if (ListItems_instance === null) {
      new ListItems();
    }return ListItems_instance;
  }
  function NewObject3() {
    NewObject3_instance = this;
    TernaryRelation$Functional.call(this, 'new_object');
  }
  NewObject3.prototype.computeOneSubstitution_uxflct$ = function ($receiver, first, second, third) {
    PrimitiveWrapper.Companion.ensuringArgumentIsStruct_3adri$($receiver, 0);
    PrimitiveWrapper.Companion.ensuringArgumentIsList_3adri$($receiver, 1);
    var catchingOopExceptions$result;
    try {
      var tmp$, tmp$_0, tmp$_1;
      var type = getArgumentAsTypeRef($receiver, 0);
      var arguments_0 = (Kotlin.isType(tmp$ = second, List_0) ? tmp$ : throwCCE()).toArray();
      var objectReference = (tmp$_0 = type != null ? type.create_r8fmqz$(get_termToObjectConverter($receiver), arguments_0.slice()) : null) != null ? tmp$_0.asObjectRef() : null;
      catchingOopExceptions$result = (tmp$_1 = objectReference != null ? Unificator.Companion.mguWith(objectReference, third) : null) != null ? tmp$_1 : Substitution.Companion.failed();
    } catch (e) {
      if (Kotlin.isType(e, OopException)) {
        throw e.toPrologError_yuggv1$($receiver.context, $receiver.signature);
      } else if (Kotlin.isType(e, Throwable)) {
        throw SystemError.Companion.forUncaughtKtException($receiver.context, e);
      } else
        throw e;
    }
    return catchingOopExceptions$result;
  };
  NewObject3.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'NewObject3',
    interfaces: [TernaryRelation$Functional]
  };
  var NewObject3_instance = null;
  function NewObject3_getInstance() {
    if (NewObject3_instance === null) {
      new NewObject3();
    }return NewObject3_instance;
  }
  function NullRef_0() {
    NullRef_instance = this;
    TypeTester.call(this, 'null_ref');
  }
  NullRef_0.prototype.testType_z0t4vt$ = function (term) {
    return Kotlin.isType(term, NullRef);
  };
  NullRef_0.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'NullRef',
    interfaces: [TypeTester]
  };
  var NullRef_instance = null;
  function NullRef_getInstance() {
    if (NullRef_instance === null) {
      new NullRef_0();
    }return NullRef_instance;
  }
  function ObjectRef_0() {
    ObjectRef_instance = this;
    TypeTester.call(this, 'object_ref');
  }
  ObjectRef_0.prototype.testType_z0t4vt$ = function (term) {
    return Kotlin.isType(term, ObjectRef);
  };
  ObjectRef_0.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ObjectRef',
    interfaces: [TypeTester]
  };
  var ObjectRef_instance = null;
  function ObjectRef_getInstance() {
    if (ObjectRef_instance === null) {
      new ObjectRef_0();
    }return ObjectRef_instance;
  }
  function filterIsInstance$lambda(typeClosure$R, isR) {
    return function (it) {
      return isR(it);
    };
  }
  var DEALIASING_TEMPLATE;
  function get_isDealiasingExpression($receiver) {
    return Kotlin.isType($receiver, Struct) && Unificator.Companion.matches($receiver, DEALIASING_TEMPLATE) && Kotlin.isType($receiver.argsList.get_za3lpa$(0), Atom);
  }
  var CAST_TEMPLATE;
  function ensuringArgumentIsRef($receiver, index) {
    var tmp$;
    var arg = $receiver.arguments.get_za3lpa$(index);
    if (Kotlin.isType(arg, Struct) && Unificator.Companion.matches(arg, DEALIASING_TEMPLATE) && ensureAliasIsRegistered($receiver, arg))
      tmp$ = $receiver;
    else if (!Kotlin.isType(arg, Ref))
      throw TypeError.Companion.forArgument($receiver.context, $receiver.signature, TypeError$Expected.REFERENCE, arg, index);
    else
      tmp$ = $receiver;
    return tmp$;
  }
  function ensuringArgumentIsObjectRef($receiver, index) {
    var tmp$;
    var arg = $receiver.arguments.get_za3lpa$(index);
    if (Kotlin.isType(arg, Struct) && Unificator.Companion.matches(arg, DEALIASING_TEMPLATE) && Kotlin.isType(findRefFromAlias($receiver, arg), ObjectRef))
      tmp$ = $receiver;
    else if (!Kotlin.isType(arg, ObjectRef))
      throw TypeError.Companion.forArgument($receiver.context, $receiver.signature, TypeError$Expected.OBJECT_REFERENCE, arg, index);
    else
      tmp$ = $receiver;
    return tmp$;
  }
  function ensuringArgumentIsTypeRef($receiver, index) {
    var tmp$;
    var arg = $receiver.arguments.get_za3lpa$(index);
    if (Kotlin.isType(arg, Struct) && Unificator.Companion.matches(arg, DEALIASING_TEMPLATE) && Kotlin.isType(findRefFromAlias($receiver, arg), TypeRef))
      tmp$ = $receiver;
    else if (!Kotlin.isType(arg, TypeRef))
      throw TypeError.Companion.forArgument($receiver.context, $receiver.signature, TypeError$Expected.TYPE_REFERENCE, arg, index);
    else
      tmp$ = $receiver;
    return tmp$;
  }
  function getArgumentAsTypeRef($receiver, index) {
    var tmp$, tmp$_0;
    PrimitiveWrapper.Companion.ensuringArgumentIsStruct_3adri$($receiver, index);
    var arg = $receiver.arguments.get_za3lpa$(index);
    if (Kotlin.isType(arg, TypeRef))
      tmp$_0 = arg;
    else if (Kotlin.isType(arg, Atom))
      tmp$_0 = TypeFactory$Companion_getInstance().default.typeRefFromName_61zpoe$(arg.value);
    else if (Kotlin.isType(arg, Struct) && get_isDealiasingExpression(arg))
      tmp$_0 = Kotlin.isType(tmp$ = findRefFromAlias($receiver, arg), TypeRef) ? tmp$ : null;
    else {
      ensuringArgumentIsTypeRef($receiver, 1);
      tmp$_0 = null;
    }
    return tmp$_0;
  }
  function findRefFromAliasOrNull($receiver, alias) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    if (get_isDealiasingExpression(alias)) {
      tmp$_0 = Kotlin.isType(tmp$ = alias.get(0), Struct) ? tmp$ : throwCCE();
    } else {
      throw new MalformedAliasException(alias);
    }
    var actualAlias = tmp$_0;
    var ActualRef = Var.Companion.of('ActualRef');
    var $receiver_0 = $receiver.solve(Struct.Companion.of(Alias$Companion_getInstance().FUNCTOR, [actualAlias, ActualRef]));
    var tmp$_4;
    return (tmp$_3 = (tmp$_2 = (tmp$_1 = firstOrNull(Kotlin.isType(tmp$_4 = filter($receiver_0, filterIsInstance$lambda(Solution$Yes, Kotlin.isInstanceOf(Solution$Yes))), Sequence) ? tmp$_4 : throwCCE())) != null ? tmp$_1.solvedQuery : null) != null ? tmp$_2.get(1) : null) != null ? tmp$_3.castTo_wr69nn$() : null;
  }
  function isAliasRegistered($receiver, alias) {
    return findRefFromAliasOrNull($receiver, alias) != null;
  }
  function ensureAliasIsRegistered($receiver, alias) {
    if (isAliasRegistered($receiver, alias))
      return true;
    else
      throw new NoSuchAnAliasException(alias);
  }
  function findRefFromAlias($receiver, alias) {
    var tmp$;
    tmp$ = findRefFromAliasOrNull($receiver, alias);
    if (tmp$ == null) {
      throw new NoSuchAnAliasException(alias);
    }return tmp$;
  }
  var catchingOopExceptions = defineInlineFunction('2p-oop-lib.it.unibo.tuprolog.solve.libs.oop.primitives.catchingOopExceptions_mhmzyt$', wrapFunction(function () {
    var OopException = _.it.unibo.tuprolog.solve.libs.oop.exceptions.OopException;
    var SystemError = _.$$importsForInline$$['2p-solve'].it.unibo.tuprolog.solve.exception.error.SystemError;
    var Throwable = Error;
    return function ($receiver, action) {
      try {
        return action($receiver);
      } catch (e) {
        if (Kotlin.isType(e, OopException)) {
          throw e.toPrologError_yuggv1$($receiver.context, $receiver.signature);
        } else if (Kotlin.isType(e, Throwable)) {
          throw SystemError.Companion.forUncaughtKtException($receiver.context, e);
        } else
          throw e;
      }
    };
  }));
  function get_termToObjectConverter$lambda(this$termToObjectConverter) {
    return function (it) {
      return findRefFromAliasOrNull(this$termToObjectConverter, it);
    };
  }
  function get_termToObjectConverter($receiver) {
    return TermToObjectConverter$Companion_getInstance().of_u5gbj4$(void 0, get_termToObjectConverter$lambda($receiver));
  }
  function Ref_0() {
    Ref_instance = this;
    TypeTester.call(this, 'ref');
  }
  Ref_0.prototype.testType_z0t4vt$ = function (term) {
    return Kotlin.isType(term, Ref);
  };
  Ref_0.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Ref',
    interfaces: [TypeTester]
  };
  var Ref_instance = null;
  function Ref_getInstance() {
    if (Ref_instance === null) {
      new Ref_0();
    }return Ref_instance;
  }
  function Register() {
    Register_instance = this;
    BinaryRelation$NonBacktrackable.call(this, 'register');
  }
  function Register$computeOne$lambda(closure$second, closure$first) {
    return function ($receiver) {
      var tmp$, tmp$_0;
      $receiver.addStaticClauses([Alias$Companion_getInstance().of_icbcds$(Kotlin.isType(tmp$ = closure$second, Struct) ? tmp$ : throwCCE(), Kotlin.isType(tmp$_0 = closure$first, Ref) ? tmp$_0 : throwCCE()).wrappedImplementation]);
      return Unit;
    };
  }
  Register.prototype.computeOne_2j1e5m$ = function ($receiver, first_0, second) {
    PrimitiveWrapper.Companion.ensuringAllArgumentsAreInstantiated_7mfa40$($receiver);
    ensuringArgumentIsRef($receiver, 0);
    PrimitiveWrapper.Companion.ensuringArgumentIsStruct_3adri$($receiver, 1);
    if (!second.isGround) {
      throw InstantiationError.Companion.forArgument($receiver.context, $receiver.signature, first(second.variables), 0);
    }return $receiver.replySuccessBuildingSideEffects(void 0, void 0, Register$computeOne$lambda(second, first_0));
  };
  Register.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Register',
    interfaces: [BinaryRelation$NonBacktrackable]
  };
  var Register_instance = null;
  function Register_getInstance() {
    if (Register_instance === null) {
      new Register();
    }return Register_instance;
  }
  function SetItems() {
    SetItems_instance = this;
    AbstractIterableItems.call(this, 'set', getKClass(Set));
  }
  SetItems.prototype.toIterable_i087mg$ = function ($receiver) {
    return toSet($receiver);
  };
  SetItems.prototype.get_isIterable_mzud1t$ = function ($receiver) {
    return Kotlin.isType($receiver, Set);
  };
  SetItems.prototype.get_items_l5gk0$ = function ($receiver) {
    return asSequence($receiver);
  };
  SetItems.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'SetItems',
    interfaces: [AbstractIterableItems]
  };
  var SetItems_instance = null;
  function SetItems_getInstance() {
    if (SetItems_instance === null) {
      new SetItems();
    }return SetItems_instance;
  }
  function Type() {
    Type_instance = this;
    BinaryRelation$Functional.call(this, 'type');
    this.typeFactory_0 = TypeFactory$Companion_getInstance().default;
  }
  Type.prototype.computeOneSubstitution_2j1e5m$ = function ($receiver, first, second) {
    var catchingOopExceptions$result;
    try {
      var action$result;
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
      if (Kotlin.isType(first, Var) && Kotlin.isType(second, Var)) {
        PrimitiveWrapper.Companion.ensuringArgumentIsInstantiated_3adri$($receiver, 0);
        action$result = Substitution.Companion.failed();
      } else if (Kotlin.isType(first, Var)) {
        PrimitiveWrapper.Companion.ensuringArgumentIsAtom_3adri$($receiver, 1);
        ensuringArgumentIsTypeRef($receiver, 1);
        tmp$_0 = Atom.Companion.of(get_name((Kotlin.isType(tmp$ = second, TypeRef) ? tmp$ : throwCCE()).type));
        action$result = Unificator.Companion.mguWith(first, tmp$_0);
      } else if (Kotlin.isType(second, Var)) {
        PrimitiveWrapper.Companion.ensuringArgumentIsAtom_3adri$($receiver, 0);
        action$result = (tmp$_3 = (tmp$_2 = this.typeFactory_0.typeRefFromName_61zpoe$((Kotlin.isType(tmp$_1 = first, Atom) ? tmp$_1 : throwCCE()).value)) != null ? Unificator.Companion.mguWith(tmp$_2, second) : null) != null ? tmp$_3 : Substitution.Companion.failed();
      } else {
        PrimitiveWrapper.Companion.ensuringArgumentIsAtom_3adri$($receiver, 0);
        action$result = Substitution.Companion.failed();
      }
      catchingOopExceptions$result = action$result;
    } catch (e) {
      if (Kotlin.isType(e, OopException)) {
        throw e.toPrologError_yuggv1$($receiver.context, $receiver.signature);
      } else if (Kotlin.isType(e, Throwable)) {
        throw SystemError.Companion.forUncaughtKtException($receiver.context, e);
      } else
        throw e;
    }
    return catchingOopExceptions$result;
  };
  Type.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Type',
    interfaces: [BinaryRelation$Functional]
  };
  var Type_instance = null;
  function Type_getInstance() {
    if (Type_instance === null) {
      new Type();
    }return Type_instance;
  }
  function TypeRef_0() {
    TypeRef_instance = this;
    TypeTester.call(this, 'type_ref');
  }
  TypeRef_0.prototype.testType_z0t4vt$ = function (term) {
    return Kotlin.isType(term, TypeRef);
  };
  TypeRef_0.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TypeRef',
    interfaces: [TypeTester]
  };
  var TypeRef_instance = null;
  function TypeRef_getInstance() {
    if (TypeRef_instance === null) {
      new TypeRef_0();
    }return TypeRef_instance;
  }
  function Unregister() {
    Unregister_instance = this;
    UnaryPredicate$NonBacktrackable.call(this, 'unregister');
  }
  function Unregister$computeOne$lambda(closure$first) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.head.get(0)) != null ? tmp$.equals(closure$first) : null;
    };
  }
  function Unregister$computeOne$lambda_0(closure$toBeRemoved) {
    return function ($receiver) {
      $receiver.removeStaticClausesIterable(closure$toBeRemoved);
      return Unit;
    };
  }
  Unregister.prototype.computeOne_jktvg7$ = function ($receiver, first_0) {
    var tmp$;
    PrimitiveWrapper.Companion.ensuringArgumentIsStruct_3adri$($receiver, 0);
    if (!first_0.isGround) {
      throw InstantiationError.Companion.forArgument($receiver.context, $receiver.signature, first(first_0.variables), 0);
    }var pattern = Struct.Companion.of(Alias$Companion_getInstance().FUNCTOR, [first_0, Var.Companion.anonymous()]);
    var toBeRemoved = toList_0(filter($receiver.context.staticKb.getByHead(pattern), Unregister$computeOne$lambda(first_0)));
    if (toBeRemoved.isEmpty()) {
      tmp$ = $receiver.replyFail(void 0, []);
    } else {
      tmp$ = $receiver.replySuccessBuildingSideEffects(void 0, void 0, Unregister$computeOne$lambda_0(toBeRemoved));
    }
    return tmp$;
  };
  Unregister.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Unregister',
    interfaces: [UnaryPredicate$NonBacktrackable]
  };
  var Unregister_instance = null;
  function Unregister_getInstance() {
    if (Unregister_instance === null) {
      new Unregister();
    }return Unregister_instance;
  }
  function Alias(alias, ref) {
    Alias$Companion_getInstance();
    RuleWrapper_init(Alias$Companion_getInstance().FUNCTOR, 2, void 0, this);
    this.alias = alias;
    this.ref = ref;
    if (!this.alias.isGround) {
      var message = 'Alias must be a ground term, got: ' + this.alias;
      throw IllegalArgumentException_init(message.toString());
    }}
  function Alias$Companion() {
    Alias$Companion_instance = this;
    this.FUNCTOR = OOP_getInstance().ALIAS_FUNCTOR;
  }
  Alias$Companion.prototype.forObject_4w9ihe$ = function (alias, object) {
    return new Alias(Atom.Companion.of(alias), ObjectRef$Companion_getInstance().of_s8jyv4$(object));
  };
  Alias$Companion.prototype.forType_hqvncd$ = function (alias, type) {
    return new Alias(Atom.Companion.of(alias), TypeRef$Companion_getInstance().of_xo1ogr$(type));
  };
  Alias$Companion.prototype.of_icbcds$ = function (alias, ref) {
    return new Alias(alias, ref);
  };
  Alias$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Alias$Companion_instance = null;
  function Alias$Companion_getInstance() {
    if (Alias$Companion_instance === null) {
      new Alias$Companion();
    }return Alias$Companion_instance;
  }
  Alias.prototype.get_head_cjtn4o$ = function ($receiver) {
    return toList_0(sequenceOf([this.alias, this.ref]));
  };
  Alias.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Alias',
    interfaces: [RuleWrapper]
  };
  function ColonEquals() {
    RuleWrapper_init(OOP_getInstance().CALL_OPERATOR, 2, void 0, this);
  }
  function ColonEquals$Cast() {
    ColonEquals$Cast_instance = this;
    ColonEquals.call(this);
    this.R_9blan7$_0 = this.variables;
    this.X_9blasd$_0 = this.variables;
    this.Y_9blat8$_0 = this.variables;
    this.T_9blaox$_0 = this.variables;
  }
  var ColonEquals$Cast$R_metadata = new PropertyMetadata('R');
  Object.defineProperty(ColonEquals$Cast.prototype, 'R_0', {
    configurable: true,
    get: function () {
      return this.R_9blan7$_0.getValue_n5byny$(this, ColonEquals$Cast$R_metadata);
    }
  });
  var ColonEquals$Cast$X_metadata = new PropertyMetadata('X');
  Object.defineProperty(ColonEquals$Cast.prototype, 'X_0', {
    configurable: true,
    get: function () {
      return this.X_9blasd$_0.getValue_n5byny$(this, ColonEquals$Cast$X_metadata);
    }
  });
  var ColonEquals$Cast$Y_metadata = new PropertyMetadata('Y');
  Object.defineProperty(ColonEquals$Cast.prototype, 'Y_0', {
    configurable: true,
    get: function () {
      return this.Y_9blat8$_0.getValue_n5byny$(this, ColonEquals$Cast$Y_metadata);
    }
  });
  var ColonEquals$Cast$T_metadata = new PropertyMetadata('T');
  Object.defineProperty(ColonEquals$Cast.prototype, 'T_0', {
    configurable: true,
    get: function () {
      return this.T_9blaox$_0.getValue_n5byny$(this, ColonEquals$Cast$T_metadata);
    }
  });
  ColonEquals$Cast.prototype.get_head_cjtn4o$ = function ($receiver) {
    return $receiver.ktListOf([this.R_0, $receiver.structOf(OOP_getInstance().CAST_OPERATOR, [this.X_0, this.T_0])]);
  };
  ColonEquals$Cast.prototype.get_body_cjtn4o$ = function ($receiver) {
    return $receiver.tupleOf([$receiver.structOf(primitive.Var.signature.name, [this.R_0]), $receiver.atomOf('!'), $receiver.structOf(FluentReduce$Companion_getInstance().FUNCTOR, [this.X_0, this.Y_0]), $receiver.structOf(Cast_getInstance().signature.name, [this.Y_0, this.T_0, this.R_0])]);
  };
  ColonEquals$Cast.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Cast',
    interfaces: [ColonEquals]
  };
  var ColonEquals$Cast_instance = null;
  function ColonEquals$Cast_getInstance() {
    if (ColonEquals$Cast_instance === null) {
      new ColonEquals$Cast();
    }return ColonEquals$Cast_instance;
  }
  function ColonEquals$Invocation() {
    ColonEquals$Invocation_instance = this;
    ColonEquals.call(this);
    this.R_zco5yq$_0 = this.variables;
    this.M_zco5uf$_0 = this.variables;
  }
  var ColonEquals$Invocation$R_metadata = new PropertyMetadata('R');
  Object.defineProperty(ColonEquals$Invocation.prototype, 'R_0', {
    configurable: true,
    get: function () {
      return this.R_zco5yq$_0.getValue_n5byny$(this, ColonEquals$Invocation$R_metadata);
    }
  });
  var ColonEquals$Invocation$M_metadata = new PropertyMetadata('M');
  Object.defineProperty(ColonEquals$Invocation.prototype, 'M_0', {
    configurable: true,
    get: function () {
      return this.M_zco5uf$_0.getValue_n5byny$(this, ColonEquals$Invocation$M_metadata);
    }
  });
  ColonEquals$Invocation.prototype.get_head_cjtn4o$ = function ($receiver) {
    return listOf([this.R_0, this.M_0]);
  };
  ColonEquals$Invocation.prototype.get_body_cjtn4o$ = function ($receiver) {
    return $receiver.tupleOf([$receiver.structOf(primitive.Var.signature.name, [this.R_0]), $receiver.atomOf('!'), $receiver.structOf(FluentReduce$Companion_getInstance().FUNCTOR, [this.M_0, this.R_0])]);
  };
  ColonEquals$Invocation.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Invocation',
    interfaces: [ColonEquals]
  };
  var ColonEquals$Invocation_instance = null;
  function ColonEquals$Invocation_getInstance() {
    if (ColonEquals$Invocation_instance === null) {
      new ColonEquals$Invocation();
    }return ColonEquals$Invocation_instance;
  }
  function ColonEquals$Assignment() {
    ColonEquals$Assignment_instance = this;
    ColonEquals.call(this);
    this.C_b6bd30$_0 = this.variables;
    this.P_b6bcrt$_0 = this.variables;
    this.R_b6bcq3$_0 = this.variables;
    this.V_b6bcmn$_0 = this.variables;
  }
  var ColonEquals$Assignment$C_metadata = new PropertyMetadata('C');
  Object.defineProperty(ColonEquals$Assignment.prototype, 'C_0', {
    configurable: true,
    get: function () {
      return this.C_b6bd30$_0.getValue_n5byny$(this, ColonEquals$Assignment$C_metadata);
    }
  });
  var ColonEquals$Assignment$P_metadata = new PropertyMetadata('P');
  Object.defineProperty(ColonEquals$Assignment.prototype, 'P_0', {
    configurable: true,
    get: function () {
      return this.P_b6bcrt$_0.getValue_n5byny$(this, ColonEquals$Assignment$P_metadata);
    }
  });
  var ColonEquals$Assignment$R_metadata = new PropertyMetadata('R');
  Object.defineProperty(ColonEquals$Assignment.prototype, 'R_0', {
    configurable: true,
    get: function () {
      return this.R_b6bcq3$_0.getValue_n5byny$(this, ColonEquals$Assignment$R_metadata);
    }
  });
  var ColonEquals$Assignment$V_metadata = new PropertyMetadata('V');
  Object.defineProperty(ColonEquals$Assignment.prototype, 'V_0', {
    configurable: true,
    get: function () {
      return this.V_b6bcmn$_0.getValue_n5byny$(this, ColonEquals$Assignment$V_metadata);
    }
  });
  ColonEquals$Assignment.prototype.get_head_cjtn4o$ = function ($receiver) {
    return listOf([this.C_0, this.V_0]);
  };
  ColonEquals$Assignment.prototype.get_body_cjtn4o$ = function ($receiver) {
    return $receiver.tupleOf([$receiver.structOf(PropertyReduce$Companion_getInstance().FUNCTOR, [this.C_0, this.R_0, this.P_0]), $receiver.structOf(Assign_getInstance().signature.name, [this.R_0, this.P_0, this.V_0])]);
  };
  ColonEquals$Assignment.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Assignment',
    interfaces: [ColonEquals]
  };
  var ColonEquals$Assignment_instance = null;
  function ColonEquals$Assignment_getInstance() {
    if (ColonEquals$Assignment_instance === null) {
      new ColonEquals$Assignment();
    }return ColonEquals$Assignment_instance;
  }
  ColonEquals.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ColonEquals',
    interfaces: [RuleWrapper]
  };
  function Dot() {
    Dot_instance = this;
    RuleWrapper_init(OOP_getInstance().ACCESS_OPERATOR, 2, void 0, this);
    this.Method_bqtqr4$_0 = this.variables;
    this.Ref_nz69tc$_0 = this.variables;
  }
  var Dot$Method_metadata = new PropertyMetadata('Method');
  Object.defineProperty(Dot.prototype, 'Method_0', {
    configurable: true,
    get: function () {
      return this.Method_bqtqr4$_0.getValue_n5byny$(this, Dot$Method_metadata);
    }
  });
  var Dot$Ref_metadata = new PropertyMetadata('Ref');
  Object.defineProperty(Dot.prototype, 'Ref_0', {
    configurable: true,
    get: function () {
      return this.Ref_nz69tc$_0.getValue_n5byny$(this, Dot$Ref_metadata);
    }
  });
  Dot.prototype.get_head_cjtn4o$ = function ($receiver) {
    return listOf([this.Ref_0, this.Method_0]);
  };
  Dot.prototype.get_body_cjtn4o$ = function ($receiver) {
    return $receiver.structOf(FluentReduce$Companion_getInstance().FUNCTOR, [$receiver.consOf(this.Ref_0, this.Method_0), $receiver._]);
  };
  Dot.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Dot',
    interfaces: [RuleWrapper]
  };
  var Dot_instance = null;
  function Dot_getInstance() {
    if (Dot_instance === null) {
      new Dot();
    }return Dot_instance;
  }
  function FluentReduce() {
    FluentReduce$Companion_getInstance();
    RuleWrapper_init(FluentReduce$Companion_getInstance().FUNCTOR, 2, void 0, this);
    this.R_2q59m8$_0 = this.variables;
  }
  function FluentReduce$Companion() {
    FluentReduce$Companion_instance = this;
    this.FUNCTOR = 'fluent_reduce';
    this.ARITY = 2;
  }
  FluentReduce$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FluentReduce$Companion_instance = null;
  function FluentReduce$Companion_getInstance() {
    if (FluentReduce$Companion_instance === null) {
      new FluentReduce$Companion();
    }return FluentReduce$Companion_instance;
  }
  var FluentReduce$R_metadata = new PropertyMetadata('R');
  Object.defineProperty(FluentReduce.prototype, 'R', {
    configurable: true,
    get: function () {
      return this.R_2q59m8$_0.getValue_n5byny$(this, FluentReduce$R_metadata);
    }
  });
  FluentReduce.prototype.get_body_cjtn4o$ = function ($receiver) {
    return $receiver.atomOf('!');
  };
  function FluentReduce$Recursive() {
    FluentReduce$Recursive_instance = this;
    FluentReduce.call(this);
    this.P_oxi8zy$_0 = this.variables;
    this.M_oxi8xd$_0 = this.variables;
    this.P1_8hiuy3$_0 = this.variables;
    this.X_oxi96u$_0 = this.variables;
  }
  var FluentReduce$Recursive$P_metadata = new PropertyMetadata('P');
  Object.defineProperty(FluentReduce$Recursive.prototype, 'P_0', {
    configurable: true,
    get: function () {
      return this.P_oxi8zy$_0.getValue_n5byny$(this, FluentReduce$Recursive$P_metadata);
    }
  });
  var FluentReduce$Recursive$M_metadata = new PropertyMetadata('M');
  Object.defineProperty(FluentReduce$Recursive.prototype, 'M_0', {
    configurable: true,
    get: function () {
      return this.M_oxi8xd$_0.getValue_n5byny$(this, FluentReduce$Recursive$M_metadata);
    }
  });
  var FluentReduce$Recursive$P1_metadata = new PropertyMetadata('P1');
  Object.defineProperty(FluentReduce$Recursive.prototype, 'P1_0', {
    configurable: true,
    get: function () {
      return this.P1_8hiuy3$_0.getValue_n5byny$(this, FluentReduce$Recursive$P1_metadata);
    }
  });
  var FluentReduce$Recursive$X_metadata = new PropertyMetadata('X');
  Object.defineProperty(FluentReduce$Recursive.prototype, 'X_0', {
    configurable: true,
    get: function () {
      return this.X_oxi96u$_0.getValue_n5byny$(this, FluentReduce$Recursive$X_metadata);
    }
  });
  FluentReduce$Recursive.prototype.get_head_cjtn4o$ = function ($receiver) {
    return listOf([$receiver.listFrom([this.P_0, this.M_0], this.X_0), this.R]);
  };
  FluentReduce$Recursive.prototype.get_body_cjtn4o$ = function ($receiver) {
    return $receiver.tupleOf([$receiver.atomOf('!'), $receiver.structOf(InvokeMethod_getInstance().signature.name, [this.P_0, this.M_0, this.P1_0]), $receiver.structOf(FluentReduce$Companion_getInstance().FUNCTOR, [$receiver.consOf(this.P1_0, this.X_0), this.R])]);
  };
  FluentReduce$Recursive.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Recursive',
    interfaces: [FluentReduce]
  };
  var FluentReduce$Recursive_instance = null;
  function FluentReduce$Recursive_getInstance() {
    if (FluentReduce$Recursive_instance === null) {
      new FluentReduce$Recursive();
    }return FluentReduce$Recursive_instance;
  }
  function FluentReduce$Couple() {
    FluentReduce$Couple_instance = this;
    FluentReduce.call(this);
    this.P_l2z5rk$_0 = this.variables;
    this.M_l2z5oz$_0 = this.variables;
  }
  var FluentReduce$Couple$P_metadata = new PropertyMetadata('P');
  Object.defineProperty(FluentReduce$Couple.prototype, 'P_0', {
    configurable: true,
    get: function () {
      return this.P_l2z5rk$_0.getValue_n5byny$(this, FluentReduce$Couple$P_metadata);
    }
  });
  var FluentReduce$Couple$M_metadata = new PropertyMetadata('M');
  Object.defineProperty(FluentReduce$Couple.prototype, 'M_0', {
    configurable: true,
    get: function () {
      return this.M_l2z5oz$_0.getValue_n5byny$(this, FluentReduce$Couple$M_metadata);
    }
  });
  FluentReduce$Couple.prototype.get_head_cjtn4o$ = function ($receiver) {
    return listOf([$receiver.consOf(this.P_0, this.M_0), this.R]);
  };
  FluentReduce$Couple.prototype.get_body_cjtn4o$ = function ($receiver) {
    return $receiver.tupleOf([$receiver.atomOf('!'), $receiver.structOf(InvokeMethod_getInstance().signature.name, [this.P_0, this.M_0, this.R])]);
  };
  FluentReduce$Couple.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Couple',
    interfaces: [FluentReduce]
  };
  var FluentReduce$Couple_instance = null;
  function FluentReduce$Couple_getInstance() {
    if (FluentReduce$Couple_instance === null) {
      new FluentReduce$Couple();
    }return FluentReduce$Couple_instance;
  }
  function FluentReduce$Trivial() {
    FluentReduce$Trivial_instance = this;
    FluentReduce.call(this);
  }
  FluentReduce$Trivial.prototype.get_head_cjtn4o$ = function ($receiver) {
    return listOf([this.R, this.R]);
  };
  FluentReduce$Trivial.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Trivial',
    interfaces: [FluentReduce]
  };
  var FluentReduce$Trivial_instance = null;
  function FluentReduce$Trivial_getInstance() {
    if (FluentReduce$Trivial_instance === null) {
      new FluentReduce$Trivial();
    }return FluentReduce$Trivial_instance;
  }
  FluentReduce.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FluentReduce',
    interfaces: [RuleWrapper]
  };
  function NewObject2() {
    NewObject2_instance = this;
    RuleWrapper_init(NewObject3_getInstance().signature.name, 2, void 0, this);
    this.Type_9o7f2h$_0 = this.variables;
    this.Instance_ew9c3y$_0 = this.variables;
  }
  var NewObject2$Type_metadata = new PropertyMetadata('Type');
  Object.defineProperty(NewObject2.prototype, 'Type_0', {
    configurable: true,
    get: function () {
      return this.Type_9o7f2h$_0.getValue_n5byny$(this, NewObject2$Type_metadata);
    }
  });
  var NewObject2$Instance_metadata = new PropertyMetadata('Instance');
  Object.defineProperty(NewObject2.prototype, 'Instance_0', {
    configurable: true,
    get: function () {
      return this.Instance_ew9c3y$_0.getValue_n5byny$(this, NewObject2$Instance_metadata);
    }
  });
  NewObject2.prototype.get_head_cjtn4o$ = function ($receiver) {
    return listOf([this.Type_0, this.Instance_0]);
  };
  NewObject2.prototype.get_body_cjtn4o$ = function ($receiver) {
    return $receiver.structOf(NewObject3_getInstance().signature.name, [this.Type_0, $receiver.emptyList, this.Instance_0]);
  };
  NewObject2.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'NewObject2',
    interfaces: [RuleWrapper]
  };
  var NewObject2_instance = null;
  function NewObject2_getInstance() {
    if (NewObject2_instance === null) {
      new NewObject2();
    }return NewObject2_instance;
  }
  function PropertyReduce() {
    PropertyReduce$Companion_getInstance();
    RuleWrapper_init(PropertyReduce$Companion_getInstance().FUNCTOR, 3, void 0, this);
    this.A_i7w0qg$_0 = this.variables;
    this.B_i7w0pl$_0 = this.variables;
  }
  function PropertyReduce$Companion() {
    PropertyReduce$Companion_instance = this;
    this.FUNCTOR = 'property_reduce';
    this.ARITY = 3;
  }
  PropertyReduce$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PropertyReduce$Companion_instance = null;
  function PropertyReduce$Companion_getInstance() {
    if (PropertyReduce$Companion_instance === null) {
      new PropertyReduce$Companion();
    }return PropertyReduce$Companion_instance;
  }
  var PropertyReduce$A_metadata = new PropertyMetadata('A');
  Object.defineProperty(PropertyReduce.prototype, 'A', {
    configurable: true,
    get: function () {
      return this.A_i7w0qg$_0.getValue_n5byny$(this, PropertyReduce$A_metadata);
    }
  });
  var PropertyReduce$B_metadata = new PropertyMetadata('B');
  Object.defineProperty(PropertyReduce.prototype, 'B', {
    configurable: true,
    get: function () {
      return this.B_i7w0pl$_0.getValue_n5byny$(this, PropertyReduce$B_metadata);
    }
  });
  PropertyReduce.prototype.get_body_cjtn4o$ = function ($receiver) {
    return $receiver.atomOf('!');
  };
  function PropertyReduce$Recursive() {
    PropertyReduce$Recursive_instance = this;
    PropertyReduce.call(this);
    this.B1_o4fibk$_0 = this.variables;
    this.C_m4v02q$_0 = this.variables;
    this.O_m4v0d2$_0 = this.variables;
    this.P_m4v0dx$_0 = this.variables;
  }
  var PropertyReduce$Recursive$B1_metadata = new PropertyMetadata('B1');
  Object.defineProperty(PropertyReduce$Recursive.prototype, 'B1_0', {
    configurable: true,
    get: function () {
      return this.B1_o4fibk$_0.getValue_n5byny$(this, PropertyReduce$Recursive$B1_metadata);
    }
  });
  var PropertyReduce$Recursive$C_metadata = new PropertyMetadata('C');
  Object.defineProperty(PropertyReduce$Recursive.prototype, 'C_0', {
    configurable: true,
    get: function () {
      return this.C_m4v02q$_0.getValue_n5byny$(this, PropertyReduce$Recursive$C_metadata);
    }
  });
  var PropertyReduce$Recursive$O_metadata = new PropertyMetadata('O');
  Object.defineProperty(PropertyReduce$Recursive.prototype, 'O_0', {
    configurable: true,
    get: function () {
      return this.O_m4v0d2$_0.getValue_n5byny$(this, PropertyReduce$Recursive$O_metadata);
    }
  });
  var PropertyReduce$Recursive$P_metadata = new PropertyMetadata('P');
  Object.defineProperty(PropertyReduce$Recursive.prototype, 'P_0', {
    configurable: true,
    get: function () {
      return this.P_m4v0dx$_0.getValue_n5byny$(this, PropertyReduce$Recursive$P_metadata);
    }
  });
  PropertyReduce$Recursive.prototype.get_head_cjtn4o$ = function ($receiver) {
    return listOf([$receiver.listFrom([this.A, this.B], this.C_0), this.O_0, this.P_0]);
  };
  PropertyReduce$Recursive.prototype.get_body_cjtn4o$ = function ($receiver) {
    return $receiver.tupleOf([$receiver.atomOf('!'), $receiver.structOf(InvokeMethod_getInstance().signature.name, [this.A, this.B, this.B1_0]), $receiver.structOf(PropertyReduce$Companion_getInstance().FUNCTOR, [$receiver.consOf(this.B1_0, this.C_0), this.O_0, this.P_0])]);
  };
  PropertyReduce$Recursive.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Recursive',
    interfaces: [PropertyReduce]
  };
  var PropertyReduce$Recursive_instance = null;
  function PropertyReduce$Recursive_getInstance() {
    if (PropertyReduce$Recursive_instance === null) {
      new PropertyReduce$Recursive();
    }return PropertyReduce$Recursive_instance;
  }
  function PropertyReduce$Base() {
    PropertyReduce$Base_instance = this;
    PropertyReduce.call(this);
  }
  PropertyReduce$Base.prototype.get_head_cjtn4o$ = function ($receiver) {
    return listOf([$receiver.consOf(this.A, this.B), this.A, this.B]);
  };
  PropertyReduce$Base.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Base',
    interfaces: [PropertyReduce]
  };
  var PropertyReduce$Base_instance = null;
  function PropertyReduce$Base_getInstance() {
    if (PropertyReduce$Base_instance === null) {
      new PropertyReduce$Base();
    }return PropertyReduce$Base_instance;
  }
  PropertyReduce.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PropertyReduce',
    interfaces: [RuleWrapper]
  };
  function get_platformSpecificAliases() {
    return [];
  }
  var TODO_EXCEPTION;
  function get_companionObjectRef($receiver) {
    return Optional.Companion.none_287e2$();
  }
  function get_companionObjectType($receiver) {
    return Optional.Companion.none_287e2$();
  }
  function kClassFromName(qualifiedName) {
    var tmp$;
    var match = get_CLASS_NAME_PATTERN().matchEntire_6bul2c$(qualifiedName);
    if (!(match != null)) {
      var message = '`' + qualifiedName + '` should match ' + get_CLASS_NAME_PATTERN().pattern + ", while is doesn't";
      throw IllegalArgumentException_init(message.toString());
    }var module_0 = ensureNotNull(match.groups.get_za3lpa$(1)).value;
    var packageSteps = split(ensureNotNull(match.groups.get_za3lpa$(2)).value, Kotlin.charArrayOf(46));
    var kClass = {v: require(module_0)};
    var it = packageSteps.iterator();
    while (it.hasNext() && kClass.v != null && kClass.v != undefined) {
      kClass.v = kClass.v[it.next()];
    }
    if (kClass.v != null && kClass.v != undefined) {
      tmp$ = Optional.Companion.some_mh5how$(get_kotlin(kClass.v));
    } else {
      tmp$ = Optional.Companion.none_287e2$();
    }
    return tmp$;
  }
  var classNamePattern;
  function get_CLASS_NAME_PATTERN() {
    return classNamePattern;
  }
  function get_identifier($receiver) {
    return toString_0(hashCode(get_identifier($receiver)), 16);
  }
  function catchingPlatformSpecificException($receiver, instance, action) {
    return action();
  }
  function allSupertypes($receiver, strict) {
    throw TODO_EXCEPTION;
  }
  function get_formalParameterTypes($receiver) {
    throw TODO_EXCEPTION;
  }
  function get_fullName($receiver) {
    throw TODO_EXCEPTION;
  }
  function get_name($receiver) {
    throw TODO_EXCEPTION;
  }
  function pretty($receiver) {
    throw TODO_EXCEPTION;
  }
  function invoke_1($receiver, instance, args) {
    throw TODO_EXCEPTION;
  }
  function get_setterMethod($receiver) {
    throw TODO_EXCEPTION;
  }
  function overloadSelector(type, termToObjectConverter) {
    throw TODO_EXCEPTION;
  }
  var package$it = _.it || (_.it = {});
  var package$unibo = package$it.unibo || (package$it.unibo = {});
  var package$tuprolog = package$unibo.tuprolog || (package$unibo.tuprolog = {});
  var package$solve = package$tuprolog.solve || (package$tuprolog.solve = {});
  var package$libs = package$solve.libs || (package$solve.libs = {});
  var package$oop = package$libs.oop || (package$libs.oop = {});
  package$oop.NullRef = NullRef;
  Object.defineProperty(package$oop, 'OOP', {
    get: OOP_getInstance
  });
  $$importsForInline$$['2p-solve'] = $module$_2p_solve;
  Object.defineProperty(package$oop, 'OOPLib', {
    get: OOPLib_getInstance
  });
  Object.defineProperty(ObjectRef, 'Companion', {
    get: ObjectRef$Companion_getInstance
  });
  package$oop.ObjectRef = ObjectRef;
  Object.defineProperty(ObjectToTermConverter, 'Companion', {
    get: ObjectToTermConverter$Companion_getInstance
  });
  package$oop.ObjectToTermConverter = ObjectToTermConverter;
  Object.defineProperty(OverloadSelector, 'Companion', {
    get: OverloadSelector$Companion_getInstance
  });
  package$oop.OverloadSelector = OverloadSelector;
  package$oop.Ref = Ref;
  Object.defineProperty(Result, 'None', {
    get: Result$None_getInstance
  });
  Result.Value = Result$Value;
  package$oop.Result = Result;
  Object.defineProperty(TermToObjectConverter, 'Companion', {
    get: TermToObjectConverter$Companion_getInstance
  });
  package$oop.TermToObjectConverter = TermToObjectConverter;
  Object.defineProperty(TypeFactory, 'Companion', {
    get: TypeFactory$Companion_getInstance
  });
  package$oop.TypeFactory = TypeFactory;
  Object.defineProperty(TypeRef, 'Companion', {
    get: TypeRef$Companion_getInstance
  });
  package$oop.TypeRef = TypeRef;
  Object.defineProperty(package$oop, 'id_8be2vx$', {
    get: function () {
      return id;
    }
  });
  package$oop.get_isPrimitiveType_lr8r8q$ = get_isPrimitiveType;
  package$oop.isSupertypeOf_mkmehb$ = isSupertypeOf;
  package$oop.isSupertypeOf_xz44mg$ = isSupertypeOf_0;
  package$oop.superTypeDistance_mkmehb$ = superTypeDistance;
  package$oop.isSubtypeOf_mkmehb$ = isSubtypeOf;
  package$oop.isSubtypeOf_xz44mg$ = isSubtypeOf_0;
  package$oop.subTypeDistance_mkmehb$ = subTypeDistance;
  package$oop.invoke_175igy$ = invoke;
  package$oop.invoke_r9n1sc$ = invoke_0;
  package$oop.assign_diq9pb$ = assign;
  package$oop.assign_rqyuoj$ = assign_0;
  package$oop.create_68p8di$ = create;
  var package$exceptions = package$oop.exceptions || (package$oop.exceptions = {});
  package$exceptions.ConstructorInvocationException = ConstructorInvocationException;
  package$exceptions.MalformedAliasException = MalformedAliasException;
  package$exceptions.MethodInvocationException = MethodInvocationException;
  package$exceptions.NoSuchAnAliasException = NoSuchAnAliasException;
  Object.defineProperty(OopException, 'Companion', {
    get: OopException$Companion_getInstance
  });
  package$exceptions.OopException_init_wspj0f$ = OopException_init;
  package$exceptions.OopException_init_dbl4no$ = OopException_init_0;
  package$exceptions.OopException = OopException;
  package$exceptions.OopRuntimeException = OopRuntimeException;
  package$exceptions.PropertyAssignmentException = PropertyAssignmentException;
  package$exceptions.RuntimePermissionException = RuntimePermissionException;
  package$exceptions.TermToObjectConversionException_init_z0t4vt$ = TermToObjectConversionException_init;
  package$exceptions.TermToObjectConversionException = TermToObjectConversionException;
  var package$impl = package$oop.impl || (package$oop.impl = {});
  Object.defineProperty(package$impl, 'NullRefImpl', {
    get: NullRefImpl_getInstance
  });
  package$impl.ObjectRefImpl = ObjectRefImpl;
  package$impl.ObjectToTermConverterImpl = ObjectToTermConverterImpl;
  package$impl.TermToObjectConverterImpl = TermToObjectConverterImpl;
  package$impl.TypeFactoryImpl = TypeFactoryImpl;
  Object.defineProperty(TypeRefImpl, 'Companion', {
    get: TypeRefImpl$Companion_getInstance
  });
  package$impl.TypeRefImpl = TypeRefImpl;
  $$importsForInline$$['2p-oop-lib'] = _;
  var package$primitives = package$oop.primitives || (package$oop.primitives = {});
  package$primitives.AbstractInvoke = AbstractInvoke;
  package$primitives.AbstractIterableItems = AbstractIterableItems;
  Object.defineProperty(package$primitives, 'ArrayItems', {
    get: ArrayItems_getInstance
  });
  Object.defineProperty(package$primitives, 'Assign', {
    get: Assign_getInstance
  });
  Object.defineProperty(package$primitives, 'Cast', {
    get: Cast_getInstance
  });
  Object.defineProperty(package$primitives, 'InvokeMethod', {
    get: InvokeMethod_getInstance
  });
  Object.defineProperty(package$primitives, 'InvokeStrict', {
    get: InvokeStrict_getInstance
  });
  Object.defineProperty(package$primitives, 'ListItems', {
    get: ListItems_getInstance
  });
  Object.defineProperty(package$primitives, 'NewObject3', {
    get: NewObject3_getInstance
  });
  Object.defineProperty(package$primitives, 'NullRef', {
    get: NullRef_getInstance
  });
  Object.defineProperty(package$primitives, 'ObjectRef', {
    get: ObjectRef_getInstance
  });
  Object.defineProperty(package$primitives, 'DEALIASING_TEMPLATE_8be2vx$', {
    get: function () {
      return DEALIASING_TEMPLATE;
    }
  });
  package$primitives.get_isDealiasingExpression_9vsh6b$ = get_isDealiasingExpression;
  Object.defineProperty(package$primitives, 'CAST_TEMPLATE_8be2vx$', {
    get: function () {
      return CAST_TEMPLATE;
    }
  });
  package$primitives.ensuringArgumentIsRef_3adri$ = ensuringArgumentIsRef;
  package$primitives.ensuringArgumentIsObjectRef_3adri$ = ensuringArgumentIsObjectRef;
  package$primitives.ensuringArgumentIsTypeRef_3adri$ = ensuringArgumentIsTypeRef;
  package$primitives.getArgumentAsTypeRef_3adri$ = getArgumentAsTypeRef;
  package$primitives.isAliasRegistered_9dk89e$ = isAliasRegistered;
  package$primitives.ensureAliasIsRegistered_9dk89e$ = ensureAliasIsRegistered;
  package$primitives.findRefFromAlias_9dk89e$ = findRefFromAlias;
  package$primitives.catchingOopExceptions_mhmzyt$ = catchingOopExceptions;
  package$primitives.get_termToObjectConverter_7mfa40$ = get_termToObjectConverter;
  Object.defineProperty(package$primitives, 'Ref', {
    get: Ref_getInstance
  });
  Object.defineProperty(package$primitives, 'Register', {
    get: Register_getInstance
  });
  Object.defineProperty(package$primitives, 'SetItems', {
    get: SetItems_getInstance
  });
  Object.defineProperty(package$primitives, 'Type', {
    get: Type_getInstance
  });
  Object.defineProperty(package$primitives, 'TypeRef', {
    get: TypeRef_getInstance
  });
  Object.defineProperty(package$primitives, 'Unregister', {
    get: Unregister_getInstance
  });
  Object.defineProperty(Alias, 'Companion', {
    get: Alias$Companion_getInstance
  });
  var package$rules = package$oop.rules || (package$oop.rules = {});
  package$rules.Alias = Alias;
  Object.defineProperty(ColonEquals, 'Cast', {
    get: ColonEquals$Cast_getInstance
  });
  Object.defineProperty(ColonEquals, 'Invocation', {
    get: ColonEquals$Invocation_getInstance
  });
  Object.defineProperty(ColonEquals, 'Assignment', {
    get: ColonEquals$Assignment_getInstance
  });
  package$rules.ColonEquals = ColonEquals;
  Object.defineProperty(package$rules, 'Dot', {
    get: Dot_getInstance
  });
  Object.defineProperty(FluentReduce, 'Companion', {
    get: FluentReduce$Companion_getInstance
  });
  Object.defineProperty(FluentReduce, 'Recursive', {
    get: FluentReduce$Recursive_getInstance
  });
  Object.defineProperty(FluentReduce, 'Couple', {
    get: FluentReduce$Couple_getInstance
  });
  Object.defineProperty(FluentReduce, 'Trivial', {
    get: FluentReduce$Trivial_getInstance
  });
  package$rules.FluentReduce = FluentReduce;
  Object.defineProperty(package$rules, 'NewObject2', {
    get: NewObject2_getInstance
  });
  Object.defineProperty(PropertyReduce, 'Companion', {
    get: PropertyReduce$Companion_getInstance
  });
  Object.defineProperty(PropertyReduce, 'Recursive', {
    get: PropertyReduce$Recursive_getInstance
  });
  Object.defineProperty(PropertyReduce, 'Base', {
    get: PropertyReduce$Base_getInstance
  });
  package$rules.PropertyReduce = PropertyReduce;
  Object.defineProperty(package$oop, 'platformSpecificAliases_8be2vx$', {
    get: get_platformSpecificAliases
  });
  package$oop.get_companionObjectRef_lr8r8q$ = get_companionObjectRef;
  package$oop.get_companionObjectType_lr8r8q$ = get_companionObjectType;
  package$oop.kClassFromName_61zpoe$ = kClassFromName;
  Object.defineProperty(package$oop, 'CLASS_NAME_PATTERN', {
    get: get_CLASS_NAME_PATTERN
  });
  package$oop.get_identifier_s8jyvk$ = get_identifier;
  package$oop.catchingPlatformSpecificException_bna47r$ = catchingPlatformSpecificException;
  package$oop.allSupertypes_mufczp$ = allSupertypes;
  package$oop.get_formalParameterTypes_1ghl7o$ = get_formalParameterTypes;
  package$oop.get_fullName_lr8r8q$ = get_fullName;
  package$oop.get_name_lr8r8q$ = get_name;
  package$oop.pretty_1ghl7o$ = pretty;
  package$oop.invoke_jphuji$ = invoke_1;
  package$oop.get_setterMethod_rrrkeh$ = get_setterMethod;
  package$oop.overloadSelector_hdd6bw$ = overloadSelector;
  Object.defineProperty(Ref.prototype, 'argsList', Object.getOwnPropertyDescriptor(Atom.prototype, 'argsList'));
  Object.defineProperty(Ref.prototype, 'argsSequence', Object.getOwnPropertyDescriptor(Atom.prototype, 'argsSequence'));
  Object.defineProperty(Ref.prototype, 'arity', Object.getOwnPropertyDescriptor(Atom.prototype, 'arity'));
  Object.defineProperty(Ref.prototype, 'indicator', Object.getOwnPropertyDescriptor(Atom.prototype, 'indicator'));
  Object.defineProperty(Ref.prototype, 'isAtom', Object.getOwnPropertyDescriptor(Atom.prototype, 'isAtom'));
  Object.defineProperty(Ref.prototype, 'isClause', Object.getOwnPropertyDescriptor(Atom.prototype, 'isClause'));
  Object.defineProperty(Ref.prototype, 'isCollection', Object.getOwnPropertyDescriptor(Atom.prototype, 'isCollection'));
  Object.defineProperty(Ref.prototype, 'isCons', Object.getOwnPropertyDescriptor(Atom.prototype, 'isCons'));
  Object.defineProperty(Ref.prototype, 'isConstant', Object.getOwnPropertyDescriptor(Atom.prototype, 'isConstant'));
  Object.defineProperty(Ref.prototype, 'isDirective', Object.getOwnPropertyDescriptor(Atom.prototype, 'isDirective'));
  Object.defineProperty(Ref.prototype, 'isEmptyList', Object.getOwnPropertyDescriptor(Atom.prototype, 'isEmptyList'));
  Object.defineProperty(Ref.prototype, 'isEmptySet', Object.getOwnPropertyDescriptor(Atom.prototype, 'isEmptySet'));
  Object.defineProperty(Ref.prototype, 'isFact', Object.getOwnPropertyDescriptor(Atom.prototype, 'isFact'));
  Object.defineProperty(Ref.prototype, 'isFail', Object.getOwnPropertyDescriptor(Atom.prototype, 'isFail'));
  Object.defineProperty(Ref.prototype, 'isGround', Object.getOwnPropertyDescriptor(Atom.prototype, 'isGround'));
  Object.defineProperty(Ref.prototype, 'isIndicator', Object.getOwnPropertyDescriptor(Atom.prototype, 'isIndicator'));
  Object.defineProperty(Ref.prototype, 'isInt', Object.getOwnPropertyDescriptor(Atom.prototype, 'isInt'));
  Object.defineProperty(Ref.prototype, 'isList', Object.getOwnPropertyDescriptor(Atom.prototype, 'isList'));
  Object.defineProperty(Ref.prototype, 'isNumber', Object.getOwnPropertyDescriptor(Atom.prototype, 'isNumber'));
  Object.defineProperty(Ref.prototype, 'isReal', Object.getOwnPropertyDescriptor(Atom.prototype, 'isReal'));
  Object.defineProperty(Ref.prototype, 'isRule', Object.getOwnPropertyDescriptor(Atom.prototype, 'isRule'));
  Object.defineProperty(Ref.prototype, 'isSet', Object.getOwnPropertyDescriptor(Atom.prototype, 'isSet'));
  Object.defineProperty(Ref.prototype, 'isStruct', Object.getOwnPropertyDescriptor(Atom.prototype, 'isStruct'));
  Object.defineProperty(Ref.prototype, 'isTrue', Object.getOwnPropertyDescriptor(Atom.prototype, 'isTrue'));
  Object.defineProperty(Ref.prototype, 'isTruth', Object.getOwnPropertyDescriptor(Atom.prototype, 'isTruth'));
  Object.defineProperty(Ref.prototype, 'isTuple', Object.getOwnPropertyDescriptor(Atom.prototype, 'isTuple'));
  Object.defineProperty(Ref.prototype, 'isVariable', Object.getOwnPropertyDescriptor(Atom.prototype, 'isVariable'));
  Object.defineProperty(Ref.prototype, 'value', Object.getOwnPropertyDescriptor(Atom.prototype, 'value'));
  Object.defineProperty(Ref.prototype, 'variables', Object.getOwnPropertyDescriptor(Atom.prototype, 'variables'));
  Ref.prototype.append = Atom.prototype.append;
  Ref.prototype.apply = Atom.prototype.apply;
  Ref.prototype.as_wr69nn$ = Atom.prototype.as_wr69nn$;
  Ref.prototype.asAtom = Atom.prototype.asAtom;
  Ref.prototype.asClause = Atom.prototype.asClause;
  Ref.prototype.asCollection = Atom.prototype.asCollection;
  Ref.prototype.asCons = Atom.prototype.asCons;
  Ref.prototype.asConstant = Atom.prototype.asConstant;
  Ref.prototype.asDirective = Atom.prototype.asDirective;
  Ref.prototype.asEmptyList = Atom.prototype.asEmptyList;
  Ref.prototype.asEmptySet = Atom.prototype.asEmptySet;
  Ref.prototype.asFact = Atom.prototype.asFact;
  Ref.prototype.asIndicator = Atom.prototype.asIndicator;
  Ref.prototype.asInteger = Atom.prototype.asInteger;
  Ref.prototype.asList = Atom.prototype.asList;
  Ref.prototype.asNumeric = Atom.prototype.asNumeric;
  Ref.prototype.asReal = Atom.prototype.asReal;
  Ref.prototype.asRule = Atom.prototype.asRule;
  Ref.prototype.asSet = Atom.prototype.asSet;
  Ref.prototype.asStruct = Atom.prototype.asStruct;
  Ref.prototype.asTerm = Atom.prototype.asTerm;
  Ref.prototype.asTruth = Atom.prototype.asTruth;
  Ref.prototype.asTuple = Atom.prototype.asTuple;
  Ref.prototype.asVar = Atom.prototype.asVar;
  Ref.prototype.castTo_wr69nn$ = Atom.prototype.castTo_wr69nn$;
  Ref.prototype.castToAtom = Atom.prototype.castToAtom;
  Ref.prototype.castToClause = Atom.prototype.castToClause;
  Ref.prototype.castToCollection = Atom.prototype.castToCollection;
  Ref.prototype.castToCons = Atom.prototype.castToCons;
  Ref.prototype.castToConstant = Atom.prototype.castToConstant;
  Ref.prototype.castToDirective = Atom.prototype.castToDirective;
  Ref.prototype.castToEmptyList = Atom.prototype.castToEmptyList;
  Ref.prototype.castToEmptySet = Atom.prototype.castToEmptySet;
  Ref.prototype.castToFact = Atom.prototype.castToFact;
  Ref.prototype.castToIndicator = Atom.prototype.castToIndicator;
  Ref.prototype.castToInteger = Atom.prototype.castToInteger;
  Ref.prototype.castToList = Atom.prototype.castToList;
  Ref.prototype.castToNumeric = Atom.prototype.castToNumeric;
  Ref.prototype.castToReal = Atom.prototype.castToReal;
  Ref.prototype.castToRule = Atom.prototype.castToRule;
  Ref.prototype.castToSet = Atom.prototype.castToSet;
  Ref.prototype.castToStruct = Atom.prototype.castToStruct;
  Ref.prototype.castToTerm = Atom.prototype.castToTerm;
  Ref.prototype.castToTruth = Atom.prototype.castToTruth;
  Ref.prototype.castToTuple = Atom.prototype.castToTuple;
  Ref.prototype.castToVar = Atom.prototype.castToVar;
  Ref.prototype.compareTo_11rb$ = Atom.prototype.compareTo_11rb$;
  Ref.prototype.containsTag = Atom.prototype.containsTag;
  Ref.prototype.get = Atom.prototype.get;
  Ref.prototype.getSubstituted = Atom.prototype.getSubstituted;
  Ref.prototype.getArgAt = Atom.prototype.getArgAt;
  Ref.prototype.getTag = Atom.prototype.getTag;
  ObjectRef.prototype.invoke_eg4gfx$ = Ref.prototype.invoke_eg4gfx$;
  ObjectRef.prototype.invoke_82lxi7$ = Ref.prototype.invoke_82lxi7$;
  ObjectRef.prototype.invoke_150s8f$ = Ref.prototype.invoke_150s8f$;
  ObjectRef.prototype.invoke_ozkpgk$ = Ref.prototype.invoke_ozkpgk$;
  ObjectRef.prototype.invoke_bkd1uy$ = Ref.prototype.invoke_bkd1uy$;
  ObjectRef.prototype.invoke_589wg2$ = Ref.prototype.invoke_589wg2$;
  ObjectRef.prototype.invoke_o75wts$ = Ref.prototype.invoke_o75wts$;
  ObjectRef.prototype.assign_2ol4p7$ = Ref.prototype.assign_2ol4p7$;
  Object.defineProperty(ObjectRef.prototype, 'argsList', Object.getOwnPropertyDescriptor(Ref.prototype, 'argsList'));
  Object.defineProperty(ObjectRef.prototype, 'argsSequence', Object.getOwnPropertyDescriptor(Ref.prototype, 'argsSequence'));
  Object.defineProperty(ObjectRef.prototype, 'arity', Object.getOwnPropertyDescriptor(Ref.prototype, 'arity'));
  Object.defineProperty(ObjectRef.prototype, 'indicator', Object.getOwnPropertyDescriptor(Ref.prototype, 'indicator'));
  Object.defineProperty(ObjectRef.prototype, 'isAtom', Object.getOwnPropertyDescriptor(Ref.prototype, 'isAtom'));
  Object.defineProperty(ObjectRef.prototype, 'isClause', Object.getOwnPropertyDescriptor(Ref.prototype, 'isClause'));
  Object.defineProperty(ObjectRef.prototype, 'isCollection', Object.getOwnPropertyDescriptor(Ref.prototype, 'isCollection'));
  Object.defineProperty(ObjectRef.prototype, 'isCons', Object.getOwnPropertyDescriptor(Ref.prototype, 'isCons'));
  Object.defineProperty(ObjectRef.prototype, 'isConstant', Object.getOwnPropertyDescriptor(Ref.prototype, 'isConstant'));
  Object.defineProperty(ObjectRef.prototype, 'isDirective', Object.getOwnPropertyDescriptor(Ref.prototype, 'isDirective'));
  Object.defineProperty(ObjectRef.prototype, 'isEmptyList', Object.getOwnPropertyDescriptor(Ref.prototype, 'isEmptyList'));
  Object.defineProperty(ObjectRef.prototype, 'isEmptySet', Object.getOwnPropertyDescriptor(Ref.prototype, 'isEmptySet'));
  Object.defineProperty(ObjectRef.prototype, 'isFact', Object.getOwnPropertyDescriptor(Ref.prototype, 'isFact'));
  Object.defineProperty(ObjectRef.prototype, 'isFail', Object.getOwnPropertyDescriptor(Ref.prototype, 'isFail'));
  Object.defineProperty(ObjectRef.prototype, 'isGround', Object.getOwnPropertyDescriptor(Ref.prototype, 'isGround'));
  Object.defineProperty(ObjectRef.prototype, 'isIndicator', Object.getOwnPropertyDescriptor(Ref.prototype, 'isIndicator'));
  Object.defineProperty(ObjectRef.prototype, 'isInt', Object.getOwnPropertyDescriptor(Ref.prototype, 'isInt'));
  Object.defineProperty(ObjectRef.prototype, 'isList', Object.getOwnPropertyDescriptor(Ref.prototype, 'isList'));
  Object.defineProperty(ObjectRef.prototype, 'isNumber', Object.getOwnPropertyDescriptor(Ref.prototype, 'isNumber'));
  Object.defineProperty(ObjectRef.prototype, 'isReal', Object.getOwnPropertyDescriptor(Ref.prototype, 'isReal'));
  Object.defineProperty(ObjectRef.prototype, 'isRule', Object.getOwnPropertyDescriptor(Ref.prototype, 'isRule'));
  Object.defineProperty(ObjectRef.prototype, 'isSet', Object.getOwnPropertyDescriptor(Ref.prototype, 'isSet'));
  Object.defineProperty(ObjectRef.prototype, 'isStruct', Object.getOwnPropertyDescriptor(Ref.prototype, 'isStruct'));
  Object.defineProperty(ObjectRef.prototype, 'isTrue', Object.getOwnPropertyDescriptor(Ref.prototype, 'isTrue'));
  Object.defineProperty(ObjectRef.prototype, 'isTruth', Object.getOwnPropertyDescriptor(Ref.prototype, 'isTruth'));
  Object.defineProperty(ObjectRef.prototype, 'isTuple', Object.getOwnPropertyDescriptor(Ref.prototype, 'isTuple'));
  Object.defineProperty(ObjectRef.prototype, 'isVariable', Object.getOwnPropertyDescriptor(Ref.prototype, 'isVariable'));
  Object.defineProperty(ObjectRef.prototype, 'value', Object.getOwnPropertyDescriptor(Ref.prototype, 'value'));
  Object.defineProperty(ObjectRef.prototype, 'variables', Object.getOwnPropertyDescriptor(Ref.prototype, 'variables'));
  ObjectRef.prototype.append = Ref.prototype.append;
  ObjectRef.prototype.apply = Ref.prototype.apply;
  ObjectRef.prototype.as_wr69nn$ = Ref.prototype.as_wr69nn$;
  ObjectRef.prototype.asAtom = Ref.prototype.asAtom;
  ObjectRef.prototype.asClause = Ref.prototype.asClause;
  ObjectRef.prototype.asCollection = Ref.prototype.asCollection;
  ObjectRef.prototype.asCons = Ref.prototype.asCons;
  ObjectRef.prototype.asConstant = Ref.prototype.asConstant;
  ObjectRef.prototype.asDirective = Ref.prototype.asDirective;
  ObjectRef.prototype.asEmptyList = Ref.prototype.asEmptyList;
  ObjectRef.prototype.asEmptySet = Ref.prototype.asEmptySet;
  ObjectRef.prototype.asFact = Ref.prototype.asFact;
  ObjectRef.prototype.asIndicator = Ref.prototype.asIndicator;
  ObjectRef.prototype.asInteger = Ref.prototype.asInteger;
  ObjectRef.prototype.asList = Ref.prototype.asList;
  ObjectRef.prototype.asNumeric = Ref.prototype.asNumeric;
  ObjectRef.prototype.asReal = Ref.prototype.asReal;
  ObjectRef.prototype.asRule = Ref.prototype.asRule;
  ObjectRef.prototype.asSet = Ref.prototype.asSet;
  ObjectRef.prototype.asStruct = Ref.prototype.asStruct;
  ObjectRef.prototype.asTerm = Ref.prototype.asTerm;
  ObjectRef.prototype.asTruth = Ref.prototype.asTruth;
  ObjectRef.prototype.asTuple = Ref.prototype.asTuple;
  ObjectRef.prototype.asVar = Ref.prototype.asVar;
  ObjectRef.prototype.castTo_wr69nn$ = Ref.prototype.castTo_wr69nn$;
  ObjectRef.prototype.castToAtom = Ref.prototype.castToAtom;
  ObjectRef.prototype.castToClause = Ref.prototype.castToClause;
  ObjectRef.prototype.castToCollection = Ref.prototype.castToCollection;
  ObjectRef.prototype.castToCons = Ref.prototype.castToCons;
  ObjectRef.prototype.castToConstant = Ref.prototype.castToConstant;
  ObjectRef.prototype.castToDirective = Ref.prototype.castToDirective;
  ObjectRef.prototype.castToEmptyList = Ref.prototype.castToEmptyList;
  ObjectRef.prototype.castToEmptySet = Ref.prototype.castToEmptySet;
  ObjectRef.prototype.castToFact = Ref.prototype.castToFact;
  ObjectRef.prototype.castToIndicator = Ref.prototype.castToIndicator;
  ObjectRef.prototype.castToInteger = Ref.prototype.castToInteger;
  ObjectRef.prototype.castToList = Ref.prototype.castToList;
  ObjectRef.prototype.castToNumeric = Ref.prototype.castToNumeric;
  ObjectRef.prototype.castToReal = Ref.prototype.castToReal;
  ObjectRef.prototype.castToRule = Ref.prototype.castToRule;
  ObjectRef.prototype.castToSet = Ref.prototype.castToSet;
  ObjectRef.prototype.castToStruct = Ref.prototype.castToStruct;
  ObjectRef.prototype.castToTerm = Ref.prototype.castToTerm;
  ObjectRef.prototype.castToTruth = Ref.prototype.castToTruth;
  ObjectRef.prototype.castToTuple = Ref.prototype.castToTuple;
  ObjectRef.prototype.castToVar = Ref.prototype.castToVar;
  ObjectRef.prototype.compareTo_11rb$ = Ref.prototype.compareTo_11rb$;
  ObjectRef.prototype.containsTag = Ref.prototype.containsTag;
  ObjectRef.prototype.get = Ref.prototype.get;
  ObjectRef.prototype.getSubstituted = Ref.prototype.getSubstituted;
  ObjectRef.prototype.getArgAt = Ref.prototype.getArgAt;
  ObjectRef.prototype.getTag = Ref.prototype.getTag;
  NullRef.prototype.invoke_eg4gfx$ = ObjectRef.prototype.invoke_eg4gfx$;
  NullRef.prototype.invoke_82lxi7$ = ObjectRef.prototype.invoke_82lxi7$;
  NullRef.prototype.invoke_150s8f$ = ObjectRef.prototype.invoke_150s8f$;
  NullRef.prototype.invoke_ozkpgk$ = ObjectRef.prototype.invoke_ozkpgk$;
  NullRef.prototype.invoke_bkd1uy$ = ObjectRef.prototype.invoke_bkd1uy$;
  NullRef.prototype.invoke_589wg2$ = ObjectRef.prototype.invoke_589wg2$;
  NullRef.prototype.invoke_o75wts$ = ObjectRef.prototype.invoke_o75wts$;
  NullRef.prototype.assign_2ol4p7$ = ObjectRef.prototype.assign_2ol4p7$;
  Object.defineProperty(NullRef.prototype, 'argsList', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'argsList'));
  Object.defineProperty(NullRef.prototype, 'argsSequence', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'argsSequence'));
  Object.defineProperty(NullRef.prototype, 'arity', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'arity'));
  Object.defineProperty(NullRef.prototype, 'indicator', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'indicator'));
  Object.defineProperty(NullRef.prototype, 'isAtom', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isAtom'));
  Object.defineProperty(NullRef.prototype, 'isClause', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isClause'));
  Object.defineProperty(NullRef.prototype, 'isCollection', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isCollection'));
  Object.defineProperty(NullRef.prototype, 'isCons', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isCons'));
  Object.defineProperty(NullRef.prototype, 'isConstant', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isConstant'));
  Object.defineProperty(NullRef.prototype, 'isDirective', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isDirective'));
  Object.defineProperty(NullRef.prototype, 'isEmptyList', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isEmptyList'));
  Object.defineProperty(NullRef.prototype, 'isEmptySet', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isEmptySet'));
  Object.defineProperty(NullRef.prototype, 'isFact', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isFact'));
  Object.defineProperty(NullRef.prototype, 'isFail', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isFail'));
  Object.defineProperty(NullRef.prototype, 'isGround', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isGround'));
  Object.defineProperty(NullRef.prototype, 'isIndicator', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isIndicator'));
  Object.defineProperty(NullRef.prototype, 'isInt', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isInt'));
  Object.defineProperty(NullRef.prototype, 'isList', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isList'));
  Object.defineProperty(NullRef.prototype, 'isNumber', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isNumber'));
  Object.defineProperty(NullRef.prototype, 'isReal', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isReal'));
  Object.defineProperty(NullRef.prototype, 'isRule', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isRule'));
  Object.defineProperty(NullRef.prototype, 'isSet', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isSet'));
  Object.defineProperty(NullRef.prototype, 'isStruct', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isStruct'));
  Object.defineProperty(NullRef.prototype, 'isTrue', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isTrue'));
  Object.defineProperty(NullRef.prototype, 'isTruth', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isTruth'));
  Object.defineProperty(NullRef.prototype, 'isTuple', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isTuple'));
  Object.defineProperty(NullRef.prototype, 'isVariable', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'isVariable'));
  Object.defineProperty(NullRef.prototype, 'value', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'value'));
  Object.defineProperty(NullRef.prototype, 'variables', Object.getOwnPropertyDescriptor(ObjectRef.prototype, 'variables'));
  NullRef.prototype.append = ObjectRef.prototype.append;
  NullRef.prototype.apply = ObjectRef.prototype.apply;
  NullRef.prototype.as_wr69nn$ = ObjectRef.prototype.as_wr69nn$;
  NullRef.prototype.asAtom = ObjectRef.prototype.asAtom;
  NullRef.prototype.asClause = ObjectRef.prototype.asClause;
  NullRef.prototype.asCollection = ObjectRef.prototype.asCollection;
  NullRef.prototype.asCons = ObjectRef.prototype.asCons;
  NullRef.prototype.asConstant = ObjectRef.prototype.asConstant;
  NullRef.prototype.asDirective = ObjectRef.prototype.asDirective;
  NullRef.prototype.asEmptyList = ObjectRef.prototype.asEmptyList;
  NullRef.prototype.asEmptySet = ObjectRef.prototype.asEmptySet;
  NullRef.prototype.asFact = ObjectRef.prototype.asFact;
  NullRef.prototype.asIndicator = ObjectRef.prototype.asIndicator;
  NullRef.prototype.asInteger = ObjectRef.prototype.asInteger;
  NullRef.prototype.asList = ObjectRef.prototype.asList;
  NullRef.prototype.asNumeric = ObjectRef.prototype.asNumeric;
  NullRef.prototype.asReal = ObjectRef.prototype.asReal;
  NullRef.prototype.asRule = ObjectRef.prototype.asRule;
  NullRef.prototype.asSet = ObjectRef.prototype.asSet;
  NullRef.prototype.asStruct = ObjectRef.prototype.asStruct;
  NullRef.prototype.asTerm = ObjectRef.prototype.asTerm;
  NullRef.prototype.asTruth = ObjectRef.prototype.asTruth;
  NullRef.prototype.asTuple = ObjectRef.prototype.asTuple;
  NullRef.prototype.asVar = ObjectRef.prototype.asVar;
  NullRef.prototype.castTo_wr69nn$ = ObjectRef.prototype.castTo_wr69nn$;
  NullRef.prototype.castToAtom = ObjectRef.prototype.castToAtom;
  NullRef.prototype.castToClause = ObjectRef.prototype.castToClause;
  NullRef.prototype.castToCollection = ObjectRef.prototype.castToCollection;
  NullRef.prototype.castToCons = ObjectRef.prototype.castToCons;
  NullRef.prototype.castToConstant = ObjectRef.prototype.castToConstant;
  NullRef.prototype.castToDirective = ObjectRef.prototype.castToDirective;
  NullRef.prototype.castToEmptyList = ObjectRef.prototype.castToEmptyList;
  NullRef.prototype.castToEmptySet = ObjectRef.prototype.castToEmptySet;
  NullRef.prototype.castToFact = ObjectRef.prototype.castToFact;
  NullRef.prototype.castToIndicator = ObjectRef.prototype.castToIndicator;
  NullRef.prototype.castToInteger = ObjectRef.prototype.castToInteger;
  NullRef.prototype.castToList = ObjectRef.prototype.castToList;
  NullRef.prototype.castToNumeric = ObjectRef.prototype.castToNumeric;
  NullRef.prototype.castToReal = ObjectRef.prototype.castToReal;
  NullRef.prototype.castToRule = ObjectRef.prototype.castToRule;
  NullRef.prototype.castToSet = ObjectRef.prototype.castToSet;
  NullRef.prototype.castToStruct = ObjectRef.prototype.castToStruct;
  NullRef.prototype.castToTerm = ObjectRef.prototype.castToTerm;
  NullRef.prototype.castToTruth = ObjectRef.prototype.castToTruth;
  NullRef.prototype.castToTuple = ObjectRef.prototype.castToTuple;
  NullRef.prototype.castToVar = ObjectRef.prototype.castToVar;
  NullRef.prototype.compareTo_11rb$ = ObjectRef.prototype.compareTo_11rb$;
  NullRef.prototype.containsTag = ObjectRef.prototype.containsTag;
  NullRef.prototype.get = ObjectRef.prototype.get;
  NullRef.prototype.getSubstituted = ObjectRef.prototype.getSubstituted;
  NullRef.prototype.getArgAt = ObjectRef.prototype.getArgAt;
  NullRef.prototype.getTag = ObjectRef.prototype.getTag;
  TypeRef.prototype.invoke_eg4gfx$ = Ref.prototype.invoke_eg4gfx$;
  TypeRef.prototype.invoke_82lxi7$ = Ref.prototype.invoke_82lxi7$;
  TypeRef.prototype.invoke_150s8f$ = Ref.prototype.invoke_150s8f$;
  TypeRef.prototype.invoke_ozkpgk$ = Ref.prototype.invoke_ozkpgk$;
  TypeRef.prototype.invoke_bkd1uy$ = Ref.prototype.invoke_bkd1uy$;
  TypeRef.prototype.invoke_589wg2$ = Ref.prototype.invoke_589wg2$;
  TypeRef.prototype.invoke_o75wts$ = Ref.prototype.invoke_o75wts$;
  TypeRef.prototype.assign_2ol4p7$ = Ref.prototype.assign_2ol4p7$;
  Object.defineProperty(TypeRef.prototype, 'argsList', Object.getOwnPropertyDescriptor(Ref.prototype, 'argsList'));
  Object.defineProperty(TypeRef.prototype, 'argsSequence', Object.getOwnPropertyDescriptor(Ref.prototype, 'argsSequence'));
  Object.defineProperty(TypeRef.prototype, 'arity', Object.getOwnPropertyDescriptor(Ref.prototype, 'arity'));
  Object.defineProperty(TypeRef.prototype, 'indicator', Object.getOwnPropertyDescriptor(Ref.prototype, 'indicator'));
  Object.defineProperty(TypeRef.prototype, 'isAtom', Object.getOwnPropertyDescriptor(Ref.prototype, 'isAtom'));
  Object.defineProperty(TypeRef.prototype, 'isClause', Object.getOwnPropertyDescriptor(Ref.prototype, 'isClause'));
  Object.defineProperty(TypeRef.prototype, 'isCollection', Object.getOwnPropertyDescriptor(Ref.prototype, 'isCollection'));
  Object.defineProperty(TypeRef.prototype, 'isCons', Object.getOwnPropertyDescriptor(Ref.prototype, 'isCons'));
  Object.defineProperty(TypeRef.prototype, 'isConstant', Object.getOwnPropertyDescriptor(Ref.prototype, 'isConstant'));
  Object.defineProperty(TypeRef.prototype, 'isDirective', Object.getOwnPropertyDescriptor(Ref.prototype, 'isDirective'));
  Object.defineProperty(TypeRef.prototype, 'isEmptyList', Object.getOwnPropertyDescriptor(Ref.prototype, 'isEmptyList'));
  Object.defineProperty(TypeRef.prototype, 'isEmptySet', Object.getOwnPropertyDescriptor(Ref.prototype, 'isEmptySet'));
  Object.defineProperty(TypeRef.prototype, 'isFact', Object.getOwnPropertyDescriptor(Ref.prototype, 'isFact'));
  Object.defineProperty(TypeRef.prototype, 'isFail', Object.getOwnPropertyDescriptor(Ref.prototype, 'isFail'));
  Object.defineProperty(TypeRef.prototype, 'isGround', Object.getOwnPropertyDescriptor(Ref.prototype, 'isGround'));
  Object.defineProperty(TypeRef.prototype, 'isIndicator', Object.getOwnPropertyDescriptor(Ref.prototype, 'isIndicator'));
  Object.defineProperty(TypeRef.prototype, 'isInt', Object.getOwnPropertyDescriptor(Ref.prototype, 'isInt'));
  Object.defineProperty(TypeRef.prototype, 'isList', Object.getOwnPropertyDescriptor(Ref.prototype, 'isList'));
  Object.defineProperty(TypeRef.prototype, 'isNumber', Object.getOwnPropertyDescriptor(Ref.prototype, 'isNumber'));
  Object.defineProperty(TypeRef.prototype, 'isReal', Object.getOwnPropertyDescriptor(Ref.prototype, 'isReal'));
  Object.defineProperty(TypeRef.prototype, 'isRule', Object.getOwnPropertyDescriptor(Ref.prototype, 'isRule'));
  Object.defineProperty(TypeRef.prototype, 'isSet', Object.getOwnPropertyDescriptor(Ref.prototype, 'isSet'));
  Object.defineProperty(TypeRef.prototype, 'isStruct', Object.getOwnPropertyDescriptor(Ref.prototype, 'isStruct'));
  Object.defineProperty(TypeRef.prototype, 'isTrue', Object.getOwnPropertyDescriptor(Ref.prototype, 'isTrue'));
  Object.defineProperty(TypeRef.prototype, 'isTruth', Object.getOwnPropertyDescriptor(Ref.prototype, 'isTruth'));
  Object.defineProperty(TypeRef.prototype, 'isTuple', Object.getOwnPropertyDescriptor(Ref.prototype, 'isTuple'));
  Object.defineProperty(TypeRef.prototype, 'isVariable', Object.getOwnPropertyDescriptor(Ref.prototype, 'isVariable'));
  Object.defineProperty(TypeRef.prototype, 'value', Object.getOwnPropertyDescriptor(Ref.prototype, 'value'));
  Object.defineProperty(TypeRef.prototype, 'variables', Object.getOwnPropertyDescriptor(Ref.prototype, 'variables'));
  TypeRef.prototype.append = Ref.prototype.append;
  TypeRef.prototype.apply = Ref.prototype.apply;
  TypeRef.prototype.as_wr69nn$ = Ref.prototype.as_wr69nn$;
  TypeRef.prototype.asAtom = Ref.prototype.asAtom;
  TypeRef.prototype.asClause = Ref.prototype.asClause;
  TypeRef.prototype.asCollection = Ref.prototype.asCollection;
  TypeRef.prototype.asCons = Ref.prototype.asCons;
  TypeRef.prototype.asConstant = Ref.prototype.asConstant;
  TypeRef.prototype.asDirective = Ref.prototype.asDirective;
  TypeRef.prototype.asEmptyList = Ref.prototype.asEmptyList;
  TypeRef.prototype.asEmptySet = Ref.prototype.asEmptySet;
  TypeRef.prototype.asFact = Ref.prototype.asFact;
  TypeRef.prototype.asIndicator = Ref.prototype.asIndicator;
  TypeRef.prototype.asInteger = Ref.prototype.asInteger;
  TypeRef.prototype.asList = Ref.prototype.asList;
  TypeRef.prototype.asNumeric = Ref.prototype.asNumeric;
  TypeRef.prototype.asReal = Ref.prototype.asReal;
  TypeRef.prototype.asRule = Ref.prototype.asRule;
  TypeRef.prototype.asSet = Ref.prototype.asSet;
  TypeRef.prototype.asStruct = Ref.prototype.asStruct;
  TypeRef.prototype.asTerm = Ref.prototype.asTerm;
  TypeRef.prototype.asTruth = Ref.prototype.asTruth;
  TypeRef.prototype.asTuple = Ref.prototype.asTuple;
  TypeRef.prototype.asVar = Ref.prototype.asVar;
  TypeRef.prototype.castTo_wr69nn$ = Ref.prototype.castTo_wr69nn$;
  TypeRef.prototype.castToAtom = Ref.prototype.castToAtom;
  TypeRef.prototype.castToClause = Ref.prototype.castToClause;
  TypeRef.prototype.castToCollection = Ref.prototype.castToCollection;
  TypeRef.prototype.castToCons = Ref.prototype.castToCons;
  TypeRef.prototype.castToConstant = Ref.prototype.castToConstant;
  TypeRef.prototype.castToDirective = Ref.prototype.castToDirective;
  TypeRef.prototype.castToEmptyList = Ref.prototype.castToEmptyList;
  TypeRef.prototype.castToEmptySet = Ref.prototype.castToEmptySet;
  TypeRef.prototype.castToFact = Ref.prototype.castToFact;
  TypeRef.prototype.castToIndicator = Ref.prototype.castToIndicator;
  TypeRef.prototype.castToInteger = Ref.prototype.castToInteger;
  TypeRef.prototype.castToList = Ref.prototype.castToList;
  TypeRef.prototype.castToNumeric = Ref.prototype.castToNumeric;
  TypeRef.prototype.castToReal = Ref.prototype.castToReal;
  TypeRef.prototype.castToRule = Ref.prototype.castToRule;
  TypeRef.prototype.castToSet = Ref.prototype.castToSet;
  TypeRef.prototype.castToStruct = Ref.prototype.castToStruct;
  TypeRef.prototype.castToTerm = Ref.prototype.castToTerm;
  TypeRef.prototype.castToTruth = Ref.prototype.castToTruth;
  TypeRef.prototype.castToTuple = Ref.prototype.castToTuple;
  TypeRef.prototype.castToVar = Ref.prototype.castToVar;
  TypeRef.prototype.compareTo_11rb$ = Ref.prototype.compareTo_11rb$;
  TypeRef.prototype.containsTag = Ref.prototype.containsTag;
  TypeRef.prototype.get = Ref.prototype.get;
  TypeRef.prototype.getSubstituted = Ref.prototype.getSubstituted;
  TypeRef.prototype.getArgAt = Ref.prototype.getArgAt;
  TypeRef.prototype.getTag = Ref.prototype.getTag;
  Object.defineProperty(NullRefImpl.prototype, 'object', Object.getOwnPropertyDescriptor(NullRef.prototype, 'object'));
  NullRefImpl.prototype.invoke_rktqbv$ = NullRef.prototype.invoke_rktqbv$;
  NullRefImpl.prototype.invoke_eg4gfx$ = NullRef.prototype.invoke_eg4gfx$;
  NullRefImpl.prototype.invoke_82lxi7$ = NullRef.prototype.invoke_82lxi7$;
  NullRefImpl.prototype.invoke_150s8f$ = NullRef.prototype.invoke_150s8f$;
  NullRefImpl.prototype.invoke_ozkpgk$ = NullRef.prototype.invoke_ozkpgk$;
  NullRefImpl.prototype.invoke_bkd1uy$ = NullRef.prototype.invoke_bkd1uy$;
  NullRefImpl.prototype.invoke_589wg2$ = NullRef.prototype.invoke_589wg2$;
  NullRefImpl.prototype.invoke_o75wts$ = NullRef.prototype.invoke_o75wts$;
  NullRefImpl.prototype.assign_2ptaz8$ = NullRef.prototype.assign_2ptaz8$;
  NullRefImpl.prototype.assign_2ol4p7$ = NullRef.prototype.assign_2ol4p7$;
  ObjectRefImpl.prototype.invoke_eg4gfx$ = ObjectRef.prototype.invoke_eg4gfx$;
  ObjectRefImpl.prototype.invoke_82lxi7$ = ObjectRef.prototype.invoke_82lxi7$;
  ObjectRefImpl.prototype.invoke_150s8f$ = ObjectRef.prototype.invoke_150s8f$;
  ObjectRefImpl.prototype.invoke_ozkpgk$ = ObjectRef.prototype.invoke_ozkpgk$;
  ObjectRefImpl.prototype.invoke_bkd1uy$ = ObjectRef.prototype.invoke_bkd1uy$;
  ObjectRefImpl.prototype.invoke_589wg2$ = ObjectRef.prototype.invoke_589wg2$;
  ObjectRefImpl.prototype.invoke_o75wts$ = ObjectRef.prototype.invoke_o75wts$;
  ObjectRefImpl.prototype.assign_2ol4p7$ = ObjectRef.prototype.assign_2ol4p7$;
  TermToObjectConverterImpl.prototype.convert_z0t4vt$ = TermToObjectConverter.prototype.convert_z0t4vt$;
  TypeFactoryImpl.prototype.typeRefFromName_61zpoe$ = TypeFactory.prototype.typeRefFromName_61zpoe$;
  TypeRefImpl.prototype.create_r8fmqz$ = TypeRef.prototype.create_r8fmqz$;
  TypeRefImpl.prototype.create_v3ypzh$ = TypeRef.prototype.create_v3ypzh$;
  TypeRefImpl.prototype.create_ur6a81$ = TypeRef.prototype.create_ur6a81$;
  TypeRefImpl.prototype.create_vek5ca$ = TypeRef.prototype.create_vek5ca$;
  TypeRefImpl.prototype.create_l0zifs$ = TypeRef.prototype.create_l0zifs$;
  TypeRefImpl.prototype.create_8bqfx0$ = TypeRef.prototype.create_8bqfx0$;
  TypeRefImpl.prototype.create_p0bg4e$ = TypeRef.prototype.create_p0bg4e$;
  TypeRefImpl.prototype.invoke_eg4gfx$ = TypeRef.prototype.invoke_eg4gfx$;
  TypeRefImpl.prototype.invoke_82lxi7$ = TypeRef.prototype.invoke_82lxi7$;
  TypeRefImpl.prototype.invoke_150s8f$ = TypeRef.prototype.invoke_150s8f$;
  TypeRefImpl.prototype.invoke_ozkpgk$ = TypeRef.prototype.invoke_ozkpgk$;
  TypeRefImpl.prototype.invoke_bkd1uy$ = TypeRef.prototype.invoke_bkd1uy$;
  TypeRefImpl.prototype.invoke_589wg2$ = TypeRef.prototype.invoke_589wg2$;
  TypeRefImpl.prototype.invoke_o75wts$ = TypeRef.prototype.invoke_o75wts$;
  TypeRefImpl.prototype.assign_2ol4p7$ = TypeRef.prototype.assign_2ol4p7$;
  PRIMITIVE_TYPES = setOf([getKClass(Long), PrimitiveClasses$intClass, PrimitiveClasses$shortClass, PrimitiveClasses$byteClass, getKClass(Char), PrimitiveClasses$doubleClass, PrimitiveClasses$floatClass]);
  id = '[a-zA-Z_][a-zA-Z0-9_]*';
  DEALIASING_TEMPLATE = Struct.Companion.of(OOP_getInstance().DEALIASING_OPERATOR, [Var.Companion.of('Alias')]);
  CAST_TEMPLATE = Struct.Companion.template(OOP_getInstance().CAST_OPERATOR, 2);
  TODO_EXCEPTION = new NotImplementedError('OOP-Prolog integration is still not supported on JS');
  classNamePattern = Regex_init('^([a-zA-Z_][a-zA-Z0-9_]*):([a-zA-Z_][a-zA-Z0-9_]*(\\.[a-zA-Z_][a-zA-Z0-9_]*)*)$');
  Kotlin.defineModule('2p-oop-lib', _);
  return _;
}));

//# sourceMappingURL=2p-oop-lib.js.map
