/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.libs.oop.impl;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Truth;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.solve.libs.oop.NullRef;
import it.unibo.tuprolog.solve.libs.oop.ObjectRef;
import it.unibo.tuprolog.solve.libs.oop.Ref;
import it.unibo.tuprolog.solve.libs.oop.TermToObjectConverter;
import it.unibo.tuprolog.solve.libs.oop.TypeFactory;
import it.unibo.tuprolog.solve.libs.oop.TypeRef;
import it.unibo.tuprolog.solve.libs.oop.TypeUtils;
import it.unibo.tuprolog.solve.libs.oop.exceptions.TermToObjectConversionException;
import it.unibo.tuprolog.solve.libs.oop.impl.TermToObjectConverterImpl;
import it.unibo.tuprolog.solve.libs.oop.primitives.PrimitiveExtensions;
import it.unibo.tuprolog.unify.Unificator;
import it.unibo.tuprolog.utils.IterUtils;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gciatto.kt.math.BigDecimal;
import org.gciatto.kt.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u001c\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0014\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J#\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u001bR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lit/unibo/tuprolog/solve/libs/oop/impl/TermToObjectConverterImpl;", "Lit/unibo/tuprolog/solve/libs/oop/TermToObjectConverter;", "typeFactory", "Lit/unibo/tuprolog/solve/libs/oop/TypeFactory;", "dealiaser", "Lkotlin/Function1;", "Lit/unibo/tuprolog/core/Struct;", "Lit/unibo/tuprolog/solve/libs/oop/Ref;", "(Lit/unibo/tuprolog/solve/libs/oop/TypeFactory;Lkotlin/jvm/functions/Function1;)V", "admissibleTypes", "", "Lkotlin/reflect/KClass;", "term", "Lit/unibo/tuprolog/core/Term;", "admissibleTypesByPriority", "Lkotlin/sequences/Sequence;", "convertInto", "", "type", "explicitConversion", "castExpression", "getType", "typeTerm", "mostAdequateType", "possibleConversions", "priorityOfConversion", "", "(Lkotlin/reflect/KClass;Lit/unibo/tuprolog/core/Term;)Ljava/lang/Integer;", "oop-lib"})
public final class TermToObjectConverterImpl
implements TermToObjectConverter {
    @NotNull
    private final TypeFactory typeFactory;
    @NotNull
    private final Function1<Struct, Ref> dealiaser;

    public TermToObjectConverterImpl(@NotNull TypeFactory typeFactory, @NotNull Function1<? super Struct, ? extends Ref> dealiaser) {
        Intrinsics.checkNotNullParameter((Object)typeFactory, (String)"typeFactory");
        Intrinsics.checkNotNullParameter(dealiaser, (String)"dealiaser");
        this.typeFactory = typeFactory;
        this.dealiaser = dealiaser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object convertInto(@NotNull KClass<?> type, @NotNull Term term) {
        Object object;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Term term2 = term;
        if (term2 instanceof NullRef ? true : term2 instanceof Var) {
            if (TypeUtils.isPrimitiveType(type)) {
                throw new TermToObjectConversionException(term, type);
            }
            object = null;
            return object;
        } else if (term2 instanceof ObjectRef) {
            if (!TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(((ObjectRef)term).getObject().getClass()), type)) throw new TermToObjectConversionException(term, type);
            object = ((ObjectRef)term).getObject();
            return object;
        } else if (term2 instanceof Truth) {
            if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(Boolean.TYPE), type)) {
                object = term.isTrue();
                return object;
            } else {
                if (!TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(String.class), type)) throw new TermToObjectConversionException(term, type);
                object = ((Truth)term).getValue();
            }
            return object;
        } else if (term2 instanceof Atom) {
            if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(String.class), type)) {
                object = ((Atom)term).getValue();
                return object;
            } else {
                if (!TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(Character.TYPE), type)) throw new TermToObjectConversionException(term, type);
                if (((Atom)term).getValue().length() != 1) {
                    throw new TermToObjectConversionException(term, type);
                }
                object = Character.valueOf(((Atom)term).getValue().charAt(0));
            }
            return object;
        } else if (term2 instanceof Real) {
            if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(BigDecimal.class), type)) {
                object = (Comparable)((Real)term).getDecimalValue();
                return object;
            } else if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(Double.TYPE), type)) {
                object = ((Real)term).getDecimalValue().toDouble();
                return object;
            } else {
                if (!TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(Float.TYPE), type)) throw new TermToObjectConversionException(term, type);
                object = Float.valueOf(((Real)term).getDecimalValue().toFloat());
            }
            return object;
        } else if (term2 instanceof it.unibo.tuprolog.core.Integer) {
            if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(BigInteger.class), type)) {
                object = (Comparable)((it.unibo.tuprolog.core.Integer)term).getIntValue();
                return object;
            } else if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(Long.TYPE), type)) {
                object = ((it.unibo.tuprolog.core.Integer)term).getIntValue().toLongExact();
                return object;
            } else if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(Integer.TYPE), type)) {
                object = ((it.unibo.tuprolog.core.Integer)term).getIntValue().toIntExact();
                return object;
            } else if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(Short.TYPE), type)) {
                object = ((it.unibo.tuprolog.core.Integer)term).getIntValue().toShortExact();
                return object;
            } else if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(Byte.TYPE), type)) {
                object = ((it.unibo.tuprolog.core.Integer)term).getIntValue().toByteExact();
                return object;
            } else if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(BigDecimal.class), type)) {
                object = (Comparable)((it.unibo.tuprolog.core.Integer)term).getDecimalValue();
                return object;
            } else if (TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(Double.TYPE), type)) {
                object = ((it.unibo.tuprolog.core.Integer)term).getDecimalValue().toDouble();
                return object;
            } else {
                if (!TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(Float.TYPE), type)) throw new TermToObjectConversionException(term, type);
                object = Float.valueOf(((it.unibo.tuprolog.core.Integer)term).getDecimalValue().toFloat());
            }
            return object;
        } else {
            Object object2;
            if (!(term2 instanceof Struct)) throw new TermToObjectConversionException(term);
            if (Unificator.Companion.matches(term, (Term)PrimitiveExtensions.getCAST_TEMPLATE())) {
                object2 = this.explicitConversion((Struct)term, ((Struct)term).get(0), ((Struct)term).get(1));
            } else {
                if (!Unificator.Companion.matches(term, (Term)PrimitiveExtensions.getDEALIASING_TEMPLATE())) throw new TermToObjectConversionException(term);
                Ref ref = (Ref)this.dealiaser.invoke((Object)term);
                if (!(ref instanceof ObjectRef)) throw new TermToObjectConversionException(term);
                object2 = this.convertInto(type, (Term)ref);
            }
            Object object3 = object2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object3;
            boolean bl3 = false;
            if (it != null && !TypeUtils.isSubtypeOf(Reflection.getOrCreateKotlinClass(it.getClass()), type)) {
                throw new TermToObjectConversionException(term);
            }
            object = object3;
        }
        return object;
    }

    private final Object explicitConversion(Struct castExpression, Term term, Term type) {
        KClass<?> targetType = this.getType(castExpression, type);
        try {
            return this.convertInto(targetType, term);
        }
        catch (TermToObjectConversionException e) {
            throw e;
        }
        catch (Exception _) {
            throw new TermToObjectConversionException(term, targetType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KClass<?> getType(Struct castExpression, Term typeTerm) {
        KClass<?> kClass;
        Term term = typeTerm;
        if (term instanceof TypeRef) {
            kClass = ((TypeRef)typeTerm).getType();
            return kClass;
        } else if (term instanceof Atom) {
            KClass<?> kClass2 = this.typeFactory.typeFromName(((Atom)typeTerm).getValue());
            if (kClass2 == null) {
                throw new TermToObjectConversionException((Term)castExpression);
            }
            kClass = kClass2;
            return kClass;
        } else {
            if (!(term instanceof Struct)) throw new TermToObjectConversionException((Term)castExpression);
            if (!Unificator.Companion.matches(typeTerm, (Term)PrimitiveExtensions.getDEALIASING_TEMPLATE())) throw new TermToObjectConversionException((Term)castExpression);
            Ref ref = (Ref)this.dealiaser.invoke((Object)typeTerm);
            if (!(ref instanceof TypeRef)) throw new TermToObjectConversionException((Term)castExpression);
            kClass = ((TypeRef)ref).getType();
        }
        return kClass;
    }

    @Override
    @NotNull
    public Sequence<Object> possibleConversions(@NotNull Term term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.admissibleTypes(term)), (Function1)new Function1<KClass<?>, Object>(this, term){
            final /* synthetic */ TermToObjectConverterImpl this$0;
            final /* synthetic */ Term $term;
            {
                this.this$0 = $receiver;
                this.$term = $term;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull KClass<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.this$0.convertInto(it, this.$term);
            }
        });
    }

    @Override
    @NotNull
    public KClass<?> mostAdequateType(@NotNull Term term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        return (KClass)SequencesKt.first(this.admissibleTypesByPriority(term));
    }

    @Override
    @Nullable
    public Integer priorityOfConversion(@NotNull KClass<?> type, @NotNull Term term) {
        Object v0;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Sequence $this$minByOrNull$iv = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)IterUtils.indexed((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.admissibleTypes(term)), (Function1)new Function1<KClass<?>, Integer>(type){
            final /* synthetic */ KClass<?> $type;
            {
                this.$type = $type;
                super(1);
            }

            @Nullable
            public final Integer invoke(@NotNull KClass<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return TypeUtils.subTypeDistance(this.$type, it);
            }
        })), (Function1)priorityOfConversion.2.INSTANCE));
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                int it = ((Number)minElem$iv).intValue();
                boolean bl = false;
                int minValue$iv = it;
                do {
                    Object e$iv = iterator$iv.next();
                    int it2 = ((Number)e$iv).intValue();
                    $i$a$-minByOrNull-TermToObjectConverterImpl$priorityOfConversion$3 = false;
                    int v$iv = it2;
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Sequence<KClass<?>> admissibleTypesByPriority(Term term) {
        Sequence sequence;
        Term term2 = term;
        if (term2 instanceof NullRef ? true : term2 instanceof Var) {
            Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Void.class)};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
            return sequence;
        } else if (term2 instanceof ObjectRef) {
            Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(((ObjectRef)term).getObject().getClass())};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
            return sequence;
        } else if (term2 instanceof Truth) {
            Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(String.class)};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
            return sequence;
        } else if (term2 instanceof Atom) {
            Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(String.class)};
            Sequence admissible = SequencesKt.sequenceOf((Object[])objectArray);
            if (((Atom)term).getValue().length() == 1) {
                objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Character.TYPE)};
                admissible = SequencesKt.plus((Sequence)admissible, (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
            }
            sequence = admissible;
            return sequence;
        } else if (term2 instanceof Real) {
            Object[] admissible = new KClass[]{Reflection.getOrCreateKotlinClass(BigDecimal.class), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE)};
            sequence = SequencesKt.sequenceOf((Object[])admissible);
            return sequence;
        } else if (term2 instanceof it.unibo.tuprolog.core.Integer) {
            Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(BigInteger.class)};
            Sequence admissible = SequencesKt.sequenceOf((Object[])objectArray);
            objectArray = BigInteger.Companion.of(Long.MIN_VALUE);
            BigInteger bigInteger = BigInteger.Companion.of(Long.MAX_VALUE);
            BigInteger bigInteger2 = ((it.unibo.tuprolog.core.Integer)term).getIntValue();
            boolean bl = 0 <= bigInteger2.compareTo((Object)objectArray) ? bigInteger2.compareTo((Object)bigInteger) <= 0 : false;
            if (bl) {
                objectArray = new Object[]{Reflection.getOrCreateKotlinClass(Long.TYPE)};
                admissible = SequencesKt.plus((Sequence)admissible, (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
            }
            objectArray = BigInteger.Companion.of(Integer.MIN_VALUE);
            bigInteger = BigInteger.Companion.of(Integer.MAX_VALUE);
            bigInteger2 = ((it.unibo.tuprolog.core.Integer)term).getIntValue();
            boolean bl2 = 0 <= bigInteger2.compareTo((Object)objectArray) ? bigInteger2.compareTo((Object)bigInteger) <= 0 : false;
            if (bl2) {
                objectArray = new Object[]{Reflection.getOrCreateKotlinClass(Integer.TYPE)};
                admissible = SequencesKt.plus((Sequence)admissible, (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
            }
            objectArray = BigInteger.Companion.of(Short.MIN_VALUE);
            bigInteger = BigInteger.Companion.of(Short.MAX_VALUE);
            bigInteger2 = ((it.unibo.tuprolog.core.Integer)term).getIntValue();
            boolean bl3 = 0 <= bigInteger2.compareTo((Object)objectArray) ? bigInteger2.compareTo((Object)bigInteger) <= 0 : false;
            if (bl3) {
                objectArray = new Object[]{Reflection.getOrCreateKotlinClass(Short.TYPE)};
                admissible = SequencesKt.plus((Sequence)admissible, (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
            }
            objectArray = BigInteger.Companion.of(-128);
            bigInteger = BigInteger.Companion.of(127);
            bigInteger2 = ((it.unibo.tuprolog.core.Integer)term).getIntValue();
            boolean bl4 = 0 <= bigInteger2.compareTo((Object)objectArray) ? bigInteger2.compareTo((Object)bigInteger) <= 0 : false;
            if (bl4) {
                objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Byte.TYPE)};
                admissible = SequencesKt.plus((Sequence)admissible, (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
            }
            objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(BigDecimal.class)};
            admissible = SequencesKt.plus((Sequence)admissible, (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
            objectArray = BigDecimal.Companion.of$default((BigDecimal.Companion)BigDecimal.Companion, (double)Double.MIN_VALUE, null, (int)2, null);
            bigInteger = BigDecimal.Companion.of$default((BigDecimal.Companion)BigDecimal.Companion, (double)Double.MAX_VALUE, null, (int)2, null);
            bigInteger2 = ((it.unibo.tuprolog.core.Integer)term).getDecimalValue();
            boolean bl5 = 0 <= bigInteger2.compareTo((Object)objectArray) ? bigInteger2.compareTo((Object)bigInteger) <= 0 : false;
            if (bl5) {
                objectArray = new Object[]{Reflection.getOrCreateKotlinClass(Double.TYPE)};
                admissible = SequencesKt.plus((Sequence)admissible, (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
            }
            objectArray = BigDecimal.Companion.of$default((BigDecimal.Companion)BigDecimal.Companion, (float)Float.MIN_VALUE, null, (int)2, null);
            bigInteger = BigDecimal.Companion.of$default((BigDecimal.Companion)BigDecimal.Companion, (float)Float.MAX_VALUE, null, (int)2, null);
            bigInteger2 = ((it.unibo.tuprolog.core.Integer)term).getDecimalValue();
            boolean bl6 = 0 <= bigInteger2.compareTo((Object)objectArray) ? bigInteger2.compareTo((Object)bigInteger) <= 0 : false;
            if (bl6) {
                objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Float.TYPE)};
                admissible = SequencesKt.plus((Sequence)admissible, (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
            }
            sequence = admissible;
            return sequence;
        } else {
            if (!(term2 instanceof Struct)) throw new TermToObjectConversionException(term);
            if (Unificator.Companion.matches(term, (Term)PrimitiveExtensions.getCAST_TEMPLATE())) {
                Object[] admissible = new KClass[]{this.getType((Struct)term, ((Struct)term).get(1))};
                sequence = SequencesKt.sequenceOf((Object[])admissible);
                return sequence;
            } else {
                if (!Unificator.Companion.matches(term, (Term)PrimitiveExtensions.getDEALIASING_TEMPLATE())) throw new TermToObjectConversionException(term);
                Ref ref = (Ref)this.dealiaser.invoke((Object)term);
                if (!(ref instanceof ObjectRef)) throw new TermToObjectConversionException(term);
                sequence = this.admissibleTypesByPriority((Term)ref);
            }
        }
        return sequence;
    }

    @Override
    @NotNull
    public Set<KClass<?>> admissibleTypes(@NotNull Term term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        return SequencesKt.toSet(this.admissibleTypesByPriority(term));
    }

    @Override
    @Nullable
    public Object convert(@NotNull Term term) {
        return TermToObjectConverter.DefaultImpls.convert(this, term);
    }
}

