/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.parser.dynamic;

import it.unibo.tuprolog.parser.dynamic.Associativity;
import it.unibo.tuprolog.parser.dynamic.DynamicLexer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.IntBinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;

public abstract class DynamicParser
extends Parser {
    private static final boolean DEBUG = false;
    private final Map<String, Map<Associativity, Integer>> operators = new HashMap<String, Map<Associativity, Integer>>();
    private DynamicLexer lexer;

    public DynamicParser(TokenStream input) {
        super(input);
        if (!(input.getTokenSource() instanceof DynamicLexer)) {
            throw new IllegalStateException("No lexer was provided");
        }
        this.lexer = (DynamicLexer)input.getTokenSource();
    }

    public DynamicParser(TokenStream input, DynamicLexer lexer) {
        super(input);
        this.lexer = lexer;
    }

    public void setLexer(DynamicLexer lexer) {
        this.lexer = lexer;
    }

    public DynamicLexer getLexer() {
        return this.lexer;
    }

    public int getOperatorPriority(String operator, Associativity associativity) {
        return Optional.ofNullable(this.operators.get(operator)).map(m -> (Integer)m.get((Object)associativity)).orElse(Integer.MAX_VALUE);
    }

    public int getOperatorPriority(Token operator, Associativity associativity) {
        return this.getOperatorPriority(operator.getText(), associativity);
    }

    public boolean isOperator(Token token) {
        return this.lexer.isOperator(token);
    }

    public boolean isOperator(String functor) {
        return this.lexer.isOperator(functor);
    }

    public void addOperator(String functor, Associativity associativity, int priority) {
        this.lexer.addOperators(functor, new String[0]);
        Map<Associativity, Integer> item = Collections.singletonMap(associativity, priority);
        this.operators.merge(functor, item, (m1, m2) -> {
            HashMap m3 = new HashMap(m1);
            m3.putAll(m2);
            return m3;
        });
    }

    public void removeOperator(String functor) {
        this.lexer.removeOperators(functor, new String[0]);
        this.operators.remove(functor);
    }

    public boolean isOperatorAssociativity(Token token, Associativity associativity) {
        return this.isOperatorAssociativity(token.getText(), associativity);
    }

    public boolean isOperatorAssociativity(String functor, Associativity a) {
        return this.operators.containsKey(functor) && this.operators.get(functor).containsKey((Object)a);
    }

    protected static void log(String format, Object ... args) {
    }

    protected OptionalInt lookahead(IntBinaryOperator f, Associativity associativity, int priority, String ... except) {
        Token lookahead = this.getTokenStream().LT(1);
        DynamicParser.log("r=%d, c=%d, l='%s' a=%s e=[%s] p(%s)=%d", new Object[]{lookahead.getLine(), lookahead.getCharPositionInLine(), lookahead.getText(), associativity, except.length > 0 ? "'" + String.join((CharSequence)"','", except) + "'" : "", lookahead.getText(), this.getOperatorPriority(lookahead, associativity)});
        if (Stream.of(except).filter(this::isOperator).anyMatch(o -> lookahead.getText().equals(o))) {
            return OptionalInt.empty();
        }
        if (!this.isOperator(lookahead)) {
            return OptionalInt.empty();
        }
        if (!this.isOperatorAssociativity(lookahead, associativity)) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(f.applyAsInt(this.getOperatorPriority(lookahead, associativity), priority));
    }

    protected boolean lookaheadIs(EnumSet<Associativity> associativities, String ... except) {
        Token lookahead = this.getTokenStream().LT(1);
        DynamicParser.log("r=%d, c=%d, l='%s' e=[%s]", lookahead.getLine(), lookahead.getCharPositionInLine(), lookahead.getText(), except.length > 0 ? "'" + String.join((CharSequence)"','", except) + "'" : "");
        boolean result = Stream.of(except).filter(this::isOperator).noneMatch(o -> lookahead.getText().equals(o)) && associativities.stream().anyMatch(a -> this.isOperatorAssociativity(lookahead, (Associativity)((Object)a)));
        DynamicParser.log(" %s %s\n", result ? "is" : "is not", associativities.size() == 1 ? associativities.iterator().next() : associativities.stream().map(Objects::toString).collect(Collectors.joining(",", "oneOf(", ")")));
        return result;
    }

    protected boolean lookaheadGt(Associativity associativity, int priority, String ... except) {
        boolean res = this.lookahead(Integer::compare, associativity, priority, except).orElse(-1) > 0;
        DynamicParser.log(" > %d? %s\n", priority, res ? "yes" : "no");
        return res;
    }

    protected boolean lookaheadEq(Associativity associativity, int priority, String ... except) {
        boolean res = this.lookahead(Integer::compare, associativity, priority, except).orElse(-1) == 0;
        DynamicParser.log(" == %d? %s\n", priority, res ? "yes" : "no");
        return res;
    }

    protected boolean lookaheadNeq(Associativity associativity, int priority, String ... except) {
        boolean res = this.lookahead(Integer::compare, associativity, priority, except).orElse(0) != 0;
        DynamicParser.log(" != %d? %s\n", priority, res ? "yes" : "no");
        return res;
    }

    protected boolean lookaheadGeq(Associativity associativity, int priority, String ... except) {
        boolean res = this.lookahead(Integer::compare, associativity, priority, except).orElse(-1) >= 0;
        DynamicParser.log(" >= %d? %s\n", priority, res ? "yes" : "no");
        return res;
    }

    protected boolean lookaheadLeq(Associativity associativity, int priority, String ... except) {
        boolean res = this.lookahead(Integer::compare, associativity, priority, except).orElse(1) <= 0;
        DynamicParser.log(" =< %d? %s\n", priority, res ? "yes" : "no");
        return res;
    }

    protected boolean lookaheadLt(Associativity associativity, int priority, String ... except) {
        boolean res = this.lookahead(Integer::compare, associativity, priority, except).orElse(1) < 0;
        DynamicParser.log(" < %d? %s\n", priority, res ? "yes" : "no");
        return res;
    }

    protected boolean lookahead(Associativity associativity, int top, int bottom, String ... except) {
        return this.lookahead(EnumSet.of(associativity), top, bottom, except);
    }

    protected boolean lookahead(EnumSet<Associativity> associativities, int top, int bottom, String ... except) {
        Token lookahead = this.getTokenStream().LT(1);
        DynamicParser.log("r=%d, c=%d, l='%s' a=%s e=[%s] p(%s)=%s", lookahead.getLine(), lookahead.getCharPositionInLine(), lookahead.getText(), associativities.size() == 1 ? associativities.iterator().next() : associativities.stream().map(Objects::toString).collect(Collectors.joining(",", "oneOf(", ")")), except.length > 0 ? "'" + String.join((CharSequence)"','", except) + "'" : "", lookahead.getText(), associativities.size() == 1 ? associativities.stream().map(a -> this.getOperatorPriority(lookahead, (Associativity)((Object)a))).map(String::valueOf).findAny().get() : associativities.stream().map(a -> this.getOperatorPriority(lookahead, (Associativity)((Object)a))).map(String::valueOf).collect(Collectors.joining(",", "oneOf(", ")")));
        boolean result = Stream.of(except).filter(this::isOperator).noneMatch(o -> lookahead.getText().equals(o)) && associativities.stream().anyMatch(associativity -> {
            if (!this.isOperatorAssociativity(lookahead, (Associativity)((Object)associativity))) {
                return false;
            }
            int priority = this.getOperatorPriority(lookahead, (Associativity)((Object)associativity));
            return priority <= top && priority >= bottom;
        });
        DynamicParser.log(" in [%d, %d]? %s\n", top, bottom, result ? "yes" : "no");
        return result;
    }
}

