/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.channel;

import it.unibo.tuprolog.solve.channel.ChannelsKt;
import it.unibo.tuprolog.solve.channel.InputChannel;
import it.unibo.tuprolog.solve.channel.OutputChannel;
import it.unibo.tuprolog.solve.channel.PrintStreamChannel;
import it.unibo.tuprolog.solve.channel.ReaderChannel;
import it.unibo.tuprolog.solve.exception.Warning;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003H\u0000\u001a\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003H\u0000\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\u0006H\u0000\u001a\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001H\u0000\u00a8\u0006\f"}, d2={"stderr", "Lit/unibo/tuprolog/solve/channel/OutputChannel;", "T", "", "stdin", "Lit/unibo/tuprolog/solve/channel/InputChannel;", "", "stdout", "stringInputChannel", "string", "warning", "Lit/unibo/tuprolog/solve/exception/Warning;", "solve"})
public final class ChannelsKt {
    @NotNull
    public static final InputChannel<String> stdin() {
        InputStream inputStream = System.in;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"`in`");
        return new ReaderChannel(inputStream);
    }

    @NotNull
    public static final <T> OutputChannel<T> stderr() {
        PrintStream printStream = System.err;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
        return new PrintStreamChannel(printStream);
    }

    @NotNull
    public static final <T> OutputChannel<T> stdout() {
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        return new PrintStreamChannel(printStream);
    }

    @NotNull
    public static final OutputChannel<Warning> warning() {
        return OutputChannel.Companion.of(warning.1.INSTANCE);
    }

    @NotNull
    public static final InputChannel<String> stringInputChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return new ReaderChannel(new StringReader(string));
    }
}

