/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.impl;

import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermFormatter;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.solve.Solution;
import it.unibo.tuprolog.solve.SolutionFormatter;
import it.unibo.tuprolog.solve.exception.HaltException;
import it.unibo.tuprolog.solve.exception.ResolutionException;
import it.unibo.tuprolog.solve.exception.TimeOutException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lit/unibo/tuprolog/solve/impl/SolutionFormatterImpl;", "Lit/unibo/tuprolog/solve/SolutionFormatter;", "termFormatter", "Lit/unibo/tuprolog/core/TermFormatter;", "(Lit/unibo/tuprolog/core/TermFormatter;)V", "format", "", "value", "Lit/unibo/tuprolog/solve/Solution;", "formatException", "e", "Lit/unibo/tuprolog/solve/exception/ResolutionException;", "formatYes", "Lit/unibo/tuprolog/solve/Solution$Yes;", "Companion", "solve"})
public final class SolutionFormatterImpl
implements SolutionFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TermFormatter termFormatter;
    @NotNull
    private static final String ASSIGNMENT_SEPARATOR = "\n    ";
    @NotNull
    private static final String STACK_ITEM_SEPARATOR = "\n    at ";

    public SolutionFormatterImpl(@NotNull TermFormatter termFormatter) {
        Intrinsics.checkNotNullParameter((Object)termFormatter, (String)"termFormatter");
        this.termFormatter = termFormatter;
    }

    @NotNull
    public String format(@NotNull Solution value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Solution solution = value;
        if (solution instanceof Solution.Yes) {
            string = this.formatYes((Solution.Yes)value);
        } else if (solution instanceof Solution.No) {
            string = "no.";
        } else if (solution instanceof Solution.Halt) {
            ResolutionException e = ((Solution.Halt)value).getException();
            string = e instanceof TimeOutException ? "timeout." : (e instanceof HaltException ? "halt: " + ((HaltException)e).getExitStatus() : this.formatException(e));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String formatException(ResolutionException e) {
        StringBuilder stringBuilder = new StringBuilder().append("halt: ");
        String string = e.getMessage();
        if (string == null) {
            string = "<no message>";
        }
        return stringBuilder.append(string).append(CollectionsKt.joinToString$default((Iterable)e.getLogicStackTrace(), (CharSequence)STACK_ITEM_SEPARATOR, (CharSequence)STACK_ITEM_SEPARATOR, null, (int)0, null, (Function1)((Function1)new Function1<Struct, CharSequence>(this){
            final /* synthetic */ SolutionFormatterImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Struct it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SolutionFormatterImpl.access$getTermFormatter$p(this.this$0).format((Term)it);
            }
        }), (int)28, null)).toString();
    }

    private final String formatYes(Solution.Yes value) {
        return "yes: " + this.termFormatter.format((Term)value.getSolvedQuery()) + CollectionsKt.joinToString$default((Iterable)((Map)value.getSubstitution()).entrySet(), (CharSequence)ASSIGNMENT_SEPARATOR, (CharSequence)ASSIGNMENT_SEPARATOR, null, (int)0, null, (Function1)((Function1)new Function1<Map.Entry<? extends Var, ? extends Term>, CharSequence>(this){
            final /* synthetic */ SolutionFormatterImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Map.Entry<? extends Var, ? extends Term> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                Var v = entry.getKey();
                Term t = entry.getValue();
                return SolutionFormatterImpl.access$getTermFormatter$p(this.this$0).format((Term)v) + " = " + SolutionFormatterImpl.access$getTermFormatter$p(this.this$0).format(t);
            }
        }), (int)28, null);
    }

    public static final /* synthetic */ TermFormatter access$getTermFormatter$p(SolutionFormatterImpl $this) {
        return $this.termFormatter;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lit/unibo/tuprolog/solve/impl/SolutionFormatterImpl$Companion;", "", "()V", "ASSIGNMENT_SEPARATOR", "", "STACK_ITEM_SEPARATOR", "solve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

