/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.stdlib.function;

import it.unibo.tuprolog.core.Integer;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.solve.ExecutionContext;
import it.unibo.tuprolog.solve.function.BinaryMathFunction;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gciatto.kt.math.BigDecimal;
import org.gciatto.kt.math.MathContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u0013"}, d2={"Lit/unibo/tuprolog/solve/stdlib/function/FloatingPointDivision;", "Lit/unibo/tuprolog/solve/function/BinaryMathFunction;", "()V", "commonBehaviour", "Lit/unibo/tuprolog/core/Real;", "dividend", "Lorg/gciatto/kt/math/BigDecimal;", "divisor", "context", "Lit/unibo/tuprolog/solve/ExecutionContext;", "mathFunction", "Lit/unibo/tuprolog/core/Numeric;", "integer1", "Lit/unibo/tuprolog/core/Integer;", "integer2", "integer", "real", "real1", "real2", "solve"})
public final class FloatingPointDivision
extends BinaryMathFunction {
    @NotNull
    public static final FloatingPointDivision INSTANCE = new FloatingPointDivision();

    private FloatingPointDivision() {
        super("/");
    }

    @Override
    @NotNull
    protected Numeric mathFunction(@NotNull Integer integer1, @NotNull Integer integer2, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)integer1, (String)"integer1");
        Intrinsics.checkNotNullParameter((Object)integer2, (String)"integer2");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (Numeric)this.commonBehaviour(integer1.getDecimalValue(), integer2.getDecimalValue(), context);
    }

    @Override
    @NotNull
    protected Numeric mathFunction(@NotNull Real real, @NotNull Integer integer, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)real, (String)"real");
        Intrinsics.checkNotNullParameter((Object)integer, (String)"integer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (Numeric)this.commonBehaviour(real.getValue(), integer.getDecimalValue(), context);
    }

    @Override
    @NotNull
    protected Numeric mathFunction(@NotNull Integer integer, @NotNull Real real, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)integer, (String)"integer");
        Intrinsics.checkNotNullParameter((Object)real, (String)"real");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (Numeric)this.commonBehaviour(integer.getDecimalValue(), real.getValue(), context);
    }

    @Override
    @NotNull
    protected Numeric mathFunction(@NotNull Real real1, @NotNull Real real2, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)real1, (String)"real1");
        Intrinsics.checkNotNullParameter((Object)real2, (String)"real2");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (Numeric)this.commonBehaviour(real1.getValue(), real2.getValue(), context);
    }

    private final Real commonBehaviour(BigDecimal dividend, BigDecimal divisor, ExecutionContext context) {
        if (divisor.compareTo(BigDecimal.ZERO) == 0) {
            this.throwZeroDivisorError(context);
            throw new KotlinNothingValueException();
        }
        BigDecimal bigDecimal = dividend.div(divisor, new MathContext());
        Intrinsics.checkNotNull((Object)bigDecimal);
        return Numeric.Companion.of(bigDecimal);
    }
}

