/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.problog.lib.knowledge.impl;

import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Rule;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Truth;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.core.exception.TuPrologException;
import it.unibo.tuprolog.solve.AbstractWrapper;
import it.unibo.tuprolog.solve.problog.lib.exception.ClauseMappingException;
import it.unibo.tuprolog.solve.problog.lib.knowledge.ProbExplanation;
import it.unibo.tuprolog.solve.problog.lib.knowledge.ProbTerm;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.ClauseMapper;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.ClauseMappingUtils;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.ClauseMappingUtilsKt;
import it.unibo.tuprolog.solve.problog.lib.primitive.ProbExplAnd;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lit/unibo/tuprolog/solve/problog/lib/knowledge/impl/ProbabilisticClauseMapper;", "Lit/unibo/tuprolog/solve/problog/lib/knowledge/impl/ClauseMapper;", "()V", "apply", "", "Lit/unibo/tuprolog/core/Clause;", "clause", "isCompatible", "", "mapRuleInternal", "Lkotlin/Pair;", "Lit/unibo/tuprolog/core/Rule;", "Lit/unibo/tuprolog/solve/problog/lib/knowledge/ProbTerm;", "rule", "mapRuleWithExplanation", "explanation", "Lit/unibo/tuprolog/solve/problog/lib/knowledge/ProbExplanation;", "solve-problog"})
public final class ProbabilisticClauseMapper
implements ClauseMapper {
    @NotNull
    public static final ProbabilisticClauseMapper INSTANCE = new ProbabilisticClauseMapper();

    private ProbabilisticClauseMapper() {
    }

    @Override
    public boolean isCompatible(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        return clause instanceof Rule && Intrinsics.areEqual((Object)((Rule)clause).getHead().getFunctor(), (Object)"::");
    }

    @Override
    @NotNull
    public List<Clause> apply(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        if (!(clause instanceof Rule)) {
            throw new ClauseMappingException(Intrinsics.stringPlus((String)"Clause is not an instance of Rule: ", (Object)clause), null, 2, null);
        }
        Pair<Rule, ProbTerm> mapped = this.mapRuleInternal((Rule)clause);
        return CollectionsKt.listOf((Object)this.mapRuleWithExplanation((Rule)mapped.getFirst(), ProbExplanation.Companion.of((ProbTerm)mapped.getSecond())));
    }

    @NotNull
    public final Pair<Rule, ProbTerm> mapRuleInternal(@NotNull Rule rule) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        if (rule.getHead().getArity() != 2) {
            throw new TuPrologException(Intrinsics.stringPlus((String)"Invalid probabilistic rule: ", (Object)rule.getHead()), null, 2, null);
        }
        Term probTerm = rule.getHead().get(0);
        double probability2 = probTerm instanceof Numeric ? ((Numeric)probTerm).getDecimalValue().toDouble() : ClauseMappingUtilsKt.solveArithmeticExpression(probTerm);
        Struct headTerm = ClauseMappingUtilsKt.safeToStruct(rule.getHead().get(1));
        if (Intrinsics.areEqual((Object)headTerm.getFunctor(), (Object)"evidence")) {
            throw new TuPrologException(Intrinsics.stringPlus((String)"Probability notation can't be expressed on evidence: ", (Object)rule.getHead()), null, 2, null);
        }
        Term bodyTerm = rule.getBody();
        if (rule.getBody() instanceof Truth && !rule.getBody().isTrue() && probability2 < 1.0) {
            probability2 = 1.0 - probability2;
            bodyTerm = (Term)Truth.Companion.of(true);
        }
        Term[] termArray = new Term[]{bodyTerm};
        Rule anonVariablesFix = ClauseMappingUtilsKt.withoutAnonymousVars(Rule.Companion.of(headTerm, termArray));
        headTerm = anonVariablesFix.getHead();
        bodyTerm = anonVariablesFix.getBody();
        Term[] termArray2 = new Term[]{bodyTerm};
        Set<Var> extraVariables = ClauseMappingUtilsKt.getExtraVariables(Rule.Companion.of(headTerm, termArray2));
        ProbTerm probTerm2 = new ProbTerm(ClauseMappingUtils.INSTANCE.newClauseId(), probability2, (Term)headTerm, extraVariables);
        Term[] termArray3 = new Term[]{bodyTerm};
        return new Pair((Object)Rule.Companion.of(headTerm, termArray3), (Object)probTerm2);
    }

    @NotNull
    public final Rule mapRuleWithExplanation(@NotNull Rule rule, @NotNull ProbExplanation explanation) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)explanation, (String)"explanation");
        if (rule.getBody() instanceof Truth) {
            Term[] termArray = new Term[]{rule.getBody()};
            return Rule.Companion.of(ClauseMappingUtilsKt.withExplanation((Term)rule.getHead(), ClauseMappingUtilsKt.toTerm(explanation)), termArray);
        }
        Var explanationVar = Var.Companion.of("EXPL_Res");
        Var explanationBodyVar = Var.Companion.of("EXPL_Body");
        Struct newBody = ClauseMappingUtilsKt.withBodyExplanation(rule.getBody(), (Term)explanationBodyVar);
        Term[] termArray = new Term[1];
        Term[] termArray2 = new Term[2];
        termArray2[0] = (Term)newBody;
        AbstractWrapper this_$iv = (AbstractWrapper)ProbExplAnd.INSTANCE;
        boolean $i$f$getFunctor = false;
        Term[] termArray3 = new Term[]{(Term)explanationVar, (Term)explanationBodyVar, ClauseMappingUtilsKt.toTerm(explanation)};
        termArray2[1] = (Term)Struct.Companion.of(this_$iv.getSignature().getName(), termArray3);
        termArray[0] = (Term)Struct.Companion.of(",", termArray2);
        return Rule.Companion.of(ClauseMappingUtilsKt.withExplanation((Term)rule.getHead(), (Term)explanationVar), termArray);
    }
}

