package it.unibo.tuprolog.collections

import it.unibo.tuprolog.collections.rete.custom.ReteTree
import it.unibo.tuprolog.core.Clause

internal abstract class AbstractClauseCollection<Self : AbstractClauseCollection<Self>>
protected constructor(protected val rete: ReteTree) : ClauseCollection {

    protected abstract val self: Self

    override val size: Int
        get() = rete.clauses.count()

    override fun isEmpty(): Boolean = size == 0

    override fun contains(element: Clause): Boolean = rete.get(element).any()

    @Suppress("RedundantAsSequence")
    override fun containsAll(elements: Iterable<Clause>): Boolean = elements.asSequence().all { it in this }

    abstract override fun add(clause: Clause): Self

    abstract override fun addAll(clauses: Iterable<Clause>): Self

    abstract override fun retrieve(clause: Clause): RetrieveResult<out Self>

    abstract override fun retrieveAll(clause: Clause): RetrieveResult<out Self>

    override fun iterator(): Iterator<Clause> = rete.clauses.iterator()

    override fun toString(): String = "${this::class.simpleName}(${this.joinToString(", ")})"
}
