/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.collections;

import it.unibo.tuprolog.collections.ClauseCollection;
import it.unibo.tuprolog.core.Clause;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u0017\u0018B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0004\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00028\u00008&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0004\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00078&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0004\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015\u0082\u0001\u0002\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lit/unibo/tuprolog/collections/RetrieveResult;", "C", "Lit/unibo/tuprolog/collections/ClauseCollection;", "", "()V", "clauses", "", "Lit/unibo/tuprolog/core/Clause;", "getClauses$annotations", "getClauses", "()Ljava/util/List;", "collection", "getCollection$annotations", "getCollection", "()Lit/unibo/tuprolog/collections/ClauseCollection;", "firstClause", "getFirstClause$annotations", "getFirstClause", "()Lit/unibo/tuprolog/core/Clause;", "isFailure", "", "()Z", "isSuccess", "Failure", "Success", "Lit/unibo/tuprolog/collections/RetrieveResult$Failure;", "Lit/unibo/tuprolog/collections/RetrieveResult$Success;", "theory"})
public abstract class RetrieveResult<C extends ClauseCollection> {
    private RetrieveResult() {
    }

    public boolean isSuccess() {
        return false;
    }

    public boolean isFailure() {
        return false;
    }

    @NotNull
    public abstract C getCollection();

    public static /* synthetic */ void getCollection$annotations() {
    }

    @Nullable
    public abstract List<Clause> getClauses();

    public static /* synthetic */ void getClauses$annotations() {
    }

    @Nullable
    public abstract Clause getFirstClause();

    public static /* synthetic */ void getFirstClause$annotations() {
    }

    public /* synthetic */ RetrieveResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0014\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lit/unibo/tuprolog/collections/RetrieveResult$Success;", "C", "Lit/unibo/tuprolog/collections/ClauseCollection;", "Lit/unibo/tuprolog/collections/RetrieveResult;", "collection", "clauses", "", "Lit/unibo/tuprolog/core/Clause;", "(Lit/unibo/tuprolog/collections/ClauseCollection;Ljava/util/List;)V", "getClauses", "()Ljava/util/List;", "getCollection", "()Lit/unibo/tuprolog/collections/ClauseCollection;", "Lit/unibo/tuprolog/collections/ClauseCollection;", "firstClause", "getFirstClause", "()Lit/unibo/tuprolog/core/Clause;", "isSuccess", "", "()Z", "component1", "component2", "copy", "(Lit/unibo/tuprolog/collections/ClauseCollection;Ljava/util/List;)Lit/unibo/tuprolog/collections/RetrieveResult$Success;", "equals", "other", "", "hashCode", "", "toString", "", "theory"})
    public static final class Success<C extends ClauseCollection>
    extends RetrieveResult<C> {
        @NotNull
        private final C collection;
        @NotNull
        private final List<Clause> clauses;

        public Success(@NotNull C collection, @NotNull List<? extends Clause> clauses) {
            Intrinsics.checkNotNullParameter(collection, (String)"collection");
            Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
            super(null);
            this.collection = collection;
            this.clauses = clauses;
        }

        @Override
        @NotNull
        public C getCollection() {
            return this.collection;
        }

        @Override
        @NotNull
        public List<Clause> getClauses() {
            return this.clauses;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        @NotNull
        public Clause getFirstClause() {
            return (Clause)CollectionsKt.first(this.getClauses());
        }

        @NotNull
        public final C component1() {
            return this.getCollection();
        }

        @NotNull
        public final List<Clause> component2() {
            return this.getClauses();
        }

        @NotNull
        public final Success<C> copy(@NotNull C collection, @NotNull List<? extends Clause> clauses) {
            Intrinsics.checkNotNullParameter(collection, (String)"collection");
            Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
            return new Success<C>(collection, clauses);
        }

        public static /* synthetic */ Success copy$default(Success success, ClauseCollection clauseCollection, List list, int n, Object object) {
            if ((n & 1) != 0) {
                clauseCollection = success.getCollection();
            }
            if ((n & 2) != 0) {
                list = success.getClauses();
            }
            return success.copy(clauseCollection, list);
        }

        @NotNull
        public String toString() {
            return "Success(collection=" + this.getCollection() + ", clauses=" + this.getClauses() + ')';
        }

        public int hashCode() {
            int result = this.getCollection().hashCode();
            result = result * 31 + ((Object)this.getClauses()).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success = (Success)other;
            if (!Intrinsics.areEqual(this.getCollection(), success.getCollection())) {
                return false;
            }
            return Intrinsics.areEqual(this.getClauses(), success.getClauses());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0012\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lit/unibo/tuprolog/collections/RetrieveResult$Failure;", "C", "Lit/unibo/tuprolog/collections/ClauseCollection;", "Lit/unibo/tuprolog/collections/RetrieveResult;", "collection", "(Lit/unibo/tuprolog/collections/ClauseCollection;)V", "clauses", "", "getClauses", "()Ljava/lang/Void;", "getCollection", "()Lit/unibo/tuprolog/collections/ClauseCollection;", "Lit/unibo/tuprolog/collections/ClauseCollection;", "firstClause", "getFirstClause", "isFailure", "", "()Z", "component1", "copy", "(Lit/unibo/tuprolog/collections/ClauseCollection;)Lit/unibo/tuprolog/collections/RetrieveResult$Failure;", "equals", "other", "", "hashCode", "", "toString", "", "theory"})
    public static final class Failure<C extends ClauseCollection>
    extends RetrieveResult<C> {
        @NotNull
        private final C collection;

        public Failure(@NotNull C collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"collection");
            super(null);
            this.collection = collection;
        }

        @Override
        @NotNull
        public C getCollection() {
            return this.collection;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Nullable
        public Void getClauses() {
            return null;
        }

        @Nullable
        public Void getFirstClause() {
            return null;
        }

        @NotNull
        public final C component1() {
            return this.getCollection();
        }

        @NotNull
        public final Failure<C> copy(@NotNull C collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"collection");
            return new Failure<C>(collection);
        }

        public static /* synthetic */ Failure copy$default(Failure failure, ClauseCollection clauseCollection, int n, Object object) {
            if ((n & 1) != 0) {
                clauseCollection = failure.getCollection();
            }
            return failure.copy(clauseCollection);
        }

        @NotNull
        public String toString() {
            return "Failure(collection=" + this.getCollection() + ')';
        }

        public int hashCode() {
            return this.getCollection().hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failure)) {
                return false;
            }
            Failure failure = (Failure)other;
            return Intrinsics.areEqual(this.getCollection(), failure.getCollection());
        }
    }
}

