/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.theory.impl;

import it.unibo.tuprolog.collections.ClauseQueue;
import it.unibo.tuprolog.collections.MutableClauseQueue;
import it.unibo.tuprolog.collections.RetrieveResult;
import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.theory.AbstractTheory;
import it.unibo.tuprolog.theory.MutableTheory;
import it.unibo.tuprolog.theory.RetractResult;
import it.unibo.tuprolog.theory.Theory;
import it.unibo.tuprolog.theory.TheoryUtils;
import it.unibo.tuprolog.theory.impl.AbstractIndexedTheory;
import it.unibo.tuprolog.utils.DequeKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\u000bB#\b\u0002\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\u000eJ*\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0014J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\u001c\u0010\u001f\u001a\u00020\u00002\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00000!2\u0006\u0010\"\u001a\u00020\u0004H\u0016J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00000!2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00000!2\u0006\u0010\"\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0014\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006&"}, d2={"Lit/unibo/tuprolog/theory/impl/IndexedTheory;", "Lit/unibo/tuprolog/theory/impl/AbstractIndexedTheory;", "clauses", "", "Lit/unibo/tuprolog/core/Clause;", "tags", "", "", "", "(Ljava/lang/Iterable;Ljava/util/Map;)V", "Lkotlin/sequences/Sequence;", "(Lkotlin/sequences/Sequence;Ljava/util/Map;)V", "queue", "Lit/unibo/tuprolog/collections/ClauseQueue;", "(Lit/unibo/tuprolog/collections/ClauseQueue;Ljava/util/Map;)V", "hashCodeCache", "", "getHashCodeCache", "()I", "hashCodeCache$delegate", "Lkotlin/Lazy;", "size", "", "getSize", "()J", "sizeCache", "getSizeCache", "sizeCache$delegate", "createNewTheory", "Lit/unibo/tuprolog/theory/AbstractTheory;", "hashCode", "replaceTags", "retract", "Lit/unibo/tuprolog/theory/RetractResult;", "clause", "retractAll", "toMutableTheory", "Lit/unibo/tuprolog/theory/MutableTheory;", "theory"})
public final class IndexedTheory
extends AbstractIndexedTheory {
    @NotNull
    private final Lazy hashCodeCache$delegate;
    @NotNull
    private final Lazy sizeCache$delegate;

    private IndexedTheory(ClauseQueue queue, Map<String, ? extends Object> tags) {
        super(queue, tags);
        this.hashCodeCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ IndexedTheory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return IndexedTheory.access$hashCode$s1741529108(this.this$0);
            }
        }));
        this.sizeCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ IndexedTheory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return IndexedTheory.access$getSize$s1741529108(this.this$0);
            }
        }));
    }

    public IndexedTheory(@NotNull Iterable<? extends Clause> clauses, @NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this(ClauseQueue.Companion.of(clauses), tags);
        TheoryUtils.INSTANCE.checkClausesCorrect(clauses);
    }

    public /* synthetic */ IndexedTheory(Iterable iterable, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(iterable, (Map<String, ? extends Object>)map);
    }

    public IndexedTheory(@NotNull Sequence<? extends Clause> clauses, @NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this(SequencesKt.asIterable(clauses), tags);
    }

    public /* synthetic */ IndexedTheory(Sequence sequence, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this((Sequence<? extends Clause>)sequence, (Map<String, ? extends Object>)map);
    }

    @Override
    @NotNull
    protected AbstractTheory createNewTheory(@NotNull Sequence<? extends Clause> clauses, @NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return new IndexedTheory(clauses, tags);
    }

    @NotNull
    public RetractResult<IndexedTheory> retract(@NotNull Clause clause) {
        RetractResult retractResult;
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        ClauseQueue newTheory = ClauseQueue.Companion.of(this.getClauses());
        RetrieveResult<? extends ClauseQueue> retracted2 = newTheory.retrieveFirst(clause);
        if (retracted2.isFailure()) {
            retractResult = new RetractResult.Failure<Theory>(this);
        } else {
            Theory theory = new IndexedTheory(retracted2.getCollection(), this.getTags());
            List<Clause> list = retracted2.getClauses();
            Intrinsics.checkNotNull(list);
            retractResult = new RetractResult.Success<Theory>(theory, (Iterable<? extends Clause>)list);
        }
        return retractResult;
    }

    @Override
    @NotNull
    public MutableTheory toMutableTheory() {
        return MutableTheory.Companion.indexedOf(this);
    }

    @NotNull
    public RetractResult<IndexedTheory> retract(@NotNull Iterable<? extends Clause> clauses) {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        MutableClauseQueue newTheory = MutableClauseQueue.Companion.of(this.getClauses());
        List removed = DequeKt.dequeOf((Object[])new Clause[0]);
        for (Clause clause : clauses) {
            RetrieveResult<? extends MutableClauseQueue> result = newTheory.retrieveFirst(clause);
            if (!result.isSuccess()) continue;
            List<Clause> list = result.getClauses();
            Intrinsics.checkNotNull(list);
            removed.addAll((Collection)list);
        }
        return removed.isEmpty() ? (RetractResult)new RetractResult.Failure<Theory>(this) : (RetractResult)new RetractResult.Success<Theory>(new IndexedTheory(newTheory, (Map<String, ? extends Object>)this.getTags()), removed);
    }

    @NotNull
    public RetractResult<IndexedTheory> retractAll(@NotNull Clause clause) {
        RetractResult retractResult;
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        ClauseQueue newTheory = ClauseQueue.Companion.of(this.getClauses());
        RetrieveResult<? extends ClauseQueue> retracted2 = newTheory.retrieveAll(clause);
        if (retracted2.isFailure()) {
            retractResult = new RetractResult.Failure<Theory>(this);
        } else {
            Theory theory = new IndexedTheory(retracted2.getCollection(), this.getTags());
            List<Clause> list = retracted2.getClauses();
            Intrinsics.checkNotNull(list);
            retractResult = new RetractResult.Success<Theory>(theory, (Iterable<? extends Clause>)list);
        }
        return retractResult;
    }

    private final int getHashCodeCache() {
        Lazy lazy = this.hashCodeCache$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public int hashCode() {
        return this.getHashCodeCache();
    }

    private final long getSizeCache() {
        Lazy lazy = this.sizeCache$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @Override
    public long getSize() {
        return this.getSizeCache();
    }

    @NotNull
    public IndexedTheory replaceTags(@NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return tags == this.getTags() ? this : new IndexedTheory(this.getQueue(), tags);
    }

    public static final /* synthetic */ int access$hashCode$s1741529108(IndexedTheory $this) {
        return super.hashCode();
    }

    public static final /* synthetic */ long access$getSize$s1741529108(IndexedTheory $this) {
        return super.getSize();
    }
}

