/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.utils.impl;

import it.unibo.tuprolog.utils.Cache;
import it.unibo.tuprolog.utils.IterUtils;
import it.unibo.tuprolog.utils.Optional;
import it.unibo.tuprolog.utils.impl.LRUCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u001e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\r2\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0005H\u0016J2\u0010\u001a\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001b0\r2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001fH\u0016J\u001a\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001b0!H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\n\u00a8\u0006$"}, d2={"Lit/unibo/tuprolog/utils/impl/LRUCache;", "K", "V", "Lit/unibo/tuprolog/utils/Cache;", "capacity", "", "(I)V", "cache", "", "getCapacity", "()I", "insertionOrder", "", "Lit/unibo/tuprolog/utils/Optional;", "[Lit/unibo/tuprolog/utils/Optional;", "nextFreeIndex", "size", "getSize", "equals", "", "other", "", "get", "key", "(Ljava/lang/Object;)Lit/unibo/tuprolog/utils/Optional;", "hashCode", "set", "Lkotlin/Pair;", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Lit/unibo/tuprolog/utils/Optional;", "toMap", "", "toSequence", "Lkotlin/sequences/Sequence;", "toString", "", "utils"})
public final class LRUCache<K, V>
implements Cache<K, V> {
    private final int capacity;
    @NotNull
    private final Map<K, V> cache;
    @NotNull
    private final Optional<? extends K>[] insertionOrder;
    private volatile int nextFreeIndex;

    /*
     * WARNING - void declaration
     */
    public LRUCache(int capacity) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.capacity = capacity;
        boolean bl = this.getCapacity() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = false;
        this.cache = new LinkedHashMap();
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.getCapacity());
        LRUCache lRUCache = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl6 = false;
            Optional optional = Optional.Companion.none();
            collection.add(optional);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Optional[] optionalArray = thisCollection$iv.toArray(new Optional[0]);
        if (optionalArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        lRUCache.insertionOrder = optionalArray;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public synchronized int getSize() {
        return this.cache.size();
    }

    @Override
    @NotNull
    public synchronized Optional<? extends Pair<K, V>> set(K key, V value) {
        Optional optional;
        Object object = this.insertionOrder[this.nextFreeIndex];
        boolean bl = false;
        boolean bl2 = false;
        Optional<K> evictedKey = object;
        boolean bl3 = false;
        if (evictedKey.isPresent()) {
            K k = evictedKey.getValue();
            Intrinsics.checkNotNull(k);
            K evictedKeyValue = k;
            V v = this.cache.get(evictedKeyValue);
            Intrinsics.checkNotNull(v);
            V evictedValue = v;
            this.cache.remove(evictedKeyValue);
            optional = Optional.Companion.some(TuplesKt.to(evictedKeyValue, evictedValue));
        } else {
            optional = Optional.Companion.none();
        }
        Optional evicted = optional;
        this.insertionOrder[this.nextFreeIndex] = Optional.Companion.some(key);
        object = this.cache;
        bl = false;
        object.put(key, value);
        this.nextFreeIndex = (this.nextFreeIndex + 1) % this.getCapacity();
        return evicted;
    }

    @Override
    @NotNull
    public synchronized Optional<? extends V> get(K key) {
        return this.cache.containsKey(key) ? Optional.Companion.of(this.cache.get(key)) : Optional.Companion.none();
    }

    @Override
    @NotNull
    public synchronized Map<K, V> toMap() {
        return MapsKt.toMap(this.cache);
    }

    public synchronized boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        LRUCache cfr_ignored_0 = (LRUCache)other;
        if (this.getCapacity() != ((LRUCache)other).getCapacity()) {
            return false;
        }
        if (!Intrinsics.areEqual(this.cache, ((LRUCache)other).cache)) {
            return false;
        }
        Object[] objectArray = this.insertionOrder;
        Object[] objectArray2 = ((LRUCache)other).insertionOrder;
        boolean bl = false;
        if (!Arrays.equals(objectArray, objectArray2)) {
            return false;
        }
        return this.nextFreeIndex == ((LRUCache)other).nextFreeIndex;
    }

    public synchronized int hashCode() {
        int result = this.getCapacity();
        result = 31 * result + ((Object)this.cache).hashCode();
        Object[] objectArray = this.insertionOrder;
        boolean bl = false;
        result = 31 * result + Arrays.hashCode(objectArray);
        result = 31 * result + this.nextFreeIndex;
        return result;
    }

    @Override
    @NotNull
    public synchronized Sequence<Pair<K, V>> toSequence() {
        Sequence indexes2 = this.getSize() < this.getCapacity() ? CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)this.getSize()))) : SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)this.getCapacity()))), (Function1)((Function1)new Function1<Integer, Integer>(this){
            final /* synthetic */ LRUCache<K, V> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return (it + LRUCache.access$getNextFreeIndex$p(this.this$0)) % this.this$0.getCapacity();
            }
        }));
        return IterUtils.buffered(SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)indexes2, (Function1)new Function1<Integer, Optional<? extends K>>(this){
            final /* synthetic */ LRUCache<K, V> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Optional<? extends K> invoke(int it) {
                return LRUCache.access$getInsertionOrder$p(this.this$0)[it];
            }
        }), (Function1)toSequence.2.INSTANCE), (Function1)toSequence.3.INSTANCE), (Function1)new Function1<K, Pair<? extends K, ? extends V>>(this){
            final /* synthetic */ LRUCache<K, V> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Pair<K, V> invoke(K it) {
                V v = LRUCache.access$getCache$p(this.this$0).get(it);
                Intrinsics.checkNotNull(v);
                return TuplesKt.to(it, v);
            }
        }));
    }

    @NotNull
    public synchronized String toString() {
        return "LRUCache(" + SequencesKt.joinToString$default((Sequence)SequencesKt.map(this.toSequence(), (Function1)toString.1.INSTANCE), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    @Override
    public V getOrSet(K key, @NotNull Function0<? extends V> valueGenerator) {
        return Cache.DefaultImpls.getOrSet(this, key, valueGenerator);
    }

    public static final /* synthetic */ int access$getNextFreeIndex$p(LRUCache $this) {
        return $this.nextFreeIndex;
    }

    public static final /* synthetic */ Optional[] access$getInsertionOrder$p(LRUCache $this) {
        return $this.insertionOrder;
    }

    public static final /* synthetic */ Map access$getCache$p(LRUCache $this) {
        return $this.cache;
    }
}

