/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.utils;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u0015*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003\u0015\u0016\u0017B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J$\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00002\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\rH&J*\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u000f0\u0000\"\u0004\b\u0001\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000f0\rH&J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H&J\b\u0010\u0013\u001a\u00020\u0014H&R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u0004\u0018\u00018\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lit/unibo/tuprolog/utils/Optional;", "T", "", "()V", "isAbsent", "", "()Z", "isPresent", "value", "getValue", "()Ljava/lang/Object;", "filter", "predicate", "Lkotlin/Function1;", "map", "R", "function", "toSequence", "Lkotlin/sequences/Sequence;", "toString", "", "Companion", "None", "Some", "Lit/unibo/tuprolog/utils/Optional$Some;", "Lit/unibo/tuprolog/utils/Optional$None;", "utils"})
public abstract class Optional<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private Optional() {
    }

    @Nullable
    public abstract T getValue();

    public abstract boolean isPresent();

    public final boolean isAbsent() {
        return !this.isPresent();
    }

    @NotNull
    public abstract <R> Optional<? extends R> map(@NotNull Function1<? super T, ? extends R> var1);

    @NotNull
    public abstract Optional<? extends T> filter(@NotNull Function1<? super T, Boolean> var1);

    @NotNull
    public abstract Sequence<T> toSequence();

    @NotNull
    public abstract String toString();

    public /* synthetic */ Optional(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u0005J#\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\b\u0010\u0007\u001a\u0004\u0018\u0001H\u0005\u00a2\u0006\u0002\u0010\bJ!\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\n\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0007\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lit/unibo/tuprolog/utils/Optional$Companion;", "", "()V", "none", "Lit/unibo/tuprolog/utils/Optional;", "T", "of", "value", "(Ljava/lang/Object;)Lit/unibo/tuprolog/utils/Optional;", "some", "Lit/unibo/tuprolog/utils/Optional$Some;", "(Ljava/lang/Object;)Lit/unibo/tuprolog/utils/Optional$Some;", "utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> Some<? extends T> some(T value) {
            return new Some<T>(value);
        }

        @NotNull
        public final <T> Optional<? extends T> of(@Nullable T value) {
            return value == null ? this.none() : (Optional)this.some(value);
        }

        @NotNull
        public final <T> Optional<? extends T> none() {
            return None.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J$\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u00022\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0000\"\u0004\b\u0002\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00170\u0013H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0016\u0010\u0003\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lit/unibo/tuprolog/utils/Optional$Some;", "T", "Lit/unibo/tuprolog/utils/Optional;", "value", "(Ljava/lang/Object;)V", "isPresent", "", "()Z", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lit/unibo/tuprolog/utils/Optional$Some;", "equals", "other", "", "filter", "predicate", "Lkotlin/Function1;", "hashCode", "", "map", "R", "function", "toSequence", "Lkotlin/sequences/Sequence;", "toString", "", "utils"})
    public static final class Some<T>
    extends Optional<T> {
        private final T value;

        public Some(T value) {
            super(null);
            this.value = value;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        @NotNull
        public <R> Some<R> map(@NotNull Function1<? super T, ? extends R> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            return new Some<Object>(function.invoke(this.getValue()));
        }

        @Override
        @NotNull
        public Optional<? extends T> filter(@NotNull Function1<? super T, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            return (Boolean)predicate.invoke(this.getValue()) != false ? (Optional)this : (Optional)None.INSTANCE;
        }

        @Override
        @NotNull
        public Sequence<T> toSequence() {
            Object[] objectArray = new Object[]{this.getValue()};
            return SequencesKt.sequenceOf((Object[])objectArray);
        }

        @Override
        @NotNull
        public String toString() {
            return "Some(" + this.getValue() + ')';
        }

        public final T component1() {
            return this.getValue();
        }

        @NotNull
        public final Some<T> copy(T value) {
            return new Some<T>(value);
        }

        public static /* synthetic */ Some copy$default(Some some, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = some.getValue();
            }
            return some.copy(object);
        }

        public int hashCode() {
            return this.getValue() == null ? 0 : this.getValue().hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Some)) {
                return false;
            }
            Some some = (Some)other;
            return Intrinsics.areEqual(this.getValue(), some.getValue());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\n\u001a\u00020\u00002\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\fH\u0016J\"\u0010\r\u001a\u00020\u0000\"\u0004\b\u0001\u0010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u000e0\fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lit/unibo/tuprolog/utils/Optional$None;", "Lit/unibo/tuprolog/utils/Optional;", "", "()V", "isPresent", "", "()Z", "value", "getValue", "()Ljava/lang/Void;", "filter", "predicate", "Lkotlin/Function1;", "map", "R", "function", "toSequence", "Lkotlin/sequences/Sequence;", "toString", "", "utils"})
    public static final class None
    extends Optional {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
            super(null);
        }

        @Nullable
        public Void getValue() {
            return null;
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @NotNull
        public <R> None map(@NotNull Function1<?, ? extends R> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            return INSTANCE;
        }

        @NotNull
        public None filter(@NotNull Function1<?, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            return INSTANCE;
        }

        @NotNull
        public Sequence toSequence() {
            return SequencesKt.emptySequence();
        }

        @Override
        @NotNull
        public String toString() {
            return "None";
        }
    }
}

