/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.utils.impl;

import it.unibo.tuprolog.utils.Cache;
import it.unibo.tuprolog.utils.IterUtils;
import it.unibo.tuprolog.utils.Optional;
import it.unibo.tuprolog.utils.impl.SimpleLRUCache;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u001e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u001c\u0010\u0017\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00180\u0013H\u0002J\u001c\u0010\u0019\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00180\u0013H\u0002J2\u0010\u001a\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00180\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001eH\u0016J\u001a\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00180 H\u0016J\b\u0010!\u001a\u00020\"H\u0016R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006#"}, d2={"Lit/unibo/tuprolog/utils/impl/SimpleLRUCache;", "K", "V", "Lit/unibo/tuprolog/utils/Cache;", "capacity", "", "(I)V", "cache", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "getCapacity", "()I", "size", "getSize", "equals", "", "other", "", "get", "Lit/unibo/tuprolog/utils/Optional;", "key", "(Ljava/lang/Object;)Lit/unibo/tuprolog/utils/Optional;", "hashCode", "removeLeastRecent", "Lkotlin/Pair;", "removeLeastRecentIfNecessary", "set", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Lit/unibo/tuprolog/utils/Optional;", "toMap", "", "toSequence", "Lkotlin/sequences/Sequence;", "toString", "", "utils"})
public final class SimpleLRUCache<K, V>
implements Cache<K, V> {
    private final int capacity;
    @NotNull
    private final LinkedHashMap<K, V> cache;

    public SimpleLRUCache(int capacity) {
        this.capacity = capacity;
        if (!(this.getCapacity() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.cache = new LinkedHashMap();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public synchronized Optional<? extends Pair<K, V>> set(K key, V value) {
        Optional<Pair<K, V>> evicted = this.removeLeastRecentIfNecessary();
        ((Map)this.cache).put(key, value);
        return evicted;
    }

    private final Optional<? extends Pair<K, V>> removeLeastRecent() {
        Map.Entry entry = ((Map)this.cache).entrySet().iterator().next();
        this.cache.remove(entry.getKey());
        Map.Entry entry2 = entry;
        return Optional.Companion.some(new Pair(entry2.getKey(), entry2.getValue()));
    }

    private final Optional<? extends Pair<K, V>> removeLeastRecentIfNecessary() {
        if (this.cache.size() < this.getCapacity()) {
            return Optional.Companion.none();
        }
        return this.removeLeastRecent();
    }

    @Override
    @NotNull
    public synchronized Optional<? extends V> get(K key) {
        return this.cache.containsKey(key) ? Optional.Companion.of(this.cache.get(key)) : Optional.Companion.none();
    }

    @Override
    @NotNull
    public synchronized Map<K, V> toMap() {
        return MapsKt.toMap((Map)this.cache);
    }

    public synchronized boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        SimpleLRUCache cfr_ignored_0 = (SimpleLRUCache)other;
        if (this.getCapacity() != ((SimpleLRUCache)other).getCapacity()) {
            return false;
        }
        return Intrinsics.areEqual(this.cache, ((SimpleLRUCache)other).cache);
    }

    public synchronized int hashCode() {
        int result = this.getCapacity();
        result = 31 * result + this.cache.hashCode();
        return result;
    }

    @Override
    @NotNull
    public synchronized Sequence<Pair<K, V>> toSequence() {
        Set<Map.Entry<K, V>> set = this.cache.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"cache.entries");
        return IterUtils.buffered(SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)toSequence.1.INSTANCE));
    }

    @NotNull
    public synchronized String toString() {
        return "SimpleLRUCache(" + SequencesKt.joinToString$default((Sequence)SequencesKt.map(this.toSequence(), (Function1)toString.1.INSTANCE), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    @Override
    public synchronized int getSize() {
        return this.cache.size();
    }
}

